/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crimson.tree;

import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Locale;
import org.apache.crimson.tree.ElementEx;
import org.apache.crimson.tree.ElementFactory;
import org.apache.crimson.tree.ElementNode;
import org.apache.crimson.tree.XmlDocument;

public class SimpleElementFactory
implements ElementFactory {
    private Dictionary defaultMapping;
    private ClassLoader defaultLoader;
    private String defaultNs;
    private Dictionary nsMappings;
    private Dictionary nsLoaders;
    private Locale locale = Locale.getDefault();
    static /* synthetic */ Class class$org$apache$crimson$tree$ElementNode;
    static /* synthetic */ Class class$org$apache$crimson$tree$SimpleElementFactory;

    public void addMapping(Dictionary dict, ClassLoader loader) {
        if (dict == null) {
            throw new IllegalArgumentException();
        }
        this.defaultMapping = dict;
        this.defaultLoader = loader;
    }

    public void addMapping(String namespace, Dictionary dict, ClassLoader loader) {
        if (namespace == null || dict == null) {
            throw new IllegalArgumentException();
        }
        if (this.nsMappings == null) {
            this.nsMappings = new Hashtable();
            this.nsLoaders = new Hashtable();
        }
        this.nsMappings.put(namespace, dict);
        if (loader != null) {
            this.nsLoaders.put(namespace, loader);
        }
    }

    public void setDefaultNamespace(String ns) {
        this.defaultNs = ns;
    }

    private Class map2Class(String key, Dictionary node2class, ClassLoader loader) {
        Object mapResult = node2class.get(key);
        if (mapResult instanceof Class) {
            return (Class)mapResult;
        }
        if (mapResult == null) {
            return null;
        }
        if (mapResult instanceof String) {
            String className = (String)mapResult;
            try {
                Class<?> retval;
                if (loader == null) {
                    loader = SimpleElementFactory.findClassLoader();
                }
                if (!(class$org$apache$crimson$tree$ElementNode == null ? (class$org$apache$crimson$tree$ElementNode = SimpleElementFactory.class$("org.apache.crimson.tree.ElementNode")) : class$org$apache$crimson$tree$ElementNode).isAssignableFrom(retval = loader == null ? Class.forName(className) : loader.loadClass(className))) {
                    throw new IllegalArgumentException(this.getMessage("SEF-000", new Object[]{key, className}));
                }
                node2class.put(key, retval);
                return retval;
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException(this.getMessage("SEF-001", new Object[]{key, className, e.getMessage()}));
            }
        }
        throw new IllegalArgumentException(this.getMessage("SEF-002", new Object[]{key}));
    }

    private ElementNode doMap(String tagName, Dictionary node2class, ClassLoader loader) {
        ElementNode retval;
        Class theClass = this.map2Class(tagName, node2class, loader);
        if (theClass == null) {
            theClass = this.map2Class("*Element", node2class, loader);
        }
        if (theClass == null) {
            retval = new ElementNode(tagName);
        } else {
            try {
                retval = (ElementNode)theClass.newInstance();
            }
            catch (Exception e) {
                throw new IllegalArgumentException(this.getMessage("SEF-003", new Object[]{tagName, theClass.getName(), e.getMessage()}));
            }
        }
        return retval;
    }

    public ElementEx createElementEx(String namespace, String localName) {
        Dictionary mapping = null;
        if (namespace == null) {
            namespace = this.defaultNs;
        }
        if (this.nsMappings != null) {
            mapping = (Dictionary)this.nsMappings.get(namespace);
        }
        if (mapping == null) {
            return this.doMap(localName, this.defaultMapping, this.defaultLoader);
        }
        return this.doMap(localName, mapping, (ClassLoader)this.nsLoaders.get(namespace));
    }

    public ElementEx createElementEx(String tag) {
        return this.doMap(tag, this.defaultMapping, this.defaultLoader);
    }

    String getMessage(String messageId) {
        return this.getMessage(messageId, null);
    }

    String getMessage(String messageId, Object[] parameters) {
        return XmlDocument.catalog.getMessage(this.locale, messageId, parameters);
    }

    private static ClassLoader findClassLoader() {
        ClassLoader classLoader;
        try {
            Class<?> clazz = Class.forName((class$org$apache$crimson$tree$SimpleElementFactory == null ? (class$org$apache$crimson$tree$SimpleElementFactory = SimpleElementFactory.class$("org.apache.crimson.tree.SimpleElementFactory")) : class$org$apache$crimson$tree$SimpleElementFactory).getName() + "$ClassLoaderFinderConcrete");
            ClassLoaderFinder clf = (ClassLoaderFinder)clazz.newInstance();
            classLoader = clf.getContextClassLoader();
        }
        catch (LinkageError le) {
            classLoader = (class$org$apache$crimson$tree$SimpleElementFactory == null ? (class$org$apache$crimson$tree$SimpleElementFactory = SimpleElementFactory.class$("org.apache.crimson.tree.SimpleElementFactory")) : class$org$apache$crimson$tree$SimpleElementFactory).getClassLoader();
        }
        catch (ClassNotFoundException x) {
            classLoader = (class$org$apache$crimson$tree$SimpleElementFactory == null ? (class$org$apache$crimson$tree$SimpleElementFactory = SimpleElementFactory.class$("org.apache.crimson.tree.SimpleElementFactory")) : class$org$apache$crimson$tree$SimpleElementFactory).getClassLoader();
        }
        catch (Exception x) {
            classLoader = (class$org$apache$crimson$tree$SimpleElementFactory == null ? (class$org$apache$crimson$tree$SimpleElementFactory = SimpleElementFactory.class$("org.apache.crimson.tree.SimpleElementFactory")) : class$org$apache$crimson$tree$SimpleElementFactory).getClassLoader();
        }
        return classLoader;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static class ClassLoaderFinderConcrete
    extends ClassLoaderFinder {
        ClassLoaderFinderConcrete() {
        }

        ClassLoader getContextClassLoader() {
            return Thread.currentThread().getContextClassLoader();
        }
    }

    private static abstract class ClassLoaderFinder {
        private ClassLoaderFinder() {
        }

        abstract ClassLoader getContextClassLoader();
    }
}

