/*
 * Decompiled with CFR 0.152.
 */
package shared.count;

import java.io.IOException;
import java.io.Reader;
import org.gjt.xpp.XmlEndTag;
import org.gjt.xpp.XmlPullParser;
import org.gjt.xpp.XmlPullParserException;
import org.gjt.xpp.XmlPullParserFactory;
import org.gjt.xpp.XmlStartTag;
import shared.count.ProgressObserver;
import shared.count.ReaderFactory;

public class XppCount {
    public String factoryClassName;
    public boolean supportNamespaces;
    public boolean trace;
    public boolean disallowMixedContent;
    public int speedTest;
    public boolean nowait;
    public int softLimit = -1;
    public int hardLimit = -1;
    public int attrCount;
    public int characterCount;
    public int elementCount;
    private XmlPullParser pp;
    private XmlStartTag stag;
    private XmlEndTag etag;

    private void setup(ProgressObserver po) throws XmlPullParserException {
        this.elementCount = 0;
        this.characterCount = 0;
        this.attrCount = 0;
        XmlPullParserFactory factory = XmlPullParserFactory.newInstance(this.factoryClassName);
        po.verbose("using factory " + factory.getClass());
        this.etag = factory.newEndTag();
        this.stag = factory.newStartTag();
        this.pp = factory.newPullParser();
        this.pp.setNamespaceAware(this.supportNamespaces);
        if (this.disallowMixedContent) {
            this.pp.setAllowedMixedContent(false);
        }
    }

    private void tearDown() {
        this.pp = null;
    }

    private long speedTest(ReaderFactory readerFactory, ProgressObserver po) throws XmlPullParserException, IOException {
        int runs = this.speedTest;
        if (this.speedTest <= 0) {
            throw new IllegalArgumentException("speedTest count must be positive not " + this.speedTest);
        }
        long startMillis = System.currentTimeMillis();
        for (int i = 0; i < runs; ++i) {
            byte type;
            if (po.stopRequested()) {
                po.println("Parsing interrupted!");
                return -1L;
            }
            Reader reader = readerFactory.newReader();
            this.pp.setInput(reader);
            while ((type = this.pp.next()) != 1) {
                if (type == 4) {
                    this.characterCount += this.pp.getContentLength();
                    continue;
                }
                if (type != 2) continue;
                this.pp.readStartTag(this.stag);
                ++this.elementCount;
                this.attrCount += this.stag.getAttributeCount();
            }
            reader.close();
        }
        long endMillis = System.currentTimeMillis();
        long walltimeMillis = endMillis - startMillis;
        return walltimeMillis;
    }

    private void prettyParse(Reader r, ProgressObserver po) throws XmlPullParserException, IOException {
        byte type;
        this.pp.setInput(r);
        while ((type = this.pp.next()) != 1) {
            if (po.stopRequested()) {
                po.println("Parsing interrupted!");
                break;
            }
            if (type == 4) {
                String s = this.pp.readContent();
                po.println("Content={'" + XppCount.escape(s) + "'}");
                this.characterCount += s.length();
                continue;
            }
            if (type == 3) {
                this.pp.readEndTag(this.etag);
                po.println("" + this.etag);
                continue;
            }
            if (type != 2) continue;
            this.pp.readStartTag(this.stag);
            po.println("" + this.stag);
            ++this.elementCount;
            this.attrCount += this.stag.getAttributeCount();
        }
    }

    private static String escape(String s) {
        StringBuffer buf = new StringBuffer(s.length());
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '\n') {
                buf.append("\\n");
                continue;
            }
            if (c == '\r') {
                buf.append("\\r");
                continue;
            }
            if (c == '\t') {
                buf.append("\\t");
                continue;
            }
            if (c == '\\') {
                buf.append("\\");
                continue;
            }
            if (c == '\"') {
                buf.append('\"');
                continue;
            }
            if (c < ' ') {
                buf.append("\\x" + Integer.toHexString(c));
                continue;
            }
            buf.append(c);
        }
        return buf.toString();
    }

    private static String to1000th(long v) {
        long vM = v % 1000L;
        String sM = "" + vM;
        if (sM.length() == 1) {
            sM = "00" + sM;
        } else if (sM.length() == 2) {
            sM = "0" + sM;
        }
        String s = v / 1000L + "." + sM;
        return s;
    }

    public void runTest(String inputName, ReaderFactory rf, ProgressObserver po) throws XmlPullParserException, IOException {
        this.setup(po);
        if (this.speedTest > 0) {
            po.verbose("run speed test for " + inputName + " " + this.speedTest + " times");
            long walltime = this.speedTest(rf, po);
            if (walltime > 0L) {
                po.print(inputName + ": ");
                String ms = XppCount.to1000th(1000L * walltime / (long)this.speedTest);
                String s = XppCount.to1000th(walltime);
                po.println("parse duration " + ms + " [ms]" + " total: " + s + " [s]");
            }
        } else {
            po.verbose("pretty printing parsed input " + inputName);
            po.verbose("================ START PARSING: " + inputName);
            Reader r = rf.newReader();
            this.prettyParse(r, po);
            po.verbose("================ END PARSING");
        }
        po.println("statistics: " + this.elementCount + " elems, " + this.attrCount + " attrs, " + this.characterCount + " chars");
        this.tearDown();
    }
}

