/*
 * Decompiled with CFR 0.152.
 */
package com.sun.midp.publickeystore;

import com.sun.ksecurity.RSAPublicKey;
import com.sun.kssl.X509Certificate;
import com.sun.midp.io.Base64;
import com.sun.midp.publickeystore.PublicKeyInfo;
import com.sun.midp.publickeystore.PublicKeyStoreBuilderBase;
import java.io.IOException;
import java.io.InputStream;

public class PublicKeyStoreBuilder
extends PublicKeyStoreBuilderBase {
    public PublicKeyStoreBuilder() {
    }

    public PublicKeyStoreBuilder(InputStream in) throws IOException {
        super(in);
    }

    public String addKeyUsingCertificate(String base64Cert) {
        return this.addKeyUsingCertificate(base64Cert, null);
    }

    public String addKeyUsingCertificate(String base64Cert, String domain) {
        X509Certificate cert = this.base64ToCertificate(base64Cert);
        if (cert == null) {
            return null;
        }
        if (!this.addKeyUsingCertificate(cert, domain)) {
            return null;
        }
        return cert.getSubject();
    }

    public boolean addKeyUsingCertificate(X509Certificate cert) {
        return this.addKeyUsingCertificate(cert, null);
    }

    public synchronized boolean addKeyUsingCertificate(X509Certificate cert, String domain) {
        if (domain == null) {
            domain = "untrusted";
        }
        PublicKeyInfo keyInfo = this.CertificateToKeyInfo(cert, domain);
        return this.addKey(keyInfo);
    }

    public boolean updateKeyUsingCertificate(String base64Cert) {
        X509Certificate cert = this.base64ToCertificate(base64Cert);
        if (cert == null) {
            return false;
        }
        return this.updateKeyUsingCertificate(cert);
    }

    public synchronized boolean updateKeyUsingCertificate(X509Certificate cert) {
        String owner = cert.getIssuer();
        PublicKeyInfo keyInfo = this.CertificateToKeyInfo(cert, null);
        return this.updateKey(owner, keyInfo);
    }

    private PublicKeyInfo CertificateToKeyInfo(X509Certificate cert, String domain) {
        RSAPublicKey key = (RSAPublicKey)cert.getPublicKey();
        int modulusLen = key.getSize() / 8;
        byte[] modulus = new byte[modulusLen];
        short exponentLen = key.getExponent(modulus, (short)0);
        key.getModulus(modulus, (short)0);
        byte[] exponent = new byte[exponentLen];
        exponentLen = key.getExponent(exponent, (short)0);
        return new PublicKeyInfo(cert.getSubject(), cert.getNotBefore().getTime(), cert.getNotAfter().getTime(), modulus, exponent, domain);
    }

    private X509Certificate base64ToCertificate(String base64Cert) {
        try {
            byte[] decodedCert = Base64.decode(base64Cert, 0, base64Cert.length());
            return X509Certificate.generateCertificate(decodedCert, 0, decodedCert.length);
        }
        catch (Exception e) {
            return null;
        }
    }
}

