/*
 * Decompiled with CFR 0.152.
 */
package com.sun.cldc.io.j2me.datagram;

import com.sun.cldc.io.GeneralBase;
import com.sun.cldc.io.NetworkConnectionBase;
import com.sun.cldc.io.j2me.datagram.DatagramObject;
import java.io.IOException;
import java.io.InterruptedIOException;
import javax.microedition.io.Datagram;
import javax.microedition.io.DatagramConnection;

public class Protocol
extends NetworkConnectionBase
implements DatagramConnection {
    private int handle;
    private String host = null;
    private int port;
    private boolean open;

    protected static String getAddress(String name) throws IOException {
        int colon = name.indexOf(58);
        if (colon < 0) {
            throw new IllegalArgumentException("No ':' in protocol name " + name);
        }
        if (colon == 0) {
            return null;
        }
        return name.substring(0, colon);
    }

    protected static int getPort(String name) throws IOException, NumberFormatException {
        int colon = name.indexOf(58);
        if (colon < 0) {
            throw new IllegalArgumentException("No ':' in protocol name " + name);
        }
        int res = Integer.parseInt(name.substring(colon + 1));
        if (res < 0 || res > 65535) {
            throw new IllegalArgumentException("Bad port number " + name);
        }
        return res;
    }

    public void open(String name, int mode, boolean timeouts) throws IOException {
        if (name.charAt(0) != '/' || name.charAt(1) != '/') {
            throw new IllegalArgumentException("Protocol must start with \"//\" " + name);
        }
        name = name.substring(2);
        this.host = Protocol.getAddress(name);
        this.port = Protocol.getPort(name);
        if (this.port <= 0) {
            throw new IllegalArgumentException("Bad port number \"//\" " + name);
        }
        this.open0(mode, timeouts, this.host == null ? this.port : 0);
        this.registerCleanup();
        this.open = true;
    }

    void ensureOpen() throws IOException {
        if (!this.open) {
            throw new IOException("Connection closed");
        }
    }

    public String getAddress() throws IOException {
        this.ensureOpen();
        throw new RuntimeException("Function not implemented");
    }

    public int getMaximumLength() throws IOException {
        this.ensureOpen();
        return this.getMaximumLength0();
    }

    public int getNominalLength() throws IOException {
        this.ensureOpen();
        return this.getNominalLength0();
    }

    public void send(Datagram dgram) throws IOException {
        Datagram datagram = dgram;
        synchronized (datagram) {
            int res;
            this.ensureOpen();
            DatagramObject dh = (DatagramObject)dgram;
            if (dh.ipNumber == 0) {
                dh.ipNumber = this.getIpNumber(dh.host == null ? "localhost" : dh.host);
            }
            while ((res = this.send0(dh.ipNumber, dh.port, dh.buf, dh.off, dh.len)) != dh.len) {
                if (res != 0) {
                    throw new IOException("Failed to send datagram");
                }
                GeneralBase.iowait();
                if (this.open) continue;
                throw new InterruptedIOException("Socket closed");
            }
        }
    }

    public synchronized void receive(Datagram dgram) throws IOException {
        Datagram datagram = dgram;
        synchronized (datagram) {
            long res;
            int count;
            this.ensureOpen();
            DatagramObject dh = (DatagramObject)dgram;
            if (dh.ipNumber == 0) {
                dh.ipNumber = this.getIpNumber(dh.host == null ? "localhost" : dh.host);
            }
            if (dh.len == 0) {
                throw new IOException("Bad datagram length");
            }
            while ((count = (int)(res = this.receive0(dh.buf, dh.off, dh.len)) & 0xFFFF) == 0) {
                GeneralBase.iowait();
                if (this.open) continue;
                throw new InterruptedIOException("Socket closed");
            }
            dh.len = count;
            dh.ipNumber = (int)(res >> 32);
            dh.port = (int)(res >> 16) & 0xFFFF;
            dh.pointer = 0;
        }
    }

    public void close() throws IOException {
        if (this.open) {
            this.open = false;
            this.close0();
        }
    }

    public Datagram newDatagram(int size) throws IOException {
        return this.newDatagram(new byte[size], size);
    }

    public Datagram newDatagram(int size, String addr) throws IOException {
        return this.newDatagram(new byte[size], size, addr);
    }

    public Datagram newDatagram(byte[] buf, int size) throws IOException {
        this.ensureOpen();
        DatagramObject dg = new DatagramObject(this, buf, size);
        if (this.host != null) {
            dg.host = this.host;
            dg.port = this.port;
        }
        return dg;
    }

    public Datagram newDatagram(byte[] buf, int size, String addr) throws IOException {
        this.ensureOpen();
        DatagramObject dh = new DatagramObject(this, buf, size);
        dh.setAddress(addr);
        return dh;
    }

    native void open0(int var1, boolean var2, int var3) throws IOException;

    native int send0(int var1, int var2, byte[] var3, int var4, int var5) throws IOException;

    native long receive0(byte[] var1, int var2, int var3) throws IOException;

    native void getHostByAddr(int var1, byte[] var2) throws IOException;

    native int getIpNumber(String var1) throws IOException;

    native int getMaximumLength0() throws IOException;

    native int getNominalLength0() throws IOException;

    native void close0() throws IOException;

    private native void registerCleanup();
}

