/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.workbench.addons.dndaddon;

import org.eclipse.jface.util.Geometry;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

class DragAndDropUtil {
    public static final String IGNORE_AS_DROP_TARGET = "ignore_as_drop_target";

    DragAndDropUtil() {
    }

    public static Rectangle getDisplayBounds(Control boundsControl) {
        Composite parent = boundsControl.getParent();
        if (parent == null || boundsControl instanceof Shell) {
            return boundsControl.getBounds();
        }
        return Geometry.toDisplay((Control)parent, (Rectangle)boundsControl.getBounds());
    }

    public static Control findControl(Display displayToSearch, Point locationToFind) {
        Shell[] shells = displayToSearch.getShells();
        DragAndDropUtil.fixShellOrder(displayToSearch, shells);
        return DragAndDropUtil.findControl((Control[])shells, locationToFind);
    }

    private static void fixShellOrder(Display display, Shell[] shells) {
        if (shells.length <= 1) {
            return;
        }
        Shell activeShell = display.getActiveShell();
        int lastIndex = shells.length - 1;
        if (activeShell == null || shells[lastIndex] == activeShell) {
            return;
        }
        int i = 0;
        while (i < shells.length) {
            if (shells[i] == activeShell) {
                Shell toMove;
                shells[i] = toMove = shells[lastIndex];
                shells[lastIndex] = activeShell;
                break;
            }
            ++i;
        }
    }

    private static Control findControl(Control[] toSearch, Point locationToFind) {
        int idx = toSearch.length - 1;
        while (idx >= 0) {
            Rectangle bounds;
            Control next = toSearch[idx];
            if (next.getData(IGNORE_AS_DROP_TARGET) == null && !next.isDisposed() && next.isVisible() && (bounds = DragAndDropUtil.getDisplayBounds(next)).contains(locationToFind)) {
                Control result;
                if (next instanceof Composite && (result = DragAndDropUtil.findControl((Composite)next, locationToFind)) != null) {
                    return result;
                }
                return next;
            }
            --idx;
        }
        return null;
    }

    private static Control findControl(Composite toSearch, Point locationToFind) {
        Control[] children = toSearch.getChildren();
        return DragAndDropUtil.findControl(children, locationToFind);
    }
}

