/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.localstore;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.internal.resources.ResourceException;
import org.eclipse.core.internal.resources.ResourceStatus;
import org.eclipse.core.internal.utils.Assert;
import org.eclipse.core.internal.utils.Policy;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public abstract class Bucket {
    private static final String BUCKET = "bucket.index";
    private final Map entries;
    private File location;
    private boolean needSaving = false;
    private File root;

    public Bucket(File root) {
        this.root = root;
        this.entries = new HashMap();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final int accept(Visitor visitor, IPath filter, int depth) throws CoreException {
        block8: {
            int n;
            if (this.entries.isEmpty()) {
                return 0;
            }
            try {
                int outcome;
                Iterator i = this.entries.entrySet().iterator();
                while (true) {
                    if (!i.hasNext()) {
                        break block8;
                    }
                    Map.Entry mapEntry = i.next();
                    Path path = new Path((String)mapEntry.getKey());
                    int matchingSegments = filter.matchingFirstSegments(path);
                    if (!filter.isPrefixOf(path) || path.segmentCount() - matchingSegments > depth) continue;
                    Entry bucketEntry = this.createEntry(path, mapEntry.getValue());
                    outcome = visitor.visit(bucketEntry);
                    bucketEntry.visited();
                    if (bucketEntry.isDeleted()) {
                        this.needSaving = true;
                        i.remove();
                    } else if (bucketEntry.isDirty()) {
                        this.needSaving = true;
                        mapEntry.setValue(bucketEntry.getValue());
                    }
                    if (outcome != 0) break;
                }
                n = outcome;
                Object var10_11 = null;
            }
            catch (Throwable throwable) {
                Object var10_13 = null;
                this.save();
                visitor.afterSaving(this);
                throw throwable;
            }
            this.save();
            visitor.afterSaving(this);
            return n;
        }
        Object var10_12 = null;
        this.save();
        visitor.afterSaving(this);
        return 0;
    }

    protected abstract Entry createEntry(IPath var1, Object var2);

    private void delete(File toDelete) {
        if (toDelete.equals(this.root)) {
            return;
        }
        if (toDelete.delete()) {
            this.delete(toDelete.getParentFile());
        }
    }

    public final int getEntryCount() {
        return this.entries.size();
    }

    public final Object getEntryValue(String path) {
        return this.entries.get(path);
    }

    public File getLocation() {
        return this.location == null ? null : this.location.getParentFile();
    }

    protected abstract byte getVersion();

    public final void load(File baseLocation) throws CoreException {
        this.load(baseLocation, false);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void load(File baseLocation, boolean force) throws CoreException {
        try {
            if (!force && this.location != null && baseLocation.equals(this.location.getParentFile())) {
                return;
            }
            this.save();
            this.location = new File(baseLocation, BUCKET);
            this.entries.clear();
            if (!this.location.isFile()) {
                return;
            }
            DataInputStream source = new DataInputStream(new BufferedInputStream(new FileInputStream(this.location), 8192));
            try {
                byte version = source.readByte();
                if (version != this.getVersion()) {
                    String message = Policy.bind("resources.readMetaWrongVersion", this.location.getAbsolutePath(), Integer.toString(version));
                    ResourceStatus status = new ResourceStatus(567, message);
                    throw new ResourceException(status);
                }
                int entryCount = source.readInt();
                int i = 0;
                while (i < entryCount) {
                    this.entries.put(source.readUTF(), this.readEntryValue(source));
                    ++i;
                }
            }
            catch (Throwable throwable) {
                Object var7_13 = null;
                source.close();
                throw throwable;
            }
            {
                Object var7_14 = null;
                source.close();
                return;
            }
        }
        catch (IOException ioe) {
            String message = Policy.bind("resources.readMeta", this.location.getAbsolutePath());
            ResourceStatus status = new ResourceStatus(567, null, message, ioe);
            throw new ResourceException(status);
        }
    }

    protected abstract Object readEntryValue(DataInputStream var1) throws IOException;

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void save() throws CoreException {
        if (!this.needSaving) {
            return;
        }
        try {
            if (this.entries.isEmpty()) {
                this.needSaving = false;
                this.delete(this.location);
                return;
            }
            this.location.getParentFile().mkdirs();
            DataOutputStream destination = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(this.location), 8192));
            try {
                destination.write(this.getVersion());
                destination.writeInt(this.entries.size());
                Iterator i = this.entries.entrySet().iterator();
                while (i.hasNext()) {
                    Map.Entry entry = i.next();
                    destination.writeUTF((String)entry.getKey());
                    this.writeEntryValue(destination, entry.getValue());
                }
            }
            catch (Throwable throwable) {
                Object var4_8 = null;
                destination.close();
                throw throwable;
            }
            {
                Object var4_9 = null;
            }
            destination.close();
            this.needSaving = false;
            return;
        }
        catch (IOException ioe) {
            String message = Policy.bind("resources.writeMeta", this.location.getAbsolutePath());
            ResourceStatus status = new ResourceStatus(568, null, message, ioe);
            throw new ResourceException(status);
        }
    }

    public final void setEntryValue(String path, Object value) {
        if (value == null) {
            this.entries.remove(path);
        } else {
            this.entries.put(path, value);
        }
        this.needSaving = true;
    }

    protected abstract void writeEntryValue(DataOutputStream var1, Object var2) throws IOException;

    public static abstract class Entry {
        private static final int STATE_CLEAR = 0;
        private static final int STATE_DELETED = 2;
        private static final int STATE_DIRTY = 1;
        private IPath path;
        private byte state = 0;

        protected Entry(IPath path) {
            this.path = path;
        }

        public void delete() {
            this.state = (byte)2;
        }

        public abstract int getOccurrences();

        public IPath getPath() {
            return this.path;
        }

        public abstract Object getValue();

        public boolean isDeleted() {
            return this.state == 2;
        }

        public boolean isDirty() {
            return this.state == 1;
        }

        public boolean isEmpty() {
            return this.getOccurrences() == 0;
        }

        public void markDirty() {
            Assert.isTrue(this.state != 2);
            this.state = 1;
        }

        public void visited() {
        }
    }

    public static abstract class Visitor {
        public static final int CONTINUE = 0;
        public static final int RETURN = 2;
        public static final int STOP = 1;

        public abstract int visit(Entry var1);

        public void afterSaving(Bucket bucket) throws CoreException {
        }
    }
}

