/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.org.eclipse.jdt.internal.compiler.lookup;

import org.aspectj.org.eclipse.jdt.core.compiler.CharOperation;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.ImportReference;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.aspectj.org.eclipse.jdt.internal.compiler.env.AccessRestriction;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.ArrayBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.ImportBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.LocalTypeBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.MethodVerifier;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.PackageBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.ProblemReferenceBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.UnresolvedReferenceBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.problem.ProblemReporter;
import org.aspectj.org.eclipse.jdt.internal.compiler.util.CompoundNameVector;
import org.aspectj.org.eclipse.jdt.internal.compiler.util.HashtableOfObject;
import org.aspectj.org.eclipse.jdt.internal.compiler.util.HashtableOfType;
import org.aspectj.org.eclipse.jdt.internal.compiler.util.ObjectVector;
import org.aspectj.org.eclipse.jdt.internal.compiler.util.SimpleNameVector;

public class CompilationUnitScope
extends Scope {
    public LookupEnvironment environment;
    public CompilationUnitDeclaration referenceContext;
    public char[][] currentPackageName;
    public PackageBinding fPackage;
    public ImportBinding[] imports;
    public HashtableOfObject resolvedSingeTypeImports;
    public SourceTypeBinding[] topLevelTypes;
    private CompoundNameVector qualifiedReferences;
    private SimpleNameVector simpleNameReferences;
    private ObjectVector referencedTypes;
    private ObjectVector referencedSuperTypes;
    HashtableOfType constantPoolNameUsage;

    public CompilationUnitScope(CompilationUnitDeclaration unit, LookupEnvironment environment) {
        super(4, null);
        this.environment = environment;
        this.referenceContext = unit;
        unit.scope = this;
        char[][] cArray = this.currentPackageName = unit.currentPackage == null ? CharOperation.NO_CHAR_CHAR : unit.currentPackage.tokens;
        if (environment.options.produceReferenceInfo) {
            this.qualifiedReferences = new CompoundNameVector();
            this.simpleNameReferences = new SimpleNameVector();
            this.referencedTypes = new ObjectVector();
            this.referencedSuperTypes = new ObjectVector();
        } else {
            this.qualifiedReferences = null;
            this.simpleNameReferences = null;
            this.referencedTypes = null;
            this.referencedSuperTypes = null;
        }
    }

    public void buildFieldsAndMethods() {
        int i = 0;
        int length = this.topLevelTypes.length;
        while (i < length) {
            this.topLevelTypes[i].scope.buildFieldsAndMethods();
            ++i;
        }
    }

    void buildTypeBindings(AccessRestriction accessRestriction) {
        TypeDeclaration[] types;
        char[][] expectedPackageName;
        this.topLevelTypes = new SourceTypeBinding[0];
        if (this.referenceContext.compilationResult.compilationUnit != null && (expectedPackageName = this.referenceContext.compilationResult.compilationUnit.getPackageName()) != null && !CharOperation.equals(this.currentPackageName, expectedPackageName)) {
            if (this.referenceContext.currentPackage != null || this.referenceContext.types != null || this.referenceContext.imports != null) {
                this.problemReporter().packageIsNotExpectedPackage(this.referenceContext);
            }
            char[][] cArray = this.currentPackageName = expectedPackageName.length == 0 ? CharOperation.NO_CHAR_CHAR : expectedPackageName;
        }
        if (this.currentPackageName == CharOperation.NO_CHAR_CHAR) {
            this.fPackage = this.environment.defaultPackage;
            if (this.fPackage == null) {
                this.problemReporter().mustSpecifyPackage(this.referenceContext);
                return;
            }
        } else {
            this.fPackage = this.environment.createPackage(this.currentPackageName);
            if (this.fPackage == null) {
                this.problemReporter().packageCollidesWithType(this.referenceContext);
                return;
            }
            this.recordQualifiedReference(this.currentPackageName);
        }
        int typeLength = (types = this.referenceContext.types) == null ? 0 : types.length;
        this.topLevelTypes = new SourceTypeBinding[typeLength];
        int count = 0;
        int i = 0;
        while (i < typeLength) {
            char[] mainTypeName;
            TypeDeclaration typeDecl = types[i];
            ReferenceBinding typeBinding = this.fPackage.getType0(typeDecl.name);
            this.recordSimpleReference(typeDecl.name);
            if (typeBinding != null && !(typeBinding instanceof UnresolvedReferenceBinding)) {
                this.problemReporter().duplicateTypes(this.referenceContext, typeDecl);
            } else if (this.fPackage != this.environment.defaultPackage && this.fPackage.getPackage(typeDecl.name) != null) {
                this.problemReporter().typeCollidesWithPackage(this.referenceContext, typeDecl);
            } else if ((typeDecl.modifiers & 1) != 0 && (mainTypeName = this.referenceContext.getMainTypeName()) != null && !CharOperation.equals(mainTypeName, typeDecl.name)) {
                this.problemReporter().publicClassMustMatchFileName(this.referenceContext, typeDecl);
            } else {
                ClassScope child = new ClassScope(this, typeDecl);
                SourceTypeBinding type = child.buildType(null, this.fPackage, accessRestriction);
                if (type != null) {
                    this.topLevelTypes[count++] = type;
                }
            }
            ++i;
        }
        if (count != this.topLevelTypes.length) {
            this.topLevelTypes = new SourceTypeBinding[count];
            System.arraycopy(this.topLevelTypes, 0, this.topLevelTypes, 0, count);
        }
    }

    public void checkAndSetImports() {
        if (this.referenceContext.imports == null) {
            this.imports = this.getDefaultImports();
            return;
        }
        int numberOfStatements = this.referenceContext.imports.length;
        int numberOfImports = numberOfStatements + 1;
        int i = 0;
        while (i < numberOfStatements) {
            ImportReference importReference = this.referenceContext.imports[i];
            if (importReference.onDemand && CharOperation.equals(TypeConstants.JAVA_LANG, importReference.tokens) && !importReference.isStatic()) {
                --numberOfImports;
                break;
            }
            ++i;
        }
        ImportBinding[] resolvedImports = new ImportBinding[numberOfImports];
        resolvedImports[0] = this.getDefaultImports()[0];
        int index = 1;
        int i2 = 0;
        while (i2 < numberOfStatements) {
            block10: {
                ImportReference importReference = this.referenceContext.imports[i2];
                char[][] compoundName = importReference.tokens;
                int j = 0;
                while (j < index) {
                    ImportBinding resolved = resolvedImports[j];
                    if (resolved.onDemand != importReference.onDemand || resolved.isStatic() != importReference.isStatic() || !CharOperation.equals(compoundName, resolvedImports[j].compoundName)) {
                        ++j;
                        continue;
                    }
                    break block10;
                }
                if (importReference.onDemand) {
                    Binding importBinding;
                    if (!(CharOperation.equals(compoundName, this.currentPackageName) || !(importBinding = this.findImport(compoundName, compoundName.length)).isValidBinding() || importReference.isStatic() && importBinding instanceof PackageBinding)) {
                        resolvedImports[index++] = new ImportBinding(compoundName, true, importBinding, importReference);
                    }
                } else {
                    resolvedImports[index++] = new ImportBinding(compoundName, false, null, importReference);
                }
            }
            ++i2;
        }
        if (resolvedImports.length > index) {
            ImportBinding[] importBindingArray = resolvedImports;
            resolvedImports = new ImportBinding[index];
            System.arraycopy(importBindingArray, 0, resolvedImports, 0, index);
        }
        this.imports = resolvedImports;
    }

    public char[] computeConstantPoolName(LocalTypeBinding localType) {
        char[] candidateName;
        if (localType.constantPoolName() != null) {
            return localType.constantPoolName();
        }
        if (this.constantPoolNameUsage == null) {
            this.constantPoolNameUsage = new HashtableOfType();
        }
        SourceTypeBinding outerMostEnclosingType = localType.scope.outerMostClassScope().enclosingSourceType();
        int index = 0;
        while (true) {
            candidateName = localType.isMemberType() ? (index == 0 ? CharOperation.concat(localType.enclosingType().constantPoolName(), localType.sourceName, '$') : CharOperation.concat(localType.enclosingType().constantPoolName(), '$', String.valueOf(index).toCharArray(), '$', localType.sourceName)) : (localType.isAnonymousType() ? CharOperation.concat(outerMostEnclosingType.constantPoolName(), String.valueOf(index + 1).toCharArray(), '$') : CharOperation.concat(outerMostEnclosingType.constantPoolName(), '$', String.valueOf(index + 1).toCharArray(), '$', localType.sourceName));
            if (this.constantPoolNameUsage.get(candidateName) == null) break;
            ++index;
        }
        this.constantPoolNameUsage.put(candidateName, localType);
        return candidateName;
    }

    public void connectTypeHierarchy() {
        int i = 0;
        int length = this.topLevelTypes.length;
        while (i < length) {
            this.topLevelTypes[i].scope.connectTypeHierarchy();
            ++i;
        }
    }

    /*
     * Unable to fully structure code
     */
    void faultInImports() {
        if (this.referenceContext.imports == null) {
            return;
        }
        numberOfStatements = this.referenceContext.imports.length;
        typesBySimpleNames = null;
        i = 0;
        while (i < numberOfStatements) {
            if (!this.referenceContext.imports[i].onDemand) {
                typesBySimpleNames = new HashtableOfType(this.topLevelTypes.length + numberOfStatements);
                j = 0;
                length = this.topLevelTypes.length;
                while (j < length) {
                    typesBySimpleNames.put(this.topLevelTypes[j].sourceName, this.topLevelTypes[j]);
                    ++j;
                }
                break;
            }
            ++i;
        }
        numberOfImports = numberOfStatements + 1;
        i = 0;
        while (i < numberOfStatements) {
            importReference = this.referenceContext.imports[i];
            if (importReference.onDemand && CharOperation.equals(TypeConstants.JAVA_LANG, importReference.tokens) && !importReference.isStatic()) {
                --numberOfImports;
                break;
            }
            ++i;
        }
        resolvedImports = new ImportBinding[numberOfImports];
        resolvedImports[0] = this.getDefaultImports()[0];
        index = 1;
        i = 0;
        while (i < numberOfStatements) {
            block24: {
                block27: {
                    block26: {
                        block25: {
                            importReference = this.referenceContext.imports[i];
                            compoundName = importReference.tokens;
                            j = 0;
                            while (j < index) {
                                resolved = resolvedImports[j];
                                if (resolved.onDemand == importReference.onDemand && resolved.isStatic() == importReference.isStatic() && CharOperation.equals(compoundName, resolved.compoundName)) {
                                    this.problemReporter().unusedImport(importReference);
                                    break block24;
                                }
                                ++j;
                            }
                            if (!importReference.onDemand) break block25;
                            if (CharOperation.equals(compoundName, this.currentPackageName)) {
                                this.problemReporter().unusedImport(importReference);
                            } else {
                                importBinding = this.findImport(compoundName, compoundName.length);
                                if (!importBinding.isValidBinding()) {
                                    this.problemReporter().importProblem(importReference, importBinding);
                                } else if (importReference.isStatic() && importBinding instanceof PackageBinding) {
                                    this.problemReporter().cannotImportPackage(importReference);
                                } else {
                                    resolvedImports[index++] = new ImportBinding(compoundName, true, importBinding, importReference);
                                }
                            }
                            break block24;
                        }
                        importBinding = this.findSingleImport(compoundName, importReference.isStatic());
                        if (importBinding.isValidBinding()) break block26;
                        this.problemReporter().importProblem(importReference, importBinding);
                        break block24;
                    }
                    if (!(importBinding instanceof PackageBinding)) break block27;
                    this.problemReporter().cannotImportPackage(importReference);
                    break block24;
                }
                if (!(importBinding instanceof ReferenceBinding)) ** GOTO lbl85
                referenceBinding = (ReferenceBinding)importBinding;
                if (importReference.isTypeUseDeprecated(referenceBinding, this)) {
                    this.problemReporter().deprecatedType(referenceBinding, importReference);
                }
                if ((existingType = typesBySimpleNames.get(compoundName[compoundName.length - 1])) != null) {
                    if (existingType != referenceBinding) {
                        j = 0;
                        length = this.topLevelTypes.length;
                        while (j < length) {
                            if (CharOperation.equals(this.topLevelTypes[j].sourceName, existingType.sourceName)) {
                                this.problemReporter().conflictingImport(importReference);
                                break block24;
                            }
                            ++j;
                        }
                        this.problemReporter().duplicateImport(importReference);
                    }
                } else {
                    typesBySimpleNames.put(compoundName[compoundName.length - 1], referenceBinding);
lbl85:
                    // 2 sources

                    resolvedImports[index++] = new ImportBinding(compoundName, false, importBinding, importReference);
                }
            }
            ++i;
        }
        if (resolvedImports.length > index) {
            v0 = resolvedImports;
            resolvedImports = new ImportBinding[index];
            System.arraycopy(v0, 0, resolvedImports, 0, index);
        }
        this.imports = resolvedImports;
        length = this.imports.length;
        this.resolvedSingeTypeImports = new HashtableOfObject(length);
        i = 0;
        while (i < length) {
            binding = this.imports[i];
            if (!binding.onDemand && binding.resolvedImport instanceof ReferenceBinding) {
                this.resolvedSingeTypeImports.put(binding.compoundName[binding.compoundName.length - 1], binding);
            }
            ++i;
        }
    }

    public void faultInTypes() {
        this.faultInImports();
        int i = 0;
        int length = this.topLevelTypes.length;
        while (i < length) {
            this.topLevelTypes[i].faultInTypesForFieldsAndMethods();
            ++i;
        }
    }

    private Binding findImport(char[][] compoundName, int length) {
        ReferenceBinding type;
        int i;
        Binding binding;
        block12: {
            this.recordQualifiedReference(compoundName);
            binding = this.environment.getTopLevelPackage(compoundName[0]);
            i = 1;
            if (binding != null) {
                PackageBinding packageBinding = binding;
                while (i < length) {
                    if ((binding = packageBinding.getTypeOrPackage(compoundName[i++])) == null || !binding.isValidBinding()) {
                        binding = null;
                    } else if (binding instanceof PackageBinding) {
                        packageBinding = (PackageBinding)binding;
                        continue;
                    }
                    break block12;
                }
                return packageBinding;
            }
        }
        if (binding == null) {
            if (this.environment.defaultPackage == null || this.environment.options.complianceLevel >= 0x300000L) {
                return new ProblemReferenceBinding(CharOperation.subarray(compoundName, 0, i), 1);
            }
            type = this.findType(compoundName[0], this.environment.defaultPackage, this.environment.defaultPackage);
            if (type == null || !type.isValidBinding()) {
                return new ProblemReferenceBinding(CharOperation.subarray(compoundName, 0, i), 1);
            }
            i = 1;
        } else {
            type = (ReferenceBinding)binding;
        }
        while (i < length) {
            char[] name;
            if (!type.canBeSeenBy(this.fPackage)) {
                return new ProblemReferenceBinding(CharOperation.subarray(compoundName, 0, i), type, 2);
            }
            if ((type = type.getMemberType(name = compoundName[i++])) != null) continue;
            return new ProblemReferenceBinding(CharOperation.subarray(compoundName, 0, i), 1);
        }
        if (!type.canBeSeenBy(this.fPackage)) {
            return new ProblemReferenceBinding(compoundName, type, 2);
        }
        return type;
    }

    private Binding findSingleImport(char[][] compoundName, boolean findStaticImports) {
        if (compoundName.length == 1) {
            if (this.environment.defaultPackage == null || this.environment.options.complianceLevel >= 0x300000L) {
                return new ProblemReferenceBinding(compoundName, 1);
            }
            ReferenceBinding typeBinding = this.findType(compoundName[0], this.environment.defaultPackage, this.fPackage);
            if (typeBinding == null) {
                return new ProblemReferenceBinding(compoundName, 1);
            }
            return typeBinding;
        }
        if (findStaticImports) {
            return this.findSingleStaticImport(compoundName);
        }
        return this.findImport(compoundName, compoundName.length);
    }

    private Binding findSingleStaticImport(char[][] compoundName) {
        Binding binding = this.findImport(compoundName, compoundName.length - 1);
        if (!binding.isValidBinding()) {
            return binding;
        }
        char[] name = compoundName[compoundName.length - 1];
        if (binding instanceof PackageBinding) {
            Binding temp = ((PackageBinding)binding).getTypeOrPackage(name);
            if (temp != null && temp instanceof ReferenceBinding) {
                return new ProblemReferenceBinding(compoundName, 14);
            }
            return binding;
        }
        ReferenceBinding type = (ReferenceBinding)binding;
        FieldBinding field = this.findField(type, name, null, true);
        if (field != null && field.isStatic() && field.canBeSeenBy(this.fPackage)) {
            return field;
        }
        if ((type = this.findMemberType(name, type)) == null || !type.isStatic()) {
            return new ProblemReferenceBinding(compoundName, type, 1);
        }
        if (!type.canBeSeenBy(this.fPackage)) {
            return new ProblemReferenceBinding(compoundName, type, 2);
        }
        return type;
    }

    ImportBinding[] getDefaultImports() {
        if (this.environment.defaultImports != null) {
            return this.environment.defaultImports;
        }
        Binding importBinding = this.environment.getTopLevelPackage(TypeConstants.JAVA);
        if (importBinding != null) {
            importBinding = importBinding.getTypeOrPackage(TypeConstants.JAVA_LANG[1]);
        }
        if (importBinding == null || !importBinding.isValidBinding()) {
            this.problemReporter().isClassPathCorrect(TypeConstants.JAVA_LANG_OBJECT, this.referenceCompilationUnit());
        }
        this.environment.defaultImports = new ImportBinding[]{new ImportBinding(TypeConstants.JAVA_LANG, true, importBinding, null)};
        return this.environment.defaultImports;
    }

    public final Binding getImport(char[][] compoundName, boolean onDemand, boolean isStaticImport) {
        if (onDemand) {
            return this.findImport(compoundName, compoundName.length);
        }
        return this.findSingleImport(compoundName, isStaticImport);
    }

    public ProblemReporter problemReporter() {
        ProblemReporter problemReporter = this.referenceContext.problemReporter;
        problemReporter.referenceContext = this.referenceContext;
        return problemReporter;
    }

    void recordQualifiedReference(char[][] qualifiedName) {
        if (this.qualifiedReferences == null) {
            return;
        }
        int length = qualifiedName.length;
        if (length > 1) {
            while (!this.qualifiedReferences.contains(qualifiedName)) {
                this.qualifiedReferences.add(qualifiedName);
                if (length == 2) {
                    this.recordSimpleReference(qualifiedName[0]);
                    this.recordSimpleReference(qualifiedName[1]);
                    return;
                }
                this.recordSimpleReference(qualifiedName[--length]);
                char[][] cArray = qualifiedName;
                qualifiedName = new char[length][];
                System.arraycopy(cArray, 0, qualifiedName, 0, length);
            }
        } else if (length == 1) {
            this.recordSimpleReference(qualifiedName[0]);
        }
    }

    void recordReference(char[][] qualifiedEnclosingName, char[] simpleName) {
        this.recordQualifiedReference(qualifiedEnclosingName);
        this.recordSimpleReference(simpleName);
    }

    void recordReference(ReferenceBinding type, char[] simpleName) {
        ReferenceBinding actualType = this.typeToRecord(type);
        if (actualType != null) {
            this.recordReference(actualType.compoundName, simpleName);
        }
    }

    void recordSimpleReference(char[] simpleName) {
        if (this.simpleNameReferences == null) {
            return;
        }
        if (!this.simpleNameReferences.contains(simpleName)) {
            this.simpleNameReferences.add(simpleName);
        }
    }

    void recordSuperTypeReference(TypeBinding type) {
        if (this.referencedSuperTypes == null) {
            return;
        }
        ReferenceBinding actualType = this.typeToRecord(type);
        if (actualType != null && !this.referencedSuperTypes.containsIdentical(actualType)) {
            this.referencedSuperTypes.add(actualType);
        }
    }

    public void recordTypeConversion(TypeBinding superType, TypeBinding subType) {
        this.recordSuperTypeReference(subType);
    }

    public void recordTypeReference(TypeBinding type) {
        if (this.referencedTypes == null) {
            return;
        }
        ReferenceBinding actualType = this.typeToRecord(type);
        if (actualType != null && !this.referencedTypes.containsIdentical(actualType)) {
            this.referencedTypes.add(actualType);
        }
    }

    void recordTypeReferences(TypeBinding[] types) {
        if (this.referencedTypes == null) {
            return;
        }
        if (types == null || types.length == 0) {
            return;
        }
        int i = 0;
        int max = types.length;
        while (i < max) {
            ReferenceBinding actualType = this.typeToRecord(types[i]);
            if (actualType != null && !this.referencedTypes.containsIdentical(actualType)) {
                this.referencedTypes.add(actualType);
            }
            ++i;
        }
    }

    Binding resolveSingleImport(ImportBinding importBinding) {
        if (importBinding.resolvedImport == null) {
            importBinding.resolvedImport = this.findSingleImport(importBinding.compoundName, importBinding.isStatic());
            if (!importBinding.resolvedImport.isValidBinding() || importBinding.resolvedImport instanceof PackageBinding) {
                if (this.imports != null) {
                    ImportBinding[] newImports = new ImportBinding[this.imports.length - 1];
                    int i = 0;
                    int n = 0;
                    int max = this.imports.length;
                    while (i < max) {
                        if (this.imports[i] != importBinding) {
                            newImports[n++] = this.imports[i];
                        }
                        ++i;
                    }
                    this.imports = newImports;
                }
                return null;
            }
        }
        return importBinding.resolvedImport;
    }

    public void storeDependencyInfo() {
        int i = 0;
        while (i < this.referencedSuperTypes.size) {
            ReferenceBinding[] interfaces;
            ReferenceBinding superclass;
            ReferenceBinding enclosing;
            ReferenceBinding type = (ReferenceBinding)this.referencedSuperTypes.elementAt(i);
            if (!this.referencedTypes.containsIdentical(type)) {
                this.referencedTypes.add(type);
            }
            if (!type.isLocalType() && (enclosing = type.enclosingType()) != null) {
                this.recordSuperTypeReference(enclosing);
            }
            if ((superclass = type.superclass()) != null) {
                this.recordSuperTypeReference(superclass);
            }
            if ((interfaces = type.superInterfaces()) != null) {
                int j = 0;
                int length = interfaces.length;
                while (j < length) {
                    this.recordSuperTypeReference(interfaces[j]);
                    ++j;
                }
            }
            ++i;
        }
        i = 0;
        int l = this.referencedTypes.size;
        while (i < l) {
            ReferenceBinding type = (ReferenceBinding)this.referencedTypes.elementAt(i);
            if (!type.isLocalType()) {
                this.recordQualifiedReference(type.isMemberType() ? CharOperation.splitOn('.', type.readableName()) : type.compoundName);
            }
            ++i;
        }
        int size = this.qualifiedReferences.size;
        char[][][] qualifiedRefs = new char[size][][];
        int i2 = 0;
        while (i2 < size) {
            qualifiedRefs[i2] = this.qualifiedReferences.elementAt(i2);
            ++i2;
        }
        this.referenceContext.compilationResult.qualifiedReferences = qualifiedRefs;
        size = this.simpleNameReferences.size;
        char[][] simpleRefs = new char[size][];
        int i3 = 0;
        while (i3 < size) {
            simpleRefs[i3] = this.simpleNameReferences.elementAt(i3);
            ++i3;
        }
        this.referenceContext.compilationResult.simpleNameReferences = simpleRefs;
    }

    public String toString() {
        return "--- CompilationUnit Scope : " + new String(this.referenceContext.getFileName());
    }

    private ReferenceBinding typeToRecord(TypeBinding type) {
        ReferenceBinding refType;
        if (type.isArrayType()) {
            type = ((ArrayBinding)type).leafComponentType;
        }
        switch (type.kind()) {
            case 260: 
            case 2052: {
                return null;
            }
            case 132: 
            case 516: {
                type = type.erasure();
            }
        }
        if (type instanceof ReferenceBinding && !(refType = (ReferenceBinding)type).isLocalType()) {
            return refType;
        }
        return null;
    }

    public void verifyMethods(MethodVerifier verifier) {
        int i = 0;
        int length = this.topLevelTypes.length;
        while (i < length) {
            this.topLevelTypes[i].verifyMethods(verifier);
            ++i;
        }
    }
}

