/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.text.similarity;

import java.util.HashMap;
import org.apache.commons.text.similarity.CosineSimilarity;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class CosineSimilarityTest {
    @Test
    public void testCosineSimilarityReturningDoubleWhereByteValueIsZero() {
        HashMap hashMap = new HashMap();
        Assertions.assertEquals((double)0.0, (double)CosineSimilarity.INSTANCE.cosineSimilarity(hashMap, hashMap), (double)0.01);
    }

    @Test
    public void testCosineSimilarityThrowsIllegalArgumentException() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> CosineSimilarity.INSTANCE.cosineSimilarity(new HashMap(), null));
    }

    @Test
    public void testCosineSimilarityWithNonEmptyMap() {
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        Integer integer = -397;
        hashMap.put("3J/$3.L", integer);
        HashMap hashMapTwo = new HashMap();
        Assertions.assertEquals((double)0.0, (double)CosineSimilarity.INSTANCE.cosineSimilarity(hashMap, hashMapTwo), (double)0.01);
    }

    @Test
    public void testCosineSimilarityWithNull() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> CosineSimilarity.INSTANCE.cosineSimilarity(null, null));
    }
}

