/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.exam;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import org.ops4j.exec.CommandLineBuilder;
import org.ops4j.exec.ExecutionException;
import org.ops4j.exec.ProcessProvider;
import org.ops4j.exec.StoppableJavaRunner;
import org.ops4j.io.Pipe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExamJavaRunner
implements StoppableJavaRunner,
ProcessProvider {
    private final boolean m_wait;
    private Process m_frameworkProcess;
    private Thread m_shutdownHook;
    private static final Logger LOG = LoggerFactory.getLogger(ExamJavaRunner.class);

    public ExamJavaRunner() {
        this(true);
    }

    public ExamJavaRunner(boolean wait) {
        this.m_wait = wait;
    }

    public synchronized void exec(String[] vmOptions, String[] classpath, String mainClass, String[] programOptions, String javaHome, File workingDirectory) throws ExecutionException {
        this.exec(vmOptions, classpath, mainClass, programOptions, javaHome, workingDirectory, new String[0]);
    }

    public synchronized void exec(String[] vmOptions, String[] classpath, String mainClass, String[] programOptions, String javaHome, File workingDirectory, String[] envOptions) throws ExecutionException {
        if (this.m_frameworkProcess != null) {
            throw new ExecutionException("Platform already started");
        }
        String cp = String.join((CharSequence)File.pathSeparator, classpath);
        CommandLineBuilder commandLine = new CommandLineBuilder().append(ExamJavaRunner.getJavaExecutable(javaHome)).append(vmOptions).append("-cp").append(cp).append(mainClass).append(programOptions);
        LOG.debug("Start command line [" + Arrays.toString(commandLine.toArray()) + "]");
        try {
            LOG.debug("Starting platform process.");
            ProcessBuilder pb = new ProcessBuilder(commandLine.toArray()).directory(workingDirectory);
            this.setEnv(envOptions, pb);
            this.m_frameworkProcess = pb.start();
        }
        catch (IOException e) {
            throw new ExecutionException("Could not start up the process", (Throwable)e);
        }
        this.m_shutdownHook = this.createShutdownHook(this.m_frameworkProcess);
        Runtime.getRuntime().addShutdownHook(this.m_shutdownHook);
        LOG.debug("Added shutdown hook.");
        LOG.info("ExamJavaRunner completed successfully");
        if (this.m_wait) {
            this.waitForExit();
        } else {
            System.out.println();
        }
    }

    private void setEnv(String[] envOptions, ProcessBuilder pb) {
        HashSet<String> envSet = new HashSet<String>(Arrays.asList(envOptions));
        Map<String, String> env = pb.environment();
        HashSet<String> toRemove = new HashSet<String>(env.keySet());
        toRemove.removeAll(envSet);
        for (String key : toRemove) {
            env.remove(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        block6: {
            try {
                if (this.m_shutdownHook == null) break block6;
                Thread thread = this.m_shutdownHook;
                synchronized (thread) {
                    if (this.m_shutdownHook != null) {
                        LOG.debug("Shutdown in progress...");
                        Runtime.getRuntime().removeShutdownHook(this.m_shutdownHook);
                        this.m_frameworkProcess = null;
                        this.m_shutdownHook.run();
                        this.m_shutdownHook = null;
                        LOG.info("Platform has been shutdown.");
                    }
                }
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForExit() {
        Process process = this.m_frameworkProcess;
        synchronized (process) {
            try {
                LOG.debug("Waiting for framework exit.");
                System.out.println();
                this.m_frameworkProcess.waitFor();
                this.shutdown();
            }
            catch (Throwable e) {
                LOG.debug("Early shutdown.", e);
                this.shutdown();
            }
        }
    }

    private Thread createShutdownHook(final Process process) {
        LOG.debug("Wrapping stream I/O.");
        final Pipe errPipe = new Pipe(process.getErrorStream(), (OutputStream)System.err).start("Error pipe");
        final Pipe outPipe = new Pipe(process.getInputStream(), (OutputStream)System.out).start("Out pipe");
        return new Thread(new Runnable(){

            @Override
            public void run() {
                System.out.println();
                LOG.debug("Unwrapping stream I/O.");
                outPipe.stop();
                errPipe.stop();
                try {
                    process.destroy();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }, "ExamJavaRunner shutdown hook");
    }

    static String getJavaExecutable(String javaHome) throws ExecutionException {
        if (javaHome == null) {
            throw new ExecutionException("JAVA_HOME is not set.");
        }
        return javaHome + "/bin/java";
    }

    public Process getProcess() {
        return this.m_frameworkProcess;
    }
}

