/*
 * Decompiled with CFR 0.152.
 */
package megamek.common.weapons;

import megamek.common.AmmoType;
import megamek.common.BattleArmor;
import megamek.common.Compute;
import megamek.common.IGame;
import megamek.common.Infantry;
import megamek.common.ToHitData;
import megamek.common.actions.WeaponAttackAction;
import megamek.common.weapons.MissileWeaponHandler;
import megamek.server.Server;

public class ThunderBoltWeaponHandler
extends MissileWeaponHandler {
    private static final long serialVersionUID = 6329291710822071023L;

    public ThunderBoltWeaponHandler(ToHitData toHitData, WeaponAttackAction weaponAttackAction, IGame iGame, Server server) {
        super(toHitData, weaponAttackAction, iGame, server);
    }

    protected int calcDamagePerHit() {
        AmmoType ammoType = (AmmoType)this.ammo.getType();
        double d = ammoType.getDamagePerShot();
        if (this.nRange <= this.wtype.getMinimumRange() && !this.weapon.isHotLoaded()) {
            d /= 2.0;
            d = Math.floor(d);
        }
        if (this.target instanceof Infantry && !(this.target instanceof BattleArmor)) {
            d = Compute.directBlowInfantryDamage(d, this.bDirect ? this.toHit.getMoS() / 3 : 0, 3, ((Infantry)this.target).isMechanized());
        } else if (this.bDirect) {
            d = Math.min(d + (double)(this.toHit.getMoS() / 3), d * 2.0);
        }
        return (int)Math.ceil(d);
    }
}

