/*
 * Decompiled with CFR 0.152.
 */
package megamek.common.verifier;

import gd.xml.ParseException;
import gd.xml.tiny.ParsedXML;
import gd.xml.tiny.TinyParser;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Enumeration;
import megamek.common.Entity;
import megamek.common.Mech;
import megamek.common.MechFileParser;
import megamek.common.MechSummary;
import megamek.common.MechSummaryCache;
import megamek.common.Tank;
import megamek.common.loaders.EntityLoadingException;
import megamek.common.verifier.TestEntity;
import megamek.common.verifier.TestMech;
import megamek.common.verifier.TestTank;
import megamek.common.verifier.TestXMLOption;

public class EntityVerifier
implements MechSummaryCache.Listener {
    public static final String CONFIG_FILENAME = "data/mechfiles/UnitVerifierOptions.xml";
    public static final String BASE_NODE = "entityverifier";
    public static final String BASE_MECH_NODE = "mech";
    public static final String BASE_TANK_NODE = "tank";
    private static MechSummaryCache mechSummaryCache = null;
    public TestXMLOption mechOption = new TestXMLOption();
    public TestXMLOption tankOption = new TestXMLOption();

    public EntityVerifier(File file) {
        ParsedXML parsedXML = null;
        try {
            parsedXML = TinyParser.parseXML((InputStream)new FileInputStream(file));
            Enumeration enumeration = parsedXML.elements();
            while (enumeration.hasMoreElements()) {
                ParsedXML parsedXML2 = (ParsedXML)enumeration.nextElement();
                if (!parsedXML2.getTypeName().equals("tag") || !parsedXML2.getName().equals(BASE_NODE)) continue;
                this.readOptions(parsedXML2);
            }
        }
        catch (ParseException parseException) {
            System.err.println("EntityVerifier: Failure parsing config file:");
            System.err.println(parseException.getMessage());
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.err.println("EntityVerifier: Configfile not found:");
            System.err.println(fileNotFoundException.getMessage());
        }
    }

    public boolean checkEntity(Entity entity, String string, boolean bl) {
        return this.checkEntity(entity, string, bl, false);
    }

    public boolean checkEntity(Entity entity, String string, boolean bl, boolean bl2) {
        boolean bl3 = false;
        TestEntity testEntity = null;
        if (entity instanceof Mech) {
            testEntity = new TestMech((Mech)entity, this.mechOption, string);
        } else if (entity instanceof Tank) {
            testEntity = new TestTank((Tank)entity, this.tankOption, string);
        } else {
            System.err.println("UnknownType: " + entity.getDisplayName());
            System.err.println("Found in: " + string);
            return false;
        }
        if (bl) {
            System.out.print(testEntity.printEntity());
            StringBuffer stringBuffer = new StringBuffer();
            System.out.println("BV: " + entity.calculateBattleValue() + "    Cost: " + entity.getCost());
            if (testEntity.correctEntity(stringBuffer, bl2)) {
                System.out.println("---Entity is valid---");
            } else {
                System.out.println("---Entity INVALID---");
            }
        } else {
            StringBuffer stringBuffer = new StringBuffer();
            if (testEntity.correctEntity(stringBuffer, bl2)) {
                bl3 = true;
            } else {
                System.out.println(testEntity.getName());
                System.out.println("Found in: " + testEntity.fileString);
                System.out.println(stringBuffer);
            }
        }
        return bl3;
    }

    public Entity loadEntity(File file, String string) {
        Entity entity = null;
        try {
            entity = new MechFileParser(file, string).getEntity();
        }
        catch (EntityLoadingException entityLoadingException) {
            System.out.println("Exception: " + entityLoadingException.toString());
        }
        return entity;
    }

    public void doneLoading() {
        MechSummary[] mechSummaryArray = mechSummaryCache.getAllMechs();
        System.out.println("\n");
        System.out.println("Mech Options:");
        System.out.println(this.mechOption.printOptions());
        System.out.println("\nTank Options:");
        System.out.println(this.tankOption.printOptions());
        int n = 0;
        for (int i = 0; i < mechSummaryArray.length; ++i) {
            Entity entity;
            if (!mechSummaryArray[i].getUnitType().equals("Mek") && !mechSummaryArray[i].getUnitType().equals("Tank") || (entity = this.loadEntity(mechSummaryArray[i].getSourceFile(), mechSummaryArray[i].getEntryName())) == null || this.checkEntity(entity, mechSummaryArray[i].getSourceFile().toString(), false)) continue;
            ++n;
        }
        System.out.println("Total Failures: " + n);
    }

    private void readOptions(ParsedXML parsedXML) {
        Enumeration enumeration = parsedXML.elements();
        while (enumeration.hasMoreElements()) {
            ParsedXML parsedXML2 = (ParsedXML)enumeration.nextElement();
            if (parsedXML2.getName().equals(BASE_TANK_NODE)) {
                this.tankOption.readXMLOptions(parsedXML2);
                continue;
            }
            if (!parsedXML2.getName().equals(BASE_MECH_NODE)) continue;
            this.mechOption.readXMLOptions(parsedXML2);
        }
    }

    public static void main(String[] stringArray) {
        File file = new File(CONFIG_FILENAME);
        File file2 = null;
        String string = null;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-file")) {
                if (stringArray.length <= i) {
                    System.out.println("Missing argument filename!");
                    return;
                }
                if (!(file2 = new File(stringArray[++i])).exists()) {
                    System.out.println("Can't find: " + stringArray[i] + "!");
                    return;
                }
                if (!stringArray[i].endsWith(".zip")) continue;
                if (stringArray.length <= i + 1) {
                    System.out.println("Missing Entity Name!");
                    return;
                }
                string = stringArray[++i];
                continue;
            }
            System.err.println("Error: Invalid argument.\n");
            System.err.println("Usage:\n\tEntityVerifier [-file <FILENAME>]");
            return;
        }
        if (file2 != null) {
            Entity entity = null;
            try {
                entity = new MechFileParser(file2, string).getEntity();
            }
            catch (EntityLoadingException entityLoadingException) {
                System.err.println("Exception: " + entityLoadingException.toString());
                System.err.println("Exception: " + entityLoadingException.getMessage());
                return;
            }
            new EntityVerifier(file).checkEntity(entity, file2.toString(), true);
        } else {
            EntityVerifier entityVerifier = new EntityVerifier(file);
            mechSummaryCache = MechSummaryCache.getInstance();
            mechSummaryCache.addListener(entityVerifier);
        }
    }
}

