/*
 * Decompiled with CFR 0.152.
 */
package megamek.common;

import megamek.common.Aero;
import megamek.common.ConvFighter;
import megamek.common.Dropship;
import megamek.common.Entity;
import megamek.common.GunEmplacement;
import megamek.common.Infantry;
import megamek.common.Jumpship;
import megamek.common.Mech;
import megamek.common.Messages;
import megamek.common.Protomech;
import megamek.common.SmallCraft;
import megamek.common.Tank;
import megamek.common.VTOL;
import megamek.common.Warship;

public class UnitType {
    public static final int MEK = 0;
    public static final int TANK = 1;
    public static final int BATTLE_ARMOR = 2;
    public static final int INFANTRY = 3;
    public static final int PROTOMEK = 4;
    public static final int VTOL = 5;
    public static final int NAVAL = 6;
    public static final int GUN_EMPLACEMENT = 7;
    public static final int CONV_FIGHTER = 8;
    public static final int AERO = 9;
    public static final int SMALL_CRAFT = 10;
    public static final int DROPSHIP = 11;
    public static final int WARSHIP = 12;
    public static final int JUMPSHIP = 13;
    public static final int SPACE_STATION = 14;
    private static String[] names = new String[]{"Mek", "Tank", "BattleArmor", "Infantry", "ProtoMek", "VTOL", "Naval", "Gun Emplacement", "Conventional Fighter", "Aero", "Small Craft", "Dropship", "Jumpship", "Warship", "Space Station"};
    public static final int SIZE = names.length;

    public static String determineUnitType(Entity entity) {
        return names[UnitType.determineUnitTypeCode(entity)];
    }

    public static int determineUnitTypeCode(Entity entity) {
        int n = entity.getMovementMode();
        if (entity instanceof Infantry) {
            return 3;
        }
        if (entity instanceof VTOL) {
            return 5;
        }
        if (n == 7 || n == 8 || n == 9) {
            return 6;
        }
        if (entity instanceof Tank) {
            return 1;
        }
        if (entity instanceof Mech) {
            return 0;
        }
        if (entity instanceof Protomech) {
            return 4;
        }
        if (entity instanceof GunEmplacement) {
            return 7;
        }
        if (entity instanceof Warship) {
            return 12;
        }
        if (entity instanceof Jumpship) {
            return 13;
        }
        if (entity instanceof Dropship) {
            return 11;
        }
        if (entity instanceof SmallCraft) {
            return 10;
        }
        if (entity instanceof ConvFighter) {
            return 8;
        }
        if (entity instanceof Aero) {
            return 9;
        }
        throw new IllegalArgumentException("Unknown unit type");
    }

    public static String getTypeName(int n) {
        if (n >= 0 && n < SIZE) {
            return names[n];
        }
        throw new IllegalArgumentException("Unknown unit type");
    }

    public static String getTypeDisplayableName(int n) {
        if (n >= 0 && n < SIZE) {
            return Messages.getString("UnitType." + names[n]);
        }
        throw new IllegalArgumentException("Unknown unit type");
    }
}

