/* Copyright 2006 aQute SARL 
 * Licensed under the Apache License, Version 2.0, see http://www.apache.org/licenses/LICENSE-2.0 */

package aQute.bnd.ant;

import java.io.*;
import java.util.*;

import org.apache.tools.ant.*;
import org.apache.tools.ant.types.*;

import aQute.lib.osgi.*;
import aQute.lib.osgi.eclipse.*;
import aQute.lib.qtokens.*;
import aQute.lib.reporter.*;

public class BndTask extends BaseTask implements Reporter {
	List	files		= new ArrayList();
	List	classpath	= new ArrayList();
	List	sourcepath	= new ArrayList();
	File	output		= null;
	File	testDir		= null;

	boolean	failok;
	boolean	exceptions;
	boolean	print;
	boolean	eclipse;

	public void execute() throws BuildException {
		try {
			if (files == null)
				throw new BuildException("No files set");

			if (eclipse) {
				File project = getProject().getBaseDir();
				EclipseClasspath cp = new EclipseClasspath(this, project
						.getParentFile(), project);
				classpath.addAll(cp.getClasspath());
				classpath.addAll(cp.getBootclasspath());
				sourcepath.addAll(cp.getSourcepath());
				classpath.add(cp.getOutput());
				if (report())
					throw new BuildException(
							"Errors during Eclipse Path inspection");

			}

			if (output == null)
				output = getProject().getBaseDir();

			for (Iterator f = files.iterator(); f.hasNext();) {
				File file = (File) f.next();
				String bsn = file.getName().replaceAll("\\.bnd$", "");
				Builder builder = new Builder();
				builder.setPedantic(isPedantic());
				if (file.exists()) {
					// Do nice property calculations
					// merging includes etc.
					builder.setProperties(file);
				}
				// get them and merge them with the project
				// properties
				Properties projectProperties = new Properties();
				projectProperties.putAll(getProject().getProperties());
				projectProperties.putAll(builder.getProperties());
				builder.setProperties(projectProperties);
				builder.setClasspath(toFiles(classpath, "classpath"));
				builder.setSourcepath(toFiles(sourcepath, "sourcepath"));
				builder.build();
				Jar jar = builder.getJar();
				jar.setName(bsn);

				if (!failok && report()) {
					throw new BuildException("Errors during build: "
							+ builder.getErrors(), new Location(file.getName()));
				}

				File output = this.output;
				if (output.isDirectory()) {
					output = getFile(this.output, bsn + ".jar");

				} else {
					if (files.size() > 1)
						error("Output is a file but there are multiple input files, these files will overwrite the output file: "
								+ output.getAbsolutePath());
				}

				String msg = "";
				if (!output.exists()
						|| output.lastModified() <= jar.lastModified()) {
					jar.write(output);
				} else {
					msg = "(not modified)";
				}
				System.out.println(jar.getName() + " "
						+ jar.getResources().size() + " " + msg);
				report();
				jar.close();
				builder.close();
			}
		} catch (Exception e) {
			// if (exceptions)
			e.printStackTrace();
			if (!failok)
				throw new BuildException("Failed to build jar file: ", e);
		}
	}

	public void setFiles(String files) {
		files = files.replaceAll("\\.jar(,|$)", ".bnd");
		addAll(this.files, files, ",");
	}

	void addAll(List list, String files, String separator) {
		QuotedTokenizer qt = new QuotedTokenizer(files, separator);
		String entries[] = qt.getTokens();
		File project = getProject().getBaseDir();
		for (int i = 0; i < entries.length; i++) {
			File f = getFile(project, entries[i]);
			if (f.exists())
				list.add(f);
			else
				error("Can not find bnd file to process: "
						+ f.getAbsolutePath());
		}
	}

	public void setClasspath(String value) {
		Path p = (Path) getProject().getReference(value);
		if ( p == null )
			addAll(classpath, value, File.pathSeparator + ",");
		else {
	    	String[] path =  p.list();
	    	for (int i = 0; i < path.length; i++)
				classpath.add(path[i]);			
		}
	}

	public void setEclipse(boolean eclipse) {
		this.eclipse = eclipse;
	}

	boolean isFailok() {
		return failok;
	}

	public void setFailok(boolean failok) {
		this.failok = failok;
	}

	boolean isExceptions() {
		return exceptions;
	}

	public void setExceptions(boolean exceptions) {
		this.exceptions = exceptions;
	}

	boolean isPrint() {
		return print;
	}

	void setPrint(boolean print) {
		this.print = print;
	}

	public void setSourcepath(String sourcepath) {
		addAll(this.sourcepath, sourcepath, File.pathSeparator + ",");
	}

	static File[]	EMPTY_FILES	= new File[0];

	File[] toFiles(List files, String what) throws IOException {
		return (File[]) files.toArray(EMPTY_FILES);
	}

	public void setOutput(File output) {
		this.output = output;
	}

	public void setDestFile(File output) {
		this.output = output;
	}

	public void setTestDir(File testDir) {
		this.testDir = testDir;
	}

}
