package aQute.impl.logger;

import org.osgi.framework.*;
import org.osgi.service.log.*;
import org.osgi.util.tracker.*;

/**
 * @author pkriens
 * 
 * To change this generated comment edit the template variable "typecomment":
 * Window>Preferences>Java>Templates. To enable and disable the creation of type
 * comments go to Window>Preferences>Java>Code Generation.
 */
public class Logger extends ServiceTracker
		implements
			org.osgi.service.log.LogService {
	boolean	stacktrace;
	String	prefix	= "";

	public void setPrefix(String s) {
		prefix = "[" + s + "]";
	}

	LogService	syslog	= new LogService() {
							public void log(int level, String message,
									Throwable exception) {
								System.err.println(getLevel(level) + ":"
										+ message);
								if (stacktrace)
									exception.printStackTrace();
							}

							/**
							 * @see org.osgi.service.log.LogService#log(int,
							 *      String)
							 */
							public void log(int level, String message) {
								System.err.println(getLevel(level) + " "
										+ message);
							}

							/**
							 * @see org.osgi.service.log.LogService#log(ServiceReference,
							 *      int, String, Throwable)
							 */
							public void log(ServiceReference sr, int level,
									String message, Throwable exception) {
								System.err.println(getLevel(level) + " "
										+ message);
							}

							/**
							 * @see org.osgi.service.log.LogService#log(ServiceReference,
							 *      int, String)
							 */
							public void log(ServiceReference sr, int level,
									String message) {
								System.err.println(getLevel(level) + " "
										+ message);
							}

							public String getLevel(int level) {
								switch (level) {
									case LogService.LOG_INFO :
										return "INFO   ";
									case LogService.LOG_ERROR :
										return "ERROR  ";
									case LogService.LOG_DEBUG :
										return "DEBUG  ";
									case LogService.LOG_WARNING :
										return "WARNING";
								}
								return level + "";
							}
						};

	public Logger(BundleContext context) {
		super(context, org.osgi.service.log.LogService.class.getName(), null);
	}
	/**
	 * @see org.osgi.service.log.LogService#log(int, String, Throwable)
	 */
	public void log(int level, String message, Throwable exception) {
		getLog().log(level, prefix + message, exception);
	}

	/**
	 * @see org.osgi.service.log.LogService#log(int, String)
	 */
	public void log(int level, String message) {
		getLog().log(level, prefix + message);
	}

	/**
	 * @see org.osgi.service.log.LogService#log(ServiceReference, int, String,
	 *      Throwable)
	 */
	public void log(ServiceReference sr, int level, String message,
			Throwable exception) {
		getLog().log(sr, level, prefix + message, exception);
	}

	/**
	 * @see org.osgi.service.log.LogService#log(ServiceReference, int, String)
	 */
	public void log(ServiceReference sr, int level, String message) {
		getLog().log(sr, level, prefix + message);
	}

	LogService getLog() {
		LogService log = (LogService) getService();
		if (log == null)
			return syslog;
		else
			return log;
	}

}