/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.pricingengines;

import org.jquantlib.instruments.AssetOrNothingPayoff;
import org.jquantlib.instruments.CashOrNothingPayoff;
import org.jquantlib.instruments.Option;
import org.jquantlib.instruments.StrikedTypePayoff;
import org.jquantlib.math.distributions.CumulativeNormalDistribution;

public class AmericanPayoffAtHit {
    private final double spot;
    private final double variance;
    private final double stdDev;
    private double strike;
    private double K;
    private double DKDstrike;
    private final double mu;
    private final double lambda;
    private final double muPlusLambda;
    private final double muMinusLambda;
    private final double log_H_S;
    private double D1;
    private double D2;
    private double cum_d1;
    private double cum_d2;
    private double n_d1;
    private double n_d2;
    private final double alpha;
    private final double beta;
    private final double DalphaDd1;
    private final double DbetaDd2;
    private final boolean inTheMoney;
    private double forward;
    private double X;
    private double DXDstrike;

    public AmericanPayoffAtHit(double spot, double discount, double dividendDiscount, double variance, StrikedTypePayoff strikedTypePayoff) {
        this.spot = spot;
        this.variance = variance;
        if (spot <= 0.0) {
            throw new IllegalArgumentException("positive spot value required: " + spot + " not allowed");
        }
        if (discount <= 0.0) {
            throw new IllegalArgumentException("positive discount required: " + discount + " not allowed");
        }
        if (dividendDiscount <= 0.0) {
            throw new IllegalArgumentException("positive dividend discount required: " + dividendDiscount + " not allowed");
        }
        if (variance < 0.0) {
            throw new IllegalArgumentException("negative variance: " + variance + " not allowed");
        }
        this.stdDev = Math.sqrt(variance);
        Option.Type optionType = strikedTypePayoff.optionType();
        this.strike = strikedTypePayoff.strike();
        this.log_H_S = Math.log(this.strike / spot);
        if (variance >= Math.E) {
            if (discount == 0.0 && dividendDiscount == 0.0) {
                this.mu = -0.5;
                this.lambda = 0.5;
            } else {
                if (discount == 0.0) {
                    throw new IllegalArgumentException("null discount not handled yet");
                }
                this.mu = Math.log(dividendDiscount / discount) / variance - 0.5;
                this.lambda = Math.sqrt(this.mu * this.mu - 2.0 * Math.log(discount) / variance);
            }
            this.D1 = this.log_H_S / this.stdDev + this.lambda * this.stdDev;
            this.D2 = this.D1 - 2.0 * this.lambda * this.stdDev;
            CumulativeNormalDistribution f = new CumulativeNormalDistribution();
            this.cum_d1 = f.evaluate(this.D1);
            this.cum_d2 = f.evaluate(this.D2);
            this.n_d1 = f.derivative(this.D1);
            this.n_d2 = f.derivative(this.D2);
        } else {
            this.mu = Math.log(dividendDiscount / discount) / variance - 0.5;
            this.lambda = Math.sqrt(this.mu * this.mu - 2.0 * Math.log(discount) / variance);
            if (this.log_H_S > 0.0) {
                this.cum_d1 = 1.0;
                this.cum_d2 = 1.0;
            } else {
                this.cum_d1 = 0.0;
                this.cum_d2 = 0.0;
            }
            this.n_d1 = 0.0;
            this.n_d2 = 0.0;
        }
        if (optionType.equals((Object)Option.Type.CALL)) {
            if (this.strike > spot) {
                this.alpha = 1.0 - this.cum_d1;
                this.DalphaDd1 = -this.n_d1;
                this.beta = 1.0 - this.cum_d2;
                this.DbetaDd2 = -this.n_d2;
            } else {
                this.alpha = 0.5;
                this.DalphaDd1 = 0.0;
                this.beta = 0.5;
                this.DbetaDd2 = 0.0;
            }
        } else if (optionType.equals((Object)Option.Type.PUT)) {
            if (this.strike < spot) {
                this.alpha = this.cum_d1;
                this.DalphaDd1 = this.n_d1;
                this.beta = this.cum_d2;
                this.DbetaDd2 = this.n_d2;
            } else {
                this.alpha = 0.5;
                this.DalphaDd1 = 0.0;
                this.beta = 0.5;
                this.DbetaDd2 = 0.0;
            }
        } else {
            throw new IllegalArgumentException("invalid option type");
        }
        this.muPlusLambda = this.mu + this.lambda;
        this.muMinusLambda = this.mu - this.lambda;
        boolean bl = this.inTheMoney = optionType.equals((Object)Option.Type.CALL) && this.strike < spot || optionType.equals((Object)Option.Type.PUT) && this.strike > spot;
        if (this.inTheMoney) {
            this.forward = 1.0;
            this.X = 1.0;
            this.DXDstrike = 0.0;
        } else {
            this.forward = Math.pow(this.strike / spot, this.muPlusLambda);
            this.X = Math.pow(this.strike / spot, this.muMinusLambda);
        }
        if (strikedTypePayoff instanceof CashOrNothingPayoff) {
            CashOrNothingPayoff coo = (CashOrNothingPayoff)strikedTypePayoff;
            this.K = coo.getCashPayoff();
            this.DKDstrike = 0.0;
        }
        if (strikedTypePayoff instanceof AssetOrNothingPayoff) {
            AssetOrNothingPayoff aoo = (AssetOrNothingPayoff)strikedTypePayoff;
            if (this.inTheMoney) {
                this.K = spot;
                this.DKDstrike = 0.0;
            } else {
                this.K = aoo.strike();
                this.DKDstrike = 1.0;
            }
        }
    }

    public double value() {
        double result = this.K * (this.forward * this.alpha + this.X * this.beta);
        return result;
    }

    public double delta() {
        double DXDs;
        double DforwardDs;
        double tempDelta = -this.spot * this.stdDev;
        double DalphaDs = this.DalphaDd1 / tempDelta;
        double DbetaDs = this.DbetaDd2 / tempDelta;
        if (this.inTheMoney) {
            DforwardDs = 0.0;
            DXDs = 0.0;
        } else {
            DforwardDs = -this.muPlusLambda * this.forward / this.spot;
            DXDs = -this.muMinusLambda * this.X / this.spot;
        }
        double delta = this.K * (DalphaDs * this.forward + this.alpha * DforwardDs + DbetaDs * this.X + this.beta * DXDs);
        return delta;
    }

    public double gamma() {
        double D2XDs2;
        double D2forwardDs2;
        double DXDs;
        double DforwardDs;
        double tempDelta = -this.spot * this.stdDev;
        double DalphaDs = this.DalphaDd1 / tempDelta;
        double DbetaDs = this.DbetaDd2 / tempDelta;
        double D2alphaDs2 = -DalphaDs / this.spot * (1.0 - this.D1 / this.stdDev);
        double D2betaDs2 = -DbetaDs / this.spot * (1.0 - this.D2 / this.stdDev);
        if (this.inTheMoney) {
            DforwardDs = 0.0;
            DXDs = 0.0;
            D2forwardDs2 = 0.0;
            D2XDs2 = 0.0;
        } else {
            DforwardDs = -this.muPlusLambda * this.forward / this.spot;
            DXDs = -this.muMinusLambda * this.X / this.spot;
            D2forwardDs2 = this.muPlusLambda * this.forward / (this.spot * this.spot) * (1.0 + this.muPlusLambda);
            D2XDs2 = this.muMinusLambda * this.X / (this.spot * this.spot) * (1.0 + this.muMinusLambda);
        }
        double gamma = this.K * (D2alphaDs2 * this.forward + DalphaDs * DforwardDs + DalphaDs * DforwardDs + this.alpha * D2forwardDs2 + D2betaDs2 * this.X + DbetaDs * DXDs + DbetaDs * DXDs + this.beta * D2XDs2);
        return gamma;
    }

    public double theta(double maturity) {
        double DXDr;
        double DforwardDr;
        if (maturity <= 0.0) {
            throw new IllegalArgumentException("negative maturity: " + maturity + " not allowed");
        }
        double DalphaDr = -this.DalphaDd1 / (this.lambda * this.stdDev) * (1.0 + this.mu);
        double DbetaDr = this.DbetaDd2 / (this.lambda * this.stdDev) * (1.0 + this.mu);
        if (this.inTheMoney) {
            DforwardDr = 0.0;
            DXDr = 0.0;
        } else {
            DforwardDr = this.forward * (1.0 + (1.0 + this.mu) / this.lambda) * this.log_H_S / this.variance;
            DXDr = this.X * (1.0 - (1.0 + this.mu) / this.lambda) * this.log_H_S / this.variance;
        }
        double theta = maturity * this.K * (DalphaDr * this.forward + this.alpha * DforwardDr + DbetaDr * this.X + this.beta * DXDr);
        return theta;
    }
}

