/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.time.calendars;

import org.jquantlib.time.Weekday;
import org.jquantlib.time.WesternCalendar;
import org.jquantlib.time.calendars.DelegateCalendar;
import org.jquantlib.util.Date;
import org.jquantlib.util.Month;

public class Canada
extends DelegateCalendar {
    private static final Canada SETTLEMENT_CALENDAR = new Canada(Market.SETTLEMENT);
    private static final Canada TSX_CALENDAR = new Canada(Market.TSX);

    private Canada(Market market) {
        WesternCalendar delegate;
        switch (market) {
            case SETTLEMENT: {
                delegate = new CanadaSettlementCalendar();
                break;
            }
            case TSX: {
                delegate = new TsxCalendar();
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown market");
            }
        }
        this.setDelegate(delegate);
    }

    public static Canada getCalendar(Market market) {
        switch (market) {
            case SETTLEMENT: {
                return SETTLEMENT_CALENDAR;
            }
            case TSX: {
                return TSX_CALENDAR;
            }
        }
        throw new IllegalArgumentException("unknown market");
    }

    private static final class TsxCalendar
    extends WesternCalendar {
        private TsxCalendar() {
        }

        @Override
        public String getName() {
            return "TSX";
        }

        @Override
        public boolean isBusinessDay(Date date) {
            Weekday w = date.getWeekday();
            int d = date.getDayOfMonth();
            int dd = date.getDayOfYear();
            Month m = date.getMonthEnum();
            int y = date.getYear();
            int em = this.easterMonday(y);
            return !(this.isWeekend(w) || (d == 1 || d == 2 && w == Weekday.MONDAY) && m == Month.JANUARY || d >= 15 && d <= 21 && w == Weekday.MONDAY && m == Month.FEBRUARY && y >= 2008 || dd == em - 3 || d > 17 && d <= 24 && w == Weekday.MONDAY && m == Month.MAY || (d == 1 || (d == 2 || d == 3) && w == Weekday.MONDAY) && m == Month.JULY || d <= 7 && w == Weekday.MONDAY && m == Month.AUGUST || d <= 7 && w == Weekday.MONDAY && m == Month.SEPTEMBER || d > 7 && d <= 14 && w == Weekday.MONDAY && m == Month.OCTOBER || (d == 25 || d == 27 && (w == Weekday.MONDAY || w == Weekday.TUESDAY)) && m == Month.DECEMBER) && (d != 26 && (d != 28 || w != Weekday.MONDAY && w != Weekday.TUESDAY) || m != Month.DECEMBER);
        }
    }

    private static final class CanadaSettlementCalendar
    extends WesternCalendar {
        private CanadaSettlementCalendar() {
        }

        @Override
        public String getName() {
            return "Canada";
        }

        @Override
        public boolean isBusinessDay(Date date) {
            Weekday w = date.getWeekday();
            int d = date.getDayOfMonth();
            int dd = date.getDayOfYear();
            Month m = date.getMonthEnum();
            int y = date.getYear();
            int em = this.easterMonday(y);
            return !(this.isWeekend(w) || (d == 1 || d == 2 && w == Weekday.MONDAY) && m == Month.JANUARY || d >= 15 && d <= 21 && w == Weekday.MONDAY && m == Month.FEBRUARY && y >= 2008 || dd == em - 3 || d > 17 && d <= 24 && w == Weekday.MONDAY && m == Month.MAY || (d == 1 || (d == 2 || d == 3) && w == Weekday.MONDAY) && m == Month.JULY || d <= 7 && w == Weekday.MONDAY && m == Month.AUGUST || d <= 7 && w == Weekday.MONDAY && m == Month.SEPTEMBER || d > 7 && d <= 14 && w == Weekday.MONDAY && m == Month.OCTOBER || (d == 11 || (d == 12 || d == 13) && w == Weekday.MONDAY) && m == Month.NOVEMBER || (d == 25 || d == 27 && (w == Weekday.MONDAY || w == Weekday.TUESDAY)) && m == Month.DECEMBER) && (d != 26 && (d != 28 || w != Weekday.MONDAY && w != Weekday.TUESDAY) || m != Month.DECEMBER);
        }
    }

    public static enum Market {
        SETTLEMENT,
        TSX;

    }
}

