/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.termstructures.yieldcurves;

import org.jquantlib.daycounters.DayCounter;
import org.jquantlib.quotes.Handle;
import org.jquantlib.quotes.Quote;
import org.jquantlib.termstructures.Compounding;
import org.jquantlib.termstructures.YieldTermStructure;
import org.jquantlib.termstructures.yieldcurves.ForwardRateStructure;
import org.jquantlib.time.Calendar;
import org.jquantlib.time.Frequency;
import org.jquantlib.util.Date;

public class ForwardSpreadedTermStructure
extends ForwardRateStructure {
    private Handle<YieldTermStructure> originalCurve_;
    private Handle<Quote> spread_;

    public ForwardSpreadedTermStructure(Handle<YieldTermStructure> h, Handle<Quote> spread) {
        this.originalCurve_ = h;
        this.spread_ = spread;
    }

    @Override
    public DayCounter dayCounter() {
        return this.originalCurve_.getLink().dayCounter();
    }

    @Override
    public Calendar calendar() {
        return this.originalCurve_.getLink().calendar();
    }

    @Override
    public Date referenceDate() {
        return this.originalCurve_.getLink().referenceDate();
    }

    @Override
    public Date maxDate() {
        return this.originalCurve_.getLink().maxDate();
    }

    @Override
    public double maxTime() {
        return this.originalCurve_.getLink().maxTime();
    }

    @Override
    protected double forwardImpl(double t) {
        return this.originalCurve_.getLink().forwardRate(t, t, Compounding.CONTINUOUS, Frequency.NO_FREQUENCY, true).rate() + this.spread_.getLink().evaluate();
    }

    @Override
    public double zeroYieldImpl(double t) {
        return this.originalCurve_.getLink().zeroRate(t, Compounding.CONTINUOUS, Frequency.NO_FREQUENCY, true).rate() + this.spread_.getLink().evaluate();
    }
}

