/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.ds.service;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Dictionary;
import java.util.Iterator;
import org.eclipse.equinox.ds.Activator;
import org.eclipse.equinox.ds.model.ComponentDescription;
import org.eclipse.equinox.ds.model.ComponentDescriptionProp;
import org.eclipse.equinox.ds.resolver.Reference;
import org.eclipse.equinox.ds.service.ComponentInstanceImpl;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.ComponentException;
import org.osgi.service.component.ComponentInstance;

public class ComponentContextImpl
implements ComponentContext {
    BundleContext bundleContext;
    private ComponentInstanceImpl componentInstance;
    private ComponentDescriptionProp cdp;
    Activator main;
    private Bundle usingBundle;

    public ComponentContextImpl(Activator main, Bundle usingBundle, ComponentInstanceImpl componentInstance) {
        this.cdp = componentInstance.getComponentDescriptionProp();
        this.componentInstance = componentInstance;
        this.bundleContext = this.cdp.getComponentDescription().getBundleContext();
        this.usingBundle = usingBundle;
        this.main = main;
    }

    public Dictionary getProperties() {
        return (Dictionary)this.cdp.getProperties().clone();
    }

    public Object locateService(String name) throws ComponentException {
        try {
            Iterator references = this.cdp.getReferences().iterator();
            Reference thisReference = null;
            while (references.hasNext()) {
                Reference reference = (Reference)references.next();
                if (!reference.getReferenceDescription().getName().equals(name)) continue;
                thisReference = reference;
                break;
            }
            if (thisReference != null) {
                Object serviceReference = null;
                if (!thisReference.getServiceReferences().isEmpty()) {
                    serviceReference = (ServiceReference)thisReference.getServiceReferences().iterator().next();
                } else {
                    Object[] serviceReferences = this.bundleContext.getServiceReferences(thisReference.getReferenceDescription().getInterfacename(), thisReference.getTarget());
                    if (serviceReferences != null && serviceReferences.length > 0) {
                        Arrays.sort(serviceReferences);
                        serviceReference = serviceReferences[0];
                    }
                }
                if (serviceReference != null) {
                    Object serviceObject = this.main.resolver.instanceProcess.buildDispose.getService(thisReference, (ServiceReference)serviceReference);
                    thisReference.addServiceReference((ServiceReference)serviceReference, serviceObject);
                    return serviceObject;
                }
            }
            return null;
        }
        catch (Exception e) {
            throw new ComponentException((Throwable)e);
        }
    }

    public Object locateService(String name, ServiceReference serviceReference) throws ComponentException {
        Iterator references = this.cdp.getReferences().iterator();
        Reference thisReference = null;
        while (references.hasNext()) {
            Reference reference = (Reference)references.next();
            if (!reference.getReferenceDescription().getName().equals(name)) continue;
            thisReference = reference;
            break;
        }
        if (thisReference != null) {
            Object serviceObject = this.main.resolver.instanceProcess.buildDispose.getService(thisReference, serviceReference);
            thisReference.addServiceReference(serviceReference, serviceObject);
            return serviceObject;
        }
        return null;
    }

    public Object[] locateServices(String name) throws ComponentException {
        try {
            Object[] serviceReferences;
            Iterator references = this.cdp.getReferences().iterator();
            Reference thisReference = null;
            while (references.hasNext()) {
                Reference reference = (Reference)references.next();
                if (!reference.getReferenceDescription().getName().equals(name)) continue;
                thisReference = reference;
                break;
            }
            if (thisReference != null && (serviceReferences = this.bundleContext.getServiceReferences(thisReference.getReferenceDescription().getInterfacename(), thisReference.getTarget())) != null) {
                Arrays.sort(serviceReferences);
                ArrayList<Object> serviceObjects = new ArrayList<Object>(serviceReferences.length);
                int counter = 0;
                while (counter < serviceReferences.length) {
                    Object serviceObject = this.main.resolver.instanceProcess.buildDispose.getService(thisReference, (ServiceReference)serviceReferences[counter]);
                    if (serviceObject != null) {
                        serviceObjects.add(serviceObject);
                        thisReference.addServiceReference((ServiceReference)serviceReferences[counter], serviceObject);
                    }
                    ++counter;
                }
                if (!serviceObjects.isEmpty()) {
                    return serviceObjects.toArray();
                }
            }
            return null;
        }
        catch (InvalidSyntaxException e) {
            throw new ComponentException(e.getMessage());
        }
    }

    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    public Bundle getUsingBundle() {
        ComponentDescription cd = this.cdp.getComponentDescription();
        if (cd.getService() == null || !cd.getService().isServicefactory()) {
            return null;
        }
        return this.usingBundle;
    }

    public ComponentInstance getComponentInstance() {
        return this.componentInstance;
    }

    public void enableComponent(String name) {
        final String componentName = name;
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                ComponentContextImpl.this.main.enableComponent(componentName, ComponentContextImpl.this.bundleContext.getBundle());
                return null;
            }
        });
    }

    public void disableComponent(String name) {
        final String componentName = name;
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                ComponentContextImpl.this.main.disableComponent(componentName, ComponentContextImpl.this.bundleContext.getBundle());
                return null;
            }
        });
    }

    public ServiceReference getServiceReference() {
        ServiceRegistration serviceRegistration;
        ServiceReference serviceReference = null;
        if (this.cdp.getComponentDescription().getService() != null && (serviceRegistration = this.cdp.getServiceRegistration()) != null) {
            serviceReference = serviceRegistration.getReference();
        }
        return serviceReference;
    }
}

