/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.ds.resolver;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.equinox.ds.Activator;
import org.eclipse.equinox.ds.Log;
import org.eclipse.equinox.ds.instance.InstanceProcess;
import org.eclipse.equinox.ds.model.ComponentDescription;
import org.eclipse.equinox.ds.model.ComponentDescriptionProp;
import org.eclipse.equinox.ds.model.ProvideDescription;
import org.eclipse.equinox.ds.model.ReferenceDescription;
import org.eclipse.equinox.ds.resolver.CircularityException;
import org.eclipse.equinox.ds.resolver.Reference;
import org.eclipse.equinox.ds.workqueue.WorkDispatcher;
import org.eclipse.equinox.ds.workqueue.WorkQueue;
import org.osgi.framework.AllServiceListener;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServicePermission;
import org.osgi.framework.ServiceReference;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.component.ComponentException;
import org.osgi.util.tracker.ServiceTracker;

public class Resolver
implements AllServiceListener,
WorkDispatcher {
    private static final boolean DEBUG = false;
    private static long componentid;
    public ServiceTracker configAdminTracker;
    private static final int BUILD = 1;
    public static final int DYNAMICBIND = 3;
    private Activator main;
    public InstanceProcess instanceProcess;
    public List enabledCDPs;
    public List satisfiedCDPs;
    public Map enabledCDsByName;
    private WorkQueue workQueue;
    static /* synthetic */ Class class$0;

    public Resolver(Activator main) {
        this.main = main;
        componentid = 1L;
        this.workQueue = main.workQueue;
        this.enabledCDPs = new ArrayList();
        this.satisfiedCDPs = new ArrayList();
        this.enabledCDsByName = new HashMap();
        BundleContext bundleContext = main.context;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.osgi.service.cm.ConfigurationAdmin");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.configAdminTracker = new ServiceTracker(bundleContext, clazz.getName(), null);
        this.configAdminTracker.open();
        this.instanceProcess = new InstanceProcess(main);
        main.context.addServiceListener((ServiceListener)this);
    }

    public void dispose() {
        this.main.context.removeServiceListener((ServiceListener)this);
        this.instanceProcess.dispose();
        this.instanceProcess = null;
        this.configAdminTracker.close();
        this.configAdminTracker = null;
        this.enabledCDPs = null;
        this.satisfiedCDPs = null;
        this.enabledCDsByName = null;
    }

    public void enableComponents(List componentDescriptions) throws ComponentException {
        Iterator it = componentDescriptions.iterator();
        while (it.hasNext()) {
            ComponentDescription cd = (ComponentDescription)it.next();
            this.enabledCDsByName.put(cd.getName(), cd);
            Configuration config = null;
            try {
                ConfigurationAdmin configurationAdmin = (ConfigurationAdmin)this.configAdminTracker.getService();
                if (configurationAdmin != null) {
                    config = configurationAdmin.getConfiguration(cd.getName(), cd.getBundleContext().getBundle().getLocation());
                }
            }
            catch (IOException e) {
                Log.log(1, "[SCR] IOException when getting Configuration Properties. ", e);
            }
            if (config == null) {
                this.map(cd, null);
                continue;
            }
            if (config.getFactoryPid() != null) {
                if (cd.getFactory() != null) {
                    throw new ComponentException("incompatible to specify both ComponentFactory and ManagedServiceFactory are incompatible");
                }
                Configuration[] configs = null;
                try {
                    ConfigurationAdmin cm = (ConfigurationAdmin)this.configAdminTracker.getService();
                    configs = cm.listConfigurations("(service.factoryPid=" + config.getFactoryPid() + ")");
                }
                catch (InvalidSyntaxException e) {
                    Log.log(1, "[SCR] InvalidSyntaxException when getting CM Configurations. ", e);
                }
                catch (IOException e) {
                    Log.log(1, "[SCR] IOException when getting CM Configurations. ", e);
                }
                if (configs == null) continue;
                int i = 0;
                while (i < configs.length) {
                    this.map(cd, configs[i].getProperties());
                    ++i;
                }
                continue;
            }
            this.map(cd, config.getProperties());
        }
        this.resolve(null);
    }

    public ComponentDescriptionProp map(ComponentDescription cd, Dictionary configAdminProps) {
        return this.doMap(cd, configAdminProps, cd.getFactory() != null);
    }

    public ComponentDescriptionProp mapFactoryInstance(ComponentDescription cd, Dictionary configAdminProps) {
        return this.doMap(cd, configAdminProps, false);
    }

    private ComponentDescriptionProp doMap(ComponentDescription cd, Dictionary configAdminProps, boolean componentFactory) {
        Hashtable properties = this.initProperties(cd, configAdminProps);
        ArrayList<Reference> references = new ArrayList<Reference>();
        Iterator it = cd.getReferenceDescriptions().iterator();
        while (it.hasNext()) {
            ReferenceDescription referenceDesc = (ReferenceDescription)it.next();
            Reference ref = new Reference(referenceDesc, properties);
            references.add(ref);
        }
        references = !references.isEmpty() ? references : Collections.EMPTY_LIST;
        ComponentDescriptionProp cdp = new ComponentDescriptionProp(cd, references, properties, componentFactory);
        it = cdp.getReferences().iterator();
        while (it.hasNext()) {
            Reference reference = (Reference)it.next();
            reference.setComponentDescriptionProp(cdp);
        }
        cd.addComponentDescriptionProp(cdp);
        this.enabledCDPs.add(cdp);
        return cdp;
    }

    private Hashtable initProperties(ComponentDescription cd, Dictionary configAdminProps) {
        List servicesProvided;
        Hashtable<String, Object> properties = new Hashtable<String, Object>();
        Iterator it = cd.getReferenceDescriptions().iterator();
        while (it.hasNext()) {
            ReferenceDescription referenceDesc = (ReferenceDescription)it.next();
            if (referenceDesc.getTarget() == null) continue;
            properties.put(String.valueOf(referenceDesc.getName()) + ".target", referenceDesc.getTarget());
        }
        properties.putAll(cd.getProperties());
        if (configAdminProps != null) {
            Enumeration keys = configAdminProps.keys();
            while (keys.hasMoreElements()) {
                Object key = keys.nextElement();
                properties.put((String)key, configAdminProps.get(key));
            }
        }
        properties.put("component.name", cd.getName());
        properties.put("component.id", new Long(this.getNextComponentId()));
        if (cd.getFactory() != null) {
            properties.put("component.factory", cd.getFactory());
        }
        if (!(servicesProvided = cd.getServicesProvided()).isEmpty()) {
            properties.put("objectClass", servicesProvided.toArray(new String[servicesProvided.size()]));
        }
        return properties;
    }

    public void disableComponents(List componentDescriptions) {
        Iterator it = componentDescriptions.iterator();
        while (it.hasNext()) {
            ComponentDescription cd = (ComponentDescription)it.next();
            this.disposeComponentConfigs((List)((ArrayList)cd.getComponentDescriptionProps()).clone());
            cd.clearComponentDescriptionProps();
            this.enabledCDsByName.remove(cd.getName());
        }
    }

    public void disposeComponentConfigs(List cdps) {
        this.satisfiedCDPs.removeAll(cdps);
        this.enabledCDPs.removeAll(cdps);
        this.instanceProcess.disposeComponentConfigs(cdps);
    }

    private void resolve(ServiceEvent event) {
        if (event == null) {
            this.resolveCycles();
            List newlySatisfiedCDPs = this.resolveSatisfied();
            newlySatisfiedCDPs.removeAll(this.satisfiedCDPs);
            if (!newlySatisfiedCDPs.isEmpty()) {
                this.satisfiedCDPs.addAll(newlySatisfiedCDPs);
                this.workQueue.enqueueWork(this, 1, newlySatisfiedCDPs);
            }
        } else if (event.getType() == 1) {
            List dynamicBind = this.selectDynamicBind(event.getServiceReference());
            if (!dynamicBind.isEmpty()) {
                this.workQueue.enqueueWork(this, 3, dynamicBind);
            }
            List newlySatisfiedCDPs = this.resolveSatisfied();
            newlySatisfiedCDPs.removeAll(this.satisfiedCDPs);
            if (!newlySatisfiedCDPs.isEmpty()) {
                this.satisfiedCDPs.addAll(newlySatisfiedCDPs);
                this.workQueue.enqueueWork(this, 1, newlySatisfiedCDPs);
            }
        } else if (event.getType() == 2) {
            List dynamicBind;
            Map dynamicUnBind;
            List newlyUnsatisfiedCDPs = (List)((ArrayList)this.satisfiedCDPs).clone();
            newlyUnsatisfiedCDPs.removeAll(this.resolveSatisfied());
            if (!newlyUnsatisfiedCDPs.isEmpty()) {
                this.satisfiedCDPs.removeAll(newlyUnsatisfiedCDPs);
                this.instanceProcess.disposeComponentConfigs(newlyUnsatisfiedCDPs);
            }
            if (!(dynamicUnBind = this.selectDynamicUnBind(event.getServiceReference())).isEmpty()) {
                this.instanceProcess.dynamicUnBind(dynamicUnBind);
            }
            if (!(dynamicBind = this.selectDynamicBind(event.getServiceReference())).isEmpty()) {
                this.workQueue.enqueueWork(this, 3, dynamicBind);
            }
            List newlySatisfiedCDPs = this.resolveSatisfied();
            newlySatisfiedCDPs.removeAll(this.satisfiedCDPs);
            if (!newlySatisfiedCDPs.isEmpty()) {
                this.satisfiedCDPs.addAll(newlySatisfiedCDPs);
                this.workQueue.enqueueWork(this, 1, newlySatisfiedCDPs);
            }
        } else if (event.getType() == 4) {
            Map dynamicUnBind;
            List newlyUnsatisfiedCDPs = (List)((ArrayList)this.satisfiedCDPs).clone();
            newlyUnsatisfiedCDPs.removeAll(this.resolveSatisfied());
            if (!newlyUnsatisfiedCDPs.isEmpty()) {
                this.satisfiedCDPs.removeAll(newlyUnsatisfiedCDPs);
                this.instanceProcess.disposeComponentConfigs(newlyUnsatisfiedCDPs);
            }
            if (!(dynamicUnBind = this.selectDynamicUnBind(event.getServiceReference())).isEmpty()) {
                this.instanceProcess.dynamicUnBind(dynamicUnBind);
            }
        }
    }

    public boolean justResolve(ComponentDescriptionProp cdp) {
        this.resolveCycles();
        List newlySatisfiedCDPs = this.resolveSatisfied();
        newlySatisfiedCDPs.removeAll(this.satisfiedCDPs);
        if (!newlySatisfiedCDPs.contains(cdp)) {
            return false;
        }
        this.satisfiedCDPs.add(cdp);
        return true;
    }

    private List resolveSatisfied() {
        ArrayList<ComponentDescriptionProp> resolvedSatisfiedCDPs = new ArrayList<ComponentDescriptionProp>();
        Iterator it = this.enabledCDPs.iterator();
        while (it.hasNext()) {
            ComponentDescriptionProp cdp = (ComponentDescriptionProp)it.next();
            ComponentDescription cd = cdp.getComponentDescription();
            List refs = cdp.getReferences();
            Iterator iterator = refs.iterator();
            boolean hasProviders = true;
            while (iterator.hasNext()) {
                Reference reference = (Reference)iterator.next();
                if (reference == null || !reference.getReferenceDescription().isRequired() || reference.hasProvider(cdp.getComponentDescription().getBundleContext())) continue;
                hasProviders = false;
                break;
            }
            if (!hasProviders) continue;
            if (cd.getService() != null && System.getSecurityManager() != null) {
                ProvideDescription[] provides = cd.getService().getProvides();
                Bundle bundle = cd.getBundleContext().getBundle();
                boolean hasPermission = true;
                int i = 0;
                while (i < provides.length) {
                    if (!bundle.hasPermission((Object)new ServicePermission(provides[i].getInterfacename(), "register"))) {
                        hasPermission = false;
                        break;
                    }
                    ++i;
                }
                if (!hasPermission) continue;
            }
            resolvedSatisfiedCDPs.add(cdp);
        }
        return resolvedSatisfiedCDPs.isEmpty() ? Collections.EMPTY_LIST : resolvedSatisfiedCDPs;
    }

    public void serviceChanged(ServiceEvent event) {
        event.getServiceReference();
        int eventType = event.getType();
        switch (eventType) {
            case 1: 
            case 2: 
            case 4: {
                this.resolve(event);
            }
        }
    }

    public void dispatchWork(int workAction, Object workObject) {
        switch (workAction) {
            case 1: {
                List queueCDPs = (List)workObject;
                ArrayList<ComponentDescriptionProp> cdps = new ArrayList<ComponentDescriptionProp>(queueCDPs.size());
                Iterator it = queueCDPs.iterator();
                while (it.hasNext()) {
                    ComponentDescriptionProp cdp = (ComponentDescriptionProp)it.next();
                    if (!this.satisfiedCDPs.contains(cdp)) continue;
                    cdps.add(cdp);
                }
                if (cdps.isEmpty()) break;
                this.instanceProcess.registerComponentConfigs(cdps);
                break;
            }
            case 3: {
                List references = (List)workObject;
                Iterator it = references.iterator();
                while (it.hasNext()) {
                    if (this.satisfiedCDPs.contains(((Reference)it.next()).getComponentDescriptionProp())) continue;
                    it.remove();
                }
                if (references.isEmpty()) break;
                this.instanceProcess.dynamicBind(references);
            }
        }
    }

    private List selectDynamicBind(ServiceReference serviceReference) {
        ArrayList<Reference> bindList = new ArrayList<Reference>();
        Iterator it = this.satisfiedCDPs.iterator();
        while (it.hasNext()) {
            ComponentDescriptionProp cdp = (ComponentDescriptionProp)it.next();
            List references = cdp.getReferences();
            Iterator refIt = references.iterator();
            while (refIt.hasNext()) {
                Reference reference = (Reference)refIt.next();
                if (!reference.dynamicBindReference(serviceReference)) continue;
                bindList.add(reference);
            }
        }
        return bindList;
    }

    private Map selectDynamicUnBind(ServiceReference serviceReference) {
        Hashtable<Reference, ServiceReference> unbindJobs = new Hashtable<Reference, ServiceReference>();
        Iterator it = this.satisfiedCDPs.iterator();
        while (it.hasNext()) {
            ComponentDescriptionProp cdp = (ComponentDescriptionProp)it.next();
            List references = cdp.getReferences();
            Iterator it_ = references.iterator();
            while (it_.hasNext()) {
                Reference reference = (Reference)it_.next();
                if (!reference.dynamicUnbindReference(serviceReference)) continue;
                unbindJobs.put(reference, serviceReference);
            }
        }
        return unbindJobs.isEmpty() ? Collections.EMPTY_MAP : unbindJobs;
    }

    private void resolveCycles() {
        try {
            Hashtable<ComponentDescriptionProp, List> dependencies = new Hashtable<ComponentDescriptionProp, List>();
            Iterator<Object> it = this.enabledCDPs.iterator();
            while (it.hasNext()) {
                ComponentDescriptionProp enabledCDP = (ComponentDescriptionProp)it.next();
                ArrayList<ReferenceCDP> dependencyList = new ArrayList<ReferenceCDP>();
                Iterator refIt = enabledCDP.getReferences().iterator();
                while (refIt.hasNext()) {
                    Reference reference = (Reference)refIt.next();
                    ComponentDescriptionProp providerCDP = reference.findProviderCDP(this.enabledCDPs);
                    if (providerCDP == null) continue;
                    dependencyList.add(new ReferenceCDP(reference, providerCDP));
                }
                if (!dependencyList.isEmpty()) {
                    dependencies.put(enabledCDP, dependencyList);
                    continue;
                }
                dependencies.put(enabledCDP, Collections.EMPTY_LIST);
            }
            HashSet visited = new HashSet();
            it = dependencies.keySet().iterator();
            while (it.hasNext()) {
                ComponentDescriptionProp cdp = (ComponentDescriptionProp)it.next();
                if (visited.contains(cdp)) continue;
                ArrayList currentStack = new ArrayList();
                this.traverseDependencies(cdp, visited, dependencies, currentStack);
            }
        }
        catch (CircularityException e) {
            Log.log(1, "[SCR] Circularity Exception.", e);
            this.enabledCDPs.remove(e.getCircularDependency());
            this.resolveCycles();
        }
    }

    private void traverseDependencies(ComponentDescriptionProp cdp, Set visited, Hashtable dependencies, List currentStack) throws CircularityException {
        if (visited.contains(cdp)) {
            return;
        }
        List refCDPs = (List)dependencies.get(cdp);
        Iterator it = refCDPs.iterator();
        while (it.hasNext()) {
            ReferenceCDP refCDP = (ReferenceCDP)it.next();
            if (currentStack.contains(refCDP)) {
                this.handleDependencyCycle(refCDP, currentStack);
                return;
            }
            currentStack.add(refCDP);
            this.traverseDependencies(refCDP.producer, visited, dependencies, currentStack);
            currentStack.remove(refCDP);
        }
        visited.add(cdp);
    }

    private void handleDependencyCycle(ReferenceCDP refCDP, List currentStack) throws CircularityException {
        ListIterator cycleIterator = currentStack.listIterator(currentStack.indexOf(refCDP));
        ReferenceCDP optionalRefCDP = null;
        while (cycleIterator.hasNext()) {
            ReferenceCDP cycleRefCDP = (ReferenceCDP)cycleIterator.next();
            if (cycleRefCDP.ref.getReferenceDescription().isRequired()) continue;
            optionalRefCDP = cycleRefCDP;
            break;
        }
        if (optionalRefCDP == null) {
            throw new CircularityException(refCDP.ref.getComponentDescriptionProp());
        }
        optionalRefCDP.ref.getComponentDescriptionProp().setDelayActivateCDPName(optionalRefCDP.producer.getComponentDescription().getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getNextComponentId() {
        Resolver resolver = this;
        synchronized (resolver) {
            return componentid++;
        }
    }

    private static class ReferenceCDP {
        public Reference ref;
        public ComponentDescriptionProp producer;

        protected ReferenceCDP(Reference ref, ComponentDescriptionProp producer) {
            this.ref = ref;
            this.producer = producer;
        }
    }
}

