/*
 * Decompiled with CFR 0.152.
 */
package com.google.ical.values;

import com.google.ical.values.AbstractIcalObject;
import com.google.ical.values.DateValue;
import com.google.ical.values.IcalValueType;
import com.google.ical.values.RRuleSchema;
import com.google.ical.values.TimeValue;
import java.text.ParseException;
import java.util.Map;
import java.util.TimeZone;

public class RDateList
extends AbstractIcalObject {
    private TimeZone tzid;
    private DateValue[] datesUtc;
    private IcalValueType valueType;

    public RDateList(String icalString, TimeZone tzid) throws ParseException {
        this.setTzid(tzid);
        this.parse(icalString, RRuleSchema.instance());
    }

    public RDateList(TimeZone tzid) {
        this.setTzid(tzid);
        this.setName("RDATE");
        this.datesUtc = new DateValue[0];
    }

    public TimeZone getTzid() {
        return this.tzid;
    }

    public void setTzid(TimeZone tzid) {
        assert (null != tzid);
        this.tzid = tzid;
    }

    public DateValue[] getDatesUtc() {
        return null != this.datesUtc ? (DateValue[])this.datesUtc.clone() : null;
    }

    public void setDatesUtc(DateValue[] datesUtc) {
        this.datesUtc = (DateValue[])datesUtc.clone();
        if (datesUtc.length > 0) {
            this.setValueType(datesUtc[0] instanceof TimeValue ? IcalValueType.DATE_TIME : IcalValueType.DATE);
        }
    }

    public IcalValueType getValueType() {
        return this.valueType;
    }

    public void setValueType(IcalValueType valueType) {
        this.valueType = valueType;
    }

    @Override
    public String toIcal() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.getName().toUpperCase());
        buf.append(";TZID=\"").append(this.tzid.getID()).append('\"');
        buf.append(";VALUE=").append(this.valueType.toIcal());
        if (this.hasExtParams()) {
            for (Map.Entry param : this.getExtParams().entrySet()) {
                String k = (String)param.getKey();
                String v = (String)param.getValue();
                if (ICAL_SPECIALS.matcher(v).find()) {
                    v = "\"" + v + "\"";
                }
                buf.append(';').append(k).append('=').append(v);
            }
        }
        buf.append(':');
        for (int i = 0; i < this.datesUtc.length; ++i) {
            if (0 != i) {
                buf.append(',');
            }
            DateValue v = this.datesUtc[i];
            buf.append(v);
            if (!(v instanceof TimeValue)) continue;
            buf.append('Z');
        }
        return buf.toString();
    }
}

