/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.time.calendars;

import org.jquantlib.time.Weekday;
import org.jquantlib.time.WesternCalendar;
import org.jquantlib.time.calendars.DelegateCalendar;
import org.jquantlib.util.Date;
import org.jquantlib.util.Month;

public class UnitedKingdom
extends DelegateCalendar {
    private static final UnitedKingdom SETTLEMENT_CALENDAR = new UnitedKingdom(Market.SETTLEMENT);
    private static final UnitedKingdom EXCHANGE_CALENDAR = new UnitedKingdom(Market.LSE);
    private static final UnitedKingdom METALS_CALENDAR = new UnitedKingdom(Market.METALS);

    private UnitedKingdom(Market market) {
        WesternCalendar delegate;
        switch (market) {
            case SETTLEMENT: {
                delegate = new UKSettlementCalendar();
                break;
            }
            case LSE: {
                delegate = new UKExchangeCalendar();
                break;
            }
            case METALS: {
                delegate = new UKMetalsCalendar();
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown market");
            }
        }
        this.setDelegate(delegate);
    }

    public static UnitedKingdom getCalendar(Market market) {
        switch (market) {
            case SETTLEMENT: {
                return SETTLEMENT_CALENDAR;
            }
            case LSE: {
                return EXCHANGE_CALENDAR;
            }
            case METALS: {
                return METALS_CALENDAR;
            }
        }
        throw new IllegalArgumentException("unknown market");
    }

    private static final class UKMetalsCalendar
    extends WesternCalendar {
        private UKMetalsCalendar() {
        }

        @Override
        public String getName() {
            return "London metals exchange";
        }

        @Override
        public boolean isBusinessDay(Date date) {
            Weekday w = date.getWeekday();
            int d = date.getDayOfMonth();
            int dd = date.getDayOfYear();
            int m = date.getMonth();
            int y = date.getYear();
            int em = this.easterMonday(y);
            return !(this.isWeekend(w) || (d == 1 || (d == 2 || d == 3) && w == Weekday.MONDAY) && m == Month.JANUARY.toInteger() || dd == em - 3 || dd == em || d <= 7 && w == Weekday.MONDAY && m == Month.MAY.toInteger() || d >= 25 && w == Weekday.MONDAY && m == Month.MAY.toInteger() && y != 2002 || d >= 25 && w == Weekday.MONDAY && m == Month.AUGUST.toInteger() || (d == 25 || d == 27 && (w == Weekday.MONDAY || w == Weekday.TUESDAY)) && m == Month.DECEMBER.toInteger() || (d == 26 || d == 28 && (w == Weekday.MONDAY || w == Weekday.TUESDAY)) && m == Month.DECEMBER.toInteger() || (d == 3 || d == 4) && m == Month.JUNE.toInteger() && y == 2002) && (d != 31 || m != Month.DECEMBER.toInteger() || y != 1999);
        }
    }

    private static final class UKExchangeCalendar
    extends WesternCalendar {
        private UKExchangeCalendar() {
        }

        @Override
        public String getName() {
            return "London stock exchange";
        }

        @Override
        public boolean isBusinessDay(Date date) {
            Weekday w = date.getWeekday();
            int d = date.getDayOfMonth();
            int dd = date.getDayOfYear();
            int m = date.getMonth();
            int y = date.getYear();
            int em = this.easterMonday(y);
            return !(this.isWeekend(w) || (d == 1 || (d == 2 || d == 3) && w == Weekday.MONDAY) && m == Month.JANUARY.toInteger() || dd == em - 3 || dd == em || d <= 7 && w == Weekday.MONDAY && m == Month.MAY.toInteger() || d >= 25 && w == Weekday.MONDAY && m == Month.MAY.toInteger() && y != 2002 || d >= 25 && w == Weekday.MONDAY && m == Month.AUGUST.toInteger() || (d == 25 || d == 27 && (w == Weekday.MONDAY || w == Weekday.TUESDAY)) && m == Month.DECEMBER.toInteger() || (d == 26 || d == 28 && (w == Weekday.MONDAY || w == Weekday.TUESDAY)) && m == Month.DECEMBER.toInteger() || (d == 3 || d == 4) && m == Month.JUNE.toInteger() && y == 2002) && (d != 31 || m != Month.DECEMBER.toInteger() || y != 1999);
        }
    }

    private static final class UKSettlementCalendar
    extends WesternCalendar {
        private UKSettlementCalendar() {
        }

        @Override
        public String getName() {
            return "UK settlement";
        }

        @Override
        public boolean isBusinessDay(Date date) {
            Weekday w = date.getWeekday();
            int d = date.getDayOfMonth();
            int dd = date.getDayOfYear();
            int m = date.getMonth();
            int y = date.getYear();
            int em = this.easterMonday(y);
            return !(this.isWeekend(w) || (d == 1 || (d == 2 || d == 3) && w == Weekday.MONDAY) && m == Month.JANUARY.toInteger() || dd == em - 3 || dd == em || d <= 7 && w == Weekday.MONDAY && m == Month.MAY.toInteger() || d >= 25 && w == Weekday.MONDAY && m == Month.MAY.toInteger() && y != 2002 || d >= 25 && w == Weekday.MONDAY && m == Month.AUGUST.toInteger() || (d == 25 || d == 27 && (w == Weekday.MONDAY || w == Weekday.TUESDAY)) && m == Month.DECEMBER.toInteger() || (d == 26 || d == 28 && (w == Weekday.MONDAY || w == Weekday.TUESDAY)) && m == Month.DECEMBER.toInteger() || (d == 3 || d == 4) && m == Month.JUNE.toInteger() && y == 2002) && (d != 31 || m != Month.DECEMBER.toInteger() || y != 1999);
        }
    }

    public static enum Market {
        SETTLEMENT,
        LSE,
        METALS;

    }
}

