/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.math.solvers1D;

import org.jquantlib.math.AbstractSolver1D;
import org.jquantlib.math.UnaryFunctionDouble;

public class Secant
extends AbstractSolver1D<UnaryFunctionDouble> {
    @Override
    protected double solveImpl(UnaryFunctionDouble f, double xAccuracy) {
        double fl;
        double xl;
        double froot;
        if (Math.abs(this.fxMin_) < Math.abs(this.fxMax_)) {
            this.root_ = this.xMin_;
            froot = this.fxMin_;
            xl = this.xMax_;
            fl = this.fxMax_;
        } else {
            this.root_ = this.xMax_;
            froot = this.fxMax_;
            xl = this.xMin_;
            fl = this.fxMin_;
        }
        while (this.evaluationNumber_ <= this.getMaxEvaluations()) {
            double dx = (xl - this.root_) * froot / (froot - fl);
            xl = this.root_;
            fl = froot;
            this.root_ += dx;
            froot = f.evaluate(this.root_);
            ++this.evaluationNumber_;
            if (!(Math.abs(dx) < xAccuracy) && froot != 0.0) continue;
            return this.root_;
        }
        throw new ArithmeticException("maximum number of function evaluations (" + this.getMaxEvaluations() + ") exceeded");
    }
}

