/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.util.tracker;

import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.SynchronousBundleListener;
import org.osgi.util.tracker.AbstractTracked;
import org.osgi.util.tracker.BundleTrackerCustomizer;

public class BundleTracker
implements BundleTrackerCustomizer {
    static final boolean DEBUG = false;
    protected final BundleContext context;
    final BundleTrackerCustomizer customizer;
    private volatile Tracked tracked;
    final int mask;

    public BundleTracker(BundleContext context, int stateMask, BundleTrackerCustomizer customizer) {
        this.context = context;
        this.mask = stateMask;
        this.customizer = customizer == null ? this : customizer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void open() {
        if (this.tracked != null) {
            return;
        }
        Tracked tracked = this.tracked = new Tracked();
        synchronized (tracked) {
            this.context.addBundleListener(this.tracked);
            Object[] bundles = this.context.getBundles();
            if (bundles != null) {
                int length = bundles.length;
                int i = 0;
                while (i < length) {
                    int state = bundles[i].getState();
                    if ((state & this.mask) == 0) {
                        bundles[i] = null;
                    }
                    ++i;
                }
                this.tracked.setInitial(bundles);
            }
        }
        this.tracked.trackInitial();
    }

    public synchronized void close() {
        if (this.tracked == null) {
            return;
        }
        this.tracked.close();
        Bundle[] bundles = this.getBundles();
        Tracked outgoing = this.tracked;
        this.tracked = null;
        try {
            this.context.removeBundleListener(outgoing);
        }
        catch (IllegalStateException illegalStateException) {}
        if (bundles != null) {
            int i = 0;
            while (i < bundles.length) {
                outgoing.untrack(bundles[i], null);
                ++i;
            }
        }
    }

    public Object addingBundle(Bundle bundle, BundleEvent event) {
        return bundle;
    }

    public void modifiedBundle(Bundle bundle, BundleEvent event, Object object) {
    }

    public void removedBundle(Bundle bundle, BundleEvent event, Object object) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Bundle[] getBundles() {
        Tracked tracked = this.tracked;
        if (tracked == null) {
            return null;
        }
        Tracked tracked2 = tracked;
        synchronized (tracked2) {
            int length;
            block5: {
                length = tracked.size();
                if (length != 0) break block5;
                return null;
            }
            Object[] bundles = new Bundle[length];
            tracked.getTracked(bundles);
            return bundles;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getObject(Bundle bundle) {
        Tracked tracked = this.tracked;
        if (tracked == null) {
            return null;
        }
        Tracked tracked2 = tracked;
        synchronized (tracked2) {
            return tracked.getCustomizedObject(bundle);
        }
    }

    public void remove(Bundle bundle) {
        Tracked tracked = this.tracked;
        if (tracked == null) {
            return;
        }
        tracked.untrack(bundle, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        Tracked tracked = this.tracked;
        if (tracked == null) {
            return 0;
        }
        Tracked tracked2 = tracked;
        synchronized (tracked2) {
            return tracked.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getTrackingCount() {
        Tracked tracked = this.tracked;
        if (tracked == null) {
            return -1;
        }
        Tracked tracked2 = tracked;
        synchronized (tracked2) {
            return tracked.getTrackingCount();
        }
    }

    void modified() {
    }

    class Tracked
    extends AbstractTracked
    implements SynchronousBundleListener {
        protected Tracked() {
        }

        public void bundleChanged(BundleEvent event) {
            if (this.closed) {
                return;
            }
            Bundle bundle = event.getBundle();
            int state = bundle.getState();
            if ((state & BundleTracker.this.mask) != 0) {
                this.track(bundle, event);
            } else {
                this.untrack(bundle, event);
            }
        }

        protected void modified() {
            super.modified();
            BundleTracker.this.modified();
        }

        protected Object customizerAdding(Object item, Object related) {
            return BundleTracker.this.customizer.addingBundle((Bundle)item, (BundleEvent)related);
        }

        protected void customizerModified(Object item, Object related, Object object) {
            BundleTracker.this.customizer.modifiedBundle((Bundle)item, (BundleEvent)related, object);
        }

        protected void customizerRemoved(Object item, Object related, Object object) {
            BundleTracker.this.customizer.removedBundle((Bundle)item, (BundleEvent)related, object);
        }
    }
}

