/*
 * Decompiled with CFR 0.152.
 */
package netscape.application;

import netscape.application.Border;
import netscape.application.Color;
import netscape.application.Graphics;
import netscape.util.ClassInfo;
import netscape.util.CodingException;
import netscape.util.Decoder;
import netscape.util.Encoder;
import netscape.util.InconsistencyException;

public class BezelBorder
extends Border {
    public static final int RAISED = 0;
    public static final int LOWERED = 1;
    public static final int GROOVED = 2;
    public static final int RAISED_BUTTON = 3;
    public static final int LOWERED_BUTTON = 4;
    static final int RAISED_SCROLL_BUTTON = 5;
    static final int LOWERED_SCROLL_BUTTON = 6;
    private static Border raisedBezel;
    private static Border loweredBezel;
    private static Border groovedBezel;
    private static Border raisedButtonBezel;
    private static Border loweredButtonBezel;
    private static Border raisedScrollButtonBezel;
    private static Border loweredScrollButtonBezel;
    private int bezelType;
    private Color baseColor;
    private Color lighterColor;
    private Color darkerColor;
    static final String bezelTypeField = "bezelType";
    static final String baseColorField = "baseColor";
    static final String lighterColorField = "lighterColor";
    static final String darkerColorField = "darkerColor";
    private static Class bezelBorderClass;
    static final Color gray218;
    static final Color gray165;
    static final Color gray143;

    public static Border raisedBezel() {
        if (raisedBezel == null) {
            raisedBezel = new BezelBorder(0, Color.lightGray, Color.white, Color.gray);
        }
        return raisedBezel;
    }

    public static Border loweredBezel() {
        if (loweredBezel == null) {
            loweredBezel = new BezelBorder(1, Color.lightGray, Color.white, Color.gray);
        }
        return loweredBezel;
    }

    public static Border groovedBezel() {
        if (groovedBezel == null) {
            groovedBezel = new BezelBorder(2, Color.lightGray, Color.white, Color.gray);
        }
        return groovedBezel;
    }

    public static Border raisedButtonBezel() {
        if (raisedButtonBezel == null) {
            raisedButtonBezel = new BezelBorder(3, Color.lightGray, Color.white, Color.gray);
        }
        return raisedButtonBezel;
    }

    public static Border loweredButtonBezel() {
        if (loweredButtonBezel == null) {
            loweredButtonBezel = new BezelBorder(4, Color.lightGray, Color.white, Color.gray);
        }
        return loweredButtonBezel;
    }

    static Border raisedScrollButtonBezel() {
        if (raisedScrollButtonBezel == null) {
            raisedScrollButtonBezel = new BezelBorder(5);
        }
        return raisedScrollButtonBezel;
    }

    static Border loweredScrollButtonBezel() {
        if (loweredScrollButtonBezel == null) {
            loweredScrollButtonBezel = new BezelBorder(6);
        }
        return loweredScrollButtonBezel;
    }

    public BezelBorder() {
    }

    public BezelBorder(int n) {
        this(n, Color.lightGray, Color.white, Color.gray);
    }

    public BezelBorder(int n, Color color) {
        this();
        this.bezelType = n;
        this.baseColor = color;
        this.lighterColor = color.lighterColor();
        this.darkerColor = color.darkerColor();
    }

    public BezelBorder(int n, Color color, Color color2, Color color3) {
        this();
        this.bezelType = n;
        this.baseColor = color;
        this.lighterColor = color2;
        this.darkerColor = color3;
    }

    public int leftMargin() {
        if (this.bezelType == 4) {
            return 3;
        }
        if (this.bezelType == 5 || this.bezelType == 6) {
            return 1;
        }
        return 2;
    }

    public int rightMargin() {
        if (this.bezelType == 3) {
            return 3;
        }
        if (this.bezelType == 5 || this.bezelType == 6) {
            return 1;
        }
        return 2;
    }

    public int topMargin() {
        if (this.bezelType == 4) {
            return 3;
        }
        if (this.bezelType == 5 || this.bezelType == 6) {
            return 1;
        }
        return 2;
    }

    public int bottomMargin() {
        if (this.bezelType == 3) {
            return 3;
        }
        if (this.bezelType == 5 || this.bezelType == 6) {
            return 1;
        }
        return 2;
    }

    public int type() {
        return this.bezelType;
    }

    public void drawInRect(Graphics graphics, int n, int n2, int n3, int n4) {
        switch (this.bezelType) {
            case 0: {
                BezelBorder.drawBezel(graphics, n, n2, n3, n4, this.baseColor, this.lighterColor, this.darkerColor, Color.darkGray, true);
                return;
            }
            case 1: {
                BezelBorder.drawBezel(graphics, n, n2, n3, n4, this.baseColor, this.lighterColor, this.darkerColor, Color.darkGray, false);
                return;
            }
            case 2: {
                BezelBorder.drawGroovedBezel(graphics, n, n2, n3, n4, this.lighterColor, this.darkerColor);
                return;
            }
            case 3: {
                BezelBorder.drawRaisedButtonBezel(graphics, n, n2, n3, n4);
                return;
            }
            case 4: {
                BezelBorder.drawLoweredButtonBezel(graphics, n, n2, n3, n4);
                return;
            }
            case 5: {
                BezelBorder.drawRaisedScrollButtonBezel(graphics, n, n2, n3, n4);
                return;
            }
            case 6: {
                BezelBorder.drawLoweredScrollButtonBezel(graphics, n, n2, n3, n4);
                return;
            }
        }
        throw new InconsistencyException("Invalid bezelType: " + this.bezelType);
    }

    private static Class bezelBorderClass() {
        if (bezelBorderClass == null) {
            bezelBorderClass = BezelBorder.loweredBezel().getClass();
        }
        return bezelBorderClass;
    }

    public void describeClassInfo(ClassInfo classInfo) {
        super.describeClassInfo(classInfo);
        classInfo.addClass("netscape.application.BezelBorder", 1);
        classInfo.addField(bezelTypeField, (byte)8);
        classInfo.addField(baseColorField, (byte)18);
        classInfo.addField(lighterColorField, (byte)18);
        classInfo.addField(darkerColorField, (byte)18);
    }

    public void encode(Encoder encoder) throws CodingException {
        super.encode(encoder);
        encoder.encodeInt(bezelTypeField, this.bezelType);
        encoder.encodeObject(baseColorField, this.baseColor);
        encoder.encodeObject(lighterColorField, this.lighterColor);
        encoder.encodeObject(darkerColorField, this.darkerColor);
    }

    public void decode(Decoder decoder) throws CodingException {
        super.decode(decoder);
        this.bezelType = decoder.decodeInt(bezelTypeField);
        this.baseColor = (Color)decoder.decodeObject(baseColorField);
        this.lighterColor = (Color)decoder.decodeObject(lighterColorField);
        this.darkerColor = (Color)decoder.decodeObject(darkerColorField);
        if (this.getClass() != BezelBorder.bezelBorderClass()) {
            return;
        }
        if (this.baseColor == Color.lightGray && this.lighterColor == Color.white && this.darkerColor == Color.gray) {
            switch (this.bezelType) {
                case 0: {
                    decoder.replaceObject(BezelBorder.raisedBezel());
                    return;
                }
                case 1: {
                    decoder.replaceObject(BezelBorder.loweredBezel());
                    return;
                }
                case 2: {
                    decoder.replaceObject(BezelBorder.groovedBezel());
                    return;
                }
                case 3: {
                    decoder.replaceObject(BezelBorder.raisedButtonBezel());
                    return;
                }
                case 4: {
                    decoder.replaceObject(BezelBorder.loweredButtonBezel());
                    return;
                }
                case 5: {
                    decoder.replaceObject(BezelBorder.raisedScrollButtonBezel());
                    return;
                }
                case 6: {
                    decoder.replaceObject(BezelBorder.loweredScrollButtonBezel());
                    return;
                }
            }
        }
    }

    public void finishDecoding() throws CodingException {
        super.finishDecoding();
    }

    public static void drawBezel(Graphics graphics, int n, int n2, int n3, int n4, Color color, Color color2, Color color3, Color color4, boolean bl) {
        Color color5;
        Color color6;
        Color color7;
        Color color8;
        if (n3 == 0 || n4 == 0) {
            return;
        }
        if (bl) {
            color8 = color;
            color7 = color4;
            color6 = color2;
            color5 = color3;
        } else {
            color8 = color3;
            color7 = color2;
            color6 = color4;
            color5 = color;
        }
        graphics.setColor(color8);
        graphics.fillRect(n, n2, n3 - 1, 1);
        graphics.fillRect(n, n2 + 1, 1, n4 - 1);
        graphics.setColor(color7);
        graphics.fillRect(n, n2 + n4 - 1, n3, 1);
        graphics.fillRect(n + n3 - 1, n2, 1, n4);
        graphics.setColor(color6);
        graphics.fillRect(++n, ++n2, (n3 -= 2) - 1, 1);
        graphics.fillRect(n, n2 + 1, 1, (n4 -= 2) - 1);
        graphics.setColor(color5);
        graphics.fillRect(n, n2 + n4 - 1, n3, 1);
        graphics.fillRect(n + n3 - 1, n2, 1, n4);
    }

    public static void drawGroovedBezel(Graphics graphics, int n, int n2, int n3, int n4, Color color, Color color2) {
        if (n3 == 0 || n4 == 0) {
            return;
        }
        graphics.setColor(color);
        graphics.drawRect(n + 1, n2 + 1, n3 - 1, n4 - 1);
        graphics.drawPoint(n + n3 - 1, n2);
        graphics.drawPoint(n, n2 + n4 - 1);
        graphics.setColor(color2);
        graphics.drawRect(n, n2, n3 - 1, n4 - 1);
    }

    public static void drawRaisedButtonBezel(Graphics graphics, int n, int n2, int n3, int n4) {
        int n5 = n + n3;
        int n6 = n2 + n4;
        graphics.setColor(Color.white);
        graphics.drawPoint(n + 1, n2 + 1);
        graphics.setColor(Color.gray231);
        graphics.drawLine(n, n2, n, n6 - 4);
        graphics.drawLine(n + 1, n2, n5 - 3, n2);
        graphics.setColor(Color.lightGray);
        graphics.drawLine(n, n6 - 3, n, n6 - 2);
        graphics.drawLine(n + 1, n2 + 2, n + 1, n6 - 3);
        graphics.drawLine(n + 2, n2 + 1, n5 - 3, n2 + 1);
        graphics.drawLine(n + 2, n6 - 3, n5 - 4, n6 - 3);
        graphics.drawLine(n5 - 3, n2 + 2, n5 - 3, n6 - 4);
        graphics.drawPoint(n5 - 2, n2);
        graphics.setColor(Color.gray153);
        graphics.drawLine(n + 1, n6 - 2, n5 - 3, n6 - 2);
        graphics.drawLine(n5 - 2, n2 + 1, n5 - 2, n6 - 3);
        graphics.drawPoint(n5 - 3, n6 - 3);
        graphics.drawPoint(n5 - 1, n2);
        graphics.drawPoint(n, n6 - 1);
        graphics.setColor(Color.gray102);
        graphics.drawLine(n + 1, n6 - 1, n5 - 1, n6 - 1);
        graphics.drawLine(n5 - 1, n2 + 1, n5 - 1, n6 - 2);
        graphics.drawPoint(n5 - 2, n6 - 2);
    }

    public static void drawLoweredButtonBezel(Graphics graphics, int n, int n2, int n3, int n4) {
        int n5 = n + n3;
        int n6 = n2 + n4;
        graphics.setColor(Color.white);
        graphics.drawPoint(n5 - 2, n6 - 2);
        graphics.setColor(Color.gray231);
        graphics.drawLine(n + 2, n6 - 1, n5 - 1, n6 - 1);
        graphics.drawLine(n5 - 1, n2 + 3, n5 - 1, n6 - 2);
        graphics.setColor(Color.lightGray);
        graphics.drawLine(n + 2, n2 + 3, n + 2, n6 - 3);
        graphics.drawLine(n + 3, n2 + 2, n5 - 2, n2 + 2);
        graphics.drawLine(n5 - 2, n2 + 3, n5 - 2, n6 - 3);
        graphics.drawLine(n + 2, n6 - 2, n5 - 3, n6 - 2);
        graphics.drawLine(n5 - 1, n2 + 1, n5 - 1, n2 + 2);
        graphics.drawPoint(n + 1, n6 - 1);
        graphics.setColor(Color.gray153);
        graphics.drawLine(n + 1, n2 + 2, n + 1, n6 - 2);
        graphics.drawLine(n + 2, n2 + 1, n5 - 2, n2 + 1);
        graphics.drawPoint(n, n6 - 1);
        graphics.drawPoint(n5 - 1, n2);
        graphics.drawPoint(n + 2, n2 + 2);
        graphics.setColor(Color.gray102);
        graphics.drawLine(n, n2, n, n6 - 2);
        graphics.drawLine(n + 1, n2, n5 - 2, n2);
        graphics.drawPoint(n + 1, n2 + 1);
    }

    static void drawRaisedScrollButtonBezel(Graphics graphics, int n, int n2, int n3, int n4) {
        int n5 = n + n3;
        int n6 = n2 + n4;
        graphics.setColor(Color.white);
        graphics.drawLine(n, n2 + 1, n, n6 - 3);
        graphics.drawLine(n + 1, n2, n5 - 3, n2);
        graphics.setColor(Color.gray231);
        graphics.drawPoint(n, n2);
        graphics.drawPoint(n, n6 - 2);
        graphics.drawPoint(n5 - 2, n2);
        graphics.setColor(Color.gray153);
        graphics.drawPoint(n5 - 1, n2);
        graphics.drawPoint(n5 - 1, n6 - 1);
        graphics.drawPoint(n, n6 - 1);
        graphics.setColor(Color.gray102);
        graphics.drawLine(n5 - 1, n2 + 1, n5 - 1, n6 - 2);
        graphics.drawLine(n + 1, n6 - 1, n5 - 2, n6 - 1);
    }

    static void drawLoweredScrollButtonBezel(Graphics graphics, int n, int n2, int n3, int n4) {
        int n5 = n + n3;
        int n6 = n2 + n4;
        graphics.setColor(Color.gray153);
        graphics.drawLine(n, n6 - 1, n5 - 1, n6 - 1);
        graphics.drawLine(n5 - 1, n2, n5 - 1, n6 - 2);
        graphics.setColor(Color.lightGray);
        graphics.drawLine(n, n2, n5 - 2, n2);
        graphics.drawLine(n, n2 + 1, n, n6 - 2);
    }

    static {
        gray218 = new Color(218, 218, 218);
        gray165 = new Color(165, 165, 165);
        gray143 = new Color(143, 143, 143);
    }
}

