/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.time.calendars;

import org.jquantlib.time.Weekday;
import org.jquantlib.time.WesternCalendar;
import org.jquantlib.time.calendars.DelegateCalendar;
import org.jquantlib.util.Date;
import org.jquantlib.util.Month;

public class Norway
extends DelegateCalendar {
    private static final Norway OSLOBORS_CALENDAR = new Norway(Market.OsloBors);

    private Norway(Market market) {
        OsloBorsCalendar delegate;
        switch (market) {
            case OsloBors: {
                delegate = new OsloBorsCalendar();
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown market");
            }
        }
        this.setDelegate(delegate);
    }

    public static Norway getCalendar(Market market) {
        switch (market) {
            case OsloBors: {
                return OSLOBORS_CALENDAR;
            }
        }
        throw new IllegalArgumentException("unknown market");
    }

    private static final class OsloBorsCalendar
    extends WesternCalendar {
        private OsloBorsCalendar() {
        }

        @Override
        public String getName() {
            return "OsloBors";
        }

        @Override
        public boolean isBusinessDay(Date date) {
            Weekday w = date.getWeekday();
            int d = date.getDayOfMonth();
            int dd = date.getDayOfYear();
            Month m = date.getMonthEnum();
            int y = date.getYear();
            int em = this.easterMonday(y);
            return !(this.isWeekend(w) || dd == em - 4 || dd == em - 3 || dd == em || dd == em + 38 || dd == em + 49 || d == 1 && m == Month.JANUARY || d == 1 && m == Month.MAY || d == 17 && m == Month.MAY || d == 25 && m == Month.DECEMBER) && (d != 26 || m != Month.DECEMBER);
        }
    }

    public static enum Market {
        OsloBors;

    }
}

