/*
 * Decompiled with CFR 0.152.
 */
package com.infor.core.pool;

import com.infor.core.pool.IRecyclable;
import com.infor.core.pool.IRecycleBin;
import com.infor.core.pool.RecycleBinIsEmptyException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class FIFO
implements IRecycleBin {
    protected List<IRecyclable> fifo = new ArrayList<IRecyclable>();
    protected boolean isDestroyed = false;

    public synchronized void destroy() {
        Iterator<IRecyclable> iter = this.fifo.iterator();
        while (iter.hasNext()) {
            IRecyclable r = iter.next();
            r.destroy();
            iter.remove();
        }
        this.fifo = null;
        this.isDestroyed = true;
    }

    public boolean isDestroyed() {
        return this.isDestroyed;
    }

    public synchronized IRecyclable getRecyclable() {
        if (this.isDestroyed) {
            throw new RecycleBinIsEmptyException("FIFO is destroyed.");
        }
        try {
            return this.fifo.remove(0);
        }
        catch (ArrayIndexOutOfBoundsException rex) {
            throw new RecycleBinIsEmptyException();
        }
    }

    public int getSize() {
        return this.isDestroyed ? 0 : this.fifo.size();
    }

    public synchronized void recycle(IRecyclable recyclable) {
        if (this.isDestroyed) {
            recyclable.destroy();
        } else {
            recyclable.clean();
            this.fifo.add(recyclable);
        }
    }
}

