/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.time.calendars;

import org.jquantlib.time.Weekday;
import org.jquantlib.time.WesternCalendar;
import org.jquantlib.time.calendars.DelegateCalendar;
import org.jquantlib.util.Date;
import org.jquantlib.util.Month;

public class India
extends DelegateCalendar {
    private static final India NSE_CALENDAR = new India(Market.NSE);

    private India(Market market) {
        IndiaNSECalendar delegate;
        switch (market) {
            case NSE: {
                delegate = new IndiaNSECalendar();
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown market");
            }
        }
        this.setDelegate(delegate);
    }

    public static India getCalendar(Market market) {
        switch (market) {
            case NSE: {
                return NSE_CALENDAR;
            }
        }
        throw new IllegalArgumentException("unknown market");
    }

    private static final class IndiaNSECalendar
    extends WesternCalendar {
        private IndiaNSECalendar() {
        }

        @Override
        public String getName() {
            return "National Stock Exchange of India";
        }

        @Override
        public boolean isBusinessDay(Date date) {
            Weekday w = date.getWeekday();
            int d = date.getDayOfMonth();
            int dd = date.getDayOfYear();
            Month m = date.getMonthEnum();
            int y = date.getYear();
            int em = this.easterMonday(y);
            if (this.isWeekend(w) || d == 26 && m == Month.JANUARY || dd == em - 3 || d == 14 && m == Month.APRIL || d == 15 && m == Month.AUGUST || d == 2 && m == Month.OCTOBER || d == 25 && m == Month.DECEMBER) {
                return false;
            }
            if (y == 2005 && (d == 21 && m == Month.JANUARY || d == 7 && m == Month.SEPTEMBER || d == 12 && m == Month.OCTOBER || d == 1 && m == Month.NOVEMBER || d == 3 && m == Month.NOVEMBER || d == 15 && m == Month.NOVEMBER)) {
                return false;
            }
            if (y == 2006 && (d == 11 && m == Month.JANUARY || d == 9 && m == Month.FEBRUARY || d == 15 && m == Month.MARCH || d == 6 && m == Month.APRIL || d == 11 && m == Month.APRIL || d == 1 && m == Month.MAY || d == 24 && m == Month.OCTOBER || d == 25 && m == Month.OCTOBER)) {
                return false;
            }
            if (y == 2007 && (d == 1 && m == Month.JANUARY || d == 30 && m == Month.JANUARY || d == 16 && m == Month.FEBRUARY || d == 27 && m == Month.MARCH || d == 1 && m == Month.MAY || d == 2 && m == Month.MAY || d == 9 && m == Month.NOVEMBER || d == 21 && m == Month.DECEMBER)) {
                return false;
            }
            if (y == 2008 && (d == 6 && m == Month.MARCH || d == 20 && m == Month.MARCH || d == 18 && m == Month.APRIL || d == 1 && m == Month.MAY || d == 19 && m == Month.MAY || d == 3 && m == Month.SEPTEMBER || d == 2 && m == Month.OCTOBER || d == 9 && m == Month.OCTOBER || d == 28 && m == Month.OCTOBER || d == 30 && m == Month.OCTOBER || d == 13 && m == Month.NOVEMBER || d == 9 && m == Month.DECEMBER || d == 27 && m == Month.NOVEMBER)) {
                return false;
            }
            return y != 2009 || !(d == 8 && m == Month.JANUARY || d == 26 && m == Month.JANUARY || d == 23 && m == Month.FEBRUARY || d == 10 && m == Month.MARCH || d == 11 && m == Month.MARCH || d == 3 && m == Month.APRIL || d == 7 && m == Month.APRIL || d == 10 && m == Month.APRIL || d == 14 && m == Month.APRIL || d == 1 && m == Month.MAY || d == 21 && m == Month.SEPTEMBER || d == 28 && m == Month.SEPTEMBER || d == 2 && m == Month.OCTOBER || d == 19 && m == Month.OCTOBER || d == 2 && m == Month.NOVEMBER || d == 25 && m == Month.DECEMBER) && (d != 28 || m != Month.DECEMBER);
        }
    }

    public static enum Market {
        NSE;

    }
}

