/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.math.interpolations;

import org.jquantlib.Configuration;
import org.jquantlib.math.Closeness;
import org.jquantlib.math.interpolations.DefaultExtrapolator;
import org.jquantlib.math.interpolations.Interpolation;
import org.jquantlib.util.stdlibc.Std;

public abstract class AbstractInterpolation
implements Interpolation {
    private boolean extraSafetyChecks = Configuration.getSystemConfiguration(null).isExtraSafetyChecks();
    protected double[] vx;
    protected double[] vy;
    private DefaultExtrapolator delegatedExtrapolator = new DefaultExtrapolator();

    protected abstract double evaluateImpl(double var1);

    protected abstract double primitiveImpl(double var1);

    protected abstract double derivativeImpl(double var1);

    protected abstract double secondDerivativeImpl(double var1);

    protected final void checkRange(double x, boolean extrapolate) {
        if (!(extrapolate || this.allowsExtrapolation() || this.isInRange(x))) {
            StringBuilder sb = new StringBuilder();
            sb.append("interpolation range is [");
            sb.append(this.xMin()).append(", ").append(this.xMax());
            sb.append("]: extrapolation at ");
            sb.append(x);
            sb.append(" not allowed");
            throw new IllegalArgumentException(sb.toString());
        }
    }

    protected int locate(double x) {
        if (x <= this.vx[0]) {
            return 0;
        }
        if (x > this.vx[this.vx.length - 1]) {
            return this.vx.length - 2;
        }
        return Std.upper_bound(this.vx, x) - 1;
    }

    @Override
    public final double xMin() {
        return this.vx[0];
    }

    @Override
    public final double xMax() {
        return this.vx[this.vx.length - 1];
    }

    @Override
    public final double[] xValues() {
        return (double[])this.vx.clone();
    }

    @Override
    public final double[] yValues() {
        return (double[])this.vy.clone();
    }

    @Override
    public final double evaluate(double x, boolean allowExtrapolation) {
        this.checkRange(x, allowExtrapolation);
        return this.evaluateImpl(x);
    }

    @Override
    public final double primitive(double x) {
        return this.primitive(x, false);
    }

    @Override
    public final double primitive(double x, boolean allowExtrapolation) {
        this.checkRange(x, allowExtrapolation);
        return this.primitiveImpl(x);
    }

    @Override
    public final double derivative(double x) {
        return this.derivative(x, false);
    }

    @Override
    public final double derivative(double x, boolean allowExtrapolation) {
        this.checkRange(x, allowExtrapolation);
        return this.derivativeImpl(x);
    }

    @Override
    public final double secondDerivative(double x) {
        return this.secondDerivative(x, false);
    }

    @Override
    public final double secondDerivative(double x, boolean allowExtrapolation) {
        this.checkRange(x, allowExtrapolation);
        return this.secondDerivativeImpl(x);
    }

    @Override
    public final boolean isInRange(double x) {
        double x1 = this.xMin();
        double x2 = this.xMax();
        return x >= x1 && x <= x2 || Closeness.isClose(x, x1) || Closeness.isClose(x, x2);
    }

    @Override
    public void reload() {
        if (this.vx.length < 2) {
            throw new IllegalArgumentException("not enough points to interpolate");
        }
        if (this.extraSafetyChecks) {
            double x1 = this.vx[0];
            for (int i = 1; i < this.vx.length; ++i) {
                double x2 = this.vx[i];
                if (x1 > x2) {
                    throw new IllegalArgumentException("unsorted values on array X");
                }
                x1 = x2;
            }
        }
    }

    @Override
    public final double evaluate(double x) {
        return this.evaluate(x, false);
    }

    @Override
    public final boolean allowsExtrapolation() {
        return this.delegatedExtrapolator.allowsExtrapolation();
    }

    @Override
    public void disableExtrapolation() {
        this.delegatedExtrapolator.disableExtrapolation();
    }

    @Override
    public void enableExtrapolation() {
        this.delegatedExtrapolator.enableExtrapolation();
    }
}

