/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.http.base.internal.logger;

import org.apache.felix.http.base.internal.logger.ConsoleLogger;
import org.apache.felix.http.base.internal.logger.InternalLogger;
import org.apache.felix.http.base.internal.logger.JDK14Logger;
import org.apache.felix.http.base.internal.logger.LogServiceSupport;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class LogServiceEnabledLogger {
    private static final String LOGSERVICE_CLASS = "org.osgi.service.log.LogService";
    private static final String JUL_LOGGER = "org.apache.felix.http.log.jul";
    protected final ServiceTracker<Object, Object> logServiceTracker;
    private volatile InternalLogger currentLogger;
    protected volatile int trackingCount = -2;
    private final InternalLogger defaultLogger;

    public LogServiceEnabledLogger(final BundleContext bundleContext) {
        String julLogOpt = bundleContext.getProperty(JUL_LOGGER);
        if (julLogOpt == null) {
            julLogOpt = System.getProperty(JUL_LOGGER);
        }
        this.defaultLogger = julLogOpt != null ? new JDK14Logger() : new ConsoleLogger();
        this.logServiceTracker = new ServiceTracker(bundleContext, LOGSERVICE_CLASS, (ServiceTrackerCustomizer)new ServiceTrackerCustomizer<Object, Object>(){
            private volatile boolean hasService = false;

            public Object addingService(ServiceReference<Object> reference) {
                Object logService;
                if (!this.hasService && (logService = bundleContext.getService(reference)) != null) {
                    this.hasService = true;
                    LogServiceSupport lsl = new LogServiceSupport(logService);
                    return lsl;
                }
                return null;
            }

            public void modifiedService(ServiceReference<Object> reference, Object service) {
            }

            public void removedService(ServiceReference<Object> reference, Object service) {
                this.hasService = false;
                bundleContext.ungetService(reference);
            }
        });
        this.logServiceTracker.open();
    }

    public void close() {
        this.logServiceTracker.close();
    }

    public boolean isLogEnabled(int level) {
        return this.getLogger().isLogEnabled(level);
    }

    public void log(int level, String message, Throwable ex) {
        if (this.isLogEnabled(level)) {
            this.getLogger().log(level, message, ex);
        }
    }

    InternalLogger getLogger() {
        if (this.trackingCount < this.logServiceTracker.getTrackingCount()) {
            Object logServiceSupport = this.logServiceTracker.getService();
            this.currentLogger = logServiceSupport == null ? this.getDefaultLogger() : ((LogServiceSupport)logServiceSupport).getLogger();
            this.trackingCount = this.logServiceTracker.getTrackingCount();
        }
        return this.currentLogger;
    }

    InternalLogger getDefaultLogger() {
        return this.defaultLogger;
    }
}

