/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.cm.impl;

import java.io.IOException;
import java.util.Dictionary;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import org.apache.felix.cm.PersistenceManager;

class Factory {
    public static final String FACTORY_PID = "factory.pid";
    public static final String FACTORY_PID_LIST = "factory.pidList";
    private PersistenceManager persistenceManager;
    private String factoryPid;
    private String bundleLocation;
    private Set pids;

    static boolean exists(PersistenceManager persistenceManager, String factoryPid) {
        return persistenceManager.exists(Factory.factoryPidToIdentifier(factoryPid));
    }

    static Factory load(PersistenceManager persistenceManager, String factoryPid) throws IOException {
        Dictionary dict = persistenceManager.load(Factory.factoryPidToIdentifier(factoryPid));
        return new Factory(persistenceManager, factoryPid, dict);
    }

    static Factory getFactory(PersistenceManager persistenceManager, Dictionary props) {
        String factoryPid = (String)props.get(FACTORY_PID);
        if (factoryPid == null) {
            return null;
        }
        return new Factory(persistenceManager, factoryPid, props);
    }

    private static String factoryPidToIdentifier(String factoryPid) {
        return factoryPid + ".factory";
    }

    Factory(PersistenceManager persistenceManager, String factoryPid) {
        this.persistenceManager = persistenceManager;
        this.factoryPid = factoryPid;
        this.pids = new HashSet();
    }

    Factory(PersistenceManager persistenceManager, String factoryPid, Dictionary props) {
        this(persistenceManager, factoryPid);
        this.bundleLocation = (String)props.get("service.bundleLocation");
        String[] pidList = (String[])props.get(FACTORY_PID_LIST);
        if (pidList != null) {
            for (int i = 0; i < pidList.length; ++i) {
                this.pids.add(pidList[i]);
            }
        }
    }

    PersistenceManager getPersistenceManager() {
        return this.persistenceManager;
    }

    String getFactoryPid() {
        return this.factoryPid;
    }

    String getBundleLocation() {
        return this.bundleLocation;
    }

    void setBundleLocation(String bundleLocation) {
        this.bundleLocation = bundleLocation;
        this.storeSilently();
    }

    Set getPIDs() {
        return new HashSet(this.pids);
    }

    boolean addPID(String pid) {
        return this.pids.add(pid);
    }

    boolean removePID(String pid) {
        return this.pids.remove(pid);
    }

    void store() throws IOException {
        Hashtable<String, Object> props = new Hashtable<String, Object>();
        if (this.bundleLocation != null) {
            props.put("service.bundleLocation", this.getBundleLocation());
        }
        if (!this.pids.isEmpty()) {
            props.put(FACTORY_PID_LIST, this.pids.toArray(new String[this.pids.size()]));
        }
        String id = Factory.factoryPidToIdentifier(this.getFactoryPid());
        if (props.isEmpty()) {
            this.persistenceManager.delete(id);
        } else {
            props.put(FACTORY_PID, this.getFactoryPid());
            this.persistenceManager.store(id, props);
        }
    }

    void storeSilently() {
        try {
            this.store();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

