/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.pricingengines;

import org.jquantlib.daycounters.DayCounter;
import org.jquantlib.exercise.Exercise;
import org.jquantlib.instruments.StrikedTypePayoff;
import org.jquantlib.pricingengines.BlackCalculator;
import org.jquantlib.pricingengines.VanillaOptionEngine;
import org.jquantlib.pricingengines.arguments.OneAssetOptionArguments;
import org.jquantlib.pricingengines.results.OneAssetOptionResults;
import org.jquantlib.processes.GeneralizedBlackScholesProcess;

public class AnalyticEuropeanEngine
extends VanillaOptionEngine {
    @Override
    public void calculate() {
        if (((OneAssetOptionArguments)this.arguments).exercise.type() != Exercise.Type.EUROPEAN) {
            throw new IllegalArgumentException("not an European option");
        }
        StrikedTypePayoff payoff = (StrikedTypePayoff)((OneAssetOptionArguments)this.arguments).payoff;
        if (payoff == null) {
            throw new NullPointerException("non-striked payoff given");
        }
        GeneralizedBlackScholesProcess process = (GeneralizedBlackScholesProcess)((OneAssetOptionArguments)this.arguments).stochasticProcess;
        if (process == null) {
            throw new NullPointerException("Black-Scholes process required");
        }
        double variance = process.blackVolatility().getLink().blackVariance(((OneAssetOptionArguments)this.arguments).exercise.lastDate(), payoff.strike());
        double dividendDiscount = process.dividendYield().getLink().discount(((OneAssetOptionArguments)this.arguments).exercise.lastDate());
        double riskFreeDiscount = process.riskFreeRate().getLink().discount(((OneAssetOptionArguments)this.arguments).exercise.lastDate());
        double spot = process.stateVariable().getLink().evaluate();
        double forwardPrice = spot * dividendDiscount / riskFreeDiscount;
        BlackCalculator black = new BlackCalculator(payoff, forwardPrice, Math.sqrt(variance), riskFreeDiscount);
        ((OneAssetOptionResults)this.results).value = black.value();
        ((OneAssetOptionResults)this.results).delta = black.delta(spot);
        ((OneAssetOptionResults)this.results).deltaForward = black.deltaForward();
        ((OneAssetOptionResults)this.results).elasticity = black.elasticity(spot);
        ((OneAssetOptionResults)this.results).gamma = black.gamma(spot);
        DayCounter rfdc = process.riskFreeRate().getLink().dayCounter();
        DayCounter divdc = process.dividendYield().getLink().dayCounter();
        DayCounter voldc = process.blackVolatility().getLink().dayCounter();
        double t = rfdc.yearFraction(process.riskFreeRate().getLink().referenceDate(), ((OneAssetOptionArguments)this.arguments).exercise.lastDate());
        ((OneAssetOptionResults)this.results).rho = black.rho(t);
        t = divdc.yearFraction(process.dividendYield().getLink().referenceDate(), ((OneAssetOptionArguments)this.arguments).exercise.lastDate());
        ((OneAssetOptionResults)this.results).dividendRho = black.dividendRho(t);
        t = voldc.yearFraction(process.blackVolatility().getLink().referenceDate(), ((OneAssetOptionArguments)this.arguments).exercise.lastDate());
        ((OneAssetOptionResults)this.results).vega = black.vega(t);
        try {
            ((OneAssetOptionResults)this.results).theta = black.theta(spot, t);
            ((OneAssetOptionResults)this.results).thetaPerDay = black.thetaPerDay(spot, t);
        }
        catch (Exception e) {
            ((OneAssetOptionResults)this.results).theta = Double.NaN;
            ((OneAssetOptionResults)this.results).thetaPerDay = Double.NaN;
        }
        ((OneAssetOptionResults)this.results).strikeSensitivity = black.strikeSensitivity();
        ((OneAssetOptionResults)this.results).itmCashProbability = black.itmCashProbability();
    }
}

