/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.math.solvers1D;

import org.jquantlib.math.AbstractSolver1D;
import org.jquantlib.math.UnaryFunctionDouble;

public class FalsePosition
extends AbstractSolver1D<UnaryFunctionDouble> {
    @Override
    protected double solveImpl(UnaryFunctionDouble f, double xAccuracy) {
        double fh;
        double xh;
        double fl;
        double xl;
        if (this.fxMin_ < 0.0) {
            xl = this.xMin_;
            fl = this.fxMin_;
            xh = this.xMax_;
            fh = this.fxMax_;
        } else {
            xl = this.xMax_;
            fl = this.fxMax_;
            xh = this.xMin_;
            fh = this.fxMin_;
        }
        double dx = xh - xl;
        while (this.evaluationNumber_ <= this.getMaxEvaluations()) {
            double del;
            this.root_ = xl + dx * fl / (fl - fh);
            double froot = f.evaluate(this.root_);
            ++this.evaluationNumber_;
            if (froot < 0.0) {
                del = xl - this.root_;
                xl = this.root_;
                fl = froot;
            } else {
                del = xh - this.root_;
                xh = this.root_;
                fh = froot;
            }
            dx = xh - xl;
            if (!(Math.abs(del) < xAccuracy) && froot != 0.0) continue;
            return this.root_;
        }
        throw new ArithmeticException("maximum number of function evaluations (" + this.getMaxEvaluations() + ") exceeded");
    }
}

