/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.termstructures.volatilities;

import org.jquantlib.daycounters.DayCounter;
import org.jquantlib.quotes.Handle;
import org.jquantlib.termstructures.LocalVolTermStructure;
import org.jquantlib.termstructures.TermStructure;
import org.jquantlib.termstructures.volatilities.BlackVarianceCurve;
import org.jquantlib.util.Date;
import org.jquantlib.util.TypedVisitor;
import org.jquantlib.util.Visitor;

public class LocalVolCurve
extends LocalVolTermStructure {
    private BlackVarianceCurve blackVarianceCurve_;

    public LocalVolCurve(Handle<BlackVarianceCurve> curve) {
        super(curve.getLink().dayCounter());
        this.blackVarianceCurve_ = curve.getLink();
        this.blackVarianceCurve_.addObserver(this);
    }

    @Override
    public final Date referenceDate() {
        return this.blackVarianceCurve_.referenceDate();
    }

    @Override
    public final DayCounter dayCounter() {
        return this.blackVarianceCurve_.dayCounter();
    }

    @Override
    public final Date maxDate() {
        return this.blackVarianceCurve_.maxDate();
    }

    @Override
    public final double minStrike() {
        return Double.NEGATIVE_INFINITY;
    }

    @Override
    public final double maxStrike() {
        return Double.POSITIVE_INFINITY;
    }

    @Override
    protected final double localVolImpl(double maturity, double strike) {
        double m = maturity;
        double dt = 0.0027397260273972603;
        double var1 = this.blackVarianceCurve_.blackVariance(maturity, strike, true);
        double var2 = this.blackVarianceCurve_.blackVariance(m + dt, strike, true);
        double derivative = (var2 - var1) / dt;
        return Math.sqrt(derivative);
    }

    @Override
    public void accept(TypedVisitor<TermStructure> v) {
        Visitor<TermStructure> v1;
        Visitor<TermStructure> visitor = v1 = v != null ? v.getVisitor(this.getClass()) : null;
        if (v1 != null) {
            v1.visit(this);
        } else {
            super.accept(v);
        }
    }
}

