/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.methods.finitedifferences;

import org.jquantlib.math.Array;
import org.jquantlib.methods.finitedifferences.Operator;

public class TridiagonalOperator
implements Operator {
    protected TimeSetter timeSetter;
    protected Array lowerDiagonal;
    protected Array diagonal;
    protected Array upperDiagonal;

    public TridiagonalOperator(int size) {
        if (size >= 2) {
            this.lowerDiagonal = new Array(size - 1);
            this.diagonal = new Array(size);
            this.upperDiagonal = new Array(size - 1);
        } else if (size == 0) {
            this.lowerDiagonal = new Array(0);
            this.diagonal = new Array(0);
            this.upperDiagonal = new Array(0);
        } else {
            throw new IllegalStateException("Invalid size " + size);
        }
    }

    public TridiagonalOperator(Array ldiag, Array diag, Array udiag) {
        if (ldiag.size() != diag.size() - 1) {
            throw new IllegalStateException("wrong size for lower diagonal");
        }
        if (udiag.size() != diag.size() - 1) {
            throw new IllegalStateException("wrong size for upper diagonal");
        }
        this.lowerDiagonal = ldiag;
        this.diagonal = diag;
        this.upperDiagonal = udiag;
    }

    public TridiagonalOperator(TridiagonalOperator t) {
        this.diagonal = new Array(t.diagonal());
        this.upperDiagonal = new Array(t.upperDiagonal());
        this.lowerDiagonal = new Array(t.lowerDiagonal());
        this.timeSetter = t.getTimeSetter();
    }

    public void setFirstRow(double b, double c) {
        this.diagonal.set(0, b);
        this.upperDiagonal.set(0, c);
    }

    public void setMidRow(int size, double a, double b, double c) {
        if (size < 1 || size > this.size() - 2) {
            throw new IllegalStateException("out of range in setMidRow");
        }
        this.lowerDiagonal.set(size - 1, a);
        this.diagonal.set(size, b);
        this.upperDiagonal.set(size, c);
    }

    public void setMidRows(double a, double b, double c) {
        for (int i = 1; i <= this.size() - 2; ++i) {
            this.lowerDiagonal.set(i - 1, a);
            this.diagonal.set(i, b);
            this.upperDiagonal.set(i, c);
        }
    }

    public void setLastRow(double a, double b) {
        this.lowerDiagonal.set(this.size() - 2, a);
        this.diagonal.set(this.size() - 1, b);
    }

    @Override
    public void setTime(double t) {
        if (this.timeSetter != null) {
            this.timeSetter.setTime(t, this);
        }
    }

    @Override
    public int size() {
        return this.diagonal.size();
    }

    public Operator add(Operator op) {
        TridiagonalOperator D1 = (TridiagonalOperator)op;
        TridiagonalOperator D2 = this;
        Array low = D1.lowerDiagonal.operatorAddCopy(D2.lowerDiagonal());
        Array mid = D1.diagonal.operatorAddCopy(D2.diagonal());
        Array high = D1.upperDiagonal.operatorAddCopy(D2.upperDiagonal());
        return new TridiagonalOperator(low, mid, high);
    }

    public Operator subtract(Operator op) {
        TridiagonalOperator D = (TridiagonalOperator)op;
        Array low = this.lowerDiagonal.operatorSubtractCopy(D.lowerDiagonal());
        Array mid = this.diagonal.operatorSubtractCopy(D.diagonal());
        Array high = this.upperDiagonal.operatorSubtractCopy(D.upperDiagonal());
        return new TridiagonalOperator(low, mid, high);
    }

    public Operator add(Operator op1, Operator op2) {
        TridiagonalOperator D1 = (TridiagonalOperator)op1;
        TridiagonalOperator D2 = (TridiagonalOperator)op2;
        Array low = D1.lowerDiagonal.operatorAddCopy(D2.lowerDiagonal());
        Array mid = D1.diagonal.operatorAddCopy(D2.diagonal());
        Array high = D1.upperDiagonal.operatorAddCopy(D2.upperDiagonal());
        return new TridiagonalOperator(low, mid, high);
    }

    public Operator subtract(Operator op1, Operator op2) {
        TridiagonalOperator D1 = (TridiagonalOperator)op1;
        TridiagonalOperator D2 = (TridiagonalOperator)op2;
        Array low = D1.lowerDiagonal.operatorSubtractCopy(D2.lowerDiagonal);
        Array mid = D1.diagonal.operatorSubtractCopy(D2.diagonal);
        Array high = D1.upperDiagonal.operatorSubtractCopy(D2.upperDiagonal);
        return new TridiagonalOperator(low, mid, high);
    }

    public Operator multiply(double a, Operator op) {
        TridiagonalOperator D = (TridiagonalOperator)op;
        Array low = D.lowerDiagonal;
        low.operatorMultiply(a);
        Array mid = D.diagonal;
        mid.operatorMultiply(a);
        Array high = D.upperDiagonal;
        high.operatorMultiply(a);
        return new TridiagonalOperator(low, mid, high);
    }

    public Operator multiply(Operator D, double a) {
        return this.multiply(a, D);
    }

    public Operator multiply(double a) {
        Array low = new Array(this.lowerDiagonal);
        low.operatorMultiply(a);
        Array mid = new Array(this.diagonal);
        mid.operatorMultiply(a);
        Array high = new Array(this.upperDiagonal);
        high.operatorMultiply(a);
        return new TridiagonalOperator(low, mid, high);
    }

    public Operator divide(Operator op, double a) {
        TridiagonalOperator D = (TridiagonalOperator)op;
        Array low = D.lowerDiagonal;
        low.operatorDivide(a);
        Array mid = D.diagonal;
        mid.operatorDivide(a);
        Array high = D.upperDiagonal;
        low.operatorDivide(a);
        return new TridiagonalOperator(low, mid, high);
    }

    @Override
    public final Array SOR(Array rhs, int tol) {
        if (rhs.size() != this.size()) {
            throw new IllegalStateException("rhs has the wrong size");
        }
        Array result = rhs;
        double omega = 1.5;
        double err = 2.0 * (double)tol;
        int sorIteration = 0;
        while (err > (double)tol) {
            int i;
            if (sorIteration > 100000) {
                throw new IllegalStateException("tolerance (" + tol + ") not reached in " + sorIteration + " iterations. " + "The error still is " + err);
            }
            double temp = omega * (rhs.get(0) - this.upperDiagonal.get(0) * result.get(1) - this.diagonal.get(0) * result.get(0)) / this.diagonal.get(0);
            err = temp * temp;
            result.set(0, result.get(0) + temp);
            for (i = 1; i < this.size() - 1; ++i) {
                temp = omega * (rhs.get(i) - this.upperDiagonal.get(i) * result.get(i + 1) - this.diagonal.get(i) * result.get(i) - this.lowerDiagonal.get(i - 1) * result.get(i - 1)) / this.diagonal.get(i);
                err += temp * temp;
                result.set(i, result.get(i) + temp);
            }
            temp = omega * (rhs.get(i) - this.diagonal.get(i) * result.get(i) - this.lowerDiagonal.get(i - 1) * result.get(i - 1)) / this.diagonal.get(i);
            err += temp * temp;
            result.set(i, result.get(i) + temp);
            ++sorIteration;
        }
        return result;
    }

    public TridiagonalOperator identity(int size) {
        TridiagonalOperator I = new TridiagonalOperator(new Array(size - 1, 0.0), new Array(size, 1.0), new Array(size - 1, 0.0));
        return I;
    }

    @Override
    public boolean isTimeDependent() {
        return this.timeSetter != null;
    }

    public final Array lowerDiagonal() {
        return this.lowerDiagonal;
    }

    public final Array diagonal() {
        return this.diagonal;
    }

    public final Array upperDiagonal() {
        return this.upperDiagonal;
    }

    public TimeSetter getTimeSetter() {
        return this.timeSetter;
    }

    public void swap(Operator opFrom) {
        TridiagonalOperator from = (TridiagonalOperator)opFrom;
        this.diagonal.swap(from.diagonal);
        this.lowerDiagonal.swap(from.lowerDiagonal);
        this.upperDiagonal.swap(from.upperDiagonal);
        this.timeSetter = from.getTimeSetter();
    }

    public void swap(Operator op1, Operator op2) {
        TridiagonalOperator L1;
        TridiagonalOperator temp = L1 = (TridiagonalOperator)op1;
        L1.swap(op2);
        op2.swap(temp);
    }

    @Override
    public Array applyTo(Array v) {
        if (v.size() != this.size()) {
            throw new IllegalStateException("vector of the wrong size (" + v.size() + "instead of " + this.size() + ")");
        }
        Array result = new Array(this.diagonal);
        result.operatorMultiply(v);
        result.set(0, result.get(0) + this.upperDiagonal.get(0) * v.get(1));
        for (int j = 1; j <= this.size() - 2; ++j) {
            result.set(j, result.get(j) + this.lowerDiagonal.get(j - 1) * v.get(j - 1) + this.upperDiagonal.get(j) * v.get(j + 1));
        }
        result.set(this.size() - 1, result.get(this.size() - 1) + this.lowerDiagonal.get(this.size() - 2) * v.get(this.size() - 2));
        return result;
    }

    @Override
    public final Array solveFor(Array rhs) {
        int j;
        Array result = new Array(this.size());
        Array tmp = new Array(this.size());
        double bet = this.diagonal.get(0);
        if (bet == 0.0) {
            throw new IllegalStateException("division by zero");
        }
        result.set(0, rhs.get(0) / bet);
        for (j = 1; j <= this.size() - 1; ++j) {
            tmp.set(j, this.upperDiagonal.get(j - 1) / bet);
            bet = this.diagonal.get(j) - this.lowerDiagonal.get(j - 1) * tmp.get(j);
            if (bet == 0.0) {
                throw new IllegalStateException("division by zero");
            }
            result.set(j, (rhs.get(j) - this.lowerDiagonal.get(j - 1) * result.get(j - 1)) / bet);
        }
        for (j = this.size() - 2; j > 0; --j) {
            result.set(j, result.get(j) - tmp.get(j + 1) * result.get(j + 1));
        }
        result.set(0, result.get(0) - tmp.get(1) * result.get(1));
        return result;
    }

    public static interface TimeSetter {
        public void setTime(double var1, TridiagonalOperator var3);
    }
}

