/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.math.randomnumbers;

import org.joda.primitives.list.DoubleList;
import org.joda.primitives.list.impl.ArrayDoubleList;
import org.jquantlib.math.randomnumbers.InverseCumulative;
import org.jquantlib.math.randomnumbers.RandomSequenceGeneratorIntf;
import org.jquantlib.methods.montecarlo.Sample;

public class InverseCumulativeRsg<USG extends RandomSequenceGeneratorIntf, IC extends InverseCumulative>
implements RandomSequenceGeneratorIntf {
    private final USG ursg;
    private final int dimension;
    private double[] sequence;
    private double weight;
    private IC ic;

    public InverseCumulativeRsg(USG ursg) {
        if (System.getProperty("EXPERIMENTAL") == null) {
            throw new UnsupportedOperationException("Work in progress");
        }
        this.ursg = ursg;
        this.dimension = this.ursg.dimension();
        this.sequence = new double[this.dimension];
        this.weight = 1.0;
        this.ic = null;
    }

    public InverseCumulativeRsg(USG ursg, IC ic) {
        this(ursg);
        this.ic = ic;
    }

    @Override
    public Sample<DoubleList> nextSequence() {
        if (System.getProperty("EXPERIMENTAL") == null) {
            throw new UnsupportedOperationException("Work in progress");
        }
        Sample<DoubleList> sample = this.ursg.nextSequence();
        double[] tmp = sample.getValue().toDoubleArray();
        this.weight = sample.getWeight();
        for (int i = 0; i < this.dimension; ++i) {
            this.sequence[i] = this.ic.evaluate(tmp[i]);
        }
        return new Sample<ArrayDoubleList>(new ArrayDoubleList(this.sequence), this.weight);
    }

    @Override
    public final Sample<DoubleList> lastSequence() {
        ArrayDoubleList list = new ArrayDoubleList(this.sequence);
        return new Sample<ArrayDoubleList>(list, this.weight);
    }

    @Override
    public long[] nextInt32Sequence() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int dimension() {
        return this.dimension;
    }
}

