// -*- C++ -*-
#include "Rivet/Analysis.hh"
#include "Rivet/Projections/UnstableParticles.hh"

namespace Rivet {


  /// @brief charm cross sections
  class BES_1999_I508349 : public Analysis {
  public:

    /// Constructor
    RIVET_DEFAULT_ANALYSIS_CTOR(BES_1999_I508349);


    /// @name Analysis methods
    /// @{

    /// Book histograms and initialise projections before the run
    void init() {
      declare(UnstableParticles(),"UFS");
      for (size_t ix=0; ix<4; ++ix) {
        book(_nD[ix], 1, 1, 1+ix);
      }

      _edge = "4.03";
      for (double eVal : allowedEnergies()) {

        const string en = toString(round(eVal/MeV));
        if (isCompatibleWithSqrtS(eVal)) {
          _sqs = en;
          if (en == "4140"s)  _edge = "4.14";
        }

        size_t ih = en == "4140"s;
        book(_h_D0[en], 2+ih, 1, 1);
        book(_h_Dp[en], 2+ih, 1, 2);

      }
      raiseBeamErrorIf(_sqs.empty());
    }


    /// Perform the per-event analysis
    void analyze(const Event& event) {
      double nD0(0),nDp(0),nDs(0);
      for(const Particle & p : apply<UnstableParticles>(event, "UFS").particles(Cuts::abspid==411 or
                                                                                Cuts::abspid==421 or
                                                                                Cuts::abspid==431)) {
        if (p.abspid()==421) {
          _h_D0[_sqs]->fill(p.mom().p3().mod());
          ++nD0;
        }
        else if (p.abspid()==411) {
          _h_Dp[_sqs]->fill(p.mom().p3().mod());
          ++nDp;
        }
        else {
          ++nDs;
        }
      }
      _nD[0]->fill(_edge, 0.5*nD0);
      _nD[1]->fill(_edge, 0.5*nDp);
      _nD[2]->fill(_edge, 0.5*nDs);
      _nD[3]->fill(_edge, 0.5*(nD0+nDp+nDs));
    }


    /// Normalise histograms etc., after the run
    void finalize() {
      const double fact = crossSection()/sumOfWeights()/nanobarn;
      scale(_h_D0, 0.5*fact);
      scale(_h_Dp, 0.5*fact);
      scale(_nD,fact);
    }

    /// @}


    /// @name Histograms
    /// @{
    BinnedHistoPtr<string> _nD[4];
    map<string,Histo1DPtr> _h_D0,_h_Dp;
    string _sqs = "", _edge = "";
    /// @}


  };


  RIVET_DECLARE_PLUGIN(BES_1999_I508349);

}
