<!--startmeta
custom_edit_url: "https://github.com/netdata/netdata/edit/master/src/collectors/python.d.plugin/spigotmc/README.md"
meta_yaml: "https://github.com/netdata/netdata/edit/master/src/collectors/python.d.plugin/spigotmc/metadata.yaml"
sidebar_label: "SpigotMC"
learn_status: "Published"
learn_rel_path: "Collecting Metrics/Gaming"
most_popular: False
message: "DO NOT EDIT THIS FILE DIRECTLY, IT IS GENERATED BY THE COLLECTOR'S metadata.yaml FILE"
endmeta-->

# SpigotMC


<img src="https://netdata.cloud/img/spigot.jfif" width="150"/>


Plugin: python.d.plugin
Module: spigotmc

<img src="https://img.shields.io/badge/maintained%20by-Netdata-%2300ab44" />

## Overview

This collector monitors SpigotMC server performance, in the form of ticks per second average, memory utilization, and active users.


It sends the `tps`, `list` and `online` commands to the Server, and gathers the metrics from the responses.


This collector is only supported on the following platforms:

- Linux

This collector supports collecting metrics from multiple instances of this integration, including remote instances.


### Default Behavior

#### Auto-Detection

By default, this collector will attempt to connect to a Spigot server running on the local host on port `25575`.

#### Limits

The default configuration for this integration does not impose any limits on data collection.

#### Performance Impact

The default configuration for this integration is not expected to impose a significant performance impact on the system.


## Metrics

Metrics grouped by *scope*.

The scope defines the instance that the metric belongs to. An instance is uniquely identified by a set of labels.



### Per SpigotMC instance

These metrics refer to the entire monitored application.

This scope has no labels.

Metrics:

| Metric | Dimensions | Unit |
|:------|:----------|:----|
| spigotmc.tps | 1 Minute Average, 5 Minute Average, 15 Minute Average | ticks |
| spigotmc.users | Users | users |
| spigotmc.mem | used, allocated, max | MiB |



## Alerts

There are no alerts configured by default for this integration.


## Setup

### Prerequisites

#### Enable the Remote Console Protocol

Under your SpigotMC server's `server.properties` configuration file, you should set `enable-rcon` to `true`.

This will allow the Server to listen and respond to queries over the rcon protocol.



### Configuration

#### File

The configuration file name for this integration is `python.d/spigotmc.conf`.


You can edit the configuration file using the `edit-config` script from the
Netdata [config directory](/docs/netdata-agent/configuration/README.md#the-netdata-config-directory).

```bash
cd /etc/netdata 2>/dev/null || cd /opt/netdata/etc/netdata
sudo ./edit-config python.d/spigotmc.conf
```
#### Options

There are 2 sections:

* Global variables
* One or more JOBS that can define multiple different instances to monitor.

The following options can be defined globally: priority, penalty, autodetection_retry, update_every, but can also be defined per JOB to override the global values.

Additionally, the following collapsed table contains all the options that can be configured inside a JOB definition.

Every configuration JOB starts with a `job_name` value which will appear in the dashboard, unless a `name` parameter is specified.


<details open><summary>Config options</summary>

| Name | Description | Default | Required |
|:----|:-----------|:-------|:--------:|
| update_every | Sets the default data collection frequency. | 1 | no |
| priority | Controls the order of charts at the netdata dashboard. | 60000 | no |
| autodetection_retry | Sets the job re-check interval in seconds. | 0 | no |
| penalty | Indicates whether to apply penalty to update_every in case of failures. | yes | no |
| name | Job name. This value will overwrite the `job_name` value. JOBS with the same name are mutually exclusive. Only one of them will be allowed running at any time. This allows autodetection to try several alternatives and pick the one that works. |  | no |
| host | The host's IP to connect to. | localhost | yes |
| port | The port the remote console is listening on. | 25575 | yes |
| password | Remote console password if any. |  | no |

</details>

#### Examples

##### Basic

A basic configuration example.

```yaml
local:
  name: local_server
  url: 127.0.0.1
  port: 25575

```
##### Basic Authentication

An example using basic password for authentication with the remote console.

<details open><summary>Config</summary>

```yaml
local:
  name: local_server_pass
  url: 127.0.0.1
  port: 25575
  password: 'foobar'

```
</details>

##### Multi-instance

> **Note**: When you define multiple jobs, their names must be unique.

Collecting metrics from local and remote instances.


<details open><summary>Config</summary>

```yaml
local_server:
  name : my_local_server
  url  : 127.0.0.1
  port: 25575

remote_server:
  name : another_remote_server
  url  : 192.0.2.1
  port: 25575

```
</details>



## Troubleshooting

### Debug Mode


To troubleshoot issues with the `spigotmc` collector, run the `python.d.plugin` with the debug option enabled. The output
should give you clues as to why the collector isn't working.

- Navigate to the `plugins.d` directory, usually at `/usr/libexec/netdata/plugins.d/`. If that's not the case on
  your system, open `netdata.conf` and look for the `plugins` setting under `[directories]`.

  ```bash
  cd /usr/libexec/netdata/plugins.d/
  ```

- Switch to the `netdata` user.

  ```bash
  sudo -u netdata -s
  ```

- Run the `python.d.plugin` to debug the collector:

  ```bash
  ./python.d.plugin spigotmc debug trace
  ```

### Getting Logs

If you're encountering problems with the `spigotmc` collector, follow these steps to retrieve logs and identify potential issues:

- **Run the command** specific to your system (systemd, non-systemd, or Docker container).
- **Examine the output** for any warnings or error messages that might indicate issues.  These messages should provide clues about the root cause of the problem.

#### System with systemd

Use the following command to view logs generated since the last Netdata service restart:

```bash
journalctl _SYSTEMD_INVOCATION_ID="$(systemctl show --value --property=InvocationID netdata)" --namespace=netdata --grep spigotmc
```

#### System without systemd

Locate the collector log file, typically at `/var/log/netdata/collector.log`, and use `grep` to filter for collector's name:

```bash
grep spigotmc /var/log/netdata/collector.log
```

**Note**: This method shows logs from all restarts. Focus on the **latest entries** for troubleshooting current issues.

#### Docker Container

If your Netdata runs in a Docker container named "netdata" (replace if different), use this command:

```bash
docker logs netdata 2>&1 | grep spigotmc
```


