/*  MaitreTarot.
 *  (C) 2002 Philippe Brochard <hocwp@free.fr>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */


#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include "interface.h"
#include "card.h"


gchar card_str[NUMBER_OF_CARD][4];
gint card_color[NUMBER_OF_CARD];

gint card_sort[NUMBER_OF_CARD];


void
init_card (void)
{
  int i;

  /* init string of card */
  for (i = 0; i < NUMBER_OF_CARD; i++)
    {
      sprintf (card_str[i], "..?");
      card_color[i] = COLOR_WHITE;
    }

  for (i = 0; i < 10; i++)
    {
      sprintf (card_str[i + CLUB], "%i%s", i + 1, _("c"));
      sprintf (card_str[i + SPADE], "%i%s", i + 1, _("s"));
      sprintf (card_str[i + HEART], "%i%s", i + 1, _("h"));
      sprintf (card_str[i + DIAMOND], "%i%s", i + 1, _("d"));
    }

  sprintf (card_str[i + CLUB], "%s%s", _("J"), _("c"));
  sprintf (card_str[i + SPADE], "%s%s", _("J"), _("s"));
  sprintf (card_str[i + HEART], "%s%s", _("J"), _("h"));
  sprintf (card_str[i + DIAMOND], "%s%s", _("J"), _("d"));
  i++;

  sprintf (card_str[i + CLUB], "%s%s", _("C"), _("c"));
  sprintf (card_str[i + SPADE], "%s%s", _("C"), _("s"));
  sprintf (card_str[i + HEART], "%s%s", _("C"), _("h"));
  sprintf (card_str[i + DIAMOND], "%s%s", _("C"), _("d"));
  i++;

  sprintf (card_str[i + CLUB], "%s%s", _("Q"), _("c"));
  sprintf (card_str[i + SPADE], "%s%s", _("Q"), _("s"));
  sprintf (card_str[i + HEART], "%s%s", _("Q"), _("h"));
  sprintf (card_str[i + DIAMOND], "%s%s", _("Q"), _("d"));
  i++;

  sprintf (card_str[i + CLUB], "%s%s", _("K"), _("c"));
  sprintf (card_str[i + SPADE], "%s%s", _("K"), _("s"));
  sprintf (card_str[i + HEART], "%s%s", _("K"), _("h"));
  sprintf (card_str[i + DIAMOND], "%s%s", _("K"), _("d"));
  i++;

  for (i = 0; i < 21; i++)
    {
      sprintf (card_str[i + TRUMP], "%d", i + 1);
    }

  sprintf (card_str[FOOL], "%s", _("F"));


  /* init color of card */
  for (i = 0; i < 14; i++)
    {
      card_color[i + CLUB] = COLOR_CYAN;
      card_color[i + SPADE] = COLOR_CYAN;
      card_color[i + HEART] = COLOR_RED;
      card_color[i + DIAMOND] = COLOR_RED;
    }

  card_color[TRUMP] = COLOR_YELLOW;
  for (i = 1; i < 20; i++)
    {
      card_color[i + TRUMP] = COLOR_GREEN;
    }
  card_color[TRUMP + 20] = COLOR_YELLOW;

  card_color[FOOL] = COLOR_YELLOW;


  /* init card_sort */
  for (i = 0; i < NUMBER_OF_CARD; i++)
    card_sort[i] = i;

  for (i = 0; i < 14; i++)
    {
      card_sort[i + HEART] = i;
      card_sort[i + CLUB] = 14 + i;
      card_sort[i + DIAMOND] = 28 + i;
      card_sort[i + SPADE] = 42 + i;
    }
}



void
draw_card_game (int line, int col)
{
  int i;
  GString *st;

  st = g_string_new ("");

  for (i = 0; i < 78; i++)
    {
      set_color (COLOR_BLUE);
      g_string_sprintf (st, "%d", i);
      mvaddstr (line + (i / 14) * 3, col + (i % 14) * 4, st->str);
      set_color (card_color[i]);
      mvaddstr (line + 1 + (i / 14) * 3, col + (i % 14) * 4, card_str[i]);
    }

  set_color (card_color[CLUB]);
  mvaddstr (line + 1, col + 56, "c : club/trefle");
  set_color (card_color[SPADE]);
  mvaddstr (line + 4, col + 56, "s : spade/pique");
  set_color (card_color[HEART]);
  mvaddstr (line + 7, col + 56, "h : heart/coeur");
  set_color (card_color[DIAMOND]);
  mvaddstr (line + 10, col + 56, "d : diamond/carreau");
  set_color (card_color[TRUMP]);
  mvaddstr (line + 13, col + 56, "trump/atout");
  set_color (card_color[FOOL]);
  mvaddstr (line + 16, col + 56, "fool/excuse");
}



void
draw_hand_card (int line, int col, gint * card, gint card_sel)
{
  gint i;

  for (i = 0; i < nb_hand_card; i++)
    {
      set_color (COLOR_WHITE);
      mvaddstr (line + (i / (nb_hand_card / 2)),
		col + 4 * (i % (nb_hand_card / 2)) - 1, "     ");
    }

  for (i = 0; i < nb_hand_card; i++)
    {
      if (card[i] >= 0)
	{
	  set_color (card_color[card[i]]);
	  mvaddstr (line + (i / (nb_hand_card / 2)),
		    col + 4 * (i % (nb_hand_card / 2)), card_str[card[i]]);
	  if (i == card_sel)
	    {
	      set_color (COLOR_YELLOW);
	      mvaddch (line + (i / (nb_hand_card / 2)),
		       col + 4 * (i % (nb_hand_card / 2)) - 1, '>');
	      mvaddch (line + (i / (nb_hand_card / 2)),
		       col + 4 * (i % (nb_hand_card / 2))
		       + strlen (card_str[card[i]]), '<');
	    }
	}
    }
  refresh ();
}



void
draw_chien_card (int line, int col, gint * card, gint card_sel)
{
  gint i;

  for (i = 0; i < nb_chien_card; i++)
    {
      set_color (COLOR_WHITE);
      mvaddstr (line, col + 4 * i - 1, "     ");
    }

  for (i = 0; i < nb_chien_card; i++)
    {
      set_color (card_color[card[i]]);
      mvaddstr (line, col + 4 * i, card_str[card[i]]);

      if (i == card_sel)
	{
	  set_color (COLOR_YELLOW);
	  mvaddch (line, col + 4 * i - 1, '>');
	  mvaddch (line, col + 4 * i + strlen (card_str[card[i]]), '<');
	}
    }

  refresh ();
}


void
draw_card (int line, int col, gint card)
{
  set_color (COLOR_WHITE);
  mvaddstr (line, col, "   ");

  refresh ();

  if (card < 0 || card > NUMBER_OF_CARD)
    return;

  set_color (card_color[card]);
  mvaddstr (line, col, card_str[card]);

  refresh ();
}





static int
compare (const void *ap, const void *bp)
{
  gint a, b;

  a = card_sort[*((gint *) ap)];
  b = card_sort[*((gint *) bp)];

  if (a < b)
    return (-1);
  if (a > b)
    return (1);

  return (0);
}

void
sort_card (gint * card, gint nb_card)
{
  qsort (card, nb_card, sizeof (gint), compare);
}
