/* xkeycaps, Copyright (c) 1991, 1992, 1993, 1994, 1996
 * Jamie Zawinski <jwz@jwz.org>
 *
 * This file describes the key surfaces of the
 * Swedish Tektronix XN10/XN11 keyboard
 * By Kristian Ejvind (Kristian.Ejvind@sth.frontec.se)
 */

static const struct key_strings tekxn10_sf_caps [] = {

  /* Row 0 */

  {"Hold", "Screen", 0},
  {"D Copy", "S Copy", 0},
  {"Setup", 0},
  {"Menu", 0},
  {"Break", 0},
  {"S Eras", 0}, /* Yep, the caps do say 'Eras' ! */
  {"G Eras", 0},
  {"D Eras", 0},
  {"Cancel", 0},
  {"Dialog", 0},
  {"F1", 0},
  {"F2", 0},
  {"F3", 0},
  {"F4", 0},
  {"Help", 0},
  {"Do", 0},
  {"F5", 0},
  {"F6", 0},
  {"F7", 0},
  {"F8", 0},

  /* Row 2 */

  {"Esc", 0},
  {"\260", "~", 0},
  {"!", "1", 0},
  {"\"","2", 0},
  {"\247", "3", 0},
  {"\244", "4", 0},
  {"%", "5", 0},
  {"&", "6", 0},
  {"/", "7", 0},
  {"(", "8", 0},
  {")", "9", 0},
  {"\075", "0", 0},
  {"?", "+", 0},
  {"`", "^", 0},
  {"Back","Space", 0},
  {"<=I", "(Del)", 0},
  {"Find", 0},
  {"Insert","Here", 0},
  {"Re-", "move", 0},
  {"PF 1", 0},
  {"PF 2", 0},
  {"PF 3", 0},
  {"PF 4", 0},

  /* Row 3 */

  {"Line","Feed", 0},
  {"Tab", 0},
  {"Q", 0},
  {"W", 0},
  {"E", 0},
  {"R", 0},
  {"T", 0},
  {"Y", 0},
  {"U", 0},
  {"I", 0},
  {"O", 0},
  {"P", 0},
  {"\305", 0},
  {"\334", 0},
  {"Return", 0},
  {"Select", 0},
  {"Prev","Screen", 0},
  {"Next","Screen", 0},
  {"7", 0},
  {"8", 0},
  {"9", 0},
  {"-", 0},

  /* Row 4 */

  {"Ctrl", 0},
  {"Lock", 0},
  {"A", 0},
  {"S", 0},
  {"D", 0},
  {"F", 0},
  {"G", 0},
  {"H", 0},
  {"J", 0},
  {"K", 0},
  {"L", 0},
  {"\326", 0},
  {"\304", 0},
  {"*", "'", 0},
  {"UpArrow", 0},
  {"4", 0},
  {"5", 0},
  {"6", 0},
  {",", 0},

  /* Row 5 */

  {"Shift", 0},
  {">", "<", 0},
  {"Z", 0},
  {"X", 0},
  {"C", 0},
  {"V", 0},
  {"B", 0},
  {"N", 0},
  {"M", 0},
  {";", ",", 0},
  {":", ".", 0},
  {"_", "-", 0},
  {"Shift", 0},
  {"LeftArrow", 0},
  {"RightArrow", 0},
  {"1", 0},
  {"2", 0},
  {"3", 0},
  {"Enter", 0},

  /* Row 6 */

  {"Compose","Character", 0},
  {" ", 0},
  {"Tek", 0},
  {"DownArrow", 0},
  {"0", 0},
  {".", 0}
};
