# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .scaling_trigger_description_py3 import ScalingTriggerDescription


class AverageServiceLoadScalingTrigger(ScalingTriggerDescription):
    """Represents a scaling policy related to an average load of a metric/resource
    of a service.

    All required parameters must be populated in order to send to Azure.

    :param kind: Required. Constant filled by server.
    :type kind: str
    :param metric_name: Required. The name of the metric for which usage
     should be tracked.
    :type metric_name: str
    :param lower_load_threshold: Required. The lower limit of the load below
     which a scale in operation should be performed.
    :type lower_load_threshold: str
    :param upper_load_threshold: Required. The upper limit of the load beyond
     which a scale out operation should be performed.
    :type upper_load_threshold: str
    :param scale_interval_in_seconds: Required. The period in seconds on which
     a decision is made whether to scale or not.
    :type scale_interval_in_seconds: long
    """

    _validation = {
        'kind': {'required': True},
        'metric_name': {'required': True},
        'lower_load_threshold': {'required': True},
        'upper_load_threshold': {'required': True},
        'scale_interval_in_seconds': {'required': True, 'maximum': 4294967295, 'minimum': 0},
    }

    _attribute_map = {
        'kind': {'key': 'Kind', 'type': 'str'},
        'metric_name': {'key': 'MetricName', 'type': 'str'},
        'lower_load_threshold': {'key': 'LowerLoadThreshold', 'type': 'str'},
        'upper_load_threshold': {'key': 'UpperLoadThreshold', 'type': 'str'},
        'scale_interval_in_seconds': {'key': 'ScaleIntervalInSeconds', 'type': 'long'},
    }

    def __init__(self, *, metric_name: str, lower_load_threshold: str, upper_load_threshold: str, scale_interval_in_seconds: int, **kwargs) -> None:
        super(AverageServiceLoadScalingTrigger, self).__init__(**kwargs)
        self.metric_name = metric_name
        self.lower_load_threshold = lower_load_threshold
        self.upper_load_threshold = upper_load_threshold
        self.scale_interval_in_seconds = scale_interval_in_seconds
        self.kind = 'AverageServiceLoad'
