# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class DomainControlCenterSsoRequest(Model):
    """Single sign-on request information for domain management.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar url: URL where the single sign-on request is to be made.
    :vartype url: str
    :ivar post_parameter_key: Post parameter key.
    :vartype post_parameter_key: str
    :ivar post_parameter_value: Post parameter value. Client should use
     'application/x-www-form-urlencoded' encoding for this value.
    :vartype post_parameter_value: str
    """

    _validation = {
        'url': {'readonly': True},
        'post_parameter_key': {'readonly': True},
        'post_parameter_value': {'readonly': True},
    }

    _attribute_map = {
        'url': {'key': 'url', 'type': 'str'},
        'post_parameter_key': {'key': 'postParameterKey', 'type': 'str'},
        'post_parameter_value': {'key': 'postParameterValue', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(DomainControlCenterSsoRequest, self).__init__(**kwargs)
        self.url = None
        self.post_parameter_key = None
        self.post_parameter_value = None
