# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class ElasticPoolEditionCapability(Model):
    """The elastic pool edition capability.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar name: The elastic pool edition name.
    :vartype name: str
    :ivar supported_elastic_pool_performance_levels: The list of supported
     elastic pool DTU levels for the edition.
    :vartype supported_elastic_pool_performance_levels:
     list[~azure.mgmt.sql.models.ElasticPoolPerformanceLevelCapability]
    :ivar zone_redundant: Whether or not zone redundancy is supported for the
     edition.
    :vartype zone_redundant: bool
    :ivar status: The status of the capability. Possible values include:
     'Visible', 'Available', 'Default', 'Disabled'
    :vartype status: str or ~azure.mgmt.sql.models.CapabilityStatus
    :param reason: The reason for the capability not being available.
    :type reason: str
    """

    _validation = {
        'name': {'readonly': True},
        'supported_elastic_pool_performance_levels': {'readonly': True},
        'zone_redundant': {'readonly': True},
        'status': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'supported_elastic_pool_performance_levels': {'key': 'supportedElasticPoolPerformanceLevels', 'type': '[ElasticPoolPerformanceLevelCapability]'},
        'zone_redundant': {'key': 'zoneRedundant', 'type': 'bool'},
        'status': {'key': 'status', 'type': 'CapabilityStatus'},
        'reason': {'key': 'reason', 'type': 'str'},
    }

    def __init__(self, *, reason: str=None, **kwargs) -> None:
        super(ElasticPoolEditionCapability, self).__init__(**kwargs)
        self.name = None
        self.supported_elastic_pool_performance_levels = None
        self.zone_redundant = None
        self.status = None
        self.reason = reason
