# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

import uuid
from msrest.pipeline import ClientRawResponse
from msrestazure.azure_exceptions import CloudError

from .. import models


class AdvancedThreatProtectionOperations(object):
    """AdvancedThreatProtectionOperations operations.

    :param client: Client for service requests.
    :param config: Configuration of service client.
    :param serializer: An object model serializer.
    :param deserializer: An object model deserializer.
    :ivar api_version: API version for the operation. Constant value: "2017-08-01-preview".
    :ivar setting_name: Advanced Threat Protection setting name. Constant value: "current".
    """

    models = models

    def __init__(self, client, config, serializer, deserializer):

        self._client = client
        self._serialize = serializer
        self._deserialize = deserializer
        self.api_version = "2017-08-01-preview"
        self.setting_name = "current"

        self.config = config

    def get(
            self, resource_id, custom_headers=None, raw=False, **operation_config):
        """Gets the Advanced Threat Protection settings for the specified
        resource.

        :param resource_id: The identifier of the resource.
        :type resource_id: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: AdvancedThreatProtectionSetting or ClientRawResponse if
         raw=true
        :rtype: ~azure.mgmt.security.models.AdvancedThreatProtectionSetting or
         ~msrest.pipeline.ClientRawResponse
        :raises: :class:`CloudError<msrestazure.azure_exceptions.CloudError>`
        """
        # Construct URL
        url = self.get.metadata['url']
        path_format_arguments = {
            'resourceId': self._serialize.url("resource_id", resource_id, 'str'),
            'settingName': self._serialize.url("self.setting_name", self.setting_name, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("self.api_version", self.api_version, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if self.config.generate_client_request_id:
            header_parameters['x-ms-client-request-id'] = str(uuid.uuid1())
        if custom_headers:
            header_parameters.update(custom_headers)
        if self.config.accept_language is not None:
            header_parameters['accept-language'] = self._serialize.header("self.config.accept_language", self.config.accept_language, 'str')

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200]:
            exp = CloudError(response)
            exp.request_id = response.headers.get('x-ms-request-id')
            raise exp

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('AdvancedThreatProtectionSetting', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    get.metadata = {'url': '/{resourceId}/providers/Microsoft.Security/advancedThreatProtectionSettings/{settingName}'}

    def create(
            self, resource_id, is_enabled=None, custom_headers=None, raw=False, **operation_config):
        """Creates or updates the Advanced Threat Protection settings on a
        specified resource.

        :param resource_id: The identifier of the resource.
        :type resource_id: str
        :param is_enabled: Indicates whether Advanced Threat Protection is
         enabled.
        :type is_enabled: bool
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: AdvancedThreatProtectionSetting or ClientRawResponse if
         raw=true
        :rtype: ~azure.mgmt.security.models.AdvancedThreatProtectionSetting or
         ~msrest.pipeline.ClientRawResponse
        :raises: :class:`CloudError<msrestazure.azure_exceptions.CloudError>`
        """
        advanced_threat_protection_setting = models.AdvancedThreatProtectionSetting(is_enabled=is_enabled)

        # Construct URL
        url = self.create.metadata['url']
        path_format_arguments = {
            'resourceId': self._serialize.url("resource_id", resource_id, 'str'),
            'settingName': self._serialize.url("self.setting_name", self.setting_name, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("self.api_version", self.api_version, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        header_parameters['Content-Type'] = 'application/json; charset=utf-8'
        if self.config.generate_client_request_id:
            header_parameters['x-ms-client-request-id'] = str(uuid.uuid1())
        if custom_headers:
            header_parameters.update(custom_headers)
        if self.config.accept_language is not None:
            header_parameters['accept-language'] = self._serialize.header("self.config.accept_language", self.config.accept_language, 'str')

        # Construct body
        body_content = self._serialize.body(advanced_threat_protection_setting, 'AdvancedThreatProtectionSetting')

        # Construct and send request
        request = self._client.put(url, query_parameters, header_parameters, body_content)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200]:
            exp = CloudError(response)
            exp.request_id = response.headers.get('x-ms-request-id')
            raise exp

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('AdvancedThreatProtectionSetting', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    create.metadata = {'url': '/{resourceId}/providers/Microsoft.Security/advancedThreatProtectionSettings/{settingName}'}
