# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class SummarizeResults(Model):
    """Summarize action results.

    :param odatacontext: OData context string; used by OData clients to
     resolve type information based on metadata.
    :type odatacontext: str
    :param odatacount: OData entity count; represents the number of summaries
     returned; always set to 1.
    :type odatacount: int
    :param value: Summarize action results.
    :type value: list[~azure.mgmt.policyinsights.models.Summary]
    """

    _validation = {
        'odatacount': {'maximum': 1, 'minimum': 1},
    }

    _attribute_map = {
        'odatacontext': {'key': '@odata\\.context', 'type': 'str'},
        'odatacount': {'key': '@odata\\.count', 'type': 'int'},
        'value': {'key': 'value', 'type': '[Summary]'},
    }

    def __init__(self, **kwargs):
        super(SummarizeResults, self).__init__(**kwargs)
        self.odatacontext = kwargs.get('odatacontext', None)
        self.odatacount = kwargs.get('odatacount', None)
        self.value = kwargs.get('value', None)
