/*
 * Copyright (C) 2008-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include "config.h"

#include <assert.h>
#include <stdio.h>

#include <gtk/gtk.h>

#include "glue-gui-gtk-switch.h"

typedef struct {
	GtkToggleButtonClass parent_class;

	void (*switched_on) (GuiGtkSwitch *_switch);
	void (*switched_off) (GuiGtkSwitch *_switch);
} GuiGtkSwitchClass;

enum {
	SWITCHED_ON,
	SWITCHED_OFF,
	GUI_GTK_SWITCH_LAST_SIGNAL
};

static guint gui_gtk_switch_signals[GUI_GTK_SWITCH_LAST_SIGNAL] = { 0, 0 };

static void
gui_gtk_switch_class_init(GuiGtkSwitchClass *class)
{
	gui_gtk_switch_signals[SWITCHED_ON] =
		g_signal_new("switched-on",
			G_TYPE_FROM_CLASS(class),
			G_SIGNAL_RUN_FIRST | G_SIGNAL_ACTION, /* FIXME */
			G_STRUCT_OFFSET(GuiGtkSwitchClass, switched_on),
			NULL, NULL,
			g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	gui_gtk_switch_signals[SWITCHED_OFF] =
		g_signal_new("switched-off",
			G_TYPE_FROM_CLASS(class),
			G_SIGNAL_RUN_FIRST | G_SIGNAL_ACTION, /* FIXME */
			G_STRUCT_OFFSET(GuiGtkSwitchClass, switched_off),
			NULL, NULL,
			g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
gui_gtk_toggled_event(GtkWidget *w, void *__switch)
{
	GuiGtkSwitch *_switch = (GuiGtkSwitch *) __switch;

	if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(_switch))) {
		g_signal_emit(G_OBJECT(_switch),
				gui_gtk_switch_signals[SWITCHED_ON], 0);
	} else {
		g_signal_emit(G_OBJECT(_switch),
				gui_gtk_switch_signals[SWITCHED_OFF], 0);
	}
}

static void
gui_gtk_switch_init(GuiGtkSwitch *_switch)
{
	g_signal_connect(G_OBJECT(_switch), "toggled",
			  G_CALLBACK(gui_gtk_toggled_event), _switch);
}

GType
gui_gtk_switch_get_type(void)
{
	static GType ttt_type = 0;

	if (! ttt_type) {
		static const GTypeInfo ttt_info = {
			sizeof(GuiGtkSwitchClass),
			NULL,	/* base_init */
			NULL,	/* base_finalize */
			(GClassInitFunc) gui_gtk_switch_class_init,
			NULL,	/* class_finalize */
			NULL,	/* class_data */
			sizeof(GuiGtkSwitch),
			0,	/* n_preallocs */
			(GInstanceInitFunc) gui_gtk_switch_init,
		};

		ttt_type = g_type_register_static (GTK_TYPE_TOGGLE_BUTTON,
				"Switch", &ttt_info, 0);
	}

	return ttt_type;
}

#define GUIGTKSWITCH_TYPE	gui_gtk_switch_get_type()

GtkWidget *
gui_gtk_switch_new(void)
{
	GtkWidget *_switch;
	GtkWidget *icon;

	_switch = GTK_WIDGET(g_object_new(GUIGTKSWITCH_TYPE, NULL));
	GTK_WIDGET_UNSET_FLAGS(_switch, GTK_CAN_FOCUS);

	gtk_button_set_label(GTK_BUTTON(_switch), "Switch");
	icon = gtk_image_new_from_stock("gtk-yes", GTK_ICON_SIZE_BUTTON);
	gtk_button_set_image(GTK_BUTTON(_switch), icon);

	return GTK_WIDGET(_switch);
}

void
gui_gtk_switch_set(GuiGtkSwitch *_switch, gboolean on)
{
	g_signal_handlers_block_matched(G_OBJECT(_switch),
			G_SIGNAL_MATCH_DATA, 0, 0, NULL, NULL, _switch);

	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(_switch), on);

	g_signal_handlers_unblock_matched(G_OBJECT(_switch),
			G_SIGNAL_MATCH_DATA, 0, 0, NULL, NULL, _switch);
}
