--
-- Copyright (C) 2006-2009 FAUmachine Team <info@faumachine.org>.
-- This program is free software. You can redistribute it and/or modify it
-- under the terms of the GNU General Public License, either version 2 of
-- the License, or (at your option) any later version. See COPYING.
--

-- J.STELZNER
-- IMMD3 LABOR
-- 08.12.2006
-- File: TB_TOP.VHD

LIBRARY ieee;
USE ieee.std_logic_1164.ALL;

ENTITY tb_top_vhd IS
END tb_top_vhd;

ARCHITECTURE behavior OF tb_top_vhd IS 



	SIGNAL PCI_CBEn :  std_logic_vector(3 downto 0);
	SIGNAL PCI_CLOCK :  std_logic;
	SIGNAL PCI_FRAMEn :  std_logic;
	SIGNAL PCI_IDSEL :  std_logic;
	SIGNAL PCI_IRDYn :  std_logic;
	SIGNAL PCI_RSTn :  std_logic;
	SIGNAL PCI_AD :  std_logic_vector(31 downto 0);
	SIGNAL PCI_PAR :  std_logic;
	SIGNAL PCI_DEVSELn :  std_logic;
	SIGNAL PCI_PERRn :  std_logic;
	SIGNAL PCI_SERRn :  std_logic;
	SIGNAL PCI_STOPn :  std_logic;
	SIGNAL PCI_TRDYn :  std_logic;


	signal	GEN_PERROR	: std_logic := '0'; 

	signal	MAS_PARITY	: std_logic := '0'; 



	constant	CLK_PER		:time := 0.030 us;
	constant	BUS_DELAY	:time := 0.022 us;

	constant	CMD_INT_ACK	:std_logic_vector (3 downto 0) := "0000";
	constant	CMD_SP_CYC	:std_logic_vector (3 downto 0) := "0001";
	constant	CMD_IO_READ	:std_logic_vector (3 downto 0) := "0010";
	constant	CMD_IO_WRITE	:std_logic_vector (3 downto 0) := "0011";
	constant	CMD_RES_4	:std_logic_vector (3 downto 0) := "0100";
	constant	CMD_RES_5	:std_logic_vector (3 downto 0) := "0101";
	constant	CMD_MEM_READ	:std_logic_vector (3 downto 0) := "0110";
	constant	CMD_MEM_WRITE	:std_logic_vector (3 downto 0) := "0111";
	constant	CMD_RES_8	:std_logic_vector (3 downto 0) := "1000";
	constant	CMD_RES_9	:std_logic_vector (3 downto 0) := "1001";
	constant	CMD_CONF_READ	:std_logic_vector (3 downto 0) := "1010";
	constant	CMD_CONF_WRITE	:std_logic_vector (3 downto 0) := "1011";
	constant	CMD_MEM_READ_M	:std_logic_vector (3 downto 0) := "1100";
	constant	CMD_DU_ADR_CYC	:std_logic_vector (3 downto 0) := "1101";
	constant	CMD_MEM_READ_L	:std_logic_vector (3 downto 0) := "1110";
	constant	CMD_MEM_WRITE_I	:std_logic_vector (3 downto 0) := "1111";

-------------------------------------------------------------------------------
-- *****************************  PROCEDURE RESET *****************************
-------------------------------------------------------------------------------
	procedure PROC_RESET
	(
	signal		PCI_CLOCK		:in		std_logic;
	signal		PCI_RSTn		:out	std_logic;
	signal		PCI_AD			:out	std_logic_vector(31 downto 0);
	signal		PCI_CBEn		:out	std_logic_vector( 3 downto 0);
	signal		PCI_IDSEL		:out	std_logic;
	signal		PCI_PAR			:out	std_logic;
	signal		PCI_FRAMEn		:out	std_logic;
	signal		PCI_IRDYn		:out	std_logic;
	signal		PCI_PERRn		:out	std_logic

	)
	is 

	begin

		PCI_RSTn	<= '0'				;
		PCI_AD		<= (others =>'Z')	;
		PCI_CBEn	<= (others =>'Z')	;
		PCI_IDSEL	<= 'X'				;
		PCI_PAR		<= 'Z'				;   
		PCI_FRAMEn	<= '1';	
		PCI_IRDYn	<= 'Z'				;
		PCI_PERRn	<= 'Z'				;

		wait on PCI_CLOCK until PCI_CLOCK = '1';
		wait for	BUS_DELAY;

		PCI_RSTn	<= '1';

		wait on PCI_CLOCK until PCI_CLOCK = '1';
		wait for	BUS_DELAY;


	end PROC_RESET;

-------------------------------------------------------------------------------
-- ****************************  PROCEDURE PARITY *****************************
-------------------------------------------------------------------------------
	procedure PROC_PARITY
	(
	signal	GEN_PERROR	:in		std_logic;
	signal	PCI_AD		:in		std_logic_vector(31 downto 0);
	signal	PCI_CBEn	:in		std_logic_vector( 3 downto 0);	
	signal	MAS_PARITY	:inout	std_logic 
	)
	is 

	begin

		MAS_PARITY	<=	PCI_AD( 0) xor PCI_AD( 1) xor PCI_AD( 2) xor PCI_AD( 3) xor
					PCI_AD( 4) xor PCI_AD( 5) xor PCI_AD( 6) xor PCI_AD( 7) xor
					PCI_AD( 8) xor PCI_AD( 9) xor PCI_AD(10) xor PCI_AD(11) xor
					PCI_AD(12) xor PCI_AD(13) xor PCI_AD(14) xor PCI_AD(15) xor
					PCI_AD(16) xor PCI_AD(17) xor PCI_AD(18) xor PCI_AD(19) xor
					PCI_AD(20) xor PCI_AD(21) xor PCI_AD(22) xor PCI_AD(23) xor
					PCI_AD(24) xor PCI_AD(25) xor PCI_AD(26) xor PCI_AD(27) xor
					PCI_AD(28) xor PCI_AD(29) xor PCI_AD(30) xor PCI_AD(31) xor
					PCI_CBEn( 0) xor PCI_CBEn( 1) xor PCI_CBEn( 2) xor PCI_CBEn( 3)
					xor GEN_PERROR;

	end PROC_PARITY;



-------------------------------------------------------------------------------
-- *************************  PROCEDURE CONFIG WRITE **************************
-------------------------------------------------------------------------------
	procedure PROC_PCI_CONF_WR
	(
	variable	PCI_ADR			:inout	std_logic_vector(31 downto 0);
	variable	PCI_W_DATA		:inout	std_logic_vector(31 downto 0);
	variable	PCI_BEn			:inout	std_logic_vector( 3 downto 0);

	signal		PCI_CLOCK		:in		std_logic;

	signal		PCI_AD			:inout	std_logic_vector(31 downto 0);
	signal		PCI_CBEn		:inout	std_logic_vector( 3 downto 0);

	signal		PCI_IDSEL		:out	std_logic;

	signal		PCI_PAR			:inout	std_logic;
	signal		PCI_FRAMEn		:out	std_logic;
	signal		PCI_IRDYn		:out	std_logic;

	signal		MAS_PARITY		:inout		std_logic
	)
	is

	begin


-- 1. cycle
-- address-phase

		wait on PCI_CLOCK until PCI_CLOCK = '1';
		wait for	BUS_DELAY;

		PCI_AD		<= PCI_ADR ;-- ADDRESS
		PCI_CBEn	<= CMD_CONF_WRITE ; 
		PCI_IDSEL	<= '1' ;
		PCI_FRAMEn	<= '0' ;
		PCI_IRDYn	<= '1' ;	
		PCI_PAR 	<= 'Z' ;

 
-- 2. cycle
-- data-phase

		wait on PCI_CLOCK until PCI_CLOCK = '1';

		PROC_PARITY
		(GEN_PERROR,PCI_AD, PCI_CBEn, MAS_PARITY );-- ADDRESS

		wait for BUS_DELAY;

		PCI_AD		<= PCI_W_DATA ;-- DATA-1
		PCI_CBEn	<= PCI_BEn ; 
		PCI_IDSEL	<= 'X' ;
		PCI_FRAMEn	<= '1' ;
		PCI_IRDYn	<= '0' ;	
		PCI_PAR 	<= MAS_PARITY ;-- ADDRESS


-- 3. cycle
-- end-phaes

		loop

		wait on PCI_CLOCK until PCI_CLOCK = '1';

		PROC_PARITY
		(GEN_PERROR,PCI_AD, PCI_CBEn, MAS_PARITY );-- DATA-1

		wait for BUS_DELAY;

		if PCI_TRDYn = '0' then  

		PCI_AD		<= (others =>'Z');
		PCI_CBEn	<= (others =>'Z'); 
		PCI_IDSEL	<= 'X' ;
		PCI_FRAMEn	<= '1' ;
		PCI_IRDYn	<= '1' ;	
		PCI_PAR 	<= MAS_PARITY ;-- DATA-1

		exit;

		elsif PCI_TRDYn = '1' then 

		PCI_AD		<= PCI_W_DATA ;-- DATA-1
		PCI_CBEn	<= PCI_BEn ; 
		PCI_IDSEL	<= 'X' ;
		PCI_FRAMEn	<= '1' ;
		PCI_IRDYn	<= '0' ;	
		PCI_PAR 	<= MAS_PARITY ;-- DATA_1
		
		end if;

		end loop;


-- 4. cycle
-- tri-state-phaes

		wait on PCI_CLOCK until PCI_CLOCK = '1' and PCI_TRDYn = '0';--!!!!!!;
		wait for BUS_DELAY;

		PCI_AD		<= (others =>'Z')	;
		PCI_CBEn	<= (others =>'Z')	;
		PCI_IDSEL	<= 'X'				;
		PCI_FRAMEn	<= '1';	
		PCI_IRDYn	<= 'Z'				;
		PCI_PAR		<= 'Z'				;   

--		wait until  (PCI_CLOCK'event and PCI_CLOCK = '1');
--		wait for BUS_DELAY;


	END PROC_PCI_CONF_WR ;

-------------------------------------------------------------------------------
-- *************************  PROCEDURE CONFIG READ ***************************
-------------------------------------------------------------------------------
	procedure PROC_PCI_CONF_RD
	(
	variable	PCI_ADR			:inout	std_logic_vector(31 downto 0);
	variable	PCI_R_DATA		:inout	std_logic_vector(31 downto 0);
	variable	PCI_BEn			:inout	std_logic_vector( 3 downto 0);

	signal		PCI_CLOCK		:in		std_logic;

	signal		PCI_AD			:inout	std_logic_vector(31 downto 0);
	signal		PCI_CBEn		:inout	std_logic_vector( 3 downto 0);

	signal		PCI_IDSEL		:out	std_logic;

	signal		PCI_PAR			:inout	std_logic;
	signal		PCI_FRAMEn		:out	std_logic;
	signal		PCI_IRDYn		:out	std_logic;

	signal		MAS_PARITY		:inout		std_logic
	)
	is

	begin



-- 1. cycle
-- address-phase

		wait on PCI_CLOCK until PCI_CLOCK = '1';
		wait for	BUS_DELAY;

		PCI_AD		<= PCI_ADR ;-- ADDRESS
		PCI_CBEn	<= CMD_CONF_READ ; 
		PCI_IDSEL	<= '1' ;
		PCI_FRAMEn	<= '0' ;
		PCI_IRDYn	<= '1' ;
		PCI_PAR 	<= 'Z' ;	
 
-- 2. cycle
-- turn around

		wait on PCI_CLOCK until PCI_CLOCK = '1';

		PROC_PARITY
		(GEN_PERROR,PCI_AD, PCI_CBEn, MAS_PARITY );-- von ADDRESS

		wait for BUS_DELAY;

		PCI_AD		<= (others =>'Z') ;
		PCI_CBEn	<= PCI_BEn ; 
		PCI_IDSEL	<= 'X' ;
		PCI_FRAMEn	<= '1' ;
		PCI_IRDYn	<= '0' ;
		PCI_PAR 	<= MAS_PARITY ;	

-- 3. cycle
-- read-phaes

		wait on PCI_CLOCK until PCI_CLOCK = '1';
		wait for BUS_DELAY;

		PCI_AD		<= (others =>'Z') ;
		PCI_CBEn	<= PCI_BEn ; 
		PCI_IDSEL	<= 'X' ;
		PCI_FRAMEn	<= '1' ;
		PCI_IRDYn	<= '0' ;	
		PCI_PAR		<= 'Z' ;

-- 4. cycle
-- end-phaes

		wait on PCI_CLOCK until PCI_CLOCK = '1'and PCI_TRDYn = '0';-- !!!!!!!!

		PCI_R_DATA	:= PCI_AD ;-- DATA-1

		wait for BUS_DELAY;

		PCI_AD		<= (others =>'Z');
		PCI_CBEn	<= (others =>'Z'); 
		PCI_IDSEL	<= 'X' ;
		PCI_FRAMEn	<= '1' ;
		PCI_IRDYn	<= '1' ;	
		PCI_PAR		<= 'Z' ;

-- 5. cycle
-- tri-state-phaes

		wait on PCI_CLOCK until PCI_CLOCK = '1';
		wait for BUS_DELAY;

		PCI_AD		<= (others =>'Z');
		PCI_CBEn	<= (others =>'Z');
		PCI_IDSEL	<= 'X'	;
		PCI_FRAMEn	<= '1'	;	
		PCI_IRDYn	<= 'Z'	;
		PCI_PAR		<= 'Z'	;

	
--		wait until  (PCI_CLOCK'event and PCI_CLOCK = '1');
--		wait for BUS_DELAY;

	END PROC_PCI_CONF_RD ;




-------------------------------------------------------------------------------
-- **************************  PROCEDURE IO WRITE *****************************
-------------------------------------------------------------------------------
	procedure PROC_PCI_IO_WR
	(
	variable	PCI_ADR			:inout	std_logic_vector(31 downto 0);
	variable	PCI_W_DATA		:inout	std_logic_vector(31 downto 0);
	variable	PCI_BEn			:inout	std_logic_vector( 3 downto 0);

	signal		PCI_CLOCK		:in	std_logic;

	signal		PCI_AD			:inout	std_logic_vector(31 downto 0);
	signal		PCI_CBEn		:inout	std_logic_vector( 3 downto 0);

	signal		PCI_IDSEL		:out	std_logic;

	signal		PCI_PAR			:inout	std_logic;
	signal		PCI_FRAMEn		:out	std_logic;
	signal		PCI_IRDYn		:out	std_logic;

	signal		MAS_PARITY		:inout	std_logic
	)
	is

	begin


-- 1. cycle
-- address-phase

		wait on PCI_CLOCK until PCI_CLOCK = '1';
		wait for	BUS_DELAY;

		PCI_AD		<= PCI_ADR ;-- ADDRESS
		PCI_CBEn	<= CMD_IO_WRITE ; 
		PCI_IDSEL	<= 'X' ;
		PCI_FRAMEn	<= '0' ;
		PCI_IRDYn	<= '1' ;	
		PCI_PAR 	<= 'Z' ;

 
-- 2. cycle
-- data-phase

		wait on PCI_CLOCK until PCI_CLOCK = '1';

		PROC_PARITY
		(GEN_PERROR,PCI_AD, PCI_CBEn, MAS_PARITY );-- ADDRESS

		wait for BUS_DELAY;

		PCI_AD		<= PCI_W_DATA ;-- DATA-1
		PCI_CBEn	<= PCI_BEn ; 
		PCI_IDSEL	<= 'X' ;
		PCI_FRAMEn	<= '1' ;
		PCI_IRDYn	<= '0' ;	
		PCI_PAR 	<= MAS_PARITY ;-- ADDRESS


-- 3. cycle
-- end-phaes

		loop

		wait on PCI_CLOCK until PCI_CLOCK = '1';

		PROC_PARITY
		(GEN_PERROR,PCI_AD, PCI_CBEn, MAS_PARITY );-- DATA-1

		wait for BUS_DELAY;

		if PCI_TRDYn = '0' then  

		PCI_AD		<= (others =>'Z');
		PCI_CBEn	<= (others =>'Z'); 
		PCI_IDSEL	<= 'X' ;
		PCI_FRAMEn	<= '1' ;
		PCI_IRDYn	<= '1' ;	
		PCI_PAR 	<= MAS_PARITY ;-- DATA-1

		exit;

		elsif PCI_TRDYn = '1' then 

		PCI_AD		<= PCI_W_DATA ;-- DATA-1
		PCI_CBEn	<= PCI_BEn ; 
		PCI_IDSEL	<= 'X' ;
		PCI_FRAMEn	<= '1' ;
		PCI_IRDYn	<= '0' ;	
		PCI_PAR 	<= MAS_PARITY ;-- DATA_1
		
		end if;

		end loop;


-- 4. cycle
-- tri-state-phaes

		wait on PCI_CLOCK until PCI_CLOCK = '1' and PCI_TRDYn = '0';--!!!!!!;
		wait for BUS_DELAY;

		PCI_AD		<= (others =>'Z');
		PCI_CBEn	<= (others =>'Z');
		PCI_IDSEL	<= 'X';
		PCI_FRAMEn	<= '1';	
		PCI_IRDYn	<= 'Z';
		PCI_PAR		<= 'Z';   

--		wait until  (PCI_CLOCK'event and PCI_CLOCK = '1');
--		wait for BUS_DELAY;


	END PROC_PCI_IO_WR ;




-------------------------------------------------------------------------------
-- *************************  PROCEDURE IO READ *******************************
-------------------------------------------------------------------------------
	procedure PROC_PCI_IO_RD
	(
	variable	PCI_ADR			:inout	std_logic_vector(31 downto 0);
	variable	PCI_R_DATA		:inout	std_logic_vector(31 downto 0);
	variable	PCI_BEn			:inout	std_logic_vector( 3 downto 0);

	signal		PCI_CLOCK		:in	std_logic;

	signal		PCI_AD			:inout	std_logic_vector(31 downto 0);
	signal		PCI_CBEn		:inout	std_logic_vector( 3 downto 0);

	signal		PCI_IDSEL		:out	std_logic;

	signal		PCI_PAR			:inout	std_logic;
	signal		PCI_FRAMEn		:out	std_logic;
	signal		PCI_IRDYn		:out	std_logic;

	signal		MAS_PARITY		:inout	std_logic
	)
	is

	begin



-- 1. cycle
-- address-phase

		wait on PCI_CLOCK until PCI_CLOCK = '1';
		wait for	BUS_DELAY;

		PCI_AD		<= PCI_ADR ;-- ADDRESS
		PCI_CBEn	<= CMD_IO_READ ; 
		PCI_IDSEL	<= 'X' ;
		PCI_FRAMEn	<= '0' ;
		PCI_IRDYn	<= '1' ;
		PCI_PAR 	<= 'Z' ;	
 
-- 2. cycle
-- turn around

		wait on PCI_CLOCK until PCI_CLOCK = '1';

		PROC_PARITY
		(GEN_PERROR,PCI_AD, PCI_CBEn, MAS_PARITY );-- von ADDRESS

		wait for BUS_DELAY;

		PCI_AD		<= (others =>'Z') ;
		PCI_CBEn	<= PCI_BEn ; 
		PCI_IDSEL	<= 'X' ;
		PCI_FRAMEn	<= '1' ;
		PCI_IRDYn	<= '0' ;
		PCI_PAR 	<= MAS_PARITY ;	

-- 3. cycle
-- read-phaes

		wait on PCI_CLOCK until PCI_CLOCK = '1'; 
		wait for BUS_DELAY;

		PCI_AD		<= (others =>'Z') ;
		PCI_CBEn	<= PCI_BEn ; 
		PCI_IDSEL	<= 'X' ;
		PCI_FRAMEn	<= '1' ;
		PCI_IRDYn	<= '0' ;	
		PCI_PAR		<= 'Z' ;

-- 4. cycle
-- end-phaes

	loop

		wait on PCI_CLOCK until PCI_CLOCK = '1';

		if PCI_DEVSELn = 'H' or PCI_DEVSELn = '1' then 

		assert false
		report		" KEIN PCI_DEVSELn "
		severity	Error;

		exit; -- loop

		end if;
 
		if PCI_TRDYn = '0' then

		PCI_R_DATA	:= PCI_AD ;-- DATA-1

		wait for BUS_DELAY;




		PCI_AD		<= (others =>'Z');
		PCI_CBEn	<= (others =>'Z'); 
		PCI_IDSEL	<= 'X' ;
		PCI_FRAMEn	<= '1' ;
		PCI_IRDYn	<= '1' ;	
		PCI_PAR		<= 'Z' ;

--		PCI_R_DATA	:= PCI_AD ;-- DATA-1

		exit; -- loop
		end if;

 	end loop;

-- 5. cycle
-- tri-state-phaes

		wait on PCI_CLOCK until PCI_CLOCK = '1';
		wait for BUS_DELAY;

		PCI_AD		<= (others =>'Z');
		PCI_CBEn	<= (others =>'Z');
		PCI_IDSEL	<= 'X'	;
		PCI_FRAMEn	<= '1';	
		PCI_IRDYn	<= 'Z'	;
		PCI_PAR		<= 'Z'	;

	
--		wait until  (PCI_CLOCK'event and PCI_CLOCK = '1');
--		wait for BUS_DELAY;

	END PROC_PCI_IO_RD ;

BEGIN
	c : pcicard PORT MAP (
		irdy_n => PCI_IRDYn,
		cbe_n_0 => PCI_CBEn(0),
		cbe_n_1 => PCI_CBEn(1),
		cbe_n_2 => PCI_CBEn(2),
		cbe_n_3 => PCI_CBEn(3),
		ad_0 => PCI_AD(0),
		ad_1 => PCI_AD(1),
		ad_2 => PCI_AD(2),
		ad_3 => PCI_AD(3),
		ad_4 => PCI_AD(4),
		ad_5 => PCI_AD(5),
		ad_6 => PCI_AD(6),
		ad_7 => PCI_AD(7),
		ad_8 => PCI_AD(8),
		ad_9 => PCI_AD(9),
		ad_10 => PCI_AD(10),
		ad_11 => PCI_AD(11),
		ad_12 => PCI_AD(12),
		ad_13 => PCI_AD(13),
		ad_14 => PCI_AD(14),
		ad_15 => PCI_AD(15),
		ad_16 => PCI_AD(16),
		ad_17 => PCI_AD(17),
		ad_18 => PCI_AD(18),
		ad_19 => PCI_AD(19),
		ad_20 => PCI_AD(20),
		ad_21 => PCI_AD(21),
		ad_22 => PCI_AD(22),
		ad_23 => PCI_AD(23),
		ad_24 => PCI_AD(24),
		ad_25 => PCI_AD(25),
		ad_26 => PCI_AD(26),
		ad_27 => PCI_AD(27),
		ad_28 => PCI_AD(28),
		ad_29 => PCI_AD(29),
		ad_30 => PCI_AD(30),
		ad_31 => PCI_AD(31),
		par => PCI_PAR,
		frame_n => PCI_FRAMEn,
		trdy_n => PCI_TRDYn,
		devsel_n => PCI_DEVSELn,
		idsel => PCI_IDSEL,
		clk => PCI_CLOCK,
		rst_n => PCI_RSTn);


-------------------------------------------------------------------------------
-- ************************** PROCESS PCI-CLOCK *******************************
-------------------------------------------------------------------------------
	process
	begin
		PCI_CLOCK	<=	'0';
		wait for ( CLK_PER / 2) ;
		PCI_CLOCK	<=	'1';
		wait for ( CLK_PER / 2) ;	 
	end process;

-------------------------------------------------------------------------------
-- *********************** PROCESS PCI-BUS PULL-UP ****************************
-------------------------------------------------------------------------------
	process
	begin

	PCI_AD		<= (others=>'H');
	PCI_CBEn	<= (others=>'H');
	PCI_PAR		<= 'H';

	PCI_FRAMEn	<= 'H';
	PCI_IRDYn	<= 'H';
	PCI_TRDYn	<= 'H';
	PCI_STOPn	<= 'H';
	PCI_DEVSELn	<= 'H';

--PCI_LOCKn		<= 'H';

	PCI_PERRn	<= 'H';
	PCI_SERRn	<= 'H';

--PCI_INTAn		<= 'H';		
--PCI_INTBn		<= 'H';		
--PCI_INTCn		<= 'H';		
--PCI_INTDn		<= 'H';		

	wait for ( CLK_PER ) ;
 
	end process;


-------------------------------------------------------------------------------
-- ************************** PROCESS ERROR TEST ******************************
-------------------------------------------------------------------------------
	process
	begin

	wait until PCI_RSTn = '1';

	loop

		wait on PCI_CLOCK until PCI_CLOCK = '1';
		wait for BUS_DELAY;
	
		assert		PCI_SERRn	=	'1'	
			or	PCI_SERRn	=	'H'
		report		" PCI_SERRn "
		severity	Error;

		assert		PCI_PERRn	=	'H'	
			or	PCI_PERRn	=	'1'
		report		" PCI_PERRn "
		severity	Error;

	end loop;

	end process;

-------------------------------------------------------------------------------
-- *************************** PROCESS PCI-MASTER *****************************
-------------------------------------------------------------------------------


	process

	variable	PCI_ADR		:std_logic_vector(31 downto 0);
	variable	PCI_W_DATA	:std_logic_vector(31 downto 0);
	variable	PCI_R_DATA	:std_logic_vector(31 downto 0);
	variable	PCI_BEn		:std_logic_vector( 3 downto 0);


	begin

	GEN_PERROR			<= '0';

---------------------------------------
-- *** CALL PROCEDURE     RESET ******* 
---------------------------------------

	PROC_RESET
	(
	PCI_CLOCK, PCI_RSTn, PCI_AD, PCI_CBEn, PCI_IDSEL, PCI_PAR,
	PCI_FRAMEn , PCI_IRDYn, PCI_PERRn
	);

---------------------------------------
-- *** CALL PROCEDURE   CONFIG-READ *** 
---------------------------------------

	PCI_ADR		:= X"00000000" ;
	PCI_BEn		:= "0000" ;

	PROC_PCI_CONF_RD
	(
	PCI_ADR, PCI_R_DATA, PCI_BEn, PCI_CLOCK, PCI_AD, PCI_CBEn,
	PCI_IDSEL, PCI_PAR, PCI_FRAMEn,	PCI_IRDYn,   MAS_PARITY
	);


---------------------------------------
--*** CALL PROCEDURE   CONFIG-WRITE *** 
---------------------------------------

--	set enable parity-check , PCI_SERRn , IO SPACE
--	im command register
 
	PCI_ADR			:= X"00000004";
	PCI_BEn			:= "0000";

	PCI_W_DATA	:= X"FFFF0141";

	PROC_PCI_CONF_WR
	(
	PCI_ADR, PCI_W_DATA, PCI_BEn, PCI_CLOCK, PCI_AD, PCI_CBEn, 
	PCI_IDSEL, PCI_PAR, PCI_FRAMEn, PCI_IRDYn, MAS_PARITY
	);

---------------------------------------
--*** CALL PROCEDURE   CONFIG-WRITE *** 
---------------------------------------

--	set base-addr-reg
 
	PCI_ADR			:= X"00000010";
	PCI_BEn			:= "0000";

	PCI_W_DATA	:= X"00000300";


	PROC_PCI_CONF_WR
	(
	PCI_ADR, PCI_W_DATA, PCI_BEn, PCI_CLOCK, PCI_AD, PCI_CBEn, 
	PCI_IDSEL, PCI_PAR, PCI_FRAMEn, PCI_IRDYn, MAS_PARITY
	);

---------------------------------------
-- *** CALL PROCEDURE   CONFIG-READ *** 
---------------------------------------

--	test base-addr-reg

	PCI_ADR		:= X"00000010" ;
	PCI_BEn		:= "0000" ;

	PROC_PCI_CONF_RD

	(
	PCI_ADR, PCI_R_DATA, PCI_BEn, PCI_CLOCK, PCI_AD, PCI_CBEn,
	PCI_IDSEL, PCI_PAR, PCI_FRAMEn,	PCI_IRDYn,   MAS_PARITY
	);

		
		assert		PCI_R_DATA(0) = '1'
			and	PCI_R_DATA(1) = '0'
			and 	PCI_R_DATA(2) = '0'
			and 	PCI_R_DATA(3) = '0'

			and 	PCI_R_DATA(4) = '0'
			and 	PCI_R_DATA(5) = '0'
			and 	PCI_R_DATA(6) = '0'
			and 	PCI_R_DATA(7) = '0'

			and 	PCI_R_DATA(8) = '1'
			and 	PCI_R_DATA(9) = '1'
			and 	PCI_R_DATA(10) = '0'
			and 	PCI_R_DATA(11) = '0'

			and 	PCI_R_DATA(12) = '0'
			and 	PCI_R_DATA(13) = '0'
			and 	PCI_R_DATA(14) = '0'
			and 	PCI_R_DATA(15) = '0'

			and 	PCI_R_DATA(16) = '0'
			and 	PCI_R_DATA(17) = '0'
			and 	PCI_R_DATA(18) = '0'
			and 	PCI_R_DATA(19) = '0'

			and 	PCI_R_DATA(20) = '0'
			and 	PCI_R_DATA(21) = '0'
			and 	PCI_R_DATA(22) = '0'
			and 	PCI_R_DATA(23) = '0'

			and 	PCI_R_DATA(24) = '0'
			and 	PCI_R_DATA(25) = '0'
			and 	PCI_R_DATA(26) = '0'
			and 	PCI_R_DATA(27) = '0'

			and 	PCI_R_DATA(28) = '0'
			and 	PCI_R_DATA(29) = '0'
			and 	PCI_R_DATA(30) = '0'
			and 	PCI_R_DATA(31) = '0'
		report		" FEHLER CONFIG.SPACE HEADER HEX 10 "
		severity	Error;


---------------------------------------
--***** CALL PROCEDURE   IO-WRITE ***** 
---------------------------------------

	PCI_ADR			:= X"00000300";
	PCI_BEn			:= "1100";

	PCI_W_DATA	:= X"00000001";


	PROC_PCI_IO_WR
	(
	PCI_ADR, PCI_W_DATA, PCI_BEn, PCI_CLOCK, PCI_AD, PCI_CBEn, 
	PCI_IDSEL, PCI_PAR, PCI_FRAMEn, PCI_IRDYn, MAS_PARITY
	);

	PCI_ADR			:= X"00000300";
	PCI_BEn			:= "1100";

	PROC_PCI_IO_RD
	(
	PCI_ADR, PCI_R_DATA, PCI_BEn, PCI_CLOCK, PCI_AD, PCI_CBEn, 
	PCI_IDSEL, PCI_PAR, PCI_FRAMEn, PCI_IRDYn, MAS_PARITY
	);

	assert		PCI_R_DATA(0) = '1'
		and 	PCI_R_DATA(1) = '0'
		and 	PCI_R_DATA(2) = '0'
		and 	PCI_R_DATA(3) = '0'
		and 	PCI_R_DATA(4) = '0'
		and 	PCI_R_DATA(5) = '0'
		and 	PCI_R_DATA(6) = '0'
		and 	PCI_R_DATA(7) = '0'
		and 	PCI_R_DATA(8) = '0'
		and 	PCI_R_DATA(9) = '0'
		and 	PCI_R_DATA(10) = '0'
		and 	PCI_R_DATA(11) = '0'
		and 	PCI_R_DATA(12) = '0'
		and 	PCI_R_DATA(13) = '0'
		and 	PCI_R_DATA(14) = '0'
		and 	PCI_R_DATA(15) = '0'
		report "IOR register error"
		severity failure;

--******************************************************************
		assert false
		report		" TEST-END TEST-END TEST-END "
		severity	Error;
		wait;
--******************************************************************
 end process;

END;
