/*
 * Copyright (C) 2013 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

/*
 * NOTE:
 * Keep in sync with other ?ata_disk_template_gui_gtk.c!
 */

#include <assert.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <gtk/gtk.h>

#include "system.h"
#include "glue-gui.h"
#include "glue-gui-gtk.h"
#include "glue-gui-gtk-fi.h"
#include "glue.h"

#include "sig_boolean.h"
#include "sig_integer.h"

#define NAME		core
#define NAME_(x)	core_ ## x
#define SNAME		"core"
#include "arch_ata_disk_gui_gtk.c"
#undef NAME
#undef NAME_
#undef SNAME

void *
COMP_(gui_gtk_create)(
        unsigned int page,
        const char *name,
        const char *image,
#ifndef CYLINDERS
        const char *cylinders,
        const char *heads,
        const char *sectors,
        const char *size,
#endif
        struct sig_manage *port_manage,
        struct sig_molex_ide_power_conn *port_power,
        struct sig_sata_bus *port_sata
)
{
	unsigned long nblks;

#ifndef CYLINDERS
        if (! size) size = "2047";

        nblks = strtoul(size, NULL, 0) * (1024*1024) / 512;
#else
        nblks = LINEAR;
#endif

	return core_gui_gtk_create(page, name, nblks, port_manage);
}

void
COMP_(gui_gtk_destroy)(void *_cpssp)
{
        core_gui_gtk_destroy(_cpssp);
}

void
COMP_(gui_gtk_suspend)(void *_cpssp, FILE *fp)
{
        core_gui_gtk_suspend(_cpssp, fp);
}

void
COMP_(gui_gtk_resume)(void *_cpssp, FILE *fp)
{
	core_gui_gtk_resume(_cpssp, fp);
}
