package main

import (
	"fmt"
	"github.com/godbus/dbus"
	"github.com/godbus/dbus/introspect"
	. "pkg.deepin.io/daemon/sync/infrastructure/log"
)

const (
	DBusName = "com.deepin.sync.Helper"
	DBusPath = "/com/deepin/sync/Helper"
	DBusIFC  = "com.deepin.sync.Helper"
)

type Helper struct {
	conn *dbus.Conn
}

func main() {
	helper, err := newHelper()
	if err != nil {
		Logger.Fatal("Failed to new helper:", err)
		return
	}

	err = helper.setupDBus()
	if err != nil {
		Logger.Fatal("Failed to register dbus name:", err)
		return
	}

	select {}
}

func newHelper() (*Helper, error) {
	conn, err := dbus.SystemBus()
	if err != nil {
		return nil, err
	}
	return &Helper{
		conn: conn,
	}, nil
}

func (helper *Helper) setupDBus() error {
	err := helper.conn.Export(helper, DBusPath, DBusIFC)
	if err != nil {
		Logger.Error("Failed to export dbus object:", err)
		return err
	}

	node := &introspect.Node{
		Name: DBusName,
		Interfaces: []introspect.Interface{
			introspect.IntrospectData,
			{
				Name:    DBusName,
				Methods: introspect.Methods(helper),
			},
		},
	}
	err = helper.conn.Export(introspect.NewIntrospectable(node), DBusPath,
		"org.freedesktop.DBus.Introspectable")
	if err != nil {
		Logger.Error("Failed to introspecte:", err)
		return err
	}
	reply, err := helper.conn.RequestName(DBusName, dbus.NameFlagDoNotQueue)
	if err != nil {
		Logger.Error("Failed to request dbus name:", err)
		return err
	}
	if reply != dbus.RequestNameReplyPrimaryOwner {
		err := fmt.Errorf("name %q already obtain:", DBusName)
		return err
	}

	return nil
}
