if (typeof T === 'undefined') require('../setup');

T('toBinary', function () {

  var t = function (expected, n, sd, rm) {
    Decimal.precision = sd;
    Decimal.rounding = rm;
    T.assertEqual(expected, new Decimal(n).toBinary());
  }

  Decimal.config({
    toExpNeg: -9e15,
    toExpPos: 9e15,
    minE: -9e15,
    maxE: 9e15
  });

  t('NaN', NaN, 20, 4);
  t('NaN', 'NaN', 20, 4);
  t('Infinity', Infinity, 20, 4);
  t('-Infinity', -Infinity, 20, 4);
  t('Infinity', 'Infinity', 20, 4);
  t('-Infinity', '-Infinity', 20, 4);

  // Integers

  t('0b11111111111111111111111111111111', '4294967295', 32, 4);
  t('0b100000000000000000000000000000000', '4294967296', 33, 4);
  t('0b100000000000000000000000000000001', '4294967297', 33, 4);
  t('-0b11111111111111111111111111111111', '-4294967295', 32, 4);
  t('-0b100000000000000000000000000000000', '-4294967296', 33, 4);
  t('-0b100000000000000000000000000000001', '-4294967297', 33, 4);
  t('0b0', '0', 1, 4);
  t('0b1101000100001000000110100100011100000101001', '7182272837673', 43, 4);
  t('0b1100', '12', 4, 4);
  t('0b101001110010100101010011101100111001101001100111101111111000101011011111000010011111', '12630360807685587318206623', 84, 4);
  t('0b11111001010110010000011011010110111010011011110010100101011010010000111011110110011011011100001110000001110010101000001101', '5178750376444939350710857550952606221', 122, 4);
  t('0b100110', '38', 6, 4);
  t('0b101010011010001001110001110111110010010100011100110100001101101110100100001101001', '1602153026925525548353641', 81, 4);
  t('0b100100101111011101011001111110000010001001100010101110000010010011111100100011110010001010000110100000010111011111110', '95386528077312833528510117745536766', 117, 4);
  t('0b111111101111110011111000011001110101001101110000000011000', '143545575800234008', 57, 4);
  t('0b111011100110001111100001101100100100', '63992372004', 36, 4);
  t('0b101111111110', '3070', 12, 4);
  t('0b1010001000100010110011010000100001000001111010001100001000000001011001110100101110101000001010001110101011100111111100100001010010110010000011001000110101100011100000110001', '3791391092894496185657389426598978260806574313715761', 172, 4);
  t('0b11011011001101101111100101010011000101000100', '15064322355524', 44, 4);
  t('0b10000010110111110100000101001001001011110100001100011111011011000110110011100000000101101', '316429297174908011263148077', 89, 4);
  t('0b10010111000101010011011101101001010010011100110100111100001', '340208393737103841', 59, 4);
  t('0b111111100100110000000000001000101001001001101101011000001011100001010001100110111110010111111101000100000010001001111000111011111000100101000100000100000001111100011011101011101000', '1522300117779563676992926268294212750701795813499189992', 180, 4);
  t('0b111111000111011011001001111100100111', '67770294055', 36, 4);
  t('0b100110111011000001111100110000100110011010001010000000100000011101101011110100000100010110011101001000010000100101010101010011111010110100011101', '13562459849657731179062132755251654390951197', 144, 4);
  t('0b101100010010', '2834', 12, 4);
  t('0b1111111011110011111100001011100110001010100001111100110011010001101011000001000000001100000011101000111101100011000110111111110111111111111111010101011', '2842819740151363791267849959009928040708832939', 151, 4);
  t('0b100110100000100110110110010101000101011000001100010101011110100101000010101001100000001110111010100101010010', '195266285040805814110355923380562', 108, 4);
  t('0b11111101111011111000010011100001100110110110000101100', '8934565388446764', 53, 4);
  t('0b111101011111010111100011011101010001111100010010110111101111010111011010000', '36297363457553334775504', 75, 4);
  t('0b1010111000111110100011011011100101010011110000101011000000010000010011101001010001111101111001110000010100010000111100100110001011001011110010100010111010010010100', '7958075089772384277251993017934409136873707500692', 163, 4);
  t('0b11101000111010011101011001100100101001110111101110110100011001011111101111100100111011111100010011101111001010001100', '75584728662217792152893436906631820', 116, 4);
  t('0b10011010111100000001000010101000111000100111', '10647241395751', 44, 4);
  t('0b1101001000000100000001010101100110000010101111011111001011110100000010011011101011110011000111101001111001101110110011000101001101100111011111111111011001111010000000000', '613876598207563084074184752663166261629198587982848', 169, 4);
  t('0b1000100010101010011110010010110101110000011100110', '300531517677798', 49, 4);
  t('0b10100001111011110000000110100110101010010101001001111011110000101000110111000010000000100010111011', '200464110595405607835630307515', 98, 4);
  t('0b101001100001010001110111111101100110001101100111011011101110000011111111011100', '196072603810916493443036', 78, 4);
  t('0b111000100110111111111101111111100010111000011111110101000111011000110010110000100100010110010100101000101000111100010011110101010011101110011011100', '157803884622143105853315584471057717069995228', 147, 4);
  t('0b110110010011000000100001111100110101001101010111100100111001000111000001011100011001111011010100100000010100101101110000110010', '72173098483072489213930426080106306610', 126, 4);
  t('0b11010011001001100111100101011100111011011110100100', '928648793405348', 50, 4);
  t('0b10110011010100010000101111100010111', '24067464983', 35, 4);
  t('0b1011010001011000101010000000000110111101010000111101010101000011001110001001011101011100001101101110011011110101101010011000100110101111', '61368670450547755504412274420309228620207', 136, 4);
  t('0b1000011111100010111001111100000100000000111001111111100100011100110101001010011010100111110100101001000100101000100010100000001100111001001101001110011111100000000111001010010111', '203364476148734435560803274724374642023080004086166167', 178, 4);
  t('0b11011010100100111010010', '7162322', 23, 4);
  t('0b10000100100110110001000101100111011100111010011011001101110010111100101111001001100001', '40077624010777577544413793', 86, 4);
  t('0b111', '7', 3, 4);
  t('0b100100011011111000010110101011000000011101100010001110110111', '656366019324289975', 60, 4);
  t('0b1100', '12', 4, 4);
  t('0b100001010110000111111010000011000100111100000100011111011011010010110110010010100101001100001101', '41279952929416973510169481997', 96, 4);
  t('0b10101010101111010010000111011111110100001010110000111101100', '384469593819013612', 59, 4);
  t('0b101100000001000100101100001000111011100010100111001101110011001101100111001001001011010010110010111010011111110100110100110101100001001101110100011100000100011', '502582666714640400473511879468920658557790730275', 159, 4);
  t('0b1000101011', '555', 10, 4);
  t('0b101011100101101001010111111110010111011010010100010100110101000001001101111111111111010111000110111010001010101100101101111001110111001101000010101110001010111011010', '31852131995136650015824448712052459356282756208090', 165, 4);
  t('0b11010011110000101001111110011100100101011000110001000000110001110011011010110001010101010110100001010110111011010001100100001110001101111011', '1152932454441681553686105050801467624055675', 140, 4);
  t('0b1100000001001001000111010001111010010111001011100111101110000101111110001011111', '454021537654527488097375', 79, 4);
  t('0b1101001101000111001011011000010111000111110010011011101101011101011101010011001100100111000010011100111001101111100010011001011111111100001110010001001', '2355828849861155012884780223410671381544574089', 151, 4);
  t('0b1010101011001011000110110010001011101011111101100', '375578620712940', 49, 4);
  t('0b11101111110110011011001010101101010000001100111010010010100101', '4320760375549338789', 62, 4);
  t('0b111001110101100110110110001001100011101011000110110110001110111111010110110101110010100100001101101100111011011100110000110111100000011100011', '2519183162360903506191281057447758087831779', 141, 4);
  t('0b11100000111001110001000011110101010101100011', '15455189161315', 44, 4);
  t('0b10111010101101', '11949', 14, 4);
  t('0b10010111010010010011111011111011000101100010011010101110111000010', '21802627242312687042', 65, 4);
  t('0b111100101010101010000101011000001001110000100110111000010111110010111101101000110111011111101011000001001101111111110111011100010011100011111', '2642399810851701674212632837439227993925407', 141, 4);
  t('0b110101010010011100111000100001100100101101000111000001000111101010100010010111001000001100001100100100101111100', '2161630318713979730472184517642620', 111, 4);
  t('0b11001101011011110101111100000111110011011001101110110010101100110101100101001111100101100110110010010001110001100000010011100110010101000011001111001001000111101000010', '150121826439470624887536282475629271619430756159298', 167, 4);
  t('0b101111000010001110110001111111100110010111000100010100010111111100100011010110101011110000010000100001110011100101111010011100111000100010000000011100110111000111', '4296345185753731570217826010182320032993209601479', 162, 4);
  t('0b11101000101000110001101001011101110010011110011101011011011001001010011111100101110101110011000100111001101111110101100110000000000111001001001101', '81062205635532331055236284929003822323364429', 146, 4);
  t('0b11010111', '215', 8, 4);
  t('0b10011000011011101000011000001101011000000110000101101000011101011110001010011100100011', '46069664430530648537081635', 86, 4);
  t('0b1111101001110000110010000000001001000111100111000100101111101110001100001000100001010001010011101000111101000100000100110001010111110000001011010011011', '2792505467580338130476655688091490969863067291', 151, 4);
  t('0b1111101100001101110000001101101111010010011111111101100000010111010101110110101100110010110010101000010100000010011110100100100111101010011', '683433243524982240677777243476582452055891', 139, 4);
  t('0b1010101110101110001000111100111001110011001010011111001111101100', '12370864596035695596', 64, 4);
  t('0b11000111110001100111001010011110011010110101010010111100011010111100101101101101101010', '60378345252763661786864490', 86, 4);
  t('0b10101100111000000110001100101100001101101011010000111101100001111110100100011001000001010110001001110011111111101111111000000000000010000110110100111011100010001000100', '126329653589454952926638707222811823179996994585668', 167, 4);
  t('0b111001000110000010011110111001000111011101011111100111110111111101100100110010001000011001100001000111010000010010110010110100111101000011110000111', '159155836031631574967766651303670498797193095', 147, 4);
  t('0b11000110000110100101011010000011010110100101011000011101010000011010110001010100011110011100010100111111010110000101110110110110100000', '16852729444979725339524623444714796314016', 134, 4);
  t('0b110100000100110000001100110011111010100011011111011101010011110100011001010101001001100111', '1007262826627701209829823079', 90, 4);
  t('0b1011010110011101110010000110111110100010011000001', '399378554504385', 49, 4);
  t('0b10110001001001000101010101010000101101000110100110000110001000001000010110100111000110101000010010100111010100011000100011101100111001110001010100000', '493799621713705665209661337050845053741490848', 149, 4);
  t('0b10110101110101110100000111010001011000111011010000101001110101111110110001011000000', '6869753008454091059192512', 83, 4);
  t('0b11101001010111011000000010011000001110011111110011111000110011110011001111011111101111000100010110001110100101', '1183302363719122225851040665789349', 110, 4);
  t('0b100011010000101111111110101011111111100111011111111000011101110010100000110001111000111100010111011110000101010100000101011100', '46870857086354303302378526158318027100', 126, 4);
  t('0b1001011100111010011100011010100000000100011101001101110110110010110100011001101000011110010000101110110101111110000000111100000101110100010100110100110001000000010110100011', '3536326453156193038031587123790239903142359400187299', 172, 4);
  t('0b101010100101101101010110000001111101000100001110000011010001', '767218737556283601', 60, 4);
  t('0b10110110001111010100100101100010111000001010000111100100011110001011101000101100111001111011100111001111', '14438492881715694934558943721935', 104, 4);
  t('0b11110110001010000001011100110100101010001101010100100101000010101010001111101101110101100110100000111100101011001000010000000001101111', '20940687968317900181954981756671243649135', 134, 4);
  t('0b11000001011111101100110101100110', '3246312806', 32, 4);
  t('0b100000110100001011111111101000110001111011011011101111101001100001001000011010001111001111001110000100110001011000010111101001110111', '2791627903658830465325077767573756541559', 132, 4);
  t('0b11011110001000000010111111000000000100001001000010010101111100110101100100011011011001010100011101000101100001110000001001010011000100101010101010011', '619196159474080554644191332764720245730596179', 149, 4);
  t('0b11111111100100100000010101000110100110011111111000001001001010000111010110011011100001101011011', '39547602794153772246742451035', 95, 4);
  t('0b1001001001110110001', '299953', 19, 4);
  t('0b10100100101101011011010101000101001101001100101010110111110000100000101010011110010110001001001101000010001110110011110000111100010001001001101011010010', '3673151219411926241066396539539895097311402706', 152, 4);
  t('0b111011100011111111000011011010110010010000111010100111001111001101110000', '4394919723391067681648', 72, 4);
  t('0b1110011001100111011111001110111110', '15462167486', 34, 4);
  t('0b10001001101001101101010110001101011101100100001010101100000010000100001100000010101001101100101101011100101101111000110110010010001001001101100100110110111101011000111000110100', '51501613866007552548575243188268697652335512286236212', 176, 4);
  t('0b1101010000000101100111011110011110010', '113828412658', 37, 4);
  t('0b11000010110111101110', '798190', 20, 4);
  t('0b101001001111101100100111111000110000111010000', '22674826617296', 45, 4);
  t('0b11100101111101100010000001111110011001100101111111111100000001101001011000100101000011110010111100001111', '18219421810715473011424793407247', 104, 4);
  t('0b100110101000101100100110100100100100111110100000100010110001111100111100000011111001100110011111111010100100001100011000110110011111001100001011000111100001000', '441143871171700310794467845617284706136179969800', 159, 4);
  t('0b111100111101101111000010110010101', '8182531477', 33, 4);
  t('0b111101', '61', 6, 4);
  t('0b11101010000101100100100000011100101111100011001011010011001011011100110100011100000010011111010110010000001001111011', '75965586951977951466854946826683003', 116, 4);
  t('0b11111010111100001001110010100011011111111011001010000110011000010101110010100101110100110110011010000011110011101110011100011101010000011001001010000001011100100', '2865227033411954606371792440103294708104730837732', 161, 4);
  t('0b1100', '12', 4, 4);
  t('0b1000000110001111010010110000101010101011101111101011011101000000000101010100011100', '2447314272063451666863388', 82, 4);
  t('0b1101000010010001111110110001011000000001101111000111011111000110', '15029069503449036742', 64, 4);
  t('0b1000100101100110011011000000101101001110011', '4721031010931', 43, 4);
  t('0b11111000100111111001100001100100010001100110001101000110101001111111011011101010110110110101000100100101001100010011010110100100000101010010011100111000011100111010000000110011', '93021064714003304999209676659750808550526701882548275', 176, 4);
  t('0b111111011110010111011101011101101101000100110001011011111001', '1143454535228004089', 60, 4);
  t('0b111110101010110100000011111001001010111110', '4306578150078', 42, 4);
  t('0b110000100010000111110110110111100110111001001001111000110', '109286979318617030', 57, 4);
  t('0b100001011110001110101100101110001101010010011110010010101101110110001000110101011101101000101101111110110111001111100101001000000001101010100000011111100011001000101000', '195679510499172126937950972652289628431931810918952', 168, 4);
  t('0b110001011001101100010101001101000111101010000010111101011011011011011101100', '29161467826175673743084', 75, 4);
  t('0b11111111110110000000100111111010011010000000001001', '1125213381697545', 50, 4);
  t('0b111011110101010010011000011101001010111001100000000110110111101110101110111000101011101000000001000110000111010000111101100101000011000000110', '2606077838126325794622812111329148470986246', 141, 4);
  t('0b1110110100000000001111001111001010000000000111000001000100000111101001001000011010100101100111', '18337058785747772841230707047', 94, 4);
  t('0b1011001010011111110101100010010100111110101100001000111101111010011011101110001110000000101101010110111100001110000111111010110001000111011', '486261763761604150405408746183250518303291', 139, 4);
  t('0b1110011010011010101000111100111010101111000001101010001110110001111110000100001001100011001100101100000010110110111000010000110001010', '9808812004949753301944141481962869891466', 133, 4);
  t('0b101010110001010111100100111111100000100011001010110100111000011010101000100011110110111000111000010011000101101100101101101100001000', '3638586720469021421571505782203805260552', 132, 4);
  t('0b1101111001100', '7116', 13, 4);
  t('0b11111010111011101001100100100011100010110011000101011100', '70631085671395676', 56, 4);
  t('0b1101001100111000100111000111101111110101101110011', '464480193997683', 49, 4);
  t('0b11011100010001001111010010110101001000001111000100101001001010111111001100011101011010101101110001001011101011100011100010101110100101010100111110101110011011010110011000', '1287696114982305806708561003677255537140522028742040', 170, 4);
  t('0b100110001011101010111011011011101100111001111011000', '1343422207521752', 51, 4);
  t('0b1110101110100000101011000101111100101001110011100100001000110010001101110011101000011111101000110100011100101110000101100000010000100110001001', '5131515373500601241098729740846521305336201', 142, 4);
  t('0b10011101000011001000111010000101011111110111011101101001010010011000111101100010110010100011010100001000000001100000000011000010100010100001011100', '54723606892902481536500944335964133487421532', 146, 4);
  t('0b1101001110111010100010011100001', '1776108769', 31, 4);
  t('0b100000001100000110111101111110000001100110101101000100111111001110011100010111101101011000101010101011111100000001010101111111', '42786787446528052699594039883348317567', 126, 4);
  t('0b11000011111111011101011000111101101110010000101101000010101110101011', '225962873073433848747', 68, 4);
  t('0b111111100111001101011011100101111010010110100110011000000000010110100111100011', '300402265535819852900835', 78, 4);
  t('0b100011111010111011011011111', '75331295', 27, 4);
  t('0b11000100111000000111011111010101000010111001', '13529272635577', 44, 4);
  t('0b1001101100100010000010100000000111000110011111111000111010110101001000011101100011011101000100011110111100000110101010011010101110010011000011100011001', '1729790364338742795479957074258010329122965273', 151, 4);
  t('0b110001101', '397', 9, 4);
  t('0b10011100001001100111110000111', '327470983', 29, 4);
  t('0b10100101011', '1323', 11, 4);
  t('0b1001100110010000000111010100111101011110101111101000110100', '172896507987163700', 58, 4);
  t('0b10110101100110011101011011001111000000100011011110001110101100110111011111000010010101100010100110101101101111011', '7366609054351701610086110120336251', 113, 4);
  t('0b110110010111101111010001001101010001011101101010001001001101111111011', '501483179338306460667', 69, 4);
  t('0b10101110110111001100101001110000100100101001011100101010111010101110010000000100001110', '52848936898297944277057806', 86, 4);
  t('0b110100101110001101101000000010100010010010000010110011110111100110111001010010111000101100100101111001111000011011100100011110101100111110001101011011111100', '75247462135135296147483304900271494532907456252', 156, 4);
  t('0b1000100111100011101111100111010111110011101110011001100111111000011001010010101011', '2604661372805165686559915', 82, 4);
  t('0b110000000011011011111101100001100000010100011110111001010101010000111000010000101110010100000111000000010110111011111001011011110111111100111101111010000', '8573066822280330509997029656969204484303387600', 153, 4);
  t('0b1111000010000101010011110111001010001110101010010110011011010110110001101100011001101001101', '2326173895977887311754310477', 91, 4);
  t('0b101010110000111000011000100111111000000100110110', '188077030998326', 48, 4);
  t('0b1000001000110100001000111000111110101100101010100100110111000001000011110011010001100001101010001101111111010100001100011110010100101110000100001', '22684678246378182819785716745165465876847649', 145, 4);
  t('0b1101100111111101001001001100011001000011101001001100000001000111110000101001100010011011011100101100000010001000100110010111111010011111000000001000001001011010101111110101', '5097456801022432585476312678303126165684672742665205', 172, 4);
  t('0b1111000101001100001000111101001001110001110000011100100101000000111001000010100010000110110100010001011010101001000011000110010101000010001111001110110000100110110000111011', '5642505228059227244247414269863757684704851232189499', 172, 4);
  t('0b11100011100111110000110111101111011111110001101101110101000110101100011100', '16795487938751986166556', 74, 4);
  t('0b11111001101101111001100110000101001000001111100100001011001100101100100001110100100110010110011010100111100010100111111110101000100110001011011001011000101011101000001011011', '11678786451764002081049400473764762680882990476021851', 173, 4);
  t('0b11101001011010111111100100000111101100010100011100001111011010010011111011011101000101001010111001100010001100000110000011000011010001111110010001101100000100010000111', '170573148533121700284914386034471572584747624695943', 167, 4);
  t('0b10001100111100111110001010', '36949898', 26, 4);
  t('0b1010010100010010011110001110011111100001', '708979517409', 40, 4);
  t('0b11101000001111110011000101110101110011011011110110011110000000111111111011110011101111110001110101100100101111111100010101010011110011001110001010010011011001000001000101000101001', '695150897721330668961198822938644201466146242961639977', 179, 4);
  t('0b100011011001101111', '145007', 18, 4);
  t('0b1100001010011011100011011010100011111100110100001111', '3423573638106383', 52, 4);
  t('0b1101110000000101010111111111010', '1845669882', 31, 4);
  t('0b101111100111001010111111110111111000111100111111110001110011', '857702623840828531', 60, 4);
  t('0b10100100001000010111000101101101000100001', '1409871436321', 41, 4);
  t('0b1000101011', '555', 10, 4);
  t('0b10010011010001101011011101011000110001101001001001000000111111101101010000001110000111011001101110100011001010001000100001010101000100010000110100010010', '3284369793875476139142406227062347521500187922', 152, 4);
  t('0b111010010000011101100011000010100001011001011101111110001001100000101101100111111110110101111100011111000010101110101001010001011010', '4955975645658396849750021048094688973914', 132, 4);
  t('0b1100100010101100010011010111010011011110001010011', '441284718869587', 49, 4);
  t('0b1010110010000010', '44162', 16, 4);
  t('0b101110100110000101110000101000000100100110110100000101100000011001111010111100011101011100101010001001010011001101001010001', '7741948260639498696423377430502808145', 123, 4);
  t('0b101100000110111000111001010110010000110011', '3031053984819', 42, 4);
  t('0b10110011010101011100010110100101111101111101110001011111101011011001101100100010000001010011011110010010010011101010001010011100101000001000000001010100111011111110001011', '1048393860009702438276451118840918885709561673793419', 170, 4);
  t('0b11011000100011101011010010001001101010111010000100000110100010011010100100101000110011001000000101100101', '17157448231253463055811180527973', 104, 4);
  t('0b1001111101111001100110000011001', '1337773081', 31, 4);
  t('0b1010000101', '645', 10, 4);
  t('0b111110000001000011100000110010111011001011100110111110011110111011010101010111101100101111101000000000101100011111110111100101001110000011111000010011011', '11064110199645779468713657128408705698455744667', 153, 4);
  t('0b11110010010110011110011011000110111010', '260222595514', 38, 4);
  t('0b101000100111110011111100111001011100001000101101110011000100111111011001111', '23979030927343490334415', 75, 4);
  t('0b101000000010010101101101001010', '671701834', 30, 4);
  t('0b10011100000110011001110110011111011101110001101011110111110011000001100001000101110111001110000010011101101001010111010010010101110111110110110000010111110111011010', '14258780956329408244620868751517156468304535191002', 164, 4);
  t('0b10011010111001101001111000001000011000111000010111000100011101110000111010000010101010', '46815908925437602817089706', 86, 4);
  t('0b1100010000000010001100111000011111100010101000010101100001010100011101111001101000001101111111101101000100', '62117604478929274751724622969668', 106, 4);
  t('0b11100010001001100001', '926305', 20, 4);
  t('0b1110101110110010110010101010010011001111111011011000', '4146450184077016', 52, 4);
  t('0b11100011100000111011000000111111001001011000011011110001011110010111101001001001000011111101000000011111101001111000010101001011100000010100000000001000000101001100101110110', '10640405756706933069932552513853268918056402456582518', 173, 4);
  t('0b100000010101', '2069', 12, 4);
  t('0b101000101100101111110110100100001110100101001010010100101010001100001101100011110110001001111110010010110100001011101101111010100110000000110100110101000', '7260976836577029672818019365254002054979938728', 153, 4);
  t('0b1010010010100000101011111111110100000011101101000100100000111001100000010101011011000011111010111001000111011110101111010000110', '109413864136821966738078269201594670726', 127, 4);
  t('0b11101001010010010000001010101001000010111010011111010011101101000010110', '2151676161178286545430', 71, 4);
  t('0b1', '1', 1, 4);
  t('0b11110110100000100001101001110011101100010110000110011101110010101110101010111001001000101011101101100000010000100101', '79996489761592791530139097880724517', 116, 4);
  t('0b1101000110', '838', 10, 4);
  t('0b11010000111111110000100100100110100000110001000101010100111110', '3764941434990646590', 62, 4);
  t('0b1100110001010110001011110100101011101000110000011100010000110010010111010010001101111000000111110101100010111000101101001101', '16975625492382937650444877242569558861', 124, 4);
  t('0b1110110111110101110000001100101101010101101101111111011001101011101101000010010010111101010011101111011011011110001111000001100001010010011001111010010110001001111111001', '695557780484633047451419090913265350682286538560505', 169, 4);
  t('0b10010011101100000110011111100100000000101001100101000101111110001101010110000010011010000001000110010001001011011001110011000010111001011110110', '6432766911463399701129205956556722425393910', 143, 4);
  t('0b10000010011101010000001110000110011101010111100000111010010011100001100100', '9626033841394783172708', 74, 4);
  t('0b1101101000011111101101001000111', '1829755463', 31, 4);
  t('0b111010100011110110011011011111000100011011011111000010110000110001101011001100010110100011110000', '72493971032499161046675712240', 96, 4);
  t('0b10101010100001111110010100000111110011000010111011011111', '48000163788893919', 56, 4);
  t('0b111001110111101101111011001110001110011111000010110101101', '130312977572136365', 57, 4);
  t('0b1001110011011111011001111000011011000100000001110111000110110010001101010010011000100100001100111001101001100110011110001111111111110111101111010', '27331074366810509421853388280769875793670010', 145, 4);
  t('0b1000001110110010010010110000001010001001011100000010100100100100000001011101001101100100001111000010', '652129268908332354914162721730', 100, 4);
  t('0b1100000101101000011101100101011100010111010011001000100000101101100111000010011000001110011111111111001000101110001', '31382251255391898419590799476887921', 115, 4);
  t('0b1101111011001011000101110110110111011010111100010110001110100111000010001101101001100011101001101101101110001101110010001110000000001111', '75812640390549515698067392896804260995087', 136, 4);
  t('0b1101010000010110111100110000100010111001101110110100011101001010100111100101111011100110000111000011011000101011110010111011101110001011001001101000101', '2364878576296174981737730111388996744591545157', 151, 4);
  t('0b1101111111100100101111001111011100000100000011110011111111010101100100011011', '66081699980324911274267', 76, 4);
  t('0b1110000110010101101101001100110011010000100001011100100111001010010101111000000101101111101011101100000001000110000110101111111100100000101111', '4912801682953604186696386732310079951849519', 142, 4);
  t('0b11000101100000111011101101001000010010000011100010010110011000111110110101110110100001100110100100000100000000010111010', '512777157413030085980733281858093242', 119, 4);
  t('0b110010000000100010010100110100001011001001100010001111011010100000', '57655736925864654496', 66, 4);
  t('0b1001000100111010111111000011101100000010001110101111111011000110010001010001111001110011001', '1404582351453280869403915161', 91, 4);
  t('0b100110101110100011110010101100010111011111101000111100001110000101011100010100111101100000011010001100111000011110', '12567788490336688088992466604707358', 114, 4);
  t('0b110111110010011110110111001011100010001010100001110011111111111101110001000101111100110011100110000100010110010011', '18104495725933236784651084181816723', 114, 4);
  t('0b1111000110100000011101011000111010010101011101010010110110111000010101110110110100010000110000001101101011011001101101101100100110110110111100011001100110010010000100010111011', '45201658205192969951078809960368998187352382503454907', 175, 4);
  t('0b11110111101000011110000010001', '519322641', 29, 4);
  t('0b10100000110110110111011011110111110110111001000001001000100101000001110101001101000011111000100011011110110100111101111', '417609385350091179779636810113575407', 119, 4);
  t('0b100001010110111010111000000100010101101100010111', '146710581041943', 48, 4);
  t('0b10001111010011100001101011101100110111010100100', '78782810975908', 47, 4);
  t('0b10001110110110100000011010101', '299581653', 29, 4);
  t('0b1110001011001100001001100110001010000110', '974087676550', 40, 4);
  t('0b11100011001001011111010000101001001011001001010110110101001110000000111010110100001000011100010011010011100011000010000101101001110100011101110011110111', '5065575398273300616873996741388922355920788727', 152, 4);
  t('0b1111111000001101100100011000', '266393880', 28, 4);
  t('0b10110101100100101010001010111001000000011100000110110001011100011111111100000110001001010101111111010011000011100011010001110110011101101100101111101101111110', '259149353365748547676531551540644422107339619198', 158, 4);
  t('0b1101011110100010001011001011000010000011001011110000111100001100101100100010001111101111001110100011011000010000', '4373566857843294445861437353637392', 112, 4);
  t('0b100011101001110010110011110100110011010000101000100111010100101001000111110100101011010101000001111110100000100110111001001001101010011010000101001000111000110111010', '26053480661633533853821712739093750512044053131706', 165, 4);
  t('0b1110010101111000001010010001101011101010001111011001101000000111111111010000000001011000011001101111010101100001101011001100011100010011010100111000100011100110001111110010', '5365917928263298552573558618072276593881915061068786', 172, 4);
  t('0b0', '0', 1, 4);
  t('0b101101010011001101010001010001010000110000011111', '199232011439135', 48, 4);
  t('0b100101010000010110110111111000101111000110000101010010001001101001101000', '2748976914400602004072', 72, 4);
  t('0b1100010100011100010100101000101110001101001001010111100010', '221926845064713698', 58, 4);
  t('0b111010011101110111001010101110100000001011000', '32142349779032', 45, 4);
  t('0b1011000111100001011000110110010011101101', '763990598893', 40, 4);
  t('0b111110001111011010110111001010100111111101111001001011010101110110110011010001110010101101000011', '77050543164333814857060526915', 96, 4);
  t('0b110111110010111101111000100111010010001110001111111100001101100010001101000100100100011100100011011011010111010111001001001110100001100', '37973033900975016780110288277302266862860', 135, 4);
  t('0b101000111010110010000111111000011000001001011001111000001100001001110001101100001111001000000000010111111101110011100011011001111111110100100010001110000000101101001110100', '1913677948341929506841492066019813618520908835609204', 171, 4);
  t('0b1111101001100110010101010000001000100000101001101110110100011', '2255400303091572131', 61, 4);
  t('0b110100010100001101111110100010100001100101110001100011111001010001101001100010011011001110110011000010100001001011101100001011101001011010000011001010001100', '74667765260706149423652281266282011954894090892', 156, 4);
  t('0b1000000010111101', '32957', 16, 4);
  t('0b1111110100011101111101100011', '265412451', 28, 4);
  t('0b11110010', '242', 8, 4);
  t('0b1001111110110111001001000000111011110010101101011001000011110110000001000000001101110010100000110111011000101111000100101111111001100001001100011111010100101100100', '7294509680489473516157489095568130945736908974436', 163, 4);
  t('0b111101001100101010011001111111100101100011110011110', '2153208033232798', 51, 4);
  t('0b101111100110101010011111110100000001110001010101110001000001101101101011111010100110011011011', '7366381587271251372942380251', 93, 4);
  t('0b11100', '28', 5, 4);
  t('0b10011100111001101100', '642668', 20, 4);
  t('0b10100010111000011011100101000111000010110010000101111001111001111011101110110110100101001110100100111010101010111100100001001110110100100100100', '7094500064780213519639611108740313788148004', 143, 4);
  t('0b111110111101010100110000011010010100100111110001111001101110110001011110001111011000011001000100110101101100001010000011000001000111010100', '342777004104073921541803082899350493073876', 138, 4);
  t('0b11100011110111111101111100110111111000010011000000101100001100000100000011111110011001110100000111001011111111010110100111111011010101110011011011101000', '5081771157073840975382845753680003415619876584', 152, 4);
  t('0b1110101100001100111010010101011010001101111001100101110110011101111101110111000011101001010011110110000100011010011001001100100010111', '9997939815383461009512050917690963695895', 133, 4);
  t('0b10001010010011111111100001110010110100110011101', '76038037662109', 47, 4);
  t('0b1101000011101001000100110101000110011011110000001000010010000011111000010000111011101001000010011111010011111111011111101101101110110110001011010111000000100001001000', '76330741559420840213970134181579220885370404866120', 166, 4);
  t('0b101110101011111101011000011101001100011100000100001000110011101011011101110001101110110011010110010111100', '29591313602933764036329127652540', 105, 4);
  t('0b110011101001000110010011100', '108301468', 27, 4);
  t('0b10111010011000101111000011000000111000011100011010000010011000011101011011111000001100000001110001', '230735293932368005478672810097', 98, 4);
  t('0b101110001011101011001000111000101100110110001010110111110010110111000101000010110100000010010011101000111001010010011011010', '7673368527850305306860702856736711898', 123, 4);
  t('0b11000010011011000010100001001011111110000001111000101100100011011100000', '1793230956491923932896', 71, 4);
  t('0b10101110101001011001101100000100111110111010000110100110110', '393269849358142774', 59, 4);
  t('0b11100010011101010', '115946', 17, 4);
  t('0b11110001000100001110011001100100', '4044416612', 32, 4);
  t('0b11101111111000111000010010011101000110101000100101100010', '67522678144797026', 56, 4);
  t('0b11100000110000100010000100100100000010001111011000011001101101101101001000010011101010011110110010101111010000001100000100100100000', '2390040390567048642966647388057001920800', 131, 4);
  t('0b1010000110010110100110111100111101001001101101011001111001110010000110100010000000000101100011101100010011011000000010111111000110000001', '54985654283950555052147243853162465718657', 136, 4);
  t('0b11000011100011000100111110110111001010010101000011001010010011101111010011110001101100110110001111011110100110010011', '63458983779334095341636694071699859', 116, 4);
  t('0b101111100010001011001011101011100010010111010000111100101000010011100010100001001111001100010000111111', '3766029900593721359372665013311', 102, 4);
  t('0b101111011000101011011011001000010010011111001001111010000111011111010010010100111011110010011100010011000111110011110110001010101100010110010110001111011100', '67630990462245519904689419770374213484683027420', 156, 4);
  t('0b1000101000001110001001001111100000001100000100', '37948338602756', 46, 4);
  t('0b1110100101100011001000000000001010011000110001010101101010010', '2102165078632082258', 61, 4);
  t('0b11', '3', 2, 4);
  t('0b11000000101111101111010110110101001110011010001011001011', '54253158045164235', 56, 4);
  t('0b1011101000010110000100000100111001010100101101011011101001001011001111001100101110010100100011101011', '921454163161847327849553938667', 100, 4);
  t('0b11011110010110101000111111000110101111000110111001001011111', '500696147126612575', 59, 4);
  t('0b1010101001110010100011100110011111001011001010011010000110001101', '12282035710234042765', 64, 4);
  t('0b1001101010011101000101110010011010001010101111001000000101010010100001100000110010100001000001111011011110001100110111101011111011000011001011000100000000011110001011111011', '3615489279593509708772217418002107077942788107657979', 172, 4);
  t('0b1010010111011001111100100000011001101110111101110011101010110000011011001110010010111000000110101001101000001110', '3363864999018073552305148875414030', 112, 4);
  t('0b10110111000011100000100001000111101011000010011100010111111001001110011000000111100110101111111111111011110110111010111011010000101010100111011000100110010111001', '2090116485561415533220743961894899901833660878009', 161, 4);
  t('0b101001101001001011010001100010111111010000001111110100110010110011101000000011010111111110011100001011100011111101100100010110000001100111000010001111110', '7429426803493479456828449389493437652073153662', 153, 4);
  t('0b10101101101111010111001110101001101001100', '1492415632204', 41, 4);
  t('0b100011011100100000101110001000011111111010011010011001101001010010000011110000111011010001101011000010010000110110001', '92021749248802288107686447118623153', 117, 4);
  t('0b10110001100100001110111010111001010011000110010100011010110010010100110100111111101111010110100110100', '1758529900728895870358045306164', 101, 4);
  t('0b1001111000000', '5056', 13, 4);
  t('0b110000111100010100101000011111110101000011110011111100111010010010001111001101100000001000111111100010010101100', '1985345177021823592895244450907308', 111, 4);
  t('0b1001110000100000000000110110100010010101111110010100011100010101101010', '719999719481543869802', 70, 4);
  t('0b111100100100001100100101001110001101011010010100011010011100101000000101011011', '286012825709225924788571', 78, 4);
  t('0b11010111100100111111110100111001010000011101110110100000001100001100001011011000110100010110110001110101100111100111000110010100011', '2292419381743847793952323533642807872675', 131, 4);
  t('0b100110100001101001001110101010000101110100000100000010100110001010101111110100110101001001001011011101000111001101100001101100010011000010011010', '13424243929007150060864059623182269932449946', 144, 4);
  t('0b111011000010100011011110010000000000010110111001001100010010101101000001000010111010110001110010010101', '4677623609407056260314308484245', 102, 4);
  t('0b1010001000000011111000000101001100001011100000011111111001101000100001001011010110000010011011111111000011110101010001110011', '13459691377936385656205820498694591603', 124, 4);
  t('0b101111100101010010010101000010100111111101111011110111100110', '857171914848189926', 60, 4);
  t('0b110110001001110001101001101001011100110000000100111101101000111101100100110101001110010001', '1047466460252578697656357777', 90, 4);
  t('0b10000101011010001000100001111111001110010010110100011000111101001010000001001011001000111010010000011010101111001111101101010001', '177330090800059334179372876785623300945', 128, 4);
  t('0b1010', '10', 4, 4);
  t('0b1110000101111000100101111000000001000100111010100110100101100011001010000101101001100000000100101011101001110000001110011101000001110', '9590478319392434269891419865097211165198', 133, 4);
  t('0b1101010001110100011011010010011010100010111111101000101011111111111011011100001000010100011100010000111011001011000101100010010001111011101111010100100011000010001', '9703219505953893074023234217532878016916428047889', 163, 4);
  t('0b1101000001100011011001110000010011000100110001000011010110000100', '15015958852762088836', 64, 4);
  t('0b11110011111110100111011111001010001010010100010010110', '8584226467555478', 53, 4);
  t('0b11111001001000111101010101111010100110110100011001001110111101011011100101010101001111001011', '4819067998434611218882057163', 92, 4);
  t('0b1000', '8', 4, 4);
  t('0b101110001000011100101111000001100011100000100010101011101011110', '6648324064296392542', 63, 4);
  t('0b100000001011010111010101110111110011000100', '2211226025156', 42, 4);
  t('0b111000010011100011011111000001110100100', '483660891044', 39, 4);
  t('0b1100110100110100011011000', '26896600', 25, 4);
  t('0b1110110001001101110110101111110100001000011011100111000000100111110010011011000010011001111011101010010010111111101000001011011', '157051027737987715731727950696316653659', 127, 4);
  t('0b10101101101110101011101100011100010010011011011011000110111000010000001001110111010100111', '420051957077295313153486503', 89, 4);

  // Floats

  t('0b111010110111100110100010101.1110000001100101001000101100010001111011', '123456789.87654321', 67, 4);
  t('-0b0.000000000000000000000010000100100011111', '-0.000000123456789', 17, 4);
  t('0b1111100111.11111111101111100111011011001000101101', '999.999', 48, 4);
  t('-0b11111100001000110000100000101.010000000010101111110001111101011011111', '-528769285.2506705498654986754987694357629487612132293856', 68, 4);
  t('0b111011.001010010001', '59.160508253119229720226315984803348705', 18, 4);
  t('0b1000001001001100110111.101011101111000111000101011111000010001111111011100010001100111111100100011010100001010111111', '2134839.683376639182809009377393376566052153774412236905434', 115, 4);
  t('0b110100110001101011110111011000010000110100000011111011110000111111110101000111000110001111011110111110111000010111001110000001101.1101111001111010101101110101011001000011000000101011010000001111011001101010010101', '561214248546542162784739085096665717773.86906', 211, 4);
  t('0b10110111000101011010101011100011110110000011100101000100101000111000001101110001010010110011101100101000001100011111010111011100.000110111100110011011100001111010100110111000100110000100000010010100101100011001101', '243361227524012342673912659288240813532.10859467026399996528383947490', 212, 4);
  t('0b110001011001101010010100100001011011001101010101111001010011100010110001001010010110100000111000000000001101000000110000100011100001101001100011010100110101111010110001.1011100011010100100011101101101100101011000110000110111110001100000110011000111100001', '288798319290142875873517012221913212736305288666801.721993378169914151', 253, 4);
  t('0b101111111100000110101111100000101000111011101010001100001110', '863594881689232141.62881568577668460977625904', 60, 4);
  t('0b101110011110011', '23794.501525', 15, 4);
  t('0b1000', '7.792303494645702446763290630498884400068339335428470929289382355', 4, 4);
  t('0b10110001101000000001011000001011111010111100011101101011011001001001011011010111110000111101001001110101110101011011011100010', '29513071238598351326634077220532565729.753116233815194468461197227952', 125, 4);
  t('0b110010', '50.3', 6, 4);

  // Include binary exponent.

  t = function (expected, n, sd, rm) {
    T.assertEqual(expected, new Decimal(n).toBinary(sd, rm));
  }

  t('0b0p+0', '0', 40, 4);
  t('0b1p+53', '9007199254740992', 40, 4);
  t('0b1.1p+8', '384', 40, 4);
  t('0b1p+1', '2', 40, 4);
  t('0b1p+8', '256', 40, 4);
  t('0b1p-6', '0.015625', 40, 4);
  t('0b1.10110111p-1', '0.857421875', 40, 4);
  t('0b1.10110111p-1', '0.857421875', 9, 4);

  t('0b1.001010101110101p-4', '0b1.001010101110101p-4', 16, 1);
});
