/* Copyright 2022 Advanced Micro Devices, Inc.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE COPYRIGHT HOLDER(S) OR AUTHOR(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR
 * OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
 * ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
 * OTHER DEALINGS IN THE SOFTWARE.
 *
 * Authors: AMD
 *
 */
#include "custom_float.h"
#pragma once

#ifdef __cplusplus
extern "C" {
#endif

#define NUM_OF_LUT_DATA_DEGAM        256
#define NUM_OF_LUT_DATA_REGAM_PQ     202
#define NUM_OF_LUT_DATA_REGAM_LINEAR 224
#define NUM_OF_LUT_DATA_REGAM_SDR    186
#define NUM_OF_TRANSFER_FUNCTION     4

/*
Table Layout:

   Degam          Regam
[0][0] SRGB    [1][0] SRGB
[0][1] G24     [1][1] G24
[0][2] PQ      [1][2] PQ
[0][3] BT.709  [1][3] G10

*/

static struct pwl_params tf_pwl_param_table[2][NUM_OF_TRANSFER_FUNCTION] = {
    {
        // Degam
        {.hw_points_num       = NUM_OF_LUT_DATA_DEGAM,
            .arr_curve_points = {{0x0, 0x0}, {0x1, 0x0}, {0x2, 0x1}, {0x4, 0x2}, {0x8, 0x3},
                {0x10, 0x4}, {0x20, 0x5}, {0x40, 0x6}, {0x80, 0x7}, {0x0, 0x0}, {0x0, 0x0},
                {0x0, 0x0}, {0x0, 0x0}, {0x0, 0x0}, {0x0, 0x0}, {0x0, 0x0}, {0x0, 0x0}, {0x0, 0x0},
                {0x0, 0x0}, {0x0, 0x0}, {0x0, 0x0}, {0x0, 0x0}, {0x0, 0x0}, {0x0, 0x0}, {0x0, 0x0},
                {0x0, 0x0}, {0x0, 0x0}, {0x0, 0x0}, {0x0, 0x0}, {0x0, 0x0}, {0x0, 0x0}, {0x0, 0x0},
                {0x0, 0x0}, {0x0, 0x0}},
            .corner_points    = {{.red.custom_float_x          = 0x16000,
                                     .red.custom_float_y       = 0x0,
                                     .red.custom_float_slope   = 0x1b3d0,
                                     .green.custom_float_x     = 0x16000,
                                     .green.custom_float_y     = 0x0,
                                     .green.custom_float_slope = 0x1b3d0,
                                     .blue.custom_float_x      = 0x16000,
                                     .blue.custom_float_y      = 0x0,
                                     .blue.custom_float_slope  = 0x1b3d0},
                   {.red.custom_float_x          = 0x7c00,
                       .red.custom_float_y       = 0x1f000,
                       .red.custom_float_slope   = 0x0,
                       .green.custom_float_x     = 0x7c00,
                       .green.custom_float_y     = 0x1f000,
                       .green.custom_float_slope = 0x0,
                       .blue.custom_float_x      = 0x7c00,
                       .blue.custom_float_y      = 0x1f000,
                       .blue.custom_float_slope  = 0x0}},
            .rgb_resulted     = {{.red_reg = 0x123d0, .green_reg = 0x123d0, .blue_reg = 0x123d0},
                    {.red_reg = 0x133d0, .green_reg = 0x133d0, .blue_reg = 0x133d0},
                    {.red_reg = 0x143d0, .green_reg = 0x143d0, .blue_reg = 0x143d0},
                    {.red_reg = 0x14db8, .green_reg = 0x14db8, .blue_reg = 0x14db8},
                    {.red_reg = 0x153d0, .green_reg = 0x153d0, .blue_reg = 0x153d0},
                    {.red_reg = 0x158c4, .green_reg = 0x158c4, .blue_reg = 0x158c4},
                    {.red_reg = 0x15db8, .green_reg = 0x15db8, .blue_reg = 0x15db8},
                    {.red_reg = 0x16156, .green_reg = 0x16156, .blue_reg = 0x16156},
                    {.red_reg = 0x163d0, .green_reg = 0x163d0, .blue_reg = 0x163d0},
                    {.red_reg = 0x1664a, .green_reg = 0x1664a, .blue_reg = 0x1664a},
                    {.red_reg = 0x168c4, .green_reg = 0x168c4, .blue_reg = 0x168c4},
                    {.red_reg = 0x16b4d, .green_reg = 0x16b4d, .blue_reg = 0x16b4d},
                    {.red_reg = 0x16dfc, .green_reg = 0x16dfc, .blue_reg = 0x16dfc},
                    {.red_reg = 0x17069, .green_reg = 0x17069, .blue_reg = 0x17069},
                    {.red_reg = 0x171e7, .green_reg = 0x171e7, .blue_reg = 0x171e7},
                    {.red_reg = 0x17378, .green_reg = 0x17378, .blue_reg = 0x17378},
                    {.red_reg = 0x1751e, .green_reg = 0x1751e, .blue_reg = 0x1751e},
                    {.red_reg = 0x176d7, .green_reg = 0x176d7, .blue_reg = 0x176d7},
                    {.red_reg = 0x178a5, .green_reg = 0x178a5, .blue_reg = 0x178a5},
                    {.red_reg = 0x17a87, .green_reg = 0x17a87, .blue_reg = 0x17a87},
                    {.red_reg = 0x17c7e, .green_reg = 0x17c7e, .blue_reg = 0x17c7e},
                    {.red_reg = 0x17e8b, .green_reg = 0x17e8b, .blue_reg = 0x17e8b},
                    {.red_reg = 0x18056, .green_reg = 0x18056, .blue_reg = 0x18056},
                    {.red_reg = 0x18172, .green_reg = 0x18172, .blue_reg = 0x18172},
                    {.red_reg = 0x18298, .green_reg = 0x18298, .blue_reg = 0x18298},
                    {.red_reg = 0x183ca, .green_reg = 0x183ca, .blue_reg = 0x183ca},
                    {.red_reg = 0x18506, .green_reg = 0x18506, .blue_reg = 0x18506},
                    {.red_reg = 0x1864e, .green_reg = 0x1864e, .blue_reg = 0x1864e},
                    {.red_reg = 0x187a2, .green_reg = 0x187a2, .blue_reg = 0x187a2},
                    {.red_reg = 0x18901, .green_reg = 0x18901, .blue_reg = 0x18901},
                    {.red_reg = 0x18a6b, .green_reg = 0x18a6b, .blue_reg = 0x18a6b},
                    {.red_reg = 0x18be1, .green_reg = 0x18be1, .blue_reg = 0x18be1},
                    {.red_reg = 0x18d63, .green_reg = 0x18d63, .blue_reg = 0x18d63},
                    {.red_reg = 0x18ef1, .green_reg = 0x18ef1, .blue_reg = 0x18ef1},
                    {.red_reg = 0x19045, .green_reg = 0x19045, .blue_reg = 0x19045},
                    {.red_reg = 0x19118, .green_reg = 0x19118, .blue_reg = 0x19118},
                    {.red_reg = 0x191f1, .green_reg = 0x191f1, .blue_reg = 0x191f1},
                    {.red_reg = 0x192d0, .green_reg = 0x192d0, .blue_reg = 0x192d0},
                    {.red_reg = 0x193b6, .green_reg = 0x193b6, .blue_reg = 0x193b6},
                    {.red_reg = 0x194a1, .green_reg = 0x194a1, .blue_reg = 0x194a1},
                    {.red_reg = 0x19593, .green_reg = 0x19593, .blue_reg = 0x19593},
                    {.red_reg = 0x1968c, .green_reg = 0x1968c, .blue_reg = 0x1968c},
                    {.red_reg = 0x1978a, .green_reg = 0x1978a, .blue_reg = 0x1978a},
                    {.red_reg = 0x19890, .green_reg = 0x19890, .blue_reg = 0x19890},
                    {.red_reg = 0x1999b, .green_reg = 0x1999b, .blue_reg = 0x1999b},
                    {.red_reg = 0x19aad, .green_reg = 0x19aad, .blue_reg = 0x19aad},
                    {.red_reg = 0x19bc6, .green_reg = 0x19bc6, .blue_reg = 0x19bc6},
                    {.red_reg = 0x19ce6, .green_reg = 0x19ce6, .blue_reg = 0x19ce6},
                    {.red_reg = 0x19e0c, .green_reg = 0x19e0c, .blue_reg = 0x19e0c},
                    {.red_reg = 0x19f38, .green_reg = 0x19f38, .blue_reg = 0x19f38},
                    {.red_reg = 0x1a036, .green_reg = 0x1a036, .blue_reg = 0x1a036},
                    {.red_reg = 0x1a0d3, .green_reg = 0x1a0d3, .blue_reg = 0x1a0d3},
                    {.red_reg = 0x1a173, .green_reg = 0x1a173, .blue_reg = 0x1a173},
                    {.red_reg = 0x1a217, .green_reg = 0x1a217, .blue_reg = 0x1a217},
                    {.red_reg = 0x1a2bf, .green_reg = 0x1a2bf, .blue_reg = 0x1a2bf},
                    {.red_reg = 0x1a36a, .green_reg = 0x1a36a, .blue_reg = 0x1a36a},
                    {.red_reg = 0x1a418, .green_reg = 0x1a418, .blue_reg = 0x1a418},
                    {.red_reg = 0x1a4ca, .green_reg = 0x1a4ca, .blue_reg = 0x1a4ca},
                    {.red_reg = 0x1a580, .green_reg = 0x1a580, .blue_reg = 0x1a580},
                    {.red_reg = 0x1a639, .green_reg = 0x1a639, .blue_reg = 0x1a639},
                    {.red_reg = 0x1a6f5, .green_reg = 0x1a6f5, .blue_reg = 0x1a6f5},
                    {.red_reg = 0x1a7b5, .green_reg = 0x1a7b5, .blue_reg = 0x1a7b5},
                    {.red_reg = 0x1a879, .green_reg = 0x1a879, .blue_reg = 0x1a879},
                    {.red_reg = 0x1a941, .green_reg = 0x1a941, .blue_reg = 0x1a941},
                    {.red_reg = 0x1aa0c, .green_reg = 0x1aa0c, .blue_reg = 0x1aa0c},
                    {.red_reg = 0x1aadb, .green_reg = 0x1aadb, .blue_reg = 0x1aadb},
                    {.red_reg = 0x1abad, .green_reg = 0x1abad, .blue_reg = 0x1abad},
                    {.red_reg = 0x1ac83, .green_reg = 0x1ac83, .blue_reg = 0x1ac83},
                    {.red_reg = 0x1ad5d, .green_reg = 0x1ad5d, .blue_reg = 0x1ad5d},
                    {.red_reg = 0x1ae3b, .green_reg = 0x1ae3b, .blue_reg = 0x1ae3b},
                    {.red_reg = 0x1af1d, .green_reg = 0x1af1d, .blue_reg = 0x1af1d},
                    {.red_reg = 0x1b001, .green_reg = 0x1b001, .blue_reg = 0x1b001},
                    {.red_reg = 0x1b075, .green_reg = 0x1b075, .blue_reg = 0x1b075},
                    {.red_reg = 0x1b0ec, .green_reg = 0x1b0ec, .blue_reg = 0x1b0ec},
                    {.red_reg = 0x1b164, .green_reg = 0x1b164, .blue_reg = 0x1b164},
                    {.red_reg = 0x1b1de, .green_reg = 0x1b1de, .blue_reg = 0x1b1de},
                    {.red_reg = 0x1b25b, .green_reg = 0x1b25b, .blue_reg = 0x1b25b},
                    {.red_reg = 0x1b2d9, .green_reg = 0x1b2d9, .blue_reg = 0x1b2d9},
                    {.red_reg = 0x1b359, .green_reg = 0x1b359, .blue_reg = 0x1b359},
                    {.red_reg = 0x1b3db, .green_reg = 0x1b3db, .blue_reg = 0x1b3db},
                    {.red_reg = 0x1b45f, .green_reg = 0x1b45f, .blue_reg = 0x1b45f},
                    {.red_reg = 0x1b4e5, .green_reg = 0x1b4e5, .blue_reg = 0x1b4e5},
                    {.red_reg = 0x1b56d, .green_reg = 0x1b56d, .blue_reg = 0x1b56d},
                    {.red_reg = 0x1b5f7, .green_reg = 0x1b5f7, .blue_reg = 0x1b5f7},
                    {.red_reg = 0x1b683, .green_reg = 0x1b683, .blue_reg = 0x1b683},
                    {.red_reg = 0x1b711, .green_reg = 0x1b711, .blue_reg = 0x1b711},
                    {.red_reg = 0x1b7a1, .green_reg = 0x1b7a1, .blue_reg = 0x1b7a1},
                    {.red_reg = 0x1b833, .green_reg = 0x1b833, .blue_reg = 0x1b833},
                    {.red_reg = 0x1b8c7, .green_reg = 0x1b8c7, .blue_reg = 0x1b8c7},
                    {.red_reg = 0x1b95e, .green_reg = 0x1b95e, .blue_reg = 0x1b95e},
                    {.red_reg = 0x1b9f6, .green_reg = 0x1b9f6, .blue_reg = 0x1b9f6},
                    {.red_reg = 0x1ba90, .green_reg = 0x1ba90, .blue_reg = 0x1ba90},
                    {.red_reg = 0x1bb2c, .green_reg = 0x1bb2c, .blue_reg = 0x1bb2c},
                    {.red_reg = 0x1bbcb, .green_reg = 0x1bbcb, .blue_reg = 0x1bbcb},
                    {.red_reg = 0x1bc6b, .green_reg = 0x1bc6b, .blue_reg = 0x1bc6b},
                    {.red_reg = 0x1bd0e, .green_reg = 0x1bd0e, .blue_reg = 0x1bd0e},
                    {.red_reg = 0x1bdb3, .green_reg = 0x1bdb3, .blue_reg = 0x1bdb3},
                    {.red_reg = 0x1be5a, .green_reg = 0x1be5a, .blue_reg = 0x1be5a},
                    {.red_reg = 0x1bf02, .green_reg = 0x1bf02, .blue_reg = 0x1bf02},
                    {.red_reg = 0x1bfae, .green_reg = 0x1bfae, .blue_reg = 0x1bfae},
                    {.red_reg = 0x1c02d, .green_reg = 0x1c02d, .blue_reg = 0x1c02d},
                    {.red_reg = 0x1c085, .green_reg = 0x1c085, .blue_reg = 0x1c085},
                    {.red_reg = 0x1c0de, .green_reg = 0x1c0de, .blue_reg = 0x1c0de},
                    {.red_reg = 0x1c137, .green_reg = 0x1c137, .blue_reg = 0x1c137},
                    {.red_reg = 0x1c192, .green_reg = 0x1c192, .blue_reg = 0x1c192},
                    {.red_reg = 0x1c1ee, .green_reg = 0x1c1ee, .blue_reg = 0x1c1ee},
                    {.red_reg = 0x1c24b, .green_reg = 0x1c24b, .blue_reg = 0x1c24b},
                    {.red_reg = 0x1c2a9, .green_reg = 0x1c2a9, .blue_reg = 0x1c2a9},
                    {.red_reg = 0x1c309, .green_reg = 0x1c309, .blue_reg = 0x1c309},
                    {.red_reg = 0x1c369, .green_reg = 0x1c369, .blue_reg = 0x1c369},
                    {.red_reg = 0x1c3cb, .green_reg = 0x1c3cb, .blue_reg = 0x1c3cb},
                    {.red_reg = 0x1c42d, .green_reg = 0x1c42d, .blue_reg = 0x1c42d},
                    {.red_reg = 0x1c491, .green_reg = 0x1c491, .blue_reg = 0x1c491},
                    {.red_reg = 0x1c4f6, .green_reg = 0x1c4f6, .blue_reg = 0x1c4f6},
                    {.red_reg = 0x1c55b, .green_reg = 0x1c55b, .blue_reg = 0x1c55b},
                    {.red_reg = 0x1c5c2, .green_reg = 0x1c5c2, .blue_reg = 0x1c5c2},
                    {.red_reg = 0x1c62b, .green_reg = 0x1c62b, .blue_reg = 0x1c62b},
                    {.red_reg = 0x1c694, .green_reg = 0x1c694, .blue_reg = 0x1c694},
                    {.red_reg = 0x1c6fe, .green_reg = 0x1c6fe, .blue_reg = 0x1c6fe},
                    {.red_reg = 0x1c76a, .green_reg = 0x1c76a, .blue_reg = 0x1c76a},
                    {.red_reg = 0x1c7d6, .green_reg = 0x1c7d6, .blue_reg = 0x1c7d6},
                    {.red_reg = 0x1c844, .green_reg = 0x1c844, .blue_reg = 0x1c844},
                    {.red_reg = 0x1c8b3, .green_reg = 0x1c8b3, .blue_reg = 0x1c8b3},
                    {.red_reg = 0x1c923, .green_reg = 0x1c923, .blue_reg = 0x1c923},
                    {.red_reg = 0x1c995, .green_reg = 0x1c995, .blue_reg = 0x1c995},
                    {.red_reg = 0x1ca07, .green_reg = 0x1ca07, .blue_reg = 0x1ca07},
                    {.red_reg = 0x1ca7b, .green_reg = 0x1ca7b, .blue_reg = 0x1ca7b},
                    {.red_reg = 0x1caef, .green_reg = 0x1caef, .blue_reg = 0x1caef},
                    {.red_reg = 0x1cb65, .green_reg = 0x1cb65, .blue_reg = 0x1cb65},
                    {.red_reg = 0x1cbdc, .green_reg = 0x1cbdc, .blue_reg = 0x1cbdc},
                    {.red_reg = 0x1cc54, .green_reg = 0x1cc54, .blue_reg = 0x1cc54},
                    {.red_reg = 0x1ccce, .green_reg = 0x1ccce, .blue_reg = 0x1ccce},
                    {.red_reg = 0x1cd48, .green_reg = 0x1cd48, .blue_reg = 0x1cd48},
                    {.red_reg = 0x1cdc4, .green_reg = 0x1cdc4, .blue_reg = 0x1cdc4},
                    {.red_reg = 0x1ce41, .green_reg = 0x1ce41, .blue_reg = 0x1ce41},
                    {.red_reg = 0x1cebf, .green_reg = 0x1cebf, .blue_reg = 0x1cebf},
                    {.red_reg = 0x1cf3f, .green_reg = 0x1cf3f, .blue_reg = 0x1cf3f},
                    {.red_reg = 0x1cfbf, .green_reg = 0x1cfbf, .blue_reg = 0x1cfbf},
                    {.red_reg = 0x1d020, .green_reg = 0x1d020, .blue_reg = 0x1d020},
                    {.red_reg = 0x1d062, .green_reg = 0x1d062, .blue_reg = 0x1d062},
                    {.red_reg = 0x1d0a4, .green_reg = 0x1d0a4, .blue_reg = 0x1d0a4},
                    {.red_reg = 0x1d0e6, .green_reg = 0x1d0e6, .blue_reg = 0x1d0e6},
                    {.red_reg = 0x1d12a, .green_reg = 0x1d12a, .blue_reg = 0x1d12a},
                    {.red_reg = 0x1d16d, .green_reg = 0x1d16d, .blue_reg = 0x1d16d},
                    {.red_reg = 0x1d1b2, .green_reg = 0x1d1b2, .blue_reg = 0x1d1b2},
                    {.red_reg = 0x1d1f7, .green_reg = 0x1d1f7, .blue_reg = 0x1d1f7},
                    {.red_reg = 0x1d23d, .green_reg = 0x1d23d, .blue_reg = 0x1d23d},
                    {.red_reg = 0x1d283, .green_reg = 0x1d283, .blue_reg = 0x1d283},
                    {.red_reg = 0x1d2ca, .green_reg = 0x1d2ca, .blue_reg = 0x1d2ca},
                    {.red_reg = 0x1d312, .green_reg = 0x1d312, .blue_reg = 0x1d312},
                    {.red_reg = 0x1d35a, .green_reg = 0x1d35a, .blue_reg = 0x1d35a},
                    {.red_reg = 0x1d3a2, .green_reg = 0x1d3a2, .blue_reg = 0x1d3a2},
                    {.red_reg = 0x1d3ec, .green_reg = 0x1d3ec, .blue_reg = 0x1d3ec},
                    {.red_reg = 0x1d436, .green_reg = 0x1d436, .blue_reg = 0x1d436},
                    {.red_reg = 0x1d481, .green_reg = 0x1d481, .blue_reg = 0x1d481},
                    {.red_reg = 0x1d4cc, .green_reg = 0x1d4cc, .blue_reg = 0x1d4cc},
                    {.red_reg = 0x1d518, .green_reg = 0x1d518, .blue_reg = 0x1d518},
                    {.red_reg = 0x1d564, .green_reg = 0x1d564, .blue_reg = 0x1d564},
                    {.red_reg = 0x1d5b1, .green_reg = 0x1d5b1, .blue_reg = 0x1d5b1},
                    {.red_reg = 0x1d5ff, .green_reg = 0x1d5ff, .blue_reg = 0x1d5ff},
                    {.red_reg = 0x1d64d, .green_reg = 0x1d64d, .blue_reg = 0x1d64d},
                    {.red_reg = 0x1d69d, .green_reg = 0x1d69d, .blue_reg = 0x1d69d},
                    {.red_reg = 0x1d6ec, .green_reg = 0x1d6ec, .blue_reg = 0x1d6ec},
                    {.red_reg = 0x1d73d, .green_reg = 0x1d73d, .blue_reg = 0x1d73d},
                    {.red_reg = 0x1d78d, .green_reg = 0x1d78d, .blue_reg = 0x1d78d},
                    {.red_reg = 0x1d7df, .green_reg = 0x1d7df, .blue_reg = 0x1d7df},
                    {.red_reg = 0x1d831, .green_reg = 0x1d831, .blue_reg = 0x1d831},
                    {.red_reg = 0x1d884, .green_reg = 0x1d884, .blue_reg = 0x1d884},
                    {.red_reg = 0x1d8d8, .green_reg = 0x1d8d8, .blue_reg = 0x1d8d8},
                    {.red_reg = 0x1d92c, .green_reg = 0x1d92c, .blue_reg = 0x1d92c},
                    {.red_reg = 0x1d981, .green_reg = 0x1d981, .blue_reg = 0x1d981},
                    {.red_reg = 0x1d9d6, .green_reg = 0x1d9d6, .blue_reg = 0x1d9d6},
                    {.red_reg = 0x1da2c, .green_reg = 0x1da2c, .blue_reg = 0x1da2c},
                    {.red_reg = 0x1da83, .green_reg = 0x1da83, .blue_reg = 0x1da83},
                    {.red_reg = 0x1dada, .green_reg = 0x1dada, .blue_reg = 0x1dada},
                    {.red_reg = 0x1db32, .green_reg = 0x1db32, .blue_reg = 0x1db32},
                    {.red_reg = 0x1db8b, .green_reg = 0x1db8b, .blue_reg = 0x1db8b},
                    {.red_reg = 0x1dbe4, .green_reg = 0x1dbe4, .blue_reg = 0x1dbe4},
                    {.red_reg = 0x1dc3e, .green_reg = 0x1dc3e, .blue_reg = 0x1dc3e},
                    {.red_reg = 0x1dc99, .green_reg = 0x1dc99, .blue_reg = 0x1dc99},
                    {.red_reg = 0x1dcf4, .green_reg = 0x1dcf4, .blue_reg = 0x1dcf4},
                    {.red_reg = 0x1dd50, .green_reg = 0x1dd50, .blue_reg = 0x1dd50},
                    {.red_reg = 0x1ddad, .green_reg = 0x1ddad, .blue_reg = 0x1ddad},
                    {.red_reg = 0x1de0a, .green_reg = 0x1de0a, .blue_reg = 0x1de0a},
                    {.red_reg = 0x1de68, .green_reg = 0x1de68, .blue_reg = 0x1de68},
                    {.red_reg = 0x1dec7, .green_reg = 0x1dec7, .blue_reg = 0x1dec7},
                    {.red_reg = 0x1df26, .green_reg = 0x1df26, .blue_reg = 0x1df26},
                    {.red_reg = 0x1df86, .green_reg = 0x1df86, .blue_reg = 0x1df86},
                    {.red_reg = 0x1dfe7, .green_reg = 0x1dfe7, .blue_reg = 0x1dfe7},
                    {.red_reg = 0x1e024, .green_reg = 0x1e024, .blue_reg = 0x1e024},
                    {.red_reg = 0x1e055, .green_reg = 0x1e055, .blue_reg = 0x1e055},
                    {.red_reg = 0x1e086, .green_reg = 0x1e086, .blue_reg = 0x1e086},
                    {.red_reg = 0x1e0b8, .green_reg = 0x1e0b8, .blue_reg = 0x1e0b8},
                    {.red_reg = 0x1e0ea, .green_reg = 0x1e0ea, .blue_reg = 0x1e0ea},
                    {.red_reg = 0x1e11c, .green_reg = 0x1e11c, .blue_reg = 0x1e11c},
                    {.red_reg = 0x1e14f, .green_reg = 0x1e14f, .blue_reg = 0x1e14f},
                    {.red_reg = 0x1e182, .green_reg = 0x1e182, .blue_reg = 0x1e182},
                    {.red_reg = 0x1e1b5, .green_reg = 0x1e1b5, .blue_reg = 0x1e1b5},
                    {.red_reg = 0x1e1e9, .green_reg = 0x1e1e9, .blue_reg = 0x1e1e9},
                    {.red_reg = 0x1e21d, .green_reg = 0x1e21d, .blue_reg = 0x1e21d},
                    {.red_reg = 0x1e252, .green_reg = 0x1e252, .blue_reg = 0x1e252},
                    {.red_reg = 0x1e286, .green_reg = 0x1e286, .blue_reg = 0x1e286},
                    {.red_reg = 0x1e2bc, .green_reg = 0x1e2bc, .blue_reg = 0x1e2bc},
                    {.red_reg = 0x1e2f1, .green_reg = 0x1e2f1, .blue_reg = 0x1e2f1},
                    {.red_reg = 0x1e327, .green_reg = 0x1e327, .blue_reg = 0x1e327},
                    {.red_reg = 0x1e35d, .green_reg = 0x1e35d, .blue_reg = 0x1e35d},
                    {.red_reg = 0x1e393, .green_reg = 0x1e393, .blue_reg = 0x1e393},
                    {.red_reg = 0x1e3ca, .green_reg = 0x1e3ca, .blue_reg = 0x1e3ca},
                    {.red_reg = 0x1e401, .green_reg = 0x1e401, .blue_reg = 0x1e401},
                    {.red_reg = 0x1e439, .green_reg = 0x1e439, .blue_reg = 0x1e439},
                    {.red_reg = 0x1e471, .green_reg = 0x1e471, .blue_reg = 0x1e471},
                    {.red_reg = 0x1e4a9, .green_reg = 0x1e4a9, .blue_reg = 0x1e4a9},
                    {.red_reg = 0x1e4e2, .green_reg = 0x1e4e2, .blue_reg = 0x1e4e2},
                    {.red_reg = 0x1e51b, .green_reg = 0x1e51b, .blue_reg = 0x1e51b},
                    {.red_reg = 0x1e554, .green_reg = 0x1e554, .blue_reg = 0x1e554},
                    {.red_reg = 0x1e58d, .green_reg = 0x1e58d, .blue_reg = 0x1e58d},
                    {.red_reg = 0x1e5c7, .green_reg = 0x1e5c7, .blue_reg = 0x1e5c7},
                    {.red_reg = 0x1e602, .green_reg = 0x1e602, .blue_reg = 0x1e602},
                    {.red_reg = 0x1e63c, .green_reg = 0x1e63c, .blue_reg = 0x1e63c},
                    {.red_reg = 0x1e678, .green_reg = 0x1e678, .blue_reg = 0x1e678},
                    {.red_reg = 0x1e6b3, .green_reg = 0x1e6b3, .blue_reg = 0x1e6b3},
                    {.red_reg = 0x1e6ef, .green_reg = 0x1e6ef, .blue_reg = 0x1e6ef},
                    {.red_reg = 0x1e72b, .green_reg = 0x1e72b, .blue_reg = 0x1e72b},
                    {.red_reg = 0x1e767, .green_reg = 0x1e767, .blue_reg = 0x1e767},
                    {.red_reg = 0x1e7a4, .green_reg = 0x1e7a4, .blue_reg = 0x1e7a4},
                    {.red_reg = 0x1e7e1, .green_reg = 0x1e7e1, .blue_reg = 0x1e7e1},
                    {.red_reg = 0x1e81f, .green_reg = 0x1e81f, .blue_reg = 0x1e81f},
                    {.red_reg = 0x1e85d, .green_reg = 0x1e85d, .blue_reg = 0x1e85d},
                    {.red_reg = 0x1e89b, .green_reg = 0x1e89b, .blue_reg = 0x1e89b},
                    {.red_reg = 0x1e8da, .green_reg = 0x1e8da, .blue_reg = 0x1e8da},
                    {.red_reg = 0x1e919, .green_reg = 0x1e919, .blue_reg = 0x1e919},
                    {.red_reg = 0x1e958, .green_reg = 0x1e958, .blue_reg = 0x1e958},
                    {.red_reg = 0x1e998, .green_reg = 0x1e998, .blue_reg = 0x1e998},
                    {.red_reg = 0x1e9d8, .green_reg = 0x1e9d8, .blue_reg = 0x1e9d8},
                    {.red_reg = 0x1ea18, .green_reg = 0x1ea18, .blue_reg = 0x1ea18},
                    {.red_reg = 0x1ea59, .green_reg = 0x1ea59, .blue_reg = 0x1ea59},
                    {.red_reg = 0x1ea9a, .green_reg = 0x1ea9a, .blue_reg = 0x1ea9a},
                    {.red_reg = 0x1eadc, .green_reg = 0x1eadc, .blue_reg = 0x1eadc},
                    {.red_reg = 0x1eb1e, .green_reg = 0x1eb1e, .blue_reg = 0x1eb1e},
                    {.red_reg = 0x1eb60, .green_reg = 0x1eb60, .blue_reg = 0x1eb60},
                    {.red_reg = 0x1eba3, .green_reg = 0x1eba3, .blue_reg = 0x1eba3},
                    {.red_reg = 0x1ebe6, .green_reg = 0x1ebe6, .blue_reg = 0x1ebe6},
                    {.red_reg = 0x1ec29, .green_reg = 0x1ec29, .blue_reg = 0x1ec29},
                    {.red_reg = 0x1ec6d, .green_reg = 0x1ec6d, .blue_reg = 0x1ec6d},
                    {.red_reg = 0x1ecb1, .green_reg = 0x1ecb1, .blue_reg = 0x1ecb1},
                    {.red_reg = 0x1ecf5, .green_reg = 0x1ecf5, .blue_reg = 0x1ecf5},
                    {.red_reg = 0x1ed3a, .green_reg = 0x1ed3a, .blue_reg = 0x1ed3a},
                    {.red_reg = 0x1ed80, .green_reg = 0x1ed80, .blue_reg = 0x1ed80},
                    {.red_reg = 0x1edc5, .green_reg = 0x1edc5, .blue_reg = 0x1edc5},
                    {.red_reg = 0x1ee0b, .green_reg = 0x1ee0b, .blue_reg = 0x1ee0b},
                    {.red_reg = 0x1ee51, .green_reg = 0x1ee51, .blue_reg = 0x1ee51},
                    {.red_reg = 0x1ee98, .green_reg = 0x1ee98, .blue_reg = 0x1ee98},
                    {.red_reg = 0x1eedf, .green_reg = 0x1eedf, .blue_reg = 0x1eedf},
                    {.red_reg = 0x1ef27, .green_reg = 0x1ef27, .blue_reg = 0x1ef27},
                    {.red_reg = 0x1ef6f, .green_reg = 0x1ef6f, .blue_reg = 0x1ef6f},
                    {.red_reg = 0x1efb7, .green_reg = 0x1efb7, .blue_reg = 0x1efb7},
                    {.red_reg = 0x1f000, .green_reg = 0x1f000, .blue_reg = 0x1f000},
                    {.red_reg = 0x0, .green_reg = 0x0, .blue_reg = 0x0},
                    {.red_reg = 0x0, .green_reg = 0x0, .blue_reg = 0x0}}},
        {.hw_points_num       = NUM_OF_LUT_DATA_DEGAM,
            .arr_curve_points = {{0x0, 0x0}, {0x1, 0x0}, {0x2, 0x1}, {0x4, 0x2}, {0x8, 0x3},
                {0x10, 0x4}, {0x20, 0x5}, {0x40, 0x6}, {0x80, 0x7}, {0x0, 0x0}, {0x0, 0x0},
                {0x0, 0x0}, {0x0, 0x0}, {0x0, 0x0}, {0x0, 0x0}, {0x0, 0x0}, {0x0, 0x0}, {0x0, 0x0},
                {0x0, 0x0}, {0x0, 0x0}, {0x0, 0x0}, {0x0, 0x0}, {0x0, 0x0}, {0x0, 0x0}, {0x0, 0x0},
                {0x0, 0x0}, {0x0, 0x0}, {0x0, 0x0}, {0x0, 0x0}, {0x0, 0x0}, {0x0, 0x0}, {0x0, 0x0},
                {0x0, 0x0}, {0x0, 0x0}},
            .corner_points    = {{.red.custom_float_x          = 0x16000,
                                     .red.custom_float_y       = 0x0,
                                     .red.custom_float_slope   = 0x1251c,
                                     .green.custom_float_x     = 0x16000,
                                     .green.custom_float_y     = 0x0,
                                     .green.custom_float_slope = 0x1251c,
                                     .blue.custom_float_x      = 0x16000,
                                     .blue.custom_float_y      = 0x0,
                                     .blue.custom_float_slope  = 0x1251c},
                   {.red.custom_float_x          = 0x7c00,
                       .red.custom_float_y       = 0x1f000,
                       .red.custom_float_slope   = 0x0,
                       .green.custom_float_x     = 0x7c00,
                       .green.custom_float_y     = 0x1f000,
                       .green.custom_float_slope = 0x0,
                       .blue.custom_float_x      = 0x7c00,
                       .blue.custom_float_y      = 0x1f000,
                       .blue.custom_float_slope  = 0x0}},
            .rgb_resulted     = {{.red_reg = 0x951c, .green_reg = 0x951c, .blue_reg = 0x951c},
                    {.red_reg = 0xbbdc, .green_reg = 0xbbdc, .blue_reg = 0xbbdc},
                    {.red_reg = 0xe261, .green_reg = 0xe261, .blue_reg = 0xe261},
                    {.red_reg = 0xf851, .green_reg = 0xf851, .blue_reg = 0xf851},
                    {.red_reg = 0x10840, .green_reg = 0x10840, .blue_reg = 0x10840},
                    {.red_reg = 0x114b7, .green_reg = 0x114b7, .blue_reg = 0x114b7},
                    {.red_reg = 0x1200b, .green_reg = 0x1200b, .blue_reg = 0x1200b},
                    {.red_reg = 0x12739, .green_reg = 0x12739, .blue_reg = 0x12739},
                    {.red_reg = 0x13000, .green_reg = 0x13000, .blue_reg = 0x13000},
                    {.red_reg = 0x1353a, .green_reg = 0x1353a, .blue_reg = 0x1353a},
                    {.red_reg = 0x13b55, .green_reg = 0x13b55, .blue_reg = 0x13b55},
                    {.red_reg = 0x1412e, .green_reg = 0x1412e, .blue_reg = 0x1412e},
                    {.red_reg = 0x1452b, .green_reg = 0x1452b, .blue_reg = 0x1452b},
                    {.red_reg = 0x149a7, .green_reg = 0x149a7, .blue_reg = 0x149a7},
                    {.red_reg = 0x14ea5, .green_reg = 0x14ea5, .blue_reg = 0x14ea5},
                    {.red_reg = 0x15215, .green_reg = 0x15215, .blue_reg = 0x15215},
                    {.red_reg = 0x1551c, .green_reg = 0x1551c, .blue_reg = 0x1551c},
                    {.red_reg = 0x1586b, .green_reg = 0x1586b, .blue_reg = 0x1586b},
                    {.red_reg = 0x15c02, .green_reg = 0x15c02, .blue_reg = 0x15c02},
                    {.red_reg = 0x15fe3, .green_reg = 0x15fe3, .blue_reg = 0x15fe3},
                    {.red_reg = 0x16208, .green_reg = 0x16208, .blue_reg = 0x16208},
                    {.red_reg = 0x16446, .green_reg = 0x16446, .blue_reg = 0x16446},
                    {.red_reg = 0x166ab, .green_reg = 0x166ab, .blue_reg = 0x166ab},
                    {.red_reg = 0x16938, .green_reg = 0x16938, .blue_reg = 0x16938},
                    {.red_reg = 0x16bee, .green_reg = 0x16bee, .blue_reg = 0x16bee},
                    {.red_reg = 0x16ece, .green_reg = 0x16ece, .blue_reg = 0x16ece},
                    {.red_reg = 0x170ec, .green_reg = 0x170ec, .blue_reg = 0x170ec},
                    {.red_reg = 0x17287, .green_reg = 0x17287, .blue_reg = 0x17287},
                    {.red_reg = 0x17438, .green_reg = 0x17438, .blue_reg = 0x17438},
                    {.red_reg = 0x175fe, .green_reg = 0x175fe, .blue_reg = 0x175fe},
                    {.red_reg = 0x177dc, .green_reg = 0x177dc, .blue_reg = 0x177dc},
                    {.red_reg = 0x179d0, .green_reg = 0x179d0, .blue_reg = 0x179d0},
                    {.red_reg = 0x17bdb, .green_reg = 0x17bdb, .blue_reg = 0x17bdb},
                    {.red_reg = 0x17dfe, .green_reg = 0x17dfe, .blue_reg = 0x17dfe},
                    {.red_reg = 0x1801c, .green_reg = 0x1801c, .blue_reg = 0x1801c},
                    {.red_reg = 0x18145, .green_reg = 0x18145, .blue_reg = 0x18145},
                    {.red_reg = 0x1827a, .green_reg = 0x1827a, .blue_reg = 0x1827a},
                    {.red_reg = 0x183bc, .green_reg = 0x183bc, .blue_reg = 0x183bc},
                    {.red_reg = 0x1850a, .green_reg = 0x1850a, .blue_reg = 0x1850a},
                    {.red_reg = 0x18664, .green_reg = 0x18664, .blue_reg = 0x18664},
                    {.red_reg = 0x187cb, .green_reg = 0x187cb, .blue_reg = 0x187cb},
                    {.red_reg = 0x1893f, .green_reg = 0x1893f, .blue_reg = 0x1893f},
                    {.red_reg = 0x18ac0, .green_reg = 0x18ac0, .blue_reg = 0x18ac0},
                    {.red_reg = 0x18c4e, .green_reg = 0x18c4e, .blue_reg = 0x18c4e},
                    {.red_reg = 0x18de9, .green_reg = 0x18de9, .blue_reg = 0x18de9},
                    {.red_reg = 0x18f91, .green_reg = 0x18f91, .blue_reg = 0x18f91},
                    {.red_reg = 0x190a3, .green_reg = 0x190a3, .blue_reg = 0x190a3},
                    {.red_reg = 0x19185, .green_reg = 0x19185, .blue_reg = 0x19185},
                    {.red_reg = 0x1926d, .green_reg = 0x1926d, .blue_reg = 0x1926d},
                    {.red_reg = 0x1935d, .green_reg = 0x1935d, .blue_reg = 0x1935d},
                    {.red_reg = 0x19453, .green_reg = 0x19453, .blue_reg = 0x19453},
                    {.red_reg = 0x19550, .green_reg = 0x19550, .blue_reg = 0x19550},
                    {.red_reg = 0x19655, .green_reg = 0x19655, .blue_reg = 0x19655},
                    {.red_reg = 0x19760, .green_reg = 0x19760, .blue_reg = 0x19760},
                    {.red_reg = 0x19873, .green_reg = 0x19873, .blue_reg = 0x19873},
                    {.red_reg = 0x1998c, .green_reg = 0x1998c, .blue_reg = 0x1998c},
                    {.red_reg = 0x19aad, .green_reg = 0x19aad, .blue_reg = 0x19aad},
                    {.red_reg = 0x19bd6, .green_reg = 0x19bd6, .blue_reg = 0x19bd6},
                    {.red_reg = 0x19d06, .green_reg = 0x19d06, .blue_reg = 0x19d06},
                    {.red_reg = 0x19e3d, .green_reg = 0x19e3d, .blue_reg = 0x19e3d},
                    {.red_reg = 0x19f7b, .green_reg = 0x19f7b, .blue_reg = 0x19f7b},
                    {.red_reg = 0x1a061, .green_reg = 0x1a061, .blue_reg = 0x1a061},
                    {.red_reg = 0x1a107, .green_reg = 0x1a107, .blue_reg = 0x1a107},
                    {.red_reg = 0x1a1b2, .green_reg = 0x1a1b2, .blue_reg = 0x1a1b2},
                    {.red_reg = 0x1a261, .green_reg = 0x1a261, .blue_reg = 0x1a261},
                    {.red_reg = 0x1a313, .green_reg = 0x1a313, .blue_reg = 0x1a313},
                    {.red_reg = 0x1a3c9, .green_reg = 0x1a3c9, .blue_reg = 0x1a3c9},
                    {.red_reg = 0x1a483, .green_reg = 0x1a483, .blue_reg = 0x1a483},
                    {.red_reg = 0x1a541, .green_reg = 0x1a541, .blue_reg = 0x1a541},
                    {.red_reg = 0x1a604, .green_reg = 0x1a604, .blue_reg = 0x1a604},
                    {.red_reg = 0x1a6ca, .green_reg = 0x1a6ca, .blue_reg = 0x1a6ca},
                    {.red_reg = 0x1a794, .green_reg = 0x1a794, .blue_reg = 0x1a794},
                    {.red_reg = 0x1a862, .green_reg = 0x1a862, .blue_reg = 0x1a862},
                    {.red_reg = 0x1a934, .green_reg = 0x1a934, .blue_reg = 0x1a934},
                    {.red_reg = 0x1aa0a, .green_reg = 0x1aa0a, .blue_reg = 0x1aa0a},
                    {.red_reg = 0x1aae4, .green_reg = 0x1aae4, .blue_reg = 0x1aae4},
                    {.red_reg = 0x1abc3, .green_reg = 0x1abc3, .blue_reg = 0x1abc3},
                    {.red_reg = 0x1aca5, .green_reg = 0x1aca5, .blue_reg = 0x1aca5},
                    {.red_reg = 0x1ad8c, .green_reg = 0x1ad8c, .blue_reg = 0x1ad8c},
                    {.red_reg = 0x1ae77, .green_reg = 0x1ae77, .blue_reg = 0x1ae77},
                    {.red_reg = 0x1af66, .green_reg = 0x1af66, .blue_reg = 0x1af66},
                    {.red_reg = 0x1b02c, .green_reg = 0x1b02c, .blue_reg = 0x1b02c},
                    {.red_reg = 0x1b0a8, .green_reg = 0x1b0a8, .blue_reg = 0x1b0a8},
                    {.red_reg = 0x1b126, .green_reg = 0x1b126, .blue_reg = 0x1b126},
                    {.red_reg = 0x1b1a6, .green_reg = 0x1b1a6, .blue_reg = 0x1b1a6},
                    {.red_reg = 0x1b228, .green_reg = 0x1b228, .blue_reg = 0x1b228},
                    {.red_reg = 0x1b2ac, .green_reg = 0x1b2ac, .blue_reg = 0x1b2ac},
                    {.red_reg = 0x1b333, .green_reg = 0x1b333, .blue_reg = 0x1b333},
                    {.red_reg = 0x1b3bb, .green_reg = 0x1b3bb, .blue_reg = 0x1b3bb},
                    {.red_reg = 0x1b446, .green_reg = 0x1b446, .blue_reg = 0x1b446},
                    {.red_reg = 0x1b4d3, .green_reg = 0x1b4d3, .blue_reg = 0x1b4d3},
                    {.red_reg = 0x1b563, .green_reg = 0x1b563, .blue_reg = 0x1b563},
                    {.red_reg = 0x1b5f4, .green_reg = 0x1b5f4, .blue_reg = 0x1b5f4},
                    {.red_reg = 0x1b688, .green_reg = 0x1b688, .blue_reg = 0x1b688},
                    {.red_reg = 0x1b71e, .green_reg = 0x1b71e, .blue_reg = 0x1b71e},
                    {.red_reg = 0x1b7b6, .green_reg = 0x1b7b6, .blue_reg = 0x1b7b6},
                    {.red_reg = 0x1b851, .green_reg = 0x1b851, .blue_reg = 0x1b851},
                    {.red_reg = 0x1b8ed, .green_reg = 0x1b8ed, .blue_reg = 0x1b8ed},
                    {.red_reg = 0x1b98d, .green_reg = 0x1b98d, .blue_reg = 0x1b98d},
                    {.red_reg = 0x1ba2e, .green_reg = 0x1ba2e, .blue_reg = 0x1ba2e},
                    {.red_reg = 0x1bad2, .green_reg = 0x1bad2, .blue_reg = 0x1bad2},
                    {.red_reg = 0x1bb77, .green_reg = 0x1bb77, .blue_reg = 0x1bb77},
                    {.red_reg = 0x1bc20, .green_reg = 0x1bc20, .blue_reg = 0x1bc20},
                    {.red_reg = 0x1bcca, .green_reg = 0x1bcca, .blue_reg = 0x1bcca},
                    {.red_reg = 0x1bd77, .green_reg = 0x1bd77, .blue_reg = 0x1bd77},
                    {.red_reg = 0x1be26, .green_reg = 0x1be26, .blue_reg = 0x1be26},
                    {.red_reg = 0x1bed8, .green_reg = 0x1bed8, .blue_reg = 0x1bed8},
                    {.red_reg = 0x1bf8c, .green_reg = 0x1bf8c, .blue_reg = 0x1bf8c},
                    {.red_reg = 0x1c021, .green_reg = 0x1c021, .blue_reg = 0x1c021},
                    {.red_reg = 0x1c07d, .green_reg = 0x1c07d, .blue_reg = 0x1c07d},
                    {.red_reg = 0x1c0db, .green_reg = 0x1c0db, .blue_reg = 0x1c0db},
                    {.red_reg = 0x1c13a, .green_reg = 0x1c13a, .blue_reg = 0x1c13a},
                    {.red_reg = 0x1c19a, .green_reg = 0x1c19a, .blue_reg = 0x1c19a},
                    {.red_reg = 0x1c1fb, .green_reg = 0x1c1fb, .blue_reg = 0x1c1fb},
                    {.red_reg = 0x1c25d, .green_reg = 0x1c25d, .blue_reg = 0x1c25d},
                    {.red_reg = 0x1c2c1, .green_reg = 0x1c2c1, .blue_reg = 0x1c2c1},
                    {.red_reg = 0x1c325, .green_reg = 0x1c325, .blue_reg = 0x1c325},
                    {.red_reg = 0x1c38c, .green_reg = 0x1c38c, .blue_reg = 0x1c38c},
                    {.red_reg = 0x1c3f3, .green_reg = 0x1c3f3, .blue_reg = 0x1c3f3},
                    {.red_reg = 0x1c45b, .green_reg = 0x1c45b, .blue_reg = 0x1c45b},
                    {.red_reg = 0x1c4c5, .green_reg = 0x1c4c5, .blue_reg = 0x1c4c5},
                    {.red_reg = 0x1c530, .green_reg = 0x1c530, .blue_reg = 0x1c530},
                    {.red_reg = 0x1c59c, .green_reg = 0x1c59c, .blue_reg = 0x1c59c},
                    {.red_reg = 0x1c60a, .green_reg = 0x1c60a, .blue_reg = 0x1c60a},
                    {.red_reg = 0x1c678, .green_reg = 0x1c678, .blue_reg = 0x1c678},
                    {.red_reg = 0x1c6e8, .green_reg = 0x1c6e8, .blue_reg = 0x1c6e8},
                    {.red_reg = 0x1c75a, .green_reg = 0x1c75a, .blue_reg = 0x1c75a},
                    {.red_reg = 0x1c7cc, .green_reg = 0x1c7cc, .blue_reg = 0x1c7cc},
                    {.red_reg = 0x1c840, .green_reg = 0x1c840, .blue_reg = 0x1c840},
                    {.red_reg = 0x1c8b5, .green_reg = 0x1c8b5, .blue_reg = 0x1c8b5},
                    {.red_reg = 0x1c92b, .green_reg = 0x1c92b, .blue_reg = 0x1c92b},
                    {.red_reg = 0x1c9a3, .green_reg = 0x1c9a3, .blue_reg = 0x1c9a3},
                    {.red_reg = 0x1ca1c, .green_reg = 0x1ca1c, .blue_reg = 0x1ca1c},
                    {.red_reg = 0x1ca96, .green_reg = 0x1ca96, .blue_reg = 0x1ca96},
                    {.red_reg = 0x1cb11, .green_reg = 0x1cb11, .blue_reg = 0x1cb11},
                    {.red_reg = 0x1cb8e, .green_reg = 0x1cb8e, .blue_reg = 0x1cb8e},
                    {.red_reg = 0x1cc0c, .green_reg = 0x1cc0c, .blue_reg = 0x1cc0c},
                    {.red_reg = 0x1cc8c, .green_reg = 0x1cc8c, .blue_reg = 0x1cc8c},
                    {.red_reg = 0x1cd0c, .green_reg = 0x1cd0c, .blue_reg = 0x1cd0c},
                    {.red_reg = 0x1cd8e, .green_reg = 0x1cd8e, .blue_reg = 0x1cd8e},
                    {.red_reg = 0x1ce12, .green_reg = 0x1ce12, .blue_reg = 0x1ce12},
                    {.red_reg = 0x1ce96, .green_reg = 0x1ce96, .blue_reg = 0x1ce96},
                    {.red_reg = 0x1cf1c, .green_reg = 0x1cf1c, .blue_reg = 0x1cf1c},
                    {.red_reg = 0x1cfa3, .green_reg = 0x1cfa3, .blue_reg = 0x1cfa3},
                    {.red_reg = 0x1d016, .green_reg = 0x1d016, .blue_reg = 0x1d016},
                    {.red_reg = 0x1d05b, .green_reg = 0x1d05b, .blue_reg = 0x1d05b},
                    {.red_reg = 0x1d0a0, .green_reg = 0x1d0a0, .blue_reg = 0x1d0a0},
                    {.red_reg = 0x1d0e7, .green_reg = 0x1d0e7, .blue_reg = 0x1d0e7},
                    {.red_reg = 0x1d12e, .green_reg = 0x1d12e, .blue_reg = 0x1d12e},
                    {.red_reg = 0x1d175, .green_reg = 0x1d175, .blue_reg = 0x1d175},
                    {.red_reg = 0x1d1be, .green_reg = 0x1d1be, .blue_reg = 0x1d1be},
                    {.red_reg = 0x1d207, .green_reg = 0x1d207, .blue_reg = 0x1d207},
                    {.red_reg = 0x1d250, .green_reg = 0x1d250, .blue_reg = 0x1d250},
                    {.red_reg = 0x1d29b, .green_reg = 0x1d29b, .blue_reg = 0x1d29b},
                    {.red_reg = 0x1d2e6, .green_reg = 0x1d2e6, .blue_reg = 0x1d2e6},
                    {.red_reg = 0x1d332, .green_reg = 0x1d332, .blue_reg = 0x1d332},
                    {.red_reg = 0x1d37e, .green_reg = 0x1d37e, .blue_reg = 0x1d37e},
                    {.red_reg = 0x1d3cb, .green_reg = 0x1d3cb, .blue_reg = 0x1d3cb},
                    {.red_reg = 0x1d419, .green_reg = 0x1d419, .blue_reg = 0x1d419},
                    {.red_reg = 0x1d467, .green_reg = 0x1d467, .blue_reg = 0x1d467},
                    {.red_reg = 0x1d4b7, .green_reg = 0x1d4b7, .blue_reg = 0x1d4b7},
                    {.red_reg = 0x1d507, .green_reg = 0x1d507, .blue_reg = 0x1d507},
                    {.red_reg = 0x1d557, .green_reg = 0x1d557, .blue_reg = 0x1d557},
                    {.red_reg = 0x1d5a8, .green_reg = 0x1d5a8, .blue_reg = 0x1d5a8},
                    {.red_reg = 0x1d5fa, .green_reg = 0x1d5fa, .blue_reg = 0x1d5fa},
                    {.red_reg = 0x1d64d, .green_reg = 0x1d64d, .blue_reg = 0x1d64d},
                    {.red_reg = 0x1d6a0, .green_reg = 0x1d6a0, .blue_reg = 0x1d6a0},
                    {.red_reg = 0x1d6f5, .green_reg = 0x1d6f5, .blue_reg = 0x1d6f5},
                    {.red_reg = 0x1d749, .green_reg = 0x1d749, .blue_reg = 0x1d749},
                    {.red_reg = 0x1d79f, .green_reg = 0x1d79f, .blue_reg = 0x1d79f},
                    {.red_reg = 0x1d7f5, .green_reg = 0x1d7f5, .blue_reg = 0x1d7f5},
                    {.red_reg = 0x1d84c, .green_reg = 0x1d84c, .blue_reg = 0x1d84c},
                    {.red_reg = 0x1d8a4, .green_reg = 0x1d8a4, .blue_reg = 0x1d8a4},
                    {.red_reg = 0x1d8fc, .green_reg = 0x1d8fc, .blue_reg = 0x1d8fc},
                    {.red_reg = 0x1d955, .green_reg = 0x1d955, .blue_reg = 0x1d955},
                    {.red_reg = 0x1d9af, .green_reg = 0x1d9af, .blue_reg = 0x1d9af},
                    {.red_reg = 0x1da0a, .green_reg = 0x1da0a, .blue_reg = 0x1da0a},
                    {.red_reg = 0x1da65, .green_reg = 0x1da65, .blue_reg = 0x1da65},
                    {.red_reg = 0x1dac1, .green_reg = 0x1dac1, .blue_reg = 0x1dac1},
                    {.red_reg = 0x1db1e, .green_reg = 0x1db1e, .blue_reg = 0x1db1e},
                    {.red_reg = 0x1db7b, .green_reg = 0x1db7b, .blue_reg = 0x1db7b},
                    {.red_reg = 0x1dbd9, .green_reg = 0x1dbd9, .blue_reg = 0x1dbd9},
                    {.red_reg = 0x1dc38, .green_reg = 0x1dc38, .blue_reg = 0x1dc38},
                    {.red_reg = 0x1dc98, .green_reg = 0x1dc98, .blue_reg = 0x1dc98},
                    {.red_reg = 0x1dcf8, .green_reg = 0x1dcf8, .blue_reg = 0x1dcf8},
                    {.red_reg = 0x1dd59, .green_reg = 0x1dd59, .blue_reg = 0x1dd59},
                    {.red_reg = 0x1ddbb, .green_reg = 0x1ddbb, .blue_reg = 0x1ddbb},
                    {.red_reg = 0x1de1e, .green_reg = 0x1de1e, .blue_reg = 0x1de1e},
                    {.red_reg = 0x1de81, .green_reg = 0x1de81, .blue_reg = 0x1de81},
                    {.red_reg = 0x1dee5, .green_reg = 0x1dee5, .blue_reg = 0x1dee5},
                    {.red_reg = 0x1df4a, .green_reg = 0x1df4a, .blue_reg = 0x1df4a},
                    {.red_reg = 0x1dfaf, .green_reg = 0x1dfaf, .blue_reg = 0x1dfaf},
                    {.red_reg = 0x1e00b, .green_reg = 0x1e00b, .blue_reg = 0x1e00b},
                    {.red_reg = 0x1e03e, .green_reg = 0x1e03e, .blue_reg = 0x1e03e},
                    {.red_reg = 0x1e072, .green_reg = 0x1e072, .blue_reg = 0x1e072},
                    {.red_reg = 0x1e0a6, .green_reg = 0x1e0a6, .blue_reg = 0x1e0a6},
                    {.red_reg = 0x1e0db, .green_reg = 0x1e0db, .blue_reg = 0x1e0db},
                    {.red_reg = 0x1e110, .green_reg = 0x1e110, .blue_reg = 0x1e110},
                    {.red_reg = 0x1e145, .green_reg = 0x1e145, .blue_reg = 0x1e145},
                    {.red_reg = 0x1e17b, .green_reg = 0x1e17b, .blue_reg = 0x1e17b},
                    {.red_reg = 0x1e1b1, .green_reg = 0x1e1b1, .blue_reg = 0x1e1b1},
                    {.red_reg = 0x1e1e8, .green_reg = 0x1e1e8, .blue_reg = 0x1e1e8},
                    {.red_reg = 0x1e21f, .green_reg = 0x1e21f, .blue_reg = 0x1e21f},
                    {.red_reg = 0x1e256, .green_reg = 0x1e256, .blue_reg = 0x1e256},
                    {.red_reg = 0x1e28e, .green_reg = 0x1e28e, .blue_reg = 0x1e28e},
                    {.red_reg = 0x1e2c6, .green_reg = 0x1e2c6, .blue_reg = 0x1e2c6},
                    {.red_reg = 0x1e2fe, .green_reg = 0x1e2fe, .blue_reg = 0x1e2fe},
                    {.red_reg = 0x1e337, .green_reg = 0x1e337, .blue_reg = 0x1e337},
                    {.red_reg = 0x1e370, .green_reg = 0x1e370, .blue_reg = 0x1e370},
                    {.red_reg = 0x1e3aa, .green_reg = 0x1e3aa, .blue_reg = 0x1e3aa},
                    {.red_reg = 0x1e3e4, .green_reg = 0x1e3e4, .blue_reg = 0x1e3e4},
                    {.red_reg = 0x1e41f, .green_reg = 0x1e41f, .blue_reg = 0x1e41f},
                    {.red_reg = 0x1e459, .green_reg = 0x1e459, .blue_reg = 0x1e459},
                    {.red_reg = 0x1e494, .green_reg = 0x1e494, .blue_reg = 0x1e494},
                    {.red_reg = 0x1e4d0, .green_reg = 0x1e4d0, .blue_reg = 0x1e4d0},
                    {.red_reg = 0x1e50c, .green_reg = 0x1e50c, .blue_reg = 0x1e50c},
                    {.red_reg = 0x1e548, .green_reg = 0x1e548, .blue_reg = 0x1e548},
                    {.red_reg = 0x1e585, .green_reg = 0x1e585, .blue_reg = 0x1e585},
                    {.red_reg = 0x1e5c2, .green_reg = 0x1e5c2, .blue_reg = 0x1e5c2},
                    {.red_reg = 0x1e600, .green_reg = 0x1e600, .blue_reg = 0x1e600},
                    {.red_reg = 0x1e63e, .green_reg = 0x1e63e, .blue_reg = 0x1e63e},
                    {.red_reg = 0x1e67c, .green_reg = 0x1e67c, .blue_reg = 0x1e67c},
                    {.red_reg = 0x1e6bb, .green_reg = 0x1e6bb, .blue_reg = 0x1e6bb},
                    {.red_reg = 0x1e6fa, .green_reg = 0x1e6fa, .blue_reg = 0x1e6fa},
                    {.red_reg = 0x1e739, .green_reg = 0x1e739, .blue_reg = 0x1e739},
                    {.red_reg = 0x1e779, .green_reg = 0x1e779, .blue_reg = 0x1e779},
                    {.red_reg = 0x1e7b9, .green_reg = 0x1e7b9, .blue_reg = 0x1e7b9},
                    {.red_reg = 0x1e7fa, .green_reg = 0x1e7fa, .blue_reg = 0x1e7fa},
                    {.red_reg = 0x1e83b, .green_reg = 0x1e83b, .blue_reg = 0x1e83b},
                    {.red_reg = 0x1e87d, .green_reg = 0x1e87d, .blue_reg = 0x1e87d},
                    {.red_reg = 0x1e8bf, .green_reg = 0x1e8bf, .blue_reg = 0x1e8bf},
                    {.red_reg = 0x1e901, .green_reg = 0x1e901, .blue_reg = 0x1e901},
                    {.red_reg = 0x1e944, .green_reg = 0x1e944, .blue_reg = 0x1e944},
                    {.red_reg = 0x1e987, .green_reg = 0x1e987, .blue_reg = 0x1e987},
                    {.red_reg = 0x1e9ca, .green_reg = 0x1e9ca, .blue_reg = 0x1e9ca},
                    {.red_reg = 0x1ea0e, .green_reg = 0x1ea0e, .blue_reg = 0x1ea0e},
                    {.red_reg = 0x1ea53, .green_reg = 0x1ea53, .blue_reg = 0x1ea53},
                    {.red_reg = 0x1ea97, .green_reg = 0x1ea97, .blue_reg = 0x1ea97},
                    {.red_reg = 0x1eadc, .green_reg = 0x1eadc, .blue_reg = 0x1eadc},
                    {.red_reg = 0x1eb22, .green_reg = 0x1eb22, .blue_reg = 0x1eb22},
                    {.red_reg = 0x1eb68, .green_reg = 0x1eb68, .blue_reg = 0x1eb68},
                    {.red_reg = 0x1ebae, .green_reg = 0x1ebae, .blue_reg = 0x1ebae},
                    {.red_reg = 0x1ebf5, .green_reg = 0x1ebf5, .blue_reg = 0x1ebf5},
                    {.red_reg = 0x1ec3c, .green_reg = 0x1ec3c, .blue_reg = 0x1ec3c},
                    {.red_reg = 0x1ec84, .green_reg = 0x1ec84, .blue_reg = 0x1ec84},
                    {.red_reg = 0x1eccc, .green_reg = 0x1eccc, .blue_reg = 0x1eccc},
                    {.red_reg = 0x1ed14, .green_reg = 0x1ed14, .blue_reg = 0x1ed14},
                    {.red_reg = 0x1ed5d, .green_reg = 0x1ed5d, .blue_reg = 0x1ed5d},
                    {.red_reg = 0x1eda6, .green_reg = 0x1eda6, .blue_reg = 0x1eda6},
                    {.red_reg = 0x1edf0, .green_reg = 0x1edf0, .blue_reg = 0x1edf0},
                    {.red_reg = 0x1ee3a, .green_reg = 0x1ee3a, .blue_reg = 0x1ee3a},
                    {.red_reg = 0x1ee85, .green_reg = 0x1ee85, .blue_reg = 0x1ee85},
                    {.red_reg = 0x1eed0, .green_reg = 0x1eed0, .blue_reg = 0x1eed0},
                    {.red_reg = 0x1ef1b, .green_reg = 0x1ef1b, .blue_reg = 0x1ef1b},
                    {.red_reg = 0x1ef67, .green_reg = 0x1ef67, .blue_reg = 0x1ef67},
                    {.red_reg = 0x1efb3, .green_reg = 0x1efb3, .blue_reg = 0x1efb3},
                    {.red_reg = 0x1f000, .green_reg = 0x1f000, .blue_reg = 0x1f000},
                    {.red_reg = 0x0, .green_reg = 0x0, .blue_reg = 0x0},
                    {.red_reg = 0x0, .green_reg = 0x0, .blue_reg = 0x0}}},
        {.hw_points_num       = NUM_OF_LUT_DATA_DEGAM,
            .arr_curve_points = {{0x0, 0x0}, {0x1, 0x0}, {0x2, 0x1}, {0x4, 0x2}, {0x8, 0x3},
                {0x10, 0x4}, {0x20, 0x5}, {0x40, 0x6}, {0x80, 0x7}, {0x0, 0x0}, {0x0, 0x0},
                {0x0, 0x0}, {0x0, 0x0}, {0x0, 0x0}, {0x0, 0x0}, {0x0, 0x0}, {0x0, 0x0}, {0x0, 0x0},
                {0x0, 0x0}, {0x0, 0x0}, {0x0, 0x0}, {0x0, 0x0}, {0x0, 0x0}, {0x0, 0x0}, {0x0, 0x0},
                {0x0, 0x0}, {0x0, 0x0}, {0x0, 0x0}, {0x0, 0x0}, {0x0, 0x0}, {0x0, 0x0}, {0x0, 0x0},
                {0x0, 0x0}, {0x0, 0x0}},
            .corner_points    = {{.red.custom_float_x          = 0x16000,
                                     .red.custom_float_y       = 0x0,
                                     .red.custom_float_slope   = 0xdc00,
                                     .green.custom_float_x     = 0x16000,
                                     .green.custom_float_y     = 0x0,
                                     .green.custom_float_slope = 0xdc00,
                                     .blue.custom_float_x      = 0x16000,
                                     .blue.custom_float_y      = 0x0,
                                     .blue.custom_float_slope  = 0xdc00},
                   {.red.custom_float_x          = 0x7c00,
                       .red.custom_float_y       = 0x1f000,
                       .red.custom_float_slope   = 0x0,
                       .green.custom_float_x     = 0x7c00,
                       .green.custom_float_y     = 0x1f000,
                       .green.custom_float_slope = 0x0,
                       .blue.custom_float_x      = 0x7c00,
                       .blue.custom_float_y      = 0x1f000,
                       .blue.custom_float_slope  = 0x0}},
            .rgb_resulted = {{.red_reg = 0x4c00, .green_reg = 0x4c00, .blue_reg = 0x4c00},
                    {.red_reg = 0x6720, .green_reg = 0x6720, .blue_reg = 0x6720},
                    {.red_reg = 0x83c0, .green_reg = 0x83c0, .blue_reg = 0x83c0},
                    {.red_reg = 0x94d0, .green_reg = 0x94d0, .blue_reg = 0x94d0},
                    {.red_reg = 0xa1f8, .green_reg = 0xa1f8, .blue_reg = 0xa1f8},
                    {.red_reg = 0xabc4, .green_reg = 0xabc4, .blue_reg = 0xabc4},
                    {.red_reg = 0xb3fa, .green_reg = 0xb3fa, .blue_reg = 0xb3fa},
                    {.red_reg = 0xbb5c, .green_reg = 0xbb5c, .blue_reg = 0xbb5c},
                    {.red_reg = 0xc20f, .green_reg = 0xc20f, .blue_reg = 0xc20f},
                    {.red_reg = 0xc72e, .green_reg = 0xc72e, .blue_reg = 0xc72e},
                    {.red_reg = 0xcd18, .green_reg = 0xcd18, .blue_reg = 0xcd18},
                    {.red_reg = 0xd1ed, .green_reg = 0xd1ed, .blue_reg = 0xd1ed},
                    {.red_reg = 0xd5c1, .green_reg = 0xd5c1, .blue_reg = 0xd5c1},
                    {.red_reg = 0xda11, .green_reg = 0xda11, .blue_reg = 0xda11},
                    {.red_reg = 0xdee4, .green_reg = 0xdee4, .blue_reg = 0xdee4},
                    {.red_reg = 0xe221, .green_reg = 0xe221, .blue_reg = 0xe221},
                    {.red_reg = 0xe51a, .green_reg = 0xe51a, .blue_reg = 0xe51a},
                    {.red_reg = 0xe861, .green_reg = 0xe861, .blue_reg = 0xe861},
                    {.red_reg = 0xebfb, .green_reg = 0xebfb, .blue_reg = 0xebfb},
                    {.red_reg = 0xefed, .green_reg = 0xefed, .blue_reg = 0xefed},
                    {.red_reg = 0xf21e, .green_reg = 0xf21e, .blue_reg = 0xf21e},
                    {.red_reg = 0xf476, .green_reg = 0xf476, .blue_reg = 0xf476},
                    {.red_reg = 0xf702, .green_reg = 0xf702, .blue_reg = 0xf702},
                    {.red_reg = 0xf9c5, .green_reg = 0xf9c5, .blue_reg = 0xf9c5},
                    {.red_reg = 0xfcc2, .green_reg = 0xfcc2, .blue_reg = 0xfcc2},
                    {.red_reg = 0xfffb, .green_reg = 0xfffb, .blue_reg = 0xfffb},
                    {.red_reg = 0x101b9, .green_reg = 0x101b9, .blue_reg = 0x101b9},
                    {.red_reg = 0x10397, .green_reg = 0x10397, .blue_reg = 0x10397},
                    {.red_reg = 0x10599, .green_reg = 0x10599, .blue_reg = 0x10599},
                    {.red_reg = 0x107bf, .green_reg = 0x107bf, .blue_reg = 0x107bf},
                    {.red_reg = 0x10a0c, .green_reg = 0x10a0c, .blue_reg = 0x10a0c},
                    {.red_reg = 0x10c82, .green_reg = 0x10c82, .blue_reg = 0x10c82},
                    {.red_reg = 0x10f23, .green_reg = 0x10f23, .blue_reg = 0x10f23},
                    {.red_reg = 0x110f8, .green_reg = 0x110f8, .blue_reg = 0x110f8},
                    {.red_reg = 0x11276, .green_reg = 0x11276, .blue_reg = 0x11276},
                    {.red_reg = 0x1140d, .green_reg = 0x1140d, .blue_reg = 0x1140d},
                    {.red_reg = 0x115be, .green_reg = 0x115be, .blue_reg = 0x115be},
                    {.red_reg = 0x1178a, .green_reg = 0x1178a, .blue_reg = 0x1178a},
                    {.red_reg = 0x11972, .green_reg = 0x11972, .blue_reg = 0x11972},
                    {.red_reg = 0x11b78, .green_reg = 0x11b78, .blue_reg = 0x11b78},
                    {.red_reg = 0x11d9c, .green_reg = 0x11d9c, .blue_reg = 0x11d9c},
                    {.red_reg = 0x11fe1, .green_reg = 0x11fe1, .blue_reg = 0x11fe1},
                    {.red_reg = 0x12124, .green_reg = 0x12124, .blue_reg = 0x12124},
                    {.red_reg = 0x12269, .green_reg = 0x12269, .blue_reg = 0x12269},
                    {.red_reg = 0x123c0, .green_reg = 0x123c0, .blue_reg = 0x123c0},
                    {.red_reg = 0x1252b, .green_reg = 0x1252b, .blue_reg = 0x1252b},
                    {.red_reg = 0x126aa, .green_reg = 0x126aa, .blue_reg = 0x126aa},
                    {.red_reg = 0x1283d, .green_reg = 0x1283d, .blue_reg = 0x1283d},
                    {.red_reg = 0x129e7, .green_reg = 0x129e7, .blue_reg = 0x129e7},
                    {.red_reg = 0x12ba7, .green_reg = 0x12ba7, .blue_reg = 0x12ba7},
                    {.red_reg = 0x12d7f, .green_reg = 0x12d7f, .blue_reg = 0x12d7f},
                    {.red_reg = 0x12f70, .green_reg = 0x12f70, .blue_reg = 0x12f70},
                    {.red_reg = 0x130bd, .green_reg = 0x130bd, .blue_reg = 0x130bd},
                    {.red_reg = 0x131d0, .green_reg = 0x131d0, .blue_reg = 0x131d0},
                    {.red_reg = 0x132f1, .green_reg = 0x132f1, .blue_reg = 0x132f1},
                    {.red_reg = 0x13420, .green_reg = 0x13420, .blue_reg = 0x13420},
                    {.red_reg = 0x1355f, .green_reg = 0x1355f, .blue_reg = 0x1355f},
                    {.red_reg = 0x136ad, .green_reg = 0x136ad, .blue_reg = 0x136ad},
                    {.red_reg = 0x1380c, .green_reg = 0x1380c, .blue_reg = 0x1380c},
                    {.red_reg = 0x1397c, .green_reg = 0x1397c, .blue_reg = 0x1397c},
                    {.red_reg = 0x13afe, .green_reg = 0x13afe, .blue_reg = 0x13afe},
                    {.red_reg = 0x13c93, .green_reg = 0x13c93, .blue_reg = 0x13c93},
                    {.red_reg = 0x13e3a, .green_reg = 0x13e3a, .blue_reg = 0x13e3a},
                    {.red_reg = 0x13ff6, .green_reg = 0x13ff6, .blue_reg = 0x13ff6},
                    {.red_reg = 0x140e3, .green_reg = 0x140e3, .blue_reg = 0x140e3},
                    {.red_reg = 0x141d6, .green_reg = 0x141d6, .blue_reg = 0x141d6},
                    {.red_reg = 0x142d5, .green_reg = 0x142d5, .blue_reg = 0x142d5},
                    {.red_reg = 0x143df, .green_reg = 0x143df, .blue_reg = 0x143df},
                    {.red_reg = 0x144f5, .green_reg = 0x144f5, .blue_reg = 0x144f5},
                    {.red_reg = 0x14618, .green_reg = 0x14618, .blue_reg = 0x14618},
                    {.red_reg = 0x14749, .green_reg = 0x14749, .blue_reg = 0x14749},
                    {.red_reg = 0x14887, .green_reg = 0x14887, .blue_reg = 0x14887},
                    {.red_reg = 0x149d3, .green_reg = 0x149d3, .blue_reg = 0x149d3},
                    {.red_reg = 0x14b2d, .green_reg = 0x14b2d, .blue_reg = 0x14b2d},
                    {.red_reg = 0x14c98, .green_reg = 0x14c98, .blue_reg = 0x14c98},
                    {.red_reg = 0x14e12, .green_reg = 0x14e12, .blue_reg = 0x14e12},
                    {.red_reg = 0x14f9c, .green_reg = 0x14f9c, .blue_reg = 0x14f9c},
                    {.red_reg = 0x1509c, .green_reg = 0x1509c, .blue_reg = 0x1509c},
                    {.red_reg = 0x15172, .green_reg = 0x15172, .blue_reg = 0x15172},
                    {.red_reg = 0x15252, .green_reg = 0x15252, .blue_reg = 0x15252},
                    {.red_reg = 0x1533c, .green_reg = 0x1533c, .blue_reg = 0x1533c},
                    {.red_reg = 0x15430, .green_reg = 0x15430, .blue_reg = 0x15430},
                    {.red_reg = 0x1552d, .green_reg = 0x1552d, .blue_reg = 0x1552d},
                    {.red_reg = 0x15636, .green_reg = 0x15636, .blue_reg = 0x15636},
                    {.red_reg = 0x1574a, .green_reg = 0x1574a, .blue_reg = 0x1574a},
                    {.red_reg = 0x15869, .green_reg = 0x15869, .blue_reg = 0x15869},
                    {.red_reg = 0x15994, .green_reg = 0x15994, .blue_reg = 0x15994},
                    {.red_reg = 0x15acc, .green_reg = 0x15acc, .blue_reg = 0x15acc},
                    {.red_reg = 0x15c10, .green_reg = 0x15c10, .blue_reg = 0x15c10},
                    {.red_reg = 0x15d62, .green_reg = 0x15d62, .blue_reg = 0x15d62},
                    {.red_reg = 0x15ec1, .green_reg = 0x15ec1, .blue_reg = 0x15ec1},
                    {.red_reg = 0x16017, .green_reg = 0x16017, .blue_reg = 0x16017},
                    {.red_reg = 0x160d6, .green_reg = 0x160d6, .blue_reg = 0x160d6},
                    {.red_reg = 0x1619c, .green_reg = 0x1619c, .blue_reg = 0x1619c},
                    {.red_reg = 0x1626a, .green_reg = 0x1626a, .blue_reg = 0x1626a},
                    {.red_reg = 0x16341, .green_reg = 0x16341, .blue_reg = 0x16341},
                    {.red_reg = 0x16420, .green_reg = 0x16420, .blue_reg = 0x16420},
                    {.red_reg = 0x16508, .green_reg = 0x16508, .blue_reg = 0x16508},
                    {.red_reg = 0x165f9, .green_reg = 0x165f9, .blue_reg = 0x165f9},
                    {.red_reg = 0x166f3, .green_reg = 0x166f3, .blue_reg = 0x166f3},
                    {.red_reg = 0x167f8, .green_reg = 0x167f8, .blue_reg = 0x167f8},
                    {.red_reg = 0x16907, .green_reg = 0x16907, .blue_reg = 0x16907},
                    {.red_reg = 0x16a21, .green_reg = 0x16a21, .blue_reg = 0x16a21},
                    {.red_reg = 0x16b45, .green_reg = 0x16b45, .blue_reg = 0x16b45},
                    {.red_reg = 0x16c75, .green_reg = 0x16c75, .blue_reg = 0x16c75},
                    {.red_reg = 0x16db1, .green_reg = 0x16db1, .blue_reg = 0x16db1},
                    {.red_reg = 0x16ef9, .green_reg = 0x16ef9, .blue_reg = 0x16ef9},
                    {.red_reg = 0x17027, .green_reg = 0x17027, .blue_reg = 0x17027},
                    {.red_reg = 0x170d8, .green_reg = 0x170d8, .blue_reg = 0x170d8},
                    {.red_reg = 0x17190, .green_reg = 0x17190, .blue_reg = 0x17190},
                    {.red_reg = 0x1724f, .green_reg = 0x1724f, .blue_reg = 0x1724f},
                    {.red_reg = 0x17315, .green_reg = 0x17315, .blue_reg = 0x17315},
                    {.red_reg = 0x173e3, .green_reg = 0x173e3, .blue_reg = 0x173e3},
                    {.red_reg = 0x174b9, .green_reg = 0x174b9, .blue_reg = 0x174b9},
                    {.red_reg = 0x17597, .green_reg = 0x17597, .blue_reg = 0x17597},
                    {.red_reg = 0x1767d, .green_reg = 0x1767d, .blue_reg = 0x1767d},
                    {.red_reg = 0x1776c, .green_reg = 0x1776c, .blue_reg = 0x1776c},
                    {.red_reg = 0x17864, .green_reg = 0x17864, .blue_reg = 0x17864},
                    {.red_reg = 0x17966, .green_reg = 0x17966, .blue_reg = 0x17966},
                    {.red_reg = 0x17a71, .green_reg = 0x17a71, .blue_reg = 0x17a71},
                    {.red_reg = 0x17b86, .green_reg = 0x17b86, .blue_reg = 0x17b86},
                    {.red_reg = 0x17ca6, .green_reg = 0x17ca6, .blue_reg = 0x17ca6},
                    {.red_reg = 0x17dd0, .green_reg = 0x17dd0, .blue_reg = 0x17dd0},
                    {.red_reg = 0x17f06, .green_reg = 0x17f06, .blue_reg = 0x17f06},
                    {.red_reg = 0x18023, .green_reg = 0x18023, .blue_reg = 0x18023},
                    {.red_reg = 0x180ca, .green_reg = 0x180ca, .blue_reg = 0x180ca},
                    {.red_reg = 0x18177, .green_reg = 0x18177, .blue_reg = 0x18177},
                    {.red_reg = 0x1822a, .green_reg = 0x1822a, .blue_reg = 0x1822a},
                    {.red_reg = 0x182e4, .green_reg = 0x182e4, .blue_reg = 0x182e4},
                    {.red_reg = 0x183a5, .green_reg = 0x183a5, .blue_reg = 0x183a5},
                    {.red_reg = 0x1846d, .green_reg = 0x1846d, .blue_reg = 0x1846d},
                    {.red_reg = 0x1853c, .green_reg = 0x1853c, .blue_reg = 0x1853c},
                    {.red_reg = 0x18613, .green_reg = 0x18613, .blue_reg = 0x18613},
                    {.red_reg = 0x186f2, .green_reg = 0x186f2, .blue_reg = 0x186f2},
                    {.red_reg = 0x187d9, .green_reg = 0x187d9, .blue_reg = 0x187d9},
                    {.red_reg = 0x188c8, .green_reg = 0x188c8, .blue_reg = 0x188c8},
                    {.red_reg = 0x189c1, .green_reg = 0x189c1, .blue_reg = 0x189c1},
                    {.red_reg = 0x18ac2, .green_reg = 0x18ac2, .blue_reg = 0x18ac2},
                    {.red_reg = 0x18bcd, .green_reg = 0x18bcd, .blue_reg = 0x18bcd},
                    {.red_reg = 0x18ce2, .green_reg = 0x18ce2, .blue_reg = 0x18ce2},
                    {.red_reg = 0x18e00, .green_reg = 0x18e00, .blue_reg = 0x18e00},
                    {.red_reg = 0x18f2a, .green_reg = 0x18f2a, .blue_reg = 0x18f2a},
                    {.red_reg = 0x1902f, .green_reg = 0x1902f, .blue_reg = 0x1902f},
                    {.red_reg = 0x190ce, .green_reg = 0x190ce, .blue_reg = 0x190ce},
                    {.red_reg = 0x19174, .green_reg = 0x19174, .blue_reg = 0x19174},
                    {.red_reg = 0x1921f, .green_reg = 0x1921f, .blue_reg = 0x1921f},
                    {.red_reg = 0x192d1, .green_reg = 0x192d1, .blue_reg = 0x192d1},
                    {.red_reg = 0x19389, .green_reg = 0x19389, .blue_reg = 0x19389},
                    {.red_reg = 0x19448, .green_reg = 0x19448, .blue_reg = 0x19448},
                    {.red_reg = 0x1950e, .green_reg = 0x1950e, .blue_reg = 0x1950e},
                    {.red_reg = 0x195db, .green_reg = 0x195db, .blue_reg = 0x195db},
                    {.red_reg = 0x196af, .green_reg = 0x196af, .blue_reg = 0x196af},
                    {.red_reg = 0x1978b, .green_reg = 0x1978b, .blue_reg = 0x1978b},
                    {.red_reg = 0x1986f, .green_reg = 0x1986f, .blue_reg = 0x1986f},
                    {.red_reg = 0x1995b, .green_reg = 0x1995b, .blue_reg = 0x1995b},
                    {.red_reg = 0x19a50, .green_reg = 0x19a50, .blue_reg = 0x19a50},
                    {.red_reg = 0x19b4e, .green_reg = 0x19b4e, .blue_reg = 0x19b4e},
                    {.red_reg = 0x19c55, .green_reg = 0x19c55, .blue_reg = 0x19c55},
                    {.red_reg = 0x19d65, .green_reg = 0x19d65, .blue_reg = 0x19d65},
                    {.red_reg = 0x19e7f, .green_reg = 0x19e7f, .blue_reg = 0x19e7f},
                    {.red_reg = 0x19fa3, .green_reg = 0x19fa3, .blue_reg = 0x19fa3},
                    {.red_reg = 0x1a069, .green_reg = 0x1a069, .blue_reg = 0x1a069},
                    {.red_reg = 0x1a106, .green_reg = 0x1a106, .blue_reg = 0x1a106},
                    {.red_reg = 0x1a1a8, .green_reg = 0x1a1a8, .blue_reg = 0x1a1a8},
                    {.red_reg = 0x1a251, .green_reg = 0x1a251, .blue_reg = 0x1a251},
                    {.red_reg = 0x1a2ff, .green_reg = 0x1a2ff, .blue_reg = 0x1a2ff},
                    {.red_reg = 0x1a3b4, .green_reg = 0x1a3b4, .blue_reg = 0x1a3b4},
                    {.red_reg = 0x1a46f, .green_reg = 0x1a46f, .blue_reg = 0x1a46f},
                    {.red_reg = 0x1a531, .green_reg = 0x1a531, .blue_reg = 0x1a531},
                    {.red_reg = 0x1a5fa, .green_reg = 0x1a5fa, .blue_reg = 0x1a5fa},
                    {.red_reg = 0x1a6ca, .green_reg = 0x1a6ca, .blue_reg = 0x1a6ca},
                    {.red_reg = 0x1a7a2, .green_reg = 0x1a7a2, .blue_reg = 0x1a7a2},
                    {.red_reg = 0x1a881, .green_reg = 0x1a881, .blue_reg = 0x1a881},
                    {.red_reg = 0x1a968, .green_reg = 0x1a968, .blue_reg = 0x1a968},
                    {.red_reg = 0x1aa58, .green_reg = 0x1aa58, .blue_reg = 0x1aa58},
                    {.red_reg = 0x1ab51, .green_reg = 0x1ab51, .blue_reg = 0x1ab51},
                    {.red_reg = 0x1ac52, .green_reg = 0x1ac52, .blue_reg = 0x1ac52},
                    {.red_reg = 0x1ad5d, .green_reg = 0x1ad5d, .blue_reg = 0x1ad5d},
                    {.red_reg = 0x1ae71, .green_reg = 0x1ae71, .blue_reg = 0x1ae71},
                    {.red_reg = 0x1af8f, .green_reg = 0x1af8f, .blue_reg = 0x1af8f},
                    {.red_reg = 0x1b05c, .green_reg = 0x1b05c, .blue_reg = 0x1b05c},
                    {.red_reg = 0x1b0f5, .green_reg = 0x1b0f5, .blue_reg = 0x1b0f5},
                    {.red_reg = 0x1b194, .green_reg = 0x1b194, .blue_reg = 0x1b194},
                    {.red_reg = 0x1b239, .green_reg = 0x1b239, .blue_reg = 0x1b239},
                    {.red_reg = 0x1b2e4, .green_reg = 0x1b2e4, .blue_reg = 0x1b2e4},
                    {.red_reg = 0x1b395, .green_reg = 0x1b395, .blue_reg = 0x1b395},
                    {.red_reg = 0x1b44c, .green_reg = 0x1b44c, .blue_reg = 0x1b44c},
                    {.red_reg = 0x1b50a, .green_reg = 0x1b50a, .blue_reg = 0x1b50a},
                    {.red_reg = 0x1b5cf, .green_reg = 0x1b5cf, .blue_reg = 0x1b5cf},
                    {.red_reg = 0x1b69b, .green_reg = 0x1b69b, .blue_reg = 0x1b69b},
                    {.red_reg = 0x1b76e, .green_reg = 0x1b76e, .blue_reg = 0x1b76e},
                    {.red_reg = 0x1b849, .green_reg = 0x1b849, .blue_reg = 0x1b849},
                    {.red_reg = 0x1b92c, .green_reg = 0x1b92c, .blue_reg = 0x1b92c},
                    {.red_reg = 0x1ba17, .green_reg = 0x1ba17, .blue_reg = 0x1ba17},
                    {.red_reg = 0x1bb0b, .green_reg = 0x1bb0b, .blue_reg = 0x1bb0b},
                    {.red_reg = 0x1bc07, .green_reg = 0x1bc07, .blue_reg = 0x1bc07},
                    {.red_reg = 0x1bd0d, .green_reg = 0x1bd0d, .blue_reg = 0x1bd0d},
                    {.red_reg = 0x1be1c, .green_reg = 0x1be1c, .blue_reg = 0x1be1c},
                    {.red_reg = 0x1bf35, .green_reg = 0x1bf35, .blue_reg = 0x1bf35},
                    {.red_reg = 0x1c02c, .green_reg = 0x1c02c, .blue_reg = 0x1c02c},
                    {.red_reg = 0x1c0c3, .green_reg = 0x1c0c3, .blue_reg = 0x1c0c3},
                    {.red_reg = 0x1c15f, .green_reg = 0x1c15f, .blue_reg = 0x1c15f},
                    {.red_reg = 0x1c201, .green_reg = 0x1c201, .blue_reg = 0x1c201},
                    {.red_reg = 0x1c2a9, .green_reg = 0x1c2a9, .blue_reg = 0x1c2a9},
                    {.red_reg = 0x1c358, .green_reg = 0x1c358, .blue_reg = 0x1c358},
                    {.red_reg = 0x1c40c, .green_reg = 0x1c40c, .blue_reg = 0x1c40c},
                    {.red_reg = 0x1c4c7, .green_reg = 0x1c4c7, .blue_reg = 0x1c4c7},
                    {.red_reg = 0x1c589, .green_reg = 0x1c589, .blue_reg = 0x1c589},
                    {.red_reg = 0x1c652, .green_reg = 0x1c652, .blue_reg = 0x1c652},
                    {.red_reg = 0x1c723, .green_reg = 0x1c723, .blue_reg = 0x1c723},
                    {.red_reg = 0x1c7fb, .green_reg = 0x1c7fb, .blue_reg = 0x1c7fb},
                    {.red_reg = 0x1c8db, .green_reg = 0x1c8db, .blue_reg = 0x1c8db},
                    {.red_reg = 0x1c9c3, .green_reg = 0x1c9c3, .blue_reg = 0x1c9c3},
                    {.red_reg = 0x1cab4, .green_reg = 0x1cab4, .blue_reg = 0x1cab4},
                    {.red_reg = 0x1cbae, .green_reg = 0x1cbae, .blue_reg = 0x1cbae},
                    {.red_reg = 0x1ccb1, .green_reg = 0x1ccb1, .blue_reg = 0x1ccb1},
                    {.red_reg = 0x1cdbe, .green_reg = 0x1cdbe, .blue_reg = 0x1cdbe},
                    {.red_reg = 0x1ced4, .green_reg = 0x1ced4, .blue_reg = 0x1ced4},
                    {.red_reg = 0x1cff5, .green_reg = 0x1cff5, .blue_reg = 0x1cff5},
                    {.red_reg = 0x1d090, .green_reg = 0x1d090, .blue_reg = 0x1d090},
                    {.red_reg = 0x1d12b, .green_reg = 0x1d12b, .blue_reg = 0x1d12b},
                    {.red_reg = 0x1d1cc, .green_reg = 0x1d1cc, .blue_reg = 0x1d1cc},
                    {.red_reg = 0x1d274, .green_reg = 0x1d274, .blue_reg = 0x1d274},
                    {.red_reg = 0x1d321, .green_reg = 0x1d321, .blue_reg = 0x1d321},
                    {.red_reg = 0x1d3d5, .green_reg = 0x1d3d5, .blue_reg = 0x1d3d5},
                    {.red_reg = 0x1d48f, .green_reg = 0x1d48f, .blue_reg = 0x1d48f},
                    {.red_reg = 0x1d551, .green_reg = 0x1d551, .blue_reg = 0x1d551},
                    {.red_reg = 0x1d61a, .green_reg = 0x1d61a, .blue_reg = 0x1d61a},
                    {.red_reg = 0x1d6ea, .green_reg = 0x1d6ea, .blue_reg = 0x1d6ea},
                    {.red_reg = 0x1d7c2, .green_reg = 0x1d7c2, .blue_reg = 0x1d7c2},
                    {.red_reg = 0x1d8a2, .green_reg = 0x1d8a2, .blue_reg = 0x1d8a2},
                    {.red_reg = 0x1d98b, .green_reg = 0x1d98b, .blue_reg = 0x1d98b},
                    {.red_reg = 0x1da7d, .green_reg = 0x1da7d, .blue_reg = 0x1da7d},
                    {.red_reg = 0x1db77, .green_reg = 0x1db77, .blue_reg = 0x1db77},
                    {.red_reg = 0x1dc7c, .green_reg = 0x1dc7c, .blue_reg = 0x1dc7c},
                    {.red_reg = 0x1dd8a, .green_reg = 0x1dd8a, .blue_reg = 0x1dd8a},
                    {.red_reg = 0x1dea2, .green_reg = 0x1dea2, .blue_reg = 0x1dea2},
                    {.red_reg = 0x1dfc5, .green_reg = 0x1dfc5, .blue_reg = 0x1dfc5},
                    {.red_reg = 0x1e079, .green_reg = 0x1e079, .blue_reg = 0x1e079},
                    {.red_reg = 0x1e116, .green_reg = 0x1e116, .blue_reg = 0x1e116},
                    {.red_reg = 0x1e1b9, .green_reg = 0x1e1b9, .blue_reg = 0x1e1b9},
                    {.red_reg = 0x1e262, .green_reg = 0x1e262, .blue_reg = 0x1e262},
                    {.red_reg = 0x1e312, .green_reg = 0x1e312, .blue_reg = 0x1e312},
                    {.red_reg = 0x1e3c8, .green_reg = 0x1e3c8, .blue_reg = 0x1e3c8},
                    {.red_reg = 0x1e486, .green_reg = 0x1e486, .blue_reg = 0x1e486},
                    {.red_reg = 0x1e54a, .green_reg = 0x1e54a, .blue_reg = 0x1e54a},
                    {.red_reg = 0x1e617, .green_reg = 0x1e617, .blue_reg = 0x1e617},
                    {.red_reg = 0x1e6eb, .green_reg = 0x1e6eb, .blue_reg = 0x1e6eb},
                    {.red_reg = 0x1e7c7, .green_reg = 0x1e7c7, .blue_reg = 0x1e7c7},
                    {.red_reg = 0x1e8ac, .green_reg = 0x1e8ac, .blue_reg = 0x1e8ac},
                    {.red_reg = 0x1e99a, .green_reg = 0x1e99a, .blue_reg = 0x1e99a},
                    {.red_reg = 0x1ea92, .green_reg = 0x1ea92, .blue_reg = 0x1ea92},
                    {.red_reg = 0x1eb93, .green_reg = 0x1eb93, .blue_reg = 0x1eb93},
                    {.red_reg = 0x1ec9e, .green_reg = 0x1ec9e, .blue_reg = 0x1ec9e},
                    {.red_reg = 0x1edb3, .green_reg = 0x1edb3, .blue_reg = 0x1edb3},
                    {.red_reg = 0x1eed4, .green_reg = 0x1eed4, .blue_reg = 0x1eed4},
                    {.red_reg = 0x1f000, .green_reg = 0x1f000, .blue_reg = 0x1f000},
                    {.red_reg = 0, .green_reg = 0, .blue_reg = 0},
                    {.red_reg = 0, .green_reg = 0, .blue_reg = 0}}},
        {.hw_points_num       = NUM_OF_LUT_DATA_DEGAM,
            .arr_curve_points = {{0x0, 0x0}, {0x1, 0x0}, {0x2, 0x1}, {0x4, 0x2}, {0x8, 0x3},
                {0x10, 0x4}, {0x20, 0x5}, {0x40, 0x6}, {0x80, 0x7}, {0x0, 0x0}, {0x0, 0x0},
                {0x0, 0x0}, {0x0, 0x0}, {0x0, 0x0}, {0x0, 0x0}, {0x0, 0x0}, {0x0, 0x0}, {0x0, 0x0},
                {0x0, 0x0}, {0x0, 0x0}, {0x0, 0x0}, {0x0, 0x0}, {0x0, 0x0}, {0x0, 0x0}, {0x0, 0x0},
                {0x0, 0x0}, {0x0, 0x0}, {0x0, 0x0}, {0x0, 0x0}, {0x0, 0x0}, {0x0, 0x0}, {0x0, 0x0},
                {0x0, 0x0}, {0x0, 0x0}},
            .corner_points    = {{.red.custom_float_x          = 0x16000,
                                     .red.custom_float_y       = 0x0,
                                     .red.custom_float_slope   = 0x1cc71,
                                     .green.custom_float_x     = 0x16000,
                                     .green.custom_float_y     = 0x0,
                                     .green.custom_float_slope = 0x1cc71,
                                     .blue.custom_float_x      = 0x16000,
                                     .blue.custom_float_y      = 0x0,
                                     .blue.custom_float_slope  = 0x1cc71},
                   {.red.custom_float_x          = 0x7c00,
                       .red.custom_float_y       = 0x1f000,
                       .red.custom_float_slope   = 0x0,
                       .green.custom_float_x     = 0x7c00,
                       .green.custom_float_y     = 0x1f000,
                       .green.custom_float_slope = 0x0,
                       .blue.custom_float_x      = 0x7c00,
                       .blue.custom_float_y      = 0x1f000,
                       .blue.custom_float_slope  = 0x0}},
            .rgb_resulted     = {{.red_reg = 0x13c71, .green_reg = 0x13c71, .blue_reg = 0x13c71},
                    {.red_reg = 0x14c71, .green_reg = 0x14c71, .blue_reg = 0x14c71},
                    {.red_reg = 0x15c71, .green_reg = 0x15c71, .blue_reg = 0x15c71},
                    {.red_reg = 0x16555, .green_reg = 0x16555, .blue_reg = 0x16555},
                    {.red_reg = 0x16c71, .green_reg = 0x16c71, .blue_reg = 0x16c71},
                    {.red_reg = 0x171c7, .green_reg = 0x171c7, .blue_reg = 0x171c7},
                    {.red_reg = 0x17555, .green_reg = 0x17555, .blue_reg = 0x17555},
                    {.red_reg = 0x178e3, .green_reg = 0x178e3, .blue_reg = 0x178e3},
                    {.red_reg = 0x17c71, .green_reg = 0x17c71, .blue_reg = 0x17c71},
                    {.red_reg = 0x18000, .green_reg = 0x18000, .blue_reg = 0x18000},
                    {.red_reg = 0x181c7, .green_reg = 0x181c7, .blue_reg = 0x181c7},
                    {.red_reg = 0x1838e, .green_reg = 0x1838e, .blue_reg = 0x1838e},
                    {.red_reg = 0x18555, .green_reg = 0x18555, .blue_reg = 0x18555},
                    {.red_reg = 0x1871c, .green_reg = 0x1871c, .blue_reg = 0x1871c},
                    {.red_reg = 0x188e3, .green_reg = 0x188e3, .blue_reg = 0x188e3},
                    {.red_reg = 0x18aaa, .green_reg = 0x18aaa, .blue_reg = 0x18aaa},
                    {.red_reg = 0x18c71, .green_reg = 0x18c71, .blue_reg = 0x18c71},
                    {.red_reg = 0x18e38, .green_reg = 0x18e38, .blue_reg = 0x18e38},
                    {.red_reg = 0x19000, .green_reg = 0x19000, .blue_reg = 0x19000},
                    {.red_reg = 0x190e3, .green_reg = 0x190e3, .blue_reg = 0x190e3},
                    {.red_reg = 0x191c7, .green_reg = 0x191c7, .blue_reg = 0x191c7},
                    {.red_reg = 0x1929e, .green_reg = 0x1929e, .blue_reg = 0x1929e},
                    {.red_reg = 0x19385, .green_reg = 0x19385, .blue_reg = 0x19385},
                    {.red_reg = 0x19473, .green_reg = 0x19473, .blue_reg = 0x19473},
                    {.red_reg = 0x19566, .green_reg = 0x19566, .blue_reg = 0x19566},
                    {.red_reg = 0x19660, .green_reg = 0x19660, .blue_reg = 0x19660},
                    {.red_reg = 0x19760, .green_reg = 0x19760, .blue_reg = 0x19760},
                    {.red_reg = 0x19866, .green_reg = 0x19866, .blue_reg = 0x19866},
                    {.red_reg = 0x19973, .green_reg = 0x19973, .blue_reg = 0x19973},
                    {.red_reg = 0x19a85, .green_reg = 0x19a85, .blue_reg = 0x19a85},
                    {.red_reg = 0x19b9e, .green_reg = 0x19b9e, .blue_reg = 0x19b9e},
                    {.red_reg = 0x19cbd, .green_reg = 0x19cbd, .blue_reg = 0x19cbd},
                    {.red_reg = 0x19de2, .green_reg = 0x19de2, .blue_reg = 0x19de2},
                    {.red_reg = 0x19f0e, .green_reg = 0x19f0e, .blue_reg = 0x19f0e},
                    {.red_reg = 0x1a020, .green_reg = 0x1a020, .blue_reg = 0x1a020},
                    {.red_reg = 0x1a0bc, .green_reg = 0x1a0bc, .blue_reg = 0x1a0bc},
                    {.red_reg = 0x1a15b, .green_reg = 0x1a15b, .blue_reg = 0x1a15b},
                    {.red_reg = 0x1a1fe, .green_reg = 0x1a1fe, .blue_reg = 0x1a1fe},
                    {.red_reg = 0x1a2a3, .green_reg = 0x1a2a3, .blue_reg = 0x1a2a3},
                    {.red_reg = 0x1a34c, .green_reg = 0x1a34c, .blue_reg = 0x1a34c},
                    {.red_reg = 0x1a3f9, .green_reg = 0x1a3f9, .blue_reg = 0x1a3f9},
                    {.red_reg = 0x1a4a8, .green_reg = 0x1a4a8, .blue_reg = 0x1a4a8},
                    {.red_reg = 0x1a55b, .green_reg = 0x1a55b, .blue_reg = 0x1a55b},
                    {.red_reg = 0x1a611, .green_reg = 0x1a611, .blue_reg = 0x1a611},
                    {.red_reg = 0x1a6ca, .green_reg = 0x1a6ca, .blue_reg = 0x1a6ca},
                    {.red_reg = 0x1a787, .green_reg = 0x1a787, .blue_reg = 0x1a787},
                    {.red_reg = 0x1a847, .green_reg = 0x1a847, .blue_reg = 0x1a847},
                    {.red_reg = 0x1a90a, .green_reg = 0x1a90a, .blue_reg = 0x1a90a},
                    {.red_reg = 0x1a9d1, .green_reg = 0x1a9d1, .blue_reg = 0x1a9d1},
                    {.red_reg = 0x1aa9b, .green_reg = 0x1aa9b, .blue_reg = 0x1aa9b},
                    {.red_reg = 0x1ab68, .green_reg = 0x1ab68, .blue_reg = 0x1ab68},
                    {.red_reg = 0x1ac38, .green_reg = 0x1ac38, .blue_reg = 0x1ac38},
                    {.red_reg = 0x1ad0c, .green_reg = 0x1ad0c, .blue_reg = 0x1ad0c},
                    {.red_reg = 0x1ade4, .green_reg = 0x1ade4, .blue_reg = 0x1ade4},
                    {.red_reg = 0x1aebe, .green_reg = 0x1aebe, .blue_reg = 0x1aebe},
                    {.red_reg = 0x1af9d, .green_reg = 0x1af9d, .blue_reg = 0x1af9d},
                    {.red_reg = 0x1b03f, .green_reg = 0x1b03f, .blue_reg = 0x1b03f},
                    {.red_reg = 0x1b0b1, .green_reg = 0x1b0b1, .blue_reg = 0x1b0b1},
                    {.red_reg = 0x1b125, .green_reg = 0x1b125, .blue_reg = 0x1b125},
                    {.red_reg = 0x1b19b, .green_reg = 0x1b19b, .blue_reg = 0x1b19b},
                    {.red_reg = 0x1b213, .green_reg = 0x1b213, .blue_reg = 0x1b213},
                    {.red_reg = 0x1b28c, .green_reg = 0x1b28c, .blue_reg = 0x1b28c},
                    {.red_reg = 0x1b307, .green_reg = 0x1b307, .blue_reg = 0x1b307},
                    {.red_reg = 0x1b384, .green_reg = 0x1b384, .blue_reg = 0x1b384},
                    {.red_reg = 0x1b403, .green_reg = 0x1b403, .blue_reg = 0x1b403},
                    {.red_reg = 0x1b483, .green_reg = 0x1b483, .blue_reg = 0x1b483},
                    {.red_reg = 0x1b505, .green_reg = 0x1b505, .blue_reg = 0x1b505},
                    {.red_reg = 0x1b589, .green_reg = 0x1b589, .blue_reg = 0x1b589},
                    {.red_reg = 0x1b60e, .green_reg = 0x1b60e, .blue_reg = 0x1b60e},
                    {.red_reg = 0x1b696, .green_reg = 0x1b696, .blue_reg = 0x1b696},
                    {.red_reg = 0x1b71f, .green_reg = 0x1b71f, .blue_reg = 0x1b71f},
                    {.red_reg = 0x1b7aa, .green_reg = 0x1b7aa, .blue_reg = 0x1b7aa},
                    {.red_reg = 0x1b836, .green_reg = 0x1b836, .blue_reg = 0x1b836},
                    {.red_reg = 0x1b8c5, .green_reg = 0x1b8c5, .blue_reg = 0x1b8c5},
                    {.red_reg = 0x1b955, .green_reg = 0x1b955, .blue_reg = 0x1b955},
                    {.red_reg = 0x1b9e7, .green_reg = 0x1b9e7, .blue_reg = 0x1b9e7},
                    {.red_reg = 0x1ba7a, .green_reg = 0x1ba7a, .blue_reg = 0x1ba7a},
                    {.red_reg = 0x1bb10, .green_reg = 0x1bb10, .blue_reg = 0x1bb10},
                    {.red_reg = 0x1bba7, .green_reg = 0x1bba7, .blue_reg = 0x1bba7},
                    {.red_reg = 0x1bc40, .green_reg = 0x1bc40, .blue_reg = 0x1bc40},
                    {.red_reg = 0x1bcdb, .green_reg = 0x1bcdb, .blue_reg = 0x1bcdb},
                    {.red_reg = 0x1bd78, .green_reg = 0x1bd78, .blue_reg = 0x1bd78},
                    {.red_reg = 0x1be17, .green_reg = 0x1be17, .blue_reg = 0x1be17},
                    {.red_reg = 0x1beb7, .green_reg = 0x1beb7, .blue_reg = 0x1beb7},
                    {.red_reg = 0x1bf59, .green_reg = 0x1bf59, .blue_reg = 0x1bf59},
                    {.red_reg = 0x1bffd, .green_reg = 0x1bffd, .blue_reg = 0x1bffd},
                    {.red_reg = 0x1c051, .green_reg = 0x1c051, .blue_reg = 0x1c051},
                    {.red_reg = 0x1c0a5, .green_reg = 0x1c0a5, .blue_reg = 0x1c0a5},
                    {.red_reg = 0x1c0fa, .green_reg = 0x1c0fa, .blue_reg = 0x1c0fa},
                    {.red_reg = 0x1c14f, .green_reg = 0x1c14f, .blue_reg = 0x1c14f},
                    {.red_reg = 0x1c1a6, .green_reg = 0x1c1a6, .blue_reg = 0x1c1a6},
                    {.red_reg = 0x1c1fe, .green_reg = 0x1c1fe, .blue_reg = 0x1c1fe},
                    {.red_reg = 0x1c256, .green_reg = 0x1c256, .blue_reg = 0x1c256},
                    {.red_reg = 0x1c2af, .green_reg = 0x1c2af, .blue_reg = 0x1c2af},
                    {.red_reg = 0x1c30a, .green_reg = 0x1c30a, .blue_reg = 0x1c30a},
                    {.red_reg = 0x1c365, .green_reg = 0x1c365, .blue_reg = 0x1c365},
                    {.red_reg = 0x1c3c1, .green_reg = 0x1c3c1, .blue_reg = 0x1c3c1},
                    {.red_reg = 0x1c41e, .green_reg = 0x1c41e, .blue_reg = 0x1c41e},
                    {.red_reg = 0x1c47c, .green_reg = 0x1c47c, .blue_reg = 0x1c47c},
                    {.red_reg = 0x1c4db, .green_reg = 0x1c4db, .blue_reg = 0x1c4db},
                    {.red_reg = 0x1c53b, .green_reg = 0x1c53b, .blue_reg = 0x1c53b},
                    {.red_reg = 0x1c59c, .green_reg = 0x1c59c, .blue_reg = 0x1c59c},
                    {.red_reg = 0x1c5fd, .green_reg = 0x1c5fd, .blue_reg = 0x1c5fd},
                    {.red_reg = 0x1c660, .green_reg = 0x1c660, .blue_reg = 0x1c660},
                    {.red_reg = 0x1c6c4, .green_reg = 0x1c6c4, .blue_reg = 0x1c6c4},
                    {.red_reg = 0x1c728, .green_reg = 0x1c728, .blue_reg = 0x1c728},
                    {.red_reg = 0x1c78e, .green_reg = 0x1c78e, .blue_reg = 0x1c78e},
                    {.red_reg = 0x1c7f4, .green_reg = 0x1c7f4, .blue_reg = 0x1c7f4},
                    {.red_reg = 0x1c85c, .green_reg = 0x1c85c, .blue_reg = 0x1c85c},
                    {.red_reg = 0x1c8c4, .green_reg = 0x1c8c4, .blue_reg = 0x1c8c4},
                    {.red_reg = 0x1c92e, .green_reg = 0x1c92e, .blue_reg = 0x1c92e},
                    {.red_reg = 0x1c998, .green_reg = 0x1c998, .blue_reg = 0x1c998},
                    {.red_reg = 0x1ca03, .green_reg = 0x1ca03, .blue_reg = 0x1ca03},
                    {.red_reg = 0x1ca6f, .green_reg = 0x1ca6f, .blue_reg = 0x1ca6f},
                    {.red_reg = 0x1cadd, .green_reg = 0x1cadd, .blue_reg = 0x1cadd},
                    {.red_reg = 0x1cb4b, .green_reg = 0x1cb4b, .blue_reg = 0x1cb4b},
                    {.red_reg = 0x1cbba, .green_reg = 0x1cbba, .blue_reg = 0x1cbba},
                    {.red_reg = 0x1cc2a, .green_reg = 0x1cc2a, .blue_reg = 0x1cc2a},
                    {.red_reg = 0x1cc9b, .green_reg = 0x1cc9b, .blue_reg = 0x1cc9b},
                    {.red_reg = 0x1cd0d, .green_reg = 0x1cd0d, .blue_reg = 0x1cd0d},
                    {.red_reg = 0x1cd80, .green_reg = 0x1cd80, .blue_reg = 0x1cd80},
                    {.red_reg = 0x1cdf4, .green_reg = 0x1cdf4, .blue_reg = 0x1cdf4},
                    {.red_reg = 0x1ce69, .green_reg = 0x1ce69, .blue_reg = 0x1ce69},
                    {.red_reg = 0x1cedf, .green_reg = 0x1cedf, .blue_reg = 0x1cedf},
                    {.red_reg = 0x1cf56, .green_reg = 0x1cf56, .blue_reg = 0x1cf56},
                    {.red_reg = 0x1cfcd, .green_reg = 0x1cfcd, .blue_reg = 0x1cfcd},
                    {.red_reg = 0x1d023, .green_reg = 0x1d023, .blue_reg = 0x1d023},
                    {.red_reg = 0x1d060, .green_reg = 0x1d060, .blue_reg = 0x1d060},
                    {.red_reg = 0x1d09d, .green_reg = 0x1d09d, .blue_reg = 0x1d09d},
                    {.red_reg = 0x1d0db, .green_reg = 0x1d0db, .blue_reg = 0x1d0db},
                    {.red_reg = 0x1d119, .green_reg = 0x1d119, .blue_reg = 0x1d119},
                    {.red_reg = 0x1d158, .green_reg = 0x1d158, .blue_reg = 0x1d158},
                    {.red_reg = 0x1d198, .green_reg = 0x1d198, .blue_reg = 0x1d198},
                    {.red_reg = 0x1d1d8, .green_reg = 0x1d1d8, .blue_reg = 0x1d1d8},
                    {.red_reg = 0x1d218, .green_reg = 0x1d218, .blue_reg = 0x1d218},
                    {.red_reg = 0x1d259, .green_reg = 0x1d259, .blue_reg = 0x1d259},
                    {.red_reg = 0x1d29a, .green_reg = 0x1d29a, .blue_reg = 0x1d29a},
                    {.red_reg = 0x1d2dc, .green_reg = 0x1d2dc, .blue_reg = 0x1d2dc},
                    {.red_reg = 0x1d31e, .green_reg = 0x1d31e, .blue_reg = 0x1d31e},
                    {.red_reg = 0x1d361, .green_reg = 0x1d361, .blue_reg = 0x1d361},
                    {.red_reg = 0x1d3a4, .green_reg = 0x1d3a4, .blue_reg = 0x1d3a4},
                    {.red_reg = 0x1d3e8, .green_reg = 0x1d3e8, .blue_reg = 0x1d3e8},
                    {.red_reg = 0x1d42d, .green_reg = 0x1d42d, .blue_reg = 0x1d42d},
                    {.red_reg = 0x1d471, .green_reg = 0x1d471, .blue_reg = 0x1d471},
                    {.red_reg = 0x1d4b7, .green_reg = 0x1d4b7, .blue_reg = 0x1d4b7},
                    {.red_reg = 0x1d4fd, .green_reg = 0x1d4fd, .blue_reg = 0x1d4fd},
                    {.red_reg = 0x1d543, .green_reg = 0x1d543, .blue_reg = 0x1d543},
                    {.red_reg = 0x1d58a, .green_reg = 0x1d58a, .blue_reg = 0x1d58a},
                    {.red_reg = 0x1d5d1, .green_reg = 0x1d5d1, .blue_reg = 0x1d5d1},
                    {.red_reg = 0x1d619, .green_reg = 0x1d619, .blue_reg = 0x1d619},
                    {.red_reg = 0x1d661, .green_reg = 0x1d661, .blue_reg = 0x1d661},
                    {.red_reg = 0x1d6aa, .green_reg = 0x1d6aa, .blue_reg = 0x1d6aa},
                    {.red_reg = 0x1d6f4, .green_reg = 0x1d6f4, .blue_reg = 0x1d6f4},
                    {.red_reg = 0x1d73d, .green_reg = 0x1d73d, .blue_reg = 0x1d73d},
                    {.red_reg = 0x1d788, .green_reg = 0x1d788, .blue_reg = 0x1d788},
                    {.red_reg = 0x1d7d3, .green_reg = 0x1d7d3, .blue_reg = 0x1d7d3},
                    {.red_reg = 0x1d81e, .green_reg = 0x1d81e, .blue_reg = 0x1d81e},
                    {.red_reg = 0x1d86a, .green_reg = 0x1d86a, .blue_reg = 0x1d86a},
                    {.red_reg = 0x1d8b6, .green_reg = 0x1d8b6, .blue_reg = 0x1d8b6},
                    {.red_reg = 0x1d903, .green_reg = 0x1d903, .blue_reg = 0x1d903},
                    {.red_reg = 0x1d951, .green_reg = 0x1d951, .blue_reg = 0x1d951},
                    {.red_reg = 0x1d99f, .green_reg = 0x1d99f, .blue_reg = 0x1d99f},
                    {.red_reg = 0x1d9ed, .green_reg = 0x1d9ed, .blue_reg = 0x1d9ed},
                    {.red_reg = 0x1da3c, .green_reg = 0x1da3c, .blue_reg = 0x1da3c},
                    {.red_reg = 0x1da8c, .green_reg = 0x1da8c, .blue_reg = 0x1da8c},
                    {.red_reg = 0x1dadc, .green_reg = 0x1dadc, .blue_reg = 0x1dadc},
                    {.red_reg = 0x1db2c, .green_reg = 0x1db2c, .blue_reg = 0x1db2c},
                    {.red_reg = 0x1db7d, .green_reg = 0x1db7d, .blue_reg = 0x1db7d},
                    {.red_reg = 0x1dbcf, .green_reg = 0x1dbcf, .blue_reg = 0x1dbcf},
                    {.red_reg = 0x1dc21, .green_reg = 0x1dc21, .blue_reg = 0x1dc21},
                    {.red_reg = 0x1dc74, .green_reg = 0x1dc74, .blue_reg = 0x1dc74},
                    {.red_reg = 0x1dcc7, .green_reg = 0x1dcc7, .blue_reg = 0x1dcc7},
                    {.red_reg = 0x1dd1a, .green_reg = 0x1dd1a, .blue_reg = 0x1dd1a},
                    {.red_reg = 0x1dd6e, .green_reg = 0x1dd6e, .blue_reg = 0x1dd6e},
                    {.red_reg = 0x1ddc3, .green_reg = 0x1ddc3, .blue_reg = 0x1ddc3},
                    {.red_reg = 0x1de18, .green_reg = 0x1de18, .blue_reg = 0x1de18},
                    {.red_reg = 0x1de6e, .green_reg = 0x1de6e, .blue_reg = 0x1de6e},
                    {.red_reg = 0x1dec4, .green_reg = 0x1dec4, .blue_reg = 0x1dec4},
                    {.red_reg = 0x1df1b, .green_reg = 0x1df1b, .blue_reg = 0x1df1b},
                    {.red_reg = 0x1df72, .green_reg = 0x1df72, .blue_reg = 0x1df72},
                    {.red_reg = 0x1dfca, .green_reg = 0x1dfca, .blue_reg = 0x1dfca},
                    {.red_reg = 0x1e011, .green_reg = 0x1e011, .blue_reg = 0x1e011},
                    {.red_reg = 0x1e03d, .green_reg = 0x1e03d, .blue_reg = 0x1e03d},
                    {.red_reg = 0x1e06a, .green_reg = 0x1e06a, .blue_reg = 0x1e06a},
                    {.red_reg = 0x1e097, .green_reg = 0x1e097, .blue_reg = 0x1e097},
                    {.red_reg = 0x1e0c4, .green_reg = 0x1e0c4, .blue_reg = 0x1e0c4},
                    {.red_reg = 0x1e0f2, .green_reg = 0x1e0f2, .blue_reg = 0x1e0f2},
                    {.red_reg = 0x1e11f, .green_reg = 0x1e11f, .blue_reg = 0x1e11f},
                    {.red_reg = 0x1e14d, .green_reg = 0x1e14d, .blue_reg = 0x1e14d},
                    {.red_reg = 0x1e17c, .green_reg = 0x1e17c, .blue_reg = 0x1e17c},
                    {.red_reg = 0x1e1aa, .green_reg = 0x1e1aa, .blue_reg = 0x1e1aa},
                    {.red_reg = 0x1e1d9, .green_reg = 0x1e1d9, .blue_reg = 0x1e1d9},
                    {.red_reg = 0x1e208, .green_reg = 0x1e208, .blue_reg = 0x1e208},
                    {.red_reg = 0x1e237, .green_reg = 0x1e237, .blue_reg = 0x1e237},
                    {.red_reg = 0x1e267, .green_reg = 0x1e267, .blue_reg = 0x1e267},
                    {.red_reg = 0x1e297, .green_reg = 0x1e297, .blue_reg = 0x1e297},
                    {.red_reg = 0x1e2c7, .green_reg = 0x1e2c7, .blue_reg = 0x1e2c7},
                    {.red_reg = 0x1e2f7, .green_reg = 0x1e2f7, .blue_reg = 0x1e2f7},
                    {.red_reg = 0x1e328, .green_reg = 0x1e328, .blue_reg = 0x1e328},
                    {.red_reg = 0x1e359, .green_reg = 0x1e359, .blue_reg = 0x1e359},
                    {.red_reg = 0x1e38a, .green_reg = 0x1e38a, .blue_reg = 0x1e38a},
                    {.red_reg = 0x1e3bc, .green_reg = 0x1e3bc, .blue_reg = 0x1e3bc},
                    {.red_reg = 0x1e3ed, .green_reg = 0x1e3ed, .blue_reg = 0x1e3ed},
                    {.red_reg = 0x1e41f, .green_reg = 0x1e41f, .blue_reg = 0x1e41f},
                    {.red_reg = 0x1e452, .green_reg = 0x1e452, .blue_reg = 0x1e452},
                    {.red_reg = 0x1e484, .green_reg = 0x1e484, .blue_reg = 0x1e484},
                    {.red_reg = 0x1e4b7, .green_reg = 0x1e4b7, .blue_reg = 0x1e4b7},
                    {.red_reg = 0x1e4ea, .green_reg = 0x1e4ea, .blue_reg = 0x1e4ea},
                    {.red_reg = 0x1e51d, .green_reg = 0x1e51d, .blue_reg = 0x1e51d},
                    {.red_reg = 0x1e551, .green_reg = 0x1e551, .blue_reg = 0x1e551},
                    {.red_reg = 0x1e585, .green_reg = 0x1e585, .blue_reg = 0x1e585},
                    {.red_reg = 0x1e5b9, .green_reg = 0x1e5b9, .blue_reg = 0x1e5b9},
                    {.red_reg = 0x1e5ee, .green_reg = 0x1e5ee, .blue_reg = 0x1e5ee},
                    {.red_reg = 0x1e622, .green_reg = 0x1e622, .blue_reg = 0x1e622},
                    {.red_reg = 0x1e657, .green_reg = 0x1e657, .blue_reg = 0x1e657},
                    {.red_reg = 0x1e68c, .green_reg = 0x1e68c, .blue_reg = 0x1e68c},
                    {.red_reg = 0x1e6c2, .green_reg = 0x1e6c2, .blue_reg = 0x1e6c2},
                    {.red_reg = 0x1e6f8, .green_reg = 0x1e6f8, .blue_reg = 0x1e6f8},
                    {.red_reg = 0x1e72e, .green_reg = 0x1e72e, .blue_reg = 0x1e72e},
                    {.red_reg = 0x1e764, .green_reg = 0x1e764, .blue_reg = 0x1e764},
                    {.red_reg = 0x1e79b, .green_reg = 0x1e79b, .blue_reg = 0x1e79b},
                    {.red_reg = 0x1e7d2, .green_reg = 0x1e7d2, .blue_reg = 0x1e7d2},
                    {.red_reg = 0x1e809, .green_reg = 0x1e809, .blue_reg = 0x1e809},
                    {.red_reg = 0x1e840, .green_reg = 0x1e840, .blue_reg = 0x1e840},
                    {.red_reg = 0x1e878, .green_reg = 0x1e878, .blue_reg = 0x1e878},
                    {.red_reg = 0x1e8b0, .green_reg = 0x1e8b0, .blue_reg = 0x1e8b0},
                    {.red_reg = 0x1e8e8, .green_reg = 0x1e8e8, .blue_reg = 0x1e8e8},
                    {.red_reg = 0x1e920, .green_reg = 0x1e920, .blue_reg = 0x1e920},
                    {.red_reg = 0x1e959, .green_reg = 0x1e959, .blue_reg = 0x1e959},
                    {.red_reg = 0x1e992, .green_reg = 0x1e992, .blue_reg = 0x1e992},
                    {.red_reg = 0x1e9cc, .green_reg = 0x1e9cc, .blue_reg = 0x1e9cc},
                    {.red_reg = 0x1ea05, .green_reg = 0x1ea05, .blue_reg = 0x1ea05},
                    {.red_reg = 0x1ea3f, .green_reg = 0x1ea3f, .blue_reg = 0x1ea3f},
                    {.red_reg = 0x1ea79, .green_reg = 0x1ea79, .blue_reg = 0x1ea79},
                    {.red_reg = 0x1eab4, .green_reg = 0x1eab4, .blue_reg = 0x1eab4},
                    {.red_reg = 0x1eaee, .green_reg = 0x1eaee, .blue_reg = 0x1eaee},
                    {.red_reg = 0x1eb29, .green_reg = 0x1eb29, .blue_reg = 0x1eb29},
                    {.red_reg = 0x1eb65, .green_reg = 0x1eb65, .blue_reg = 0x1eb65},
                    {.red_reg = 0x1eba0, .green_reg = 0x1eba0, .blue_reg = 0x1eba0},
                    {.red_reg = 0x1ebdc, .green_reg = 0x1ebdc, .blue_reg = 0x1ebdc},
                    {.red_reg = 0x1ec18, .green_reg = 0x1ec18, .blue_reg = 0x1ec18},
                    {.red_reg = 0x1ec55, .green_reg = 0x1ec55, .blue_reg = 0x1ec55},
                    {.red_reg = 0x1ec91, .green_reg = 0x1ec91, .blue_reg = 0x1ec91},
                    {.red_reg = 0x1ecce, .green_reg = 0x1ecce, .blue_reg = 0x1ecce},
                    {.red_reg = 0x1ed0b, .green_reg = 0x1ed0b, .blue_reg = 0x1ed0b},
                    {.red_reg = 0x1ed49, .green_reg = 0x1ed49, .blue_reg = 0x1ed49},
                    {.red_reg = 0x1ed87, .green_reg = 0x1ed87, .blue_reg = 0x1ed87},
                    {.red_reg = 0x1edc5, .green_reg = 0x1edc5, .blue_reg = 0x1edc5},
                    {.red_reg = 0x1ee03, .green_reg = 0x1ee03, .blue_reg = 0x1ee03},
                    {.red_reg = 0x1ee41, .green_reg = 0x1ee41, .blue_reg = 0x1ee41},
                    {.red_reg = 0x1ee80, .green_reg = 0x1ee80, .blue_reg = 0x1ee80},
                    {.red_reg = 0x1eec0, .green_reg = 0x1eec0, .blue_reg = 0x1eec0},
                    {.red_reg = 0x1eeff, .green_reg = 0x1eeff, .blue_reg = 0x1eeff},
                    {.red_reg = 0x1ef3f, .green_reg = 0x1ef3f, .blue_reg = 0x1ef3f},
                    {.red_reg = 0x1ef7f, .green_reg = 0x1ef7f, .blue_reg = 0x1ef7f},
                    {.red_reg = 0x1efbf, .green_reg = 0x1efbf, .blue_reg = 0x1efbf},
                    {.red_reg = 0x1f000, .green_reg = 0x1f000, .blue_reg = 0x1f000},
                    {.red_reg = 0x0, .green_reg = 0x0, .blue_reg = 0x0},
                    {.red_reg = 0x0, .green_reg = 0x0, .blue_reg = 0x0}}},
    },
    {
        // Regam
        {.hw_points_num       = NUM_OF_LUT_DATA_REGAM_SDR,
            .arr_curve_points = {{0x0, 0x3}, {0x8, 0x4}, {0x18, 0x4}, {0x28, 0x4}, {0x38, 0x4},
                {0x48, 0x4}, {0x58, 0x4}, {0x68, 0x4}, {0x78, 0x4}, {0x88, 0x4}, {0x98, 0x4},
                {0xa8, 0x4}, {0xb8, 0x1}, {0xba, 0x0}, {0x0, 0x0}, {0x0, 0x0}, {0x0, 0x0},
                {0x0, 0x0}, {0x0, 0x0}, {0x0, 0x0}, {0x0, 0x0}, {0x0, 0x0}, {0x0, 0x0}, {0x0, 0x0},
                {0x0, 0x0}, {0x0, 0x0}, {0x0, 0x0}, {0x0, 0x0}, {0x0, 0x0}, {0x0, 0x0}, {0x0, 0x0},
                {0x0, 0x0}, {0x0, 0x0}, {0x0, 0x0}},
            .corner_points    = {{.red.custom_float_x          = 0x13000,
                                     .red.custom_float_y       = 0x0,
                                     .red.custom_float_slope   = 0x229d7,
                                     .green.custom_float_x     = 0x13000,
                                     .green.custom_float_y     = 0x0,
                                     .green.custom_float_slope = 0x229d7,
                                     .blue.custom_float_x      = 0x13000,
                                     .blue.custom_float_y      = 0x0,
                                     .blue.custom_float_slope  = 0x229d7},
                   {.red.custom_float_x          = 0x8000,
                       .red.custom_float_y       = 0x1f000,
                       .red.custom_float_slope   = 0x0,
                       .green.custom_float_x     = 0x8000,
                       .green.custom_float_y     = 0x1f000,
                       .green.custom_float_slope = 0x0,
                       .blue.custom_float_x      = 0x8000,
                       .blue.custom_float_y      = 0x1f000,
                       .blue.custom_float_slope  = 0x0}},
            .rgb_resulted     = {{.red_reg = 0x169d7, .green_reg = 0x169d7, .blue_reg = 0x169d7},
                    {.red_reg = 0x16d11, .green_reg = 0x16d11, .blue_reg = 0x16d11},
                    {.red_reg = 0x17026, .green_reg = 0x17026, .blue_reg = 0x17026},
                    {.red_reg = 0x171c3, .green_reg = 0x171c3, .blue_reg = 0x171c3},
                    {.red_reg = 0x17361, .green_reg = 0x17361, .blue_reg = 0x17361},
                    {.red_reg = 0x174fe, .green_reg = 0x174fe, .blue_reg = 0x174fe},
                    {.red_reg = 0x1769c, .green_reg = 0x1769c, .blue_reg = 0x1769c},
                    {.red_reg = 0x17839, .green_reg = 0x17839, .blue_reg = 0x17839},
                    {.red_reg = 0x179d7, .green_reg = 0x179d7, .blue_reg = 0x179d7},
                    {.red_reg = 0x17b74, .green_reg = 0x17b74, .blue_reg = 0x17b74},
                    {.red_reg = 0x17d11, .green_reg = 0x17d11, .blue_reg = 0x17d11},
                    {.red_reg = 0x17eaf, .green_reg = 0x17eaf, .blue_reg = 0x17eaf},
                    {.red_reg = 0x18026, .green_reg = 0x18026, .blue_reg = 0x18026},
                    {.red_reg = 0x180f5, .green_reg = 0x180f5, .blue_reg = 0x180f5},
                    {.red_reg = 0x181c3, .green_reg = 0x181c3, .blue_reg = 0x181c3},
                    {.red_reg = 0x18292, .green_reg = 0x18292, .blue_reg = 0x18292},
                    {.red_reg = 0x18361, .green_reg = 0x18361, .blue_reg = 0x18361},
                    {.red_reg = 0x18430, .green_reg = 0x18430, .blue_reg = 0x18430},
                    {.red_reg = 0x184fe, .green_reg = 0x184fe, .blue_reg = 0x184fe},
                    {.red_reg = 0x185cd, .green_reg = 0x185cd, .blue_reg = 0x185cd},
                    {.red_reg = 0x1869c, .green_reg = 0x1869c, .blue_reg = 0x1869c},
                    {.red_reg = 0x1876a, .green_reg = 0x1876a, .blue_reg = 0x1876a},
                    {.red_reg = 0x18839, .green_reg = 0x18839, .blue_reg = 0x18839},
                    {.red_reg = 0x18908, .green_reg = 0x18908, .blue_reg = 0x18908},
                    {.red_reg = 0x189d7, .green_reg = 0x189d7, .blue_reg = 0x189d7},
                    {.red_reg = 0x18b74, .green_reg = 0x18b74, .blue_reg = 0x18b74},
                    {.red_reg = 0x18d11, .green_reg = 0x18d11, .blue_reg = 0x18d11},
                    {.red_reg = 0x18eaf, .green_reg = 0x18eaf, .blue_reg = 0x18eaf},
                    {.red_reg = 0x19026, .green_reg = 0x19026, .blue_reg = 0x19026},
                    {.red_reg = 0x190f5, .green_reg = 0x190f5, .blue_reg = 0x190f5},
                    {.red_reg = 0x191c3, .green_reg = 0x191c3, .blue_reg = 0x191c3},
                    {.red_reg = 0x19292, .green_reg = 0x19292, .blue_reg = 0x19292},
                    {.red_reg = 0x19361, .green_reg = 0x19361, .blue_reg = 0x19361},
                    {.red_reg = 0x19430, .green_reg = 0x19430, .blue_reg = 0x19430},
                    {.red_reg = 0x194fe, .green_reg = 0x194fe, .blue_reg = 0x194fe},
                    {.red_reg = 0x195cd, .green_reg = 0x195cd, .blue_reg = 0x195cd},
                    {.red_reg = 0x1969c, .green_reg = 0x1969c, .blue_reg = 0x1969c},
                    {.red_reg = 0x1976a, .green_reg = 0x1976a, .blue_reg = 0x1976a},
                    {.red_reg = 0x19839, .green_reg = 0x19839, .blue_reg = 0x19839},
                    {.red_reg = 0x19908, .green_reg = 0x19908, .blue_reg = 0x19908},
                    {.red_reg = 0x199d7, .green_reg = 0x199d7, .blue_reg = 0x199d7},
                    {.red_reg = 0x19b74, .green_reg = 0x19b74, .blue_reg = 0x19b74},
                    {.red_reg = 0x19d11, .green_reg = 0x19d11, .blue_reg = 0x19d11},
                    {.red_reg = 0x19eaf, .green_reg = 0x19eaf, .blue_reg = 0x19eaf},
                    {.red_reg = 0x1a026, .green_reg = 0x1a026, .blue_reg = 0x1a026},
                    {.red_reg = 0x1a0f5, .green_reg = 0x1a0f5, .blue_reg = 0x1a0f5},
                    {.red_reg = 0x1a1c3, .green_reg = 0x1a1c3, .blue_reg = 0x1a1c3},
                    {.red_reg = 0x1a292, .green_reg = 0x1a292, .blue_reg = 0x1a292},
                    {.red_reg = 0x1a361, .green_reg = 0x1a361, .blue_reg = 0x1a361},
                    {.red_reg = 0x1a430, .green_reg = 0x1a430, .blue_reg = 0x1a430},
                    {.red_reg = 0x1a4fd, .green_reg = 0x1a4fd, .blue_reg = 0x1a4fd},
                    {.red_reg = 0x1a5c4, .green_reg = 0x1a5c4, .blue_reg = 0x1a5c4},
                    {.red_reg = 0x1a687, .green_reg = 0x1a687, .blue_reg = 0x1a687},
                    {.red_reg = 0x1a746, .green_reg = 0x1a746, .blue_reg = 0x1a746},
                    {.red_reg = 0x1a802, .green_reg = 0x1a802, .blue_reg = 0x1a802},
                    {.red_reg = 0x1a8b9, .green_reg = 0x1a8b9, .blue_reg = 0x1a8b9},
                    {.red_reg = 0x1a96e, .green_reg = 0x1a96e, .blue_reg = 0x1a96e},
                    {.red_reg = 0x1aacd, .green_reg = 0x1aacd, .blue_reg = 0x1aacd},
                    {.red_reg = 0x1ac20, .green_reg = 0x1ac20, .blue_reg = 0x1ac20},
                    {.red_reg = 0x1ad68, .green_reg = 0x1ad68, .blue_reg = 0x1ad68},
                    {.red_reg = 0x1aea6, .green_reg = 0x1aea6, .blue_reg = 0x1aea6},
                    {.red_reg = 0x1afdc, .green_reg = 0x1afdc, .blue_reg = 0x1afdc},
                    {.red_reg = 0x1b084, .green_reg = 0x1b084, .blue_reg = 0x1b084},
                    {.red_reg = 0x1b116, .green_reg = 0x1b116, .blue_reg = 0x1b116},
                    {.red_reg = 0x1b1a5, .green_reg = 0x1b1a5, .blue_reg = 0x1b1a5},
                    {.red_reg = 0x1b230, .green_reg = 0x1b230, .blue_reg = 0x1b230},
                    {.red_reg = 0x1b2b9, .green_reg = 0x1b2b9, .blue_reg = 0x1b2b9},
                    {.red_reg = 0x1b33e, .green_reg = 0x1b33e, .blue_reg = 0x1b33e},
                    {.red_reg = 0x1b3c0, .green_reg = 0x1b3c0, .blue_reg = 0x1b3c0},
                    {.red_reg = 0x1b440, .green_reg = 0x1b440, .blue_reg = 0x1b440},
                    {.red_reg = 0x1b4bd, .green_reg = 0x1b4bd, .blue_reg = 0x1b4bd},
                    {.red_reg = 0x1b537, .green_reg = 0x1b537, .blue_reg = 0x1b537},
                    {.red_reg = 0x1b5af, .green_reg = 0x1b5af, .blue_reg = 0x1b5af},
                    {.red_reg = 0x1b69a, .green_reg = 0x1b69a, .blue_reg = 0x1b69a},
                    {.red_reg = 0x1b77c, .green_reg = 0x1b77c, .blue_reg = 0x1b77c},
                    {.red_reg = 0x1b857, .green_reg = 0x1b857, .blue_reg = 0x1b857},
                    {.red_reg = 0x1b92c, .green_reg = 0x1b92c, .blue_reg = 0x1b92c},
                    {.red_reg = 0x1b9fa, .green_reg = 0x1b9fa, .blue_reg = 0x1b9fa},
                    {.red_reg = 0x1bac3, .green_reg = 0x1bac3, .blue_reg = 0x1bac3},
                    {.red_reg = 0x1bb86, .green_reg = 0x1bb86, .blue_reg = 0x1bb86},
                    {.red_reg = 0x1bc45, .green_reg = 0x1bc45, .blue_reg = 0x1bc45},
                    {.red_reg = 0x1bcff, .green_reg = 0x1bcff, .blue_reg = 0x1bcff},
                    {.red_reg = 0x1bdb4, .green_reg = 0x1bdb4, .blue_reg = 0x1bdb4},
                    {.red_reg = 0x1be66, .green_reg = 0x1be66, .blue_reg = 0x1be66},
                    {.red_reg = 0x1bf14, .green_reg = 0x1bf14, .blue_reg = 0x1bf14},
                    {.red_reg = 0x1bfbe, .green_reg = 0x1bfbe, .blue_reg = 0x1bfbe},
                    {.red_reg = 0x1c032, .green_reg = 0x1c032, .blue_reg = 0x1c032},
                    {.red_reg = 0x1c084, .green_reg = 0x1c084, .blue_reg = 0x1c084},
                    {.red_reg = 0x1c0d4, .green_reg = 0x1c0d4, .blue_reg = 0x1c0d4},
                    {.red_reg = 0x1c171, .green_reg = 0x1c171, .blue_reg = 0x1c171},
                    {.red_reg = 0x1c208, .green_reg = 0x1c208, .blue_reg = 0x1c208},
                    {.red_reg = 0x1c29a, .green_reg = 0x1c29a, .blue_reg = 0x1c29a},
                    {.red_reg = 0x1c328, .green_reg = 0x1c328, .blue_reg = 0x1c328},
                    {.red_reg = 0x1c3b2, .green_reg = 0x1c3b2, .blue_reg = 0x1c3b2},
                    {.red_reg = 0x1c438, .green_reg = 0x1c438, .blue_reg = 0x1c438},
                    {.red_reg = 0x1c4ba, .green_reg = 0x1c4ba, .blue_reg = 0x1c4ba},
                    {.red_reg = 0x1c539, .green_reg = 0x1c539, .blue_reg = 0x1c539},
                    {.red_reg = 0x1c5b5, .green_reg = 0x1c5b5, .blue_reg = 0x1c5b5},
                    {.red_reg = 0x1c62f, .green_reg = 0x1c62f, .blue_reg = 0x1c62f},
                    {.red_reg = 0x1c6a5, .green_reg = 0x1c6a5, .blue_reg = 0x1c6a5},
                    {.red_reg = 0x1c719, .green_reg = 0x1c719, .blue_reg = 0x1c719},
                    {.red_reg = 0x1c78b, .green_reg = 0x1c78b, .blue_reg = 0x1c78b},
                    {.red_reg = 0x1c7fa, .green_reg = 0x1c7fa, .blue_reg = 0x1c7fa},
                    {.red_reg = 0x1c868, .green_reg = 0x1c868, .blue_reg = 0x1c868},
                    {.red_reg = 0x1c8d3, .green_reg = 0x1c8d3, .blue_reg = 0x1c8d3},
                    {.red_reg = 0x1c9a3, .green_reg = 0x1c9a3, .blue_reg = 0x1c9a3},
                    {.red_reg = 0x1ca6d, .green_reg = 0x1ca6d, .blue_reg = 0x1ca6d},
                    {.red_reg = 0x1cb30, .green_reg = 0x1cb30, .blue_reg = 0x1cb30},
                    {.red_reg = 0x1cbee, .green_reg = 0x1cbee, .blue_reg = 0x1cbee},
                    {.red_reg = 0x1cca5, .green_reg = 0x1cca5, .blue_reg = 0x1cca5},
                    {.red_reg = 0x1cd58, .green_reg = 0x1cd58, .blue_reg = 0x1cd58},
                    {.red_reg = 0x1ce06, .green_reg = 0x1ce06, .blue_reg = 0x1ce06},
                    {.red_reg = 0x1ceb0, .green_reg = 0x1ceb0, .blue_reg = 0x1ceb0},
                    {.red_reg = 0x1cf56, .green_reg = 0x1cf56, .blue_reg = 0x1cf56},
                    {.red_reg = 0x1cff8, .green_reg = 0x1cff8, .blue_reg = 0x1cff8},
                    {.red_reg = 0x1d04b, .green_reg = 0x1d04b, .blue_reg = 0x1d04b},
                    {.red_reg = 0x1d098, .green_reg = 0x1d098, .blue_reg = 0x1d098},
                    {.red_reg = 0x1d0e4, .green_reg = 0x1d0e4, .blue_reg = 0x1d0e4},
                    {.red_reg = 0x1d12e, .green_reg = 0x1d12e, .blue_reg = 0x1d12e},
                    {.red_reg = 0x1d177, .green_reg = 0x1d177, .blue_reg = 0x1d177},
                    {.red_reg = 0x1d1bf, .green_reg = 0x1d1bf, .blue_reg = 0x1d1bf},
                    {.red_reg = 0x1d24a, .green_reg = 0x1d24a, .blue_reg = 0x1d24a},
                    {.red_reg = 0x1d2d1, .green_reg = 0x1d2d1, .blue_reg = 0x1d2d1},
                    {.red_reg = 0x1d353, .green_reg = 0x1d353, .blue_reg = 0x1d353},
                    {.red_reg = 0x1d3d1, .green_reg = 0x1d3d1, .blue_reg = 0x1d3d1},
                    {.red_reg = 0x1d44c, .green_reg = 0x1d44c, .blue_reg = 0x1d44c},
                    {.red_reg = 0x1d4c3, .green_reg = 0x1d4c3, .blue_reg = 0x1d4c3},
                    {.red_reg = 0x1d538, .green_reg = 0x1d538, .blue_reg = 0x1d538},
                    {.red_reg = 0x1d5a9, .green_reg = 0x1d5a9, .blue_reg = 0x1d5a9},
                    {.red_reg = 0x1d618, .green_reg = 0x1d618, .blue_reg = 0x1d618},
                    {.red_reg = 0x1d684, .green_reg = 0x1d684, .blue_reg = 0x1d684},
                    {.red_reg = 0x1d6ed, .green_reg = 0x1d6ed, .blue_reg = 0x1d6ed},
                    {.red_reg = 0x1d755, .green_reg = 0x1d755, .blue_reg = 0x1d755},
                    {.red_reg = 0x1d7ba, .green_reg = 0x1d7ba, .blue_reg = 0x1d7ba},
                    {.red_reg = 0x1d81d, .green_reg = 0x1d81d, .blue_reg = 0x1d81d},
                    {.red_reg = 0x1d87e, .green_reg = 0x1d87e, .blue_reg = 0x1d87e},
                    {.red_reg = 0x1d8de, .green_reg = 0x1d8de, .blue_reg = 0x1d8de},
                    {.red_reg = 0x1d998, .green_reg = 0x1d998, .blue_reg = 0x1d998},
                    {.red_reg = 0x1da4b, .green_reg = 0x1da4b, .blue_reg = 0x1da4b},
                    {.red_reg = 0x1daf9, .green_reg = 0x1daf9, .blue_reg = 0x1daf9},
                    {.red_reg = 0x1dba2, .green_reg = 0x1dba2, .blue_reg = 0x1dba2},
                    {.red_reg = 0x1dc46, .green_reg = 0x1dc46, .blue_reg = 0x1dc46},
                    {.red_reg = 0x1dce5, .green_reg = 0x1dce5, .blue_reg = 0x1dce5},
                    {.red_reg = 0x1dd80, .green_reg = 0x1dd80, .blue_reg = 0x1dd80},
                    {.red_reg = 0x1de17, .green_reg = 0x1de17, .blue_reg = 0x1de17},
                    {.red_reg = 0x1deab, .green_reg = 0x1deab, .blue_reg = 0x1deab},
                    {.red_reg = 0x1df3b, .green_reg = 0x1df3b, .blue_reg = 0x1df3b},
                    {.red_reg = 0x1dfc8, .green_reg = 0x1dfc8, .blue_reg = 0x1dfc8},
                    {.red_reg = 0x1e029, .green_reg = 0x1e029, .blue_reg = 0x1e029},
                    {.red_reg = 0x1e06c, .green_reg = 0x1e06c, .blue_reg = 0x1e06c},
                    {.red_reg = 0x1e0af, .green_reg = 0x1e0af, .blue_reg = 0x1e0af},
                    {.red_reg = 0x1e0f0, .green_reg = 0x1e0f0, .blue_reg = 0x1e0f0},
                    {.red_reg = 0x1e12f, .green_reg = 0x1e12f, .blue_reg = 0x1e12f},
                    {.red_reg = 0x1e1ab, .green_reg = 0x1e1ab, .blue_reg = 0x1e1ab},
                    {.red_reg = 0x1e223, .green_reg = 0x1e223, .blue_reg = 0x1e223},
                    {.red_reg = 0x1e297, .green_reg = 0x1e297, .blue_reg = 0x1e297},
                    {.red_reg = 0x1e308, .green_reg = 0x1e308, .blue_reg = 0x1e308},
                    {.red_reg = 0x1e375, .green_reg = 0x1e375, .blue_reg = 0x1e375},
                    {.red_reg = 0x1e3e0, .green_reg = 0x1e3e0, .blue_reg = 0x1e3e0},
                    {.red_reg = 0x1e447, .green_reg = 0x1e447, .blue_reg = 0x1e447},
                    {.red_reg = 0x1e4ac, .green_reg = 0x1e4ac, .blue_reg = 0x1e4ac},
                    {.red_reg = 0x1e50f, .green_reg = 0x1e50f, .blue_reg = 0x1e50f},
                    {.red_reg = 0x1e56f, .green_reg = 0x1e56f, .blue_reg = 0x1e56f},
                    {.red_reg = 0x1e5cd, .green_reg = 0x1e5cd, .blue_reg = 0x1e5cd},
                    {.red_reg = 0x1e629, .green_reg = 0x1e629, .blue_reg = 0x1e629},
                    {.red_reg = 0x1e683, .green_reg = 0x1e683, .blue_reg = 0x1e683},
                    {.red_reg = 0x1e6dc, .green_reg = 0x1e6dc, .blue_reg = 0x1e6dc},
                    {.red_reg = 0x1e732, .green_reg = 0x1e732, .blue_reg = 0x1e732},
                    {.red_reg = 0x1e788, .green_reg = 0x1e788, .blue_reg = 0x1e788},
                    {.red_reg = 0x1e82d, .green_reg = 0x1e82d, .blue_reg = 0x1e82d},
                    {.red_reg = 0x1e8cd, .green_reg = 0x1e8cd, .blue_reg = 0x1e8cd},
                    {.red_reg = 0x1e968, .green_reg = 0x1e968, .blue_reg = 0x1e968},
                    {.red_reg = 0x1e9fe, .green_reg = 0x1e9fe, .blue_reg = 0x1e9fe},
                    {.red_reg = 0x1ea90, .green_reg = 0x1ea90, .blue_reg = 0x1ea90},
                    {.red_reg = 0x1eb1e, .green_reg = 0x1eb1e, .blue_reg = 0x1eb1e},
                    {.red_reg = 0x1eba8, .green_reg = 0x1eba8, .blue_reg = 0x1eba8},
                    {.red_reg = 0x1ec2f, .green_reg = 0x1ec2f, .blue_reg = 0x1ec2f},
                    {.red_reg = 0x1ecb3, .green_reg = 0x1ecb3, .blue_reg = 0x1ecb3},
                    {.red_reg = 0x1ed33, .green_reg = 0x1ed33, .blue_reg = 0x1ed33},
                    {.red_reg = 0x1edb1, .green_reg = 0x1edb1, .blue_reg = 0x1edb1},
                    {.red_reg = 0x1ee2c, .green_reg = 0x1ee2c, .blue_reg = 0x1ee2c},
                    {.red_reg = 0x1eea4, .green_reg = 0x1eea4, .blue_reg = 0x1eea4},
                    {.red_reg = 0x1ef1a, .green_reg = 0x1ef1a, .blue_reg = 0x1ef1a},
                    {.red_reg = 0x1ef8e, .green_reg = 0x1ef8e, .blue_reg = 0x1ef8e},
                    {.red_reg = 0x1f000, .green_reg = 0x1f000, .blue_reg = 0x1f000},
                    {.red_reg = 0x1f000, .green_reg = 0x1f000, .blue_reg = 0x1f000},
                    {.red_reg = 0x0, .green_reg = 0x0, .blue_reg = 0x0},
                    {.red_reg = 0x0, .green_reg = 0x0, .blue_reg = 0x0},
                    {.red_reg = 0x0, .green_reg = 0x0, .blue_reg = 0x0},
                    {.red_reg = 0x0, .green_reg = 0x0, .blue_reg = 0x0},
                    {.red_reg = 0x0, .green_reg = 0x0, .blue_reg = 0x0},
                    {.red_reg = 0x0, .green_reg = 0x0, .blue_reg = 0x0},
                    {.red_reg = 0x0, .green_reg = 0x0, .blue_reg = 0x0},
                    {.red_reg = 0x0, .green_reg = 0x0, .blue_reg = 0x0},
                    {.red_reg = 0x0, .green_reg = 0x0, .blue_reg = 0x0},
                    {.red_reg = 0x0, .green_reg = 0x0, .blue_reg = 0x0},
                    {.red_reg = 0x0, .green_reg = 0x0, .blue_reg = 0x0},
                    {.red_reg = 0x0, .green_reg = 0x0, .blue_reg = 0x0},
                    {.red_reg = 0x0, .green_reg = 0x0, .blue_reg = 0x0},
                    {.red_reg = 0x0, .green_reg = 0x0, .blue_reg = 0x0},
                    {.red_reg = 0x0, .green_reg = 0x0, .blue_reg = 0x0},
                    {.red_reg = 0x0, .green_reg = 0x0, .blue_reg = 0x0},
                    {.red_reg = 0x0, .green_reg = 0x0, .blue_reg = 0x0},
                    {.red_reg = 0x0, .green_reg = 0x0, .blue_reg = 0x0},
                    {.red_reg = 0x0, .green_reg = 0x0, .blue_reg = 0x0},
                    {.red_reg = 0x0, .green_reg = 0x0, .blue_reg = 0x0},
                    {.red_reg = 0x0, .green_reg = 0x0, .blue_reg = 0x0},
                    {.red_reg = 0x0, .green_reg = 0x0, .blue_reg = 0x0},
                    {.red_reg = 0x0, .green_reg = 0x0, .blue_reg = 0x0},
                    {.red_reg = 0x0, .green_reg = 0x0, .blue_reg = 0x0},
                    {.red_reg = 0x0, .green_reg = 0x0, .blue_reg = 0x0},
                    {.red_reg = 0x0, .green_reg = 0x0, .blue_reg = 0x0},
                    {.red_reg = 0x0, .green_reg = 0x0, .blue_reg = 0x0},
                    {.red_reg = 0x0, .green_reg = 0x0, .blue_reg = 0x0},
                    {.red_reg = 0x0, .green_reg = 0x0, .blue_reg = 0x0},
                    {.red_reg = 0x0, .green_reg = 0x0, .blue_reg = 0x0},
                    {.red_reg = 0x0, .green_reg = 0x0, .blue_reg = 0x0},
                    {.red_reg = 0x0, .green_reg = 0x0, .blue_reg = 0x0},
                    {.red_reg = 0x0, .green_reg = 0x0, .blue_reg = 0x0},
                    {.red_reg = 0x0, .green_reg = 0x0, .blue_reg = 0x0},
                    {.red_reg = 0x0, .green_reg = 0x0, .blue_reg = 0x0},
                    {.red_reg = 0x0, .green_reg = 0x0, .blue_reg = 0x0},
                    {.red_reg = 0x0, .green_reg = 0x0, .blue_reg = 0x0},
                    {.red_reg = 0x0, .green_reg = 0x0, .blue_reg = 0x0},
                    {.red_reg = 0x0, .green_reg = 0x0, .blue_reg = 0x0},
                    {.red_reg = 0x0, .green_reg = 0x0, .blue_reg = 0x0},
                    {.red_reg = 0x0, .green_reg = 0x0, .blue_reg = 0x0},
                    {.red_reg = 0x0, .green_reg = 0x0, .blue_reg = 0x0},
                    {.red_reg = 0x0, .green_reg = 0x0, .blue_reg = 0x0},
                    {.red_reg = 0x0, .green_reg = 0x0, .blue_reg = 0x0},
                    {.red_reg = 0x0, .green_reg = 0x0, .blue_reg = 0x0},
                    {.red_reg = 0x0, .green_reg = 0x0, .blue_reg = 0x0},
                    {.red_reg = 0x0, .green_reg = 0x0, .blue_reg = 0x0},
                    {.red_reg = 0x0, .green_reg = 0x0, .blue_reg = 0x0},
                    {.red_reg = 0x0, .green_reg = 0x0, .blue_reg = 0x0},
                    {.red_reg = 0x0, .green_reg = 0x0, .blue_reg = 0x0},
                    {.red_reg = 0x0, .green_reg = 0x0, .blue_reg = 0x0},
                    {.red_reg = 0x0, .green_reg = 0x0, .blue_reg = 0x0},
                    {.red_reg = 0x0, .green_reg = 0x0, .blue_reg = 0x0},
                    {.red_reg = 0x0, .green_reg = 0x0, .blue_reg = 0x0},
                    {.red_reg = 0x0, .green_reg = 0x0, .blue_reg = 0x0},
                    {.red_reg = 0x0, .green_reg = 0x0, .blue_reg = 0x0},
                    {.red_reg = 0x0, .green_reg = 0x0, .blue_reg = 0x0},
                    {.red_reg = 0x0, .green_reg = 0x0, .blue_reg = 0x0},
                    {.red_reg = 0x0, .green_reg = 0x0, .blue_reg = 0x0},
                    {.red_reg = 0x0, .green_reg = 0x0, .blue_reg = 0x0},
                    {.red_reg = 0x0, .green_reg = 0x0, .blue_reg = 0x0},
                    {.red_reg = 0x0, .green_reg = 0x0, .blue_reg = 0x0},
                    {.red_reg = 0x0, .green_reg = 0x0, .blue_reg = 0x0},
                    {.red_reg = 0x0, .green_reg = 0x0, .blue_reg = 0x0},
                    {.red_reg = 0x0, .green_reg = 0x0, .blue_reg = 0x0},
                    {.red_reg = 0x0, .green_reg = 0x0, .blue_reg = 0x0},
                    {.red_reg = 0x0, .green_reg = 0x0, .blue_reg = 0x0},
                    {.red_reg = 0x0, .green_reg = 0x0, .blue_reg = 0x0},
                    {.red_reg = 0x0, .green_reg = 0x0, .blue_reg = 0x0},
                    {.red_reg = 0x0, .green_reg = 0x0, .blue_reg = 0x0},
                    {.red_reg = 0x0, .green_reg = 0x0, .blue_reg = 0x0},
                    {.red_reg = 0x0, .green_reg = 0x0, .blue_reg = 0x0},
                    {.red_reg = 0x0, .green_reg = 0x0, .blue_reg = 0x0}}},
        {.hw_points_num       = NUM_OF_LUT_DATA_REGAM_SDR,
            .arr_curve_points = {{0x0, 0x3}, {0x8, 0x4}, {0x18, 0x4}, {0x28, 0x4}, {0x38, 0x4},
                {0x48, 0x4}, {0x58, 0x4}, {0x68, 0x4}, {0x78, 0x4}, {0x88, 0x4}, {0x98, 0x4},
                {0xa8, 0x4}, {0xb8, 0x1}, {0xba, 0x0}, {0x0, 0x0}, {0x0, 0x0}, {0x0, 0x0},
                {0x0, 0x0}, {0x0, 0x0}, {0x0, 0x0}, {0x0, 0x0}, {0x0, 0x0}, {0x0, 0x0}, {0x0, 0x0},
                {0x0, 0x0}, {0x0, 0x0}, {0x0, 0x0}, {0x0, 0x0}, {0x0, 0x0}, {0x0, 0x0}, {0x0, 0x0},
                {0x0, 0x0}, {0x0, 0x0}, {0x0, 0x0}},
            .corner_points    = {{.red.custom_float_x          = 0x13000,
                                     .red.custom_float_y       = 0x0,
                                     .red.custom_float_slope   = 0x25ff6,
                                     .green.custom_float_x     = 0x13000,
                                     .green.custom_float_y     = 0x0,
                                     .green.custom_float_slope = 0x25ff6,
                                     .blue.custom_float_x      = 0x13000,
                                     .blue.custom_float_y      = 0x0,
                                     .blue.custom_float_slope  = 0x25ff6},
                   {.red.custom_float_x          = 0x8000,
                       .red.custom_float_y       = 0x1f000,
                       .red.custom_float_slope   = 0x0,
                       .green.custom_float_x     = 0x8000,
                       .green.custom_float_y     = 0x1f000,
                       .green.custom_float_slope = 0x0,
                       .blue.custom_float_x      = 0x8000,
                       .blue.custom_float_y      = 0x1f000,
                       .blue.custom_float_slope  = 0x0}},
            .rgb_resulted     = {{.red_reg = 0x19ff6, .green_reg = 0x19ff6, .blue_reg = 0x19ff6},
                    {.red_reg = 0x1a0cf, .green_reg = 0x1a0cf, .blue_reg = 0x1a0cf},
                    {.red_reg = 0x1a192, .green_reg = 0x1a192, .blue_reg = 0x1a192},
                    {.red_reg = 0x1a248, .green_reg = 0x1a248, .blue_reg = 0x1a248},
                    {.red_reg = 0x1a2f3, .green_reg = 0x1a2f3, .blue_reg = 0x1a2f3},
                    {.red_reg = 0x1a398, .green_reg = 0x1a398, .blue_reg = 0x1a398},
                    {.red_reg = 0x1a435, .green_reg = 0x1a435, .blue_reg = 0x1a435},
                    {.red_reg = 0x1a4c6, .green_reg = 0x1a4c6, .blue_reg = 0x1a4c6},
                    {.red_reg = 0x1a55b, .green_reg = 0x1a55b, .blue_reg = 0x1a55b},
                    {.red_reg = 0x1a5e7, .green_reg = 0x1a5e7, .blue_reg = 0x1a5e7},
                    {.red_reg = 0x1a66e, .green_reg = 0x1a66e, .blue_reg = 0x1a66e},
                    {.red_reg = 0x1a6f1, .green_reg = 0x1a6f1, .blue_reg = 0x1a6f1},
                    {.red_reg = 0x1a770, .green_reg = 0x1a770, .blue_reg = 0x1a770},
                    {.red_reg = 0x1a7eb, .green_reg = 0x1a7eb, .blue_reg = 0x1a7eb},
                    {.red_reg = 0x1a863, .green_reg = 0x1a863, .blue_reg = 0x1a863},
                    {.red_reg = 0x1a8d8, .green_reg = 0x1a8d8, .blue_reg = 0x1a8d8},
                    {.red_reg = 0x1a949, .green_reg = 0x1a949, .blue_reg = 0x1a949},
                    {.red_reg = 0x1a9b8, .green_reg = 0x1a9b8, .blue_reg = 0x1a9b8},
                    {.red_reg = 0x1aa25, .green_reg = 0x1aa25, .blue_reg = 0x1aa25},
                    {.red_reg = 0x1aa8f, .green_reg = 0x1aa8f, .blue_reg = 0x1aa8f},
                    {.red_reg = 0x1aaf7, .green_reg = 0x1aaf7, .blue_reg = 0x1aaf7},
                    {.red_reg = 0x1ab5c, .green_reg = 0x1ab5c, .blue_reg = 0x1ab5c},
                    {.red_reg = 0x1abc0, .green_reg = 0x1abc0, .blue_reg = 0x1abc0},
                    {.red_reg = 0x1ac22, .green_reg = 0x1ac22, .blue_reg = 0x1ac22},
                    {.red_reg = 0x1ac82, .green_reg = 0x1ac82, .blue_reg = 0x1ac82},
                    {.red_reg = 0x1ad3c, .green_reg = 0x1ad3c, .blue_reg = 0x1ad3c},
                    {.red_reg = 0x1adf1, .green_reg = 0x1adf1, .blue_reg = 0x1adf1},
                    {.red_reg = 0x1ae9f, .green_reg = 0x1ae9f, .blue_reg = 0x1ae9f},
                    {.red_reg = 0x1af49, .green_reg = 0x1af49, .blue_reg = 0x1af49},
                    {.red_reg = 0x1afed, .green_reg = 0x1afed, .blue_reg = 0x1afed},
                    {.red_reg = 0x1b046, .green_reg = 0x1b046, .blue_reg = 0x1b046},
                    {.red_reg = 0x1b094, .green_reg = 0x1b094, .blue_reg = 0x1b094},
                    {.red_reg = 0x1b0e0, .green_reg = 0x1b0e0, .blue_reg = 0x1b0e0},
                    {.red_reg = 0x1b12a, .green_reg = 0x1b12a, .blue_reg = 0x1b12a},
                    {.red_reg = 0x1b173, .green_reg = 0x1b173, .blue_reg = 0x1b173},
                    {.red_reg = 0x1b1ba, .green_reg = 0x1b1ba, .blue_reg = 0x1b1ba},
                    {.red_reg = 0x1b1ff, .green_reg = 0x1b1ff, .blue_reg = 0x1b1ff},
                    {.red_reg = 0x1b243, .green_reg = 0x1b243, .blue_reg = 0x1b243},
                    {.red_reg = 0x1b285, .green_reg = 0x1b285, .blue_reg = 0x1b285},
                    {.red_reg = 0x1b2c6, .green_reg = 0x1b2c6, .blue_reg = 0x1b2c6},
                    {.red_reg = 0x1b306, .green_reg = 0x1b306, .blue_reg = 0x1b306},
                    {.red_reg = 0x1b383, .green_reg = 0x1b383, .blue_reg = 0x1b383},
                    {.red_reg = 0x1b3fc, .green_reg = 0x1b3fc, .blue_reg = 0x1b3fc},
                    {.red_reg = 0x1b470, .green_reg = 0x1b470, .blue_reg = 0x1b470},
                    {.red_reg = 0x1b4e1, .green_reg = 0x1b4e1, .blue_reg = 0x1b4e1},
                    {.red_reg = 0x1b54f, .green_reg = 0x1b54f, .blue_reg = 0x1b54f},
                    {.red_reg = 0x1b5ba, .green_reg = 0x1b5ba, .blue_reg = 0x1b5ba},
                    {.red_reg = 0x1b622, .green_reg = 0x1b622, .blue_reg = 0x1b622},
                    {.red_reg = 0x1b687, .green_reg = 0x1b687, .blue_reg = 0x1b687},
                    {.red_reg = 0x1b6ea, .green_reg = 0x1b6ea, .blue_reg = 0x1b6ea},
                    {.red_reg = 0x1b74b, .green_reg = 0x1b74b, .blue_reg = 0x1b74b},
                    {.red_reg = 0x1b7a9, .green_reg = 0x1b7a9, .blue_reg = 0x1b7a9},
                    {.red_reg = 0x1b806, .green_reg = 0x1b806, .blue_reg = 0x1b806},
                    {.red_reg = 0x1b860, .green_reg = 0x1b860, .blue_reg = 0x1b860},
                    {.red_reg = 0x1b8b9, .green_reg = 0x1b8b9, .blue_reg = 0x1b8b9},
                    {.red_reg = 0x1b910, .green_reg = 0x1b910, .blue_reg = 0x1b910},
                    {.red_reg = 0x1b965, .green_reg = 0x1b965, .blue_reg = 0x1b965},
                    {.red_reg = 0x1ba0c, .green_reg = 0x1ba0c, .blue_reg = 0x1ba0c},
                    {.red_reg = 0x1baad, .green_reg = 0x1baad, .blue_reg = 0x1baad},
                    {.red_reg = 0x1bb48, .green_reg = 0x1bb48, .blue_reg = 0x1bb48},
                    {.red_reg = 0x1bbdf, .green_reg = 0x1bbdf, .blue_reg = 0x1bbdf},
                    {.red_reg = 0x1bc72, .green_reg = 0x1bc72, .blue_reg = 0x1bc72},
                    {.red_reg = 0x1bd00, .green_reg = 0x1bd00, .blue_reg = 0x1bd00},
                    {.red_reg = 0x1bd8b, .green_reg = 0x1bd8b, .blue_reg = 0x1bd8b},
                    {.red_reg = 0x1be12, .green_reg = 0x1be12, .blue_reg = 0x1be12},
                    {.red_reg = 0x1be96, .green_reg = 0x1be96, .blue_reg = 0x1be96},
                    {.red_reg = 0x1bf17, .green_reg = 0x1bf17, .blue_reg = 0x1bf17},
                    {.red_reg = 0x1bf95, .green_reg = 0x1bf95, .blue_reg = 0x1bf95},
                    {.red_reg = 0x1c008, .green_reg = 0x1c008, .blue_reg = 0x1c008},
                    {.red_reg = 0x1c045, .green_reg = 0x1c045, .blue_reg = 0x1c045},
                    {.red_reg = 0x1c080, .green_reg = 0x1c080, .blue_reg = 0x1c080},
                    {.red_reg = 0x1c0ba, .green_reg = 0x1c0ba, .blue_reg = 0x1c0ba},
                    {.red_reg = 0x1c0f3, .green_reg = 0x1c0f3, .blue_reg = 0x1c0f3},
                    {.red_reg = 0x1c162, .green_reg = 0x1c162, .blue_reg = 0x1c162},
                    {.red_reg = 0x1c1cd, .green_reg = 0x1c1cd, .blue_reg = 0x1c1cd},
                    {.red_reg = 0x1c235, .green_reg = 0x1c235, .blue_reg = 0x1c235},
                    {.red_reg = 0x1c29a, .green_reg = 0x1c29a, .blue_reg = 0x1c29a},
                    {.red_reg = 0x1c2fc, .green_reg = 0x1c2fc, .blue_reg = 0x1c2fc},
                    {.red_reg = 0x1c35b, .green_reg = 0x1c35b, .blue_reg = 0x1c35b},
                    {.red_reg = 0x1c3b7, .green_reg = 0x1c3b7, .blue_reg = 0x1c3b7},
                    {.red_reg = 0x1c412, .green_reg = 0x1c412, .blue_reg = 0x1c412},
                    {.red_reg = 0x1c46a, .green_reg = 0x1c46a, .blue_reg = 0x1c46a},
                    {.red_reg = 0x1c4c0, .green_reg = 0x1c4c0, .blue_reg = 0x1c4c0},
                    {.red_reg = 0x1c514, .green_reg = 0x1c514, .blue_reg = 0x1c514},
                    {.red_reg = 0x1c567, .green_reg = 0x1c567, .blue_reg = 0x1c567},
                    {.red_reg = 0x1c5b7, .green_reg = 0x1c5b7, .blue_reg = 0x1c5b7},
                    {.red_reg = 0x1c606, .green_reg = 0x1c606, .blue_reg = 0x1c606},
                    {.red_reg = 0x1c654, .green_reg = 0x1c654, .blue_reg = 0x1c654},
                    {.red_reg = 0x1c6a0, .green_reg = 0x1c6a0, .blue_reg = 0x1c6a0},
                    {.red_reg = 0x1c734, .green_reg = 0x1c734, .blue_reg = 0x1c734},
                    {.red_reg = 0x1c7c3, .green_reg = 0x1c7c3, .blue_reg = 0x1c7c3},
                    {.red_reg = 0x1c84e, .green_reg = 0x1c84e, .blue_reg = 0x1c84e},
                    {.red_reg = 0x1c8d5, .green_reg = 0x1c8d5, .blue_reg = 0x1c8d5},
                    {.red_reg = 0x1c957, .green_reg = 0x1c957, .blue_reg = 0x1c957},
                    {.red_reg = 0x1c9d6, .green_reg = 0x1c9d6, .blue_reg = 0x1c9d6},
                    {.red_reg = 0x1ca52, .green_reg = 0x1ca52, .blue_reg = 0x1ca52},
                    {.red_reg = 0x1caca, .green_reg = 0x1caca, .blue_reg = 0x1caca},
                    {.red_reg = 0x1cb40, .green_reg = 0x1cb40, .blue_reg = 0x1cb40},
                    {.red_reg = 0x1cbb3, .green_reg = 0x1cbb3, .blue_reg = 0x1cbb3},
                    {.red_reg = 0x1cc23, .green_reg = 0x1cc23, .blue_reg = 0x1cc23},
                    {.red_reg = 0x1cc91, .green_reg = 0x1cc91, .blue_reg = 0x1cc91},
                    {.red_reg = 0x1ccfd, .green_reg = 0x1ccfd, .blue_reg = 0x1ccfd},
                    {.red_reg = 0x1cd67, .green_reg = 0x1cd67, .blue_reg = 0x1cd67},
                    {.red_reg = 0x1cdce, .green_reg = 0x1cdce, .blue_reg = 0x1cdce},
                    {.red_reg = 0x1ce34, .green_reg = 0x1ce34, .blue_reg = 0x1ce34},
                    {.red_reg = 0x1cefa, .green_reg = 0x1cefa, .blue_reg = 0x1cefa},
                    {.red_reg = 0x1cfb9, .green_reg = 0x1cfb9, .blue_reg = 0x1cfb9},
                    {.red_reg = 0x1d039, .green_reg = 0x1d039, .blue_reg = 0x1d039},
                    {.red_reg = 0x1d092, .green_reg = 0x1d092, .blue_reg = 0x1d092},
                    {.red_reg = 0x1d0e9, .green_reg = 0x1d0e9, .blue_reg = 0x1d0e9},
                    {.red_reg = 0x1d13e, .green_reg = 0x1d13e, .blue_reg = 0x1d13e},
                    {.red_reg = 0x1d191, .green_reg = 0x1d191, .blue_reg = 0x1d191},
                    {.red_reg = 0x1d1e1, .green_reg = 0x1d1e1, .blue_reg = 0x1d1e1},
                    {.red_reg = 0x1d230, .green_reg = 0x1d230, .blue_reg = 0x1d230},
                    {.red_reg = 0x1d27c, .green_reg = 0x1d27c, .blue_reg = 0x1d27c},
                    {.red_reg = 0x1d2c7, .green_reg = 0x1d2c7, .blue_reg = 0x1d2c7},
                    {.red_reg = 0x1d311, .green_reg = 0x1d311, .blue_reg = 0x1d311},
                    {.red_reg = 0x1d359, .green_reg = 0x1d359, .blue_reg = 0x1d359},
                    {.red_reg = 0x1d39f, .green_reg = 0x1d39f, .blue_reg = 0x1d39f},
                    {.red_reg = 0x1d3e4, .green_reg = 0x1d3e4, .blue_reg = 0x1d3e4},
                    {.red_reg = 0x1d428, .green_reg = 0x1d428, .blue_reg = 0x1d428},
                    {.red_reg = 0x1d4ac, .green_reg = 0x1d4ac, .blue_reg = 0x1d4ac},
                    {.red_reg = 0x1d52c, .green_reg = 0x1d52c, .blue_reg = 0x1d52c},
                    {.red_reg = 0x1d5a7, .green_reg = 0x1d5a7, .blue_reg = 0x1d5a7},
                    {.red_reg = 0x1d61f, .green_reg = 0x1d61f, .blue_reg = 0x1d61f},
                    {.red_reg = 0x1d693, .green_reg = 0x1d693, .blue_reg = 0x1d693},
                    {.red_reg = 0x1d704, .green_reg = 0x1d704, .blue_reg = 0x1d704},
                    {.red_reg = 0x1d773, .green_reg = 0x1d773, .blue_reg = 0x1d773},
                    {.red_reg = 0x1d7de, .green_reg = 0x1d7de, .blue_reg = 0x1d7de},
                    {.red_reg = 0x1d847, .green_reg = 0x1d847, .blue_reg = 0x1d847},
                    {.red_reg = 0x1d8ad, .green_reg = 0x1d8ad, .blue_reg = 0x1d8ad},
                    {.red_reg = 0x1d911, .green_reg = 0x1d911, .blue_reg = 0x1d911},
                    {.red_reg = 0x1d973, .green_reg = 0x1d973, .blue_reg = 0x1d973},
                    {.red_reg = 0x1d9d3, .green_reg = 0x1d9d3, .blue_reg = 0x1d9d3},
                    {.red_reg = 0x1da31, .green_reg = 0x1da31, .blue_reg = 0x1da31},
                    {.red_reg = 0x1da8e, .green_reg = 0x1da8e, .blue_reg = 0x1da8e},
                    {.red_reg = 0x1dae8, .green_reg = 0x1dae8, .blue_reg = 0x1dae8},
                    {.red_reg = 0x1db98, .green_reg = 0x1db98, .blue_reg = 0x1db98},
                    {.red_reg = 0x1dc43, .green_reg = 0x1dc43, .blue_reg = 0x1dc43},
                    {.red_reg = 0x1dce7, .green_reg = 0x1dce7, .blue_reg = 0x1dce7},
                    {.red_reg = 0x1dd87, .green_reg = 0x1dd87, .blue_reg = 0x1dd87},
                    {.red_reg = 0x1de23, .green_reg = 0x1de23, .blue_reg = 0x1de23},
                    {.red_reg = 0x1deba, .green_reg = 0x1deba, .blue_reg = 0x1deba},
                    {.red_reg = 0x1df4d, .green_reg = 0x1df4d, .blue_reg = 0x1df4d},
                    {.red_reg = 0x1dfdc, .green_reg = 0x1dfdc, .blue_reg = 0x1dfdc},
                    {.red_reg = 0x1e034, .green_reg = 0x1e034, .blue_reg = 0x1e034},
                    {.red_reg = 0x1e078, .green_reg = 0x1e078, .blue_reg = 0x1e078},
                    {.red_reg = 0x1e0bb, .green_reg = 0x1e0bb, .blue_reg = 0x1e0bb},
                    {.red_reg = 0x1e0fc, .green_reg = 0x1e0fc, .blue_reg = 0x1e0fc},
                    {.red_reg = 0x1e13c, .green_reg = 0x1e13c, .blue_reg = 0x1e13c},
                    {.red_reg = 0x1e17b, .green_reg = 0x1e17b, .blue_reg = 0x1e17b},
                    {.red_reg = 0x1e1b9, .green_reg = 0x1e1b9, .blue_reg = 0x1e1b9},
                    {.red_reg = 0x1e1f5, .green_reg = 0x1e1f5, .blue_reg = 0x1e1f5},
                    {.red_reg = 0x1e26b, .green_reg = 0x1e26b, .blue_reg = 0x1e26b},
                    {.red_reg = 0x1e2dc, .green_reg = 0x1e2dc, .blue_reg = 0x1e2dc},
                    {.red_reg = 0x1e34a, .green_reg = 0x1e34a, .blue_reg = 0x1e34a},
                    {.red_reg = 0x1e3b5, .green_reg = 0x1e3b5, .blue_reg = 0x1e3b5},
                    {.red_reg = 0x1e41d, .green_reg = 0x1e41d, .blue_reg = 0x1e41d},
                    {.red_reg = 0x1e481, .green_reg = 0x1e481, .blue_reg = 0x1e481},
                    {.red_reg = 0x1e4e4, .green_reg = 0x1e4e4, .blue_reg = 0x1e4e4},
                    {.red_reg = 0x1e543, .green_reg = 0x1e543, .blue_reg = 0x1e543},
                    {.red_reg = 0x1e5a1, .green_reg = 0x1e5a1, .blue_reg = 0x1e5a1},
                    {.red_reg = 0x1e5fc, .green_reg = 0x1e5fc, .blue_reg = 0x1e5fc},
                    {.red_reg = 0x1e655, .green_reg = 0x1e655, .blue_reg = 0x1e655},
                    {.red_reg = 0x1e6ac, .green_reg = 0x1e6ac, .blue_reg = 0x1e6ac},
                    {.red_reg = 0x1e702, .green_reg = 0x1e702, .blue_reg = 0x1e702},
                    {.red_reg = 0x1e756, .green_reg = 0x1e756, .blue_reg = 0x1e756},
                    {.red_reg = 0x1e7a8, .green_reg = 0x1e7a8, .blue_reg = 0x1e7a8},
                    {.red_reg = 0x1e7f9, .green_reg = 0x1e7f9, .blue_reg = 0x1e7f9},
                    {.red_reg = 0x1e896, .green_reg = 0x1e896, .blue_reg = 0x1e896},
                    {.red_reg = 0x1e92d, .green_reg = 0x1e92d, .blue_reg = 0x1e92d},
                    {.red_reg = 0x1e9c0, .green_reg = 0x1e9c0, .blue_reg = 0x1e9c0},
                    {.red_reg = 0x1ea4f, .green_reg = 0x1ea4f, .blue_reg = 0x1ea4f},
                    {.red_reg = 0x1ead9, .green_reg = 0x1ead9, .blue_reg = 0x1ead9},
                    {.red_reg = 0x1eb5f, .green_reg = 0x1eb5f, .blue_reg = 0x1eb5f},
                    {.red_reg = 0x1ebe2, .green_reg = 0x1ebe2, .blue_reg = 0x1ebe2},
                    {.red_reg = 0x1ec62, .green_reg = 0x1ec62, .blue_reg = 0x1ec62},
                    {.red_reg = 0x1ecdf, .green_reg = 0x1ecdf, .blue_reg = 0x1ecdf},
                    {.red_reg = 0x1ed59, .green_reg = 0x1ed59, .blue_reg = 0x1ed59},
                    {.red_reg = 0x1edd0, .green_reg = 0x1edd0, .blue_reg = 0x1edd0},
                    {.red_reg = 0x1ee44, .green_reg = 0x1ee44, .blue_reg = 0x1ee44},
                    {.red_reg = 0x1eeb6, .green_reg = 0x1eeb6, .blue_reg = 0x1eeb6},
                    {.red_reg = 0x1ef26, .green_reg = 0x1ef26, .blue_reg = 0x1ef26},
                    {.red_reg = 0x1ef94, .green_reg = 0x1ef94, .blue_reg = 0x1ef94},
                    {.red_reg = 0x1f000, .green_reg = 0x1f000, .blue_reg = 0x1f000},
                    {.red_reg = 0x1f000, .green_reg = 0x1f000, .blue_reg = 0x1f000},
                    {.red_reg = 0x0, .green_reg = 0x0, .blue_reg = 0x0},
                    {.red_reg = 0x0, .green_reg = 0x0, .blue_reg = 0x0},
                    {.red_reg = 0x0, .green_reg = 0x0, .blue_reg = 0x0},
                    {.red_reg = 0x0, .green_reg = 0x0, .blue_reg = 0x0},
                    {.red_reg = 0x0, .green_reg = 0x0, .blue_reg = 0x0},
                    {.red_reg = 0x0, .green_reg = 0x0, .blue_reg = 0x0},
                    {.red_reg = 0x0, .green_reg = 0x0, .blue_reg = 0x0},
                    {.red_reg = 0x0, .green_reg = 0x0, .blue_reg = 0x0},
                    {.red_reg = 0x0, .green_reg = 0x0, .blue_reg = 0x0},
                    {.red_reg = 0x0, .green_reg = 0x0, .blue_reg = 0x0},
                    {.red_reg = 0x0, .green_reg = 0x0, .blue_reg = 0x0},
                    {.red_reg = 0x0, .green_reg = 0x0, .blue_reg = 0x0},
                    {.red_reg = 0x0, .green_reg = 0x0, .blue_reg = 0x0},
                    {.red_reg = 0x0, .green_reg = 0x0, .blue_reg = 0x0},
                    {.red_reg = 0x0, .green_reg = 0x0, .blue_reg = 0x0},
                    {.red_reg = 0x0, .green_reg = 0x0, .blue_reg = 0x0},
                    {.red_reg = 0x0, .green_reg = 0x0, .blue_reg = 0x0},
                    {.red_reg = 0x0, .green_reg = 0x0, .blue_reg = 0x0},
                    {.red_reg = 0x0, .green_reg = 0x0, .blue_reg = 0x0},
                    {.red_reg = 0x0, .green_reg = 0x0, .blue_reg = 0x0},
                    {.red_reg = 0x0, .green_reg = 0x0, .blue_reg = 0x0},
                    {.red_reg = 0x0, .green_reg = 0x0, .blue_reg = 0x0},
                    {.red_reg = 0x0, .green_reg = 0x0, .blue_reg = 0x0},
                    {.red_reg = 0x0, .green_reg = 0x0, .blue_reg = 0x0},
                    {.red_reg = 0x0, .green_reg = 0x0, .blue_reg = 0x0},
                    {.red_reg = 0x0, .green_reg = 0x0, .blue_reg = 0x0},
                    {.red_reg = 0x0, .green_reg = 0x0, .blue_reg = 0x0},
                    {.red_reg = 0x0, .green_reg = 0x0, .blue_reg = 0x0},
                    {.red_reg = 0x0, .green_reg = 0x0, .blue_reg = 0x0},
                    {.red_reg = 0x0, .green_reg = 0x0, .blue_reg = 0x0},
                    {.red_reg = 0x0, .green_reg = 0x0, .blue_reg = 0x0},
                    {.red_reg = 0x0, .green_reg = 0x0, .blue_reg = 0x0},
                    {.red_reg = 0x0, .green_reg = 0x0, .blue_reg = 0x0},
                    {.red_reg = 0x0, .green_reg = 0x0, .blue_reg = 0x0},
                    {.red_reg = 0x0, .green_reg = 0x0, .blue_reg = 0x0},
                    {.red_reg = 0x0, .green_reg = 0x0, .blue_reg = 0x0},
                    {.red_reg = 0x0, .green_reg = 0x0, .blue_reg = 0x0},
                    {.red_reg = 0x0, .green_reg = 0x0, .blue_reg = 0x0},
                    {.red_reg = 0x0, .green_reg = 0x0, .blue_reg = 0x0},
                    {.red_reg = 0x0, .green_reg = 0x0, .blue_reg = 0x0},
                    {.red_reg = 0x0, .green_reg = 0x0, .blue_reg = 0x0},
                    {.red_reg = 0x0, .green_reg = 0x0, .blue_reg = 0x0},
                    {.red_reg = 0x0, .green_reg = 0x0, .blue_reg = 0x0},
                    {.red_reg = 0x0, .green_reg = 0x0, .blue_reg = 0x0},
                    {.red_reg = 0x0, .green_reg = 0x0, .blue_reg = 0x0},
                    {.red_reg = 0x0, .green_reg = 0x0, .blue_reg = 0x0},
                    {.red_reg = 0x0, .green_reg = 0x0, .blue_reg = 0x0},
                    {.red_reg = 0x0, .green_reg = 0x0, .blue_reg = 0x0},
                    {.red_reg = 0x0, .green_reg = 0x0, .blue_reg = 0x0},
                    {.red_reg = 0x0, .green_reg = 0x0, .blue_reg = 0x0},
                    {.red_reg = 0x0, .green_reg = 0x0, .blue_reg = 0x0},
                    {.red_reg = 0x0, .green_reg = 0x0, .blue_reg = 0x0},
                    {.red_reg = 0x0, .green_reg = 0x0, .blue_reg = 0x0},
                    {.red_reg = 0x0, .green_reg = 0x0, .blue_reg = 0x0},
                    {.red_reg = 0x0, .green_reg = 0x0, .blue_reg = 0x0},
                    {.red_reg = 0x0, .green_reg = 0x0, .blue_reg = 0x0},
                    {.red_reg = 0x0, .green_reg = 0x0, .blue_reg = 0x0},
                    {.red_reg = 0x0, .green_reg = 0x0, .blue_reg = 0x0},
                    {.red_reg = 0x0, .green_reg = 0x0, .blue_reg = 0x0},
                    {.red_reg = 0x0, .green_reg = 0x0, .blue_reg = 0x0},
                    {.red_reg = 0x0, .green_reg = 0x0, .blue_reg = 0x0},
                    {.red_reg = 0x0, .green_reg = 0x0, .blue_reg = 0x0},
                    {.red_reg = 0x0, .green_reg = 0x0, .blue_reg = 0x0},
                    {.red_reg = 0x0, .green_reg = 0x0, .blue_reg = 0x0},
                    {.red_reg = 0x0, .green_reg = 0x0, .blue_reg = 0x0},
                    {.red_reg = 0x0, .green_reg = 0x0, .blue_reg = 0x0},
                    {.red_reg = 0x0, .green_reg = 0x0, .blue_reg = 0x0},
                    {.red_reg = 0x0, .green_reg = 0x0, .blue_reg = 0x0},
                    {.red_reg = 0x0, .green_reg = 0x0, .blue_reg = 0x0},
                    {.red_reg = 0x0, .green_reg = 0x0, .blue_reg = 0x0},
                    {.red_reg = 0x0, .green_reg = 0x0, .blue_reg = 0x0},
                    {.red_reg = 0x0, .green_reg = 0x0, .blue_reg = 0x0},
                    {.red_reg = 0x0, .green_reg = 0x0, .blue_reg = 0x0}}},
        {.hw_points_num       = NUM_OF_LUT_DATA_REGAM_PQ,
            .arr_curve_points = {{0x0, 0x3}, {0x8, 0x3}, {0x10, 0x3}, {0x18, 0x3}, {0x20, 0x3},
                {0x28, 0x3}, {0x30, 0x3}, {0x38, 0x3}, {0x40, 0x3}, {0x48, 0x3}, {0x50, 0x3},
                {0x58, 0x3}, {0x60, 0x3}, {0x68, 0x3}, {0x70, 0x3}, {0x78, 0x3}, {0x80, 0x3},
                {0x88, 0x3}, {0x90, 0x3}, {0x98, 0x3}, {0xa0, 0x3}, {0xa8, 0x3}, {0xb0, 0x3},
                {0xb8, 0x3}, {0xc0, 0x3}, {0xc8, 0x1}, {0xca, 0x0}, {0x0, 0x0}, {0x0, 0x0},
                {0x0, 0x0}, {0x0, 0x0}, {0x0, 0x0}, {0x0, 0x0}, {0x0, 0x0}},
            .corner_points    = {{.red.custom_float_x          = 0x6000,
                                     .red.custom_float_y       = 0x0,
                                     .red.custom_float_slope   = 0x2ec7c,
                                     .green.custom_float_x     = 0x6000,
                                     .green.custom_float_y     = 0x0,
                                     .green.custom_float_slope = 0x2ec7c,
                                     .blue.custom_float_x      = 0x6000,
                                     .blue.custom_float_y      = 0x0,
                                     .blue.custom_float_slope  = 0x2ec7c},
                   {.red.custom_float_x          = 0x8000,
                       .red.custom_float_y       = 0x1f000,
                       .red.custom_float_slope   = 0x0,
                       .green.custom_float_x     = 0x8000,
                       .green.custom_float_y     = 0x1f000,
                       .green.custom_float_slope = 0x0,
                       .blue.custom_float_x      = 0x8000,
                       .blue.custom_float_y      = 0x1f000,
                       .blue.custom_float_slope  = 0x0}},
            .rgb_resulted     = {{.red_reg = 0x15c7c, .green_reg = 0x15c7c, .blue_reg = 0x15c7c},
                    {.red_reg = 0x16006, .green_reg = 0x16006, .blue_reg = 0x16006},
                    {.red_reg = 0x161ce, .green_reg = 0x161ce, .blue_reg = 0x161ce},
                    {.red_reg = 0x16395, .green_reg = 0x16395, .blue_reg = 0x16395},
                    {.red_reg = 0x1655d, .green_reg = 0x1655d, .blue_reg = 0x1655d},
                    {.red_reg = 0x16725, .green_reg = 0x16725, .blue_reg = 0x16725},
                    {.red_reg = 0x168ed, .green_reg = 0x168ed, .blue_reg = 0x168ed},
                    {.red_reg = 0x16ab5, .green_reg = 0x16ab5, .blue_reg = 0x16ab5},
                    {.red_reg = 0x16c7c, .green_reg = 0x16c7c, .blue_reg = 0x16c7c},
                    {.red_reg = 0x17006, .green_reg = 0x17006, .blue_reg = 0x17006},
                    {.red_reg = 0x171ce, .green_reg = 0x171ce, .blue_reg = 0x171ce},
                    {.red_reg = 0x17395, .green_reg = 0x17395, .blue_reg = 0x17395},
                    {.red_reg = 0x1755d, .green_reg = 0x1755d, .blue_reg = 0x1755d},
                    {.red_reg = 0x17725, .green_reg = 0x17725, .blue_reg = 0x17725},
                    {.red_reg = 0x178ed, .green_reg = 0x178ed, .blue_reg = 0x178ed},
                    {.red_reg = 0x17ab5, .green_reg = 0x17ab5, .blue_reg = 0x17ab5},
                    {.red_reg = 0x17c7c, .green_reg = 0x17c7c, .blue_reg = 0x17c7c},
                    {.red_reg = 0x17e68, .green_reg = 0x17e68, .blue_reg = 0x17e68},
                    {.red_reg = 0x1801b, .green_reg = 0x1801b, .blue_reg = 0x1801b},
                    {.red_reg = 0x180fa, .green_reg = 0x180fa, .blue_reg = 0x180fa},
                    {.red_reg = 0x181ce, .green_reg = 0x181ce, .blue_reg = 0x181ce},
                    {.red_reg = 0x1829b, .green_reg = 0x1829b, .blue_reg = 0x1829b},
                    {.red_reg = 0x18361, .green_reg = 0x18361, .blue_reg = 0x18361},
                    {.red_reg = 0x1841e, .green_reg = 0x1841e, .blue_reg = 0x1841e},
                    {.red_reg = 0x184d4, .green_reg = 0x184d4, .blue_reg = 0x184d4},
                    {.red_reg = 0x18632, .green_reg = 0x18632, .blue_reg = 0x18632},
                    {.red_reg = 0x1877d, .green_reg = 0x1877d, .blue_reg = 0x1877d},
                    {.red_reg = 0x188b8, .green_reg = 0x188b8, .blue_reg = 0x188b8},
                    {.red_reg = 0x189e2, .green_reg = 0x189e2, .blue_reg = 0x189e2},
                    {.red_reg = 0x18b02, .green_reg = 0x18b02, .blue_reg = 0x18b02},
                    {.red_reg = 0x18c14, .green_reg = 0x18c14, .blue_reg = 0x18c14},
                    {.red_reg = 0x18d1f, .green_reg = 0x18d1f, .blue_reg = 0x18d1f},
                    {.red_reg = 0x18e1f, .green_reg = 0x18e1f, .blue_reg = 0x18e1f},
                    {.red_reg = 0x19003, .green_reg = 0x19003, .blue_reg = 0x19003},
                    {.red_reg = 0x190e9, .green_reg = 0x190e9, .blue_reg = 0x190e9},
                    {.red_reg = 0x191c3, .green_reg = 0x191c3, .blue_reg = 0x191c3},
                    {.red_reg = 0x19292, .green_reg = 0x19292, .blue_reg = 0x19292},
                    {.red_reg = 0x19358, .green_reg = 0x19358, .blue_reg = 0x19358},
                    {.red_reg = 0x19416, .green_reg = 0x19416, .blue_reg = 0x19416},
                    {.red_reg = 0x194cc, .green_reg = 0x194cc, .blue_reg = 0x194cc},
                    {.red_reg = 0x1957c, .green_reg = 0x1957c, .blue_reg = 0x1957c},
                    {.red_reg = 0x196ca, .green_reg = 0x196ca, .blue_reg = 0x196ca},
                    {.red_reg = 0x19803, .green_reg = 0x19803, .blue_reg = 0x19803},
                    {.red_reg = 0x1992b, .green_reg = 0x1992b, .blue_reg = 0x1992b},
                    {.red_reg = 0x19a44, .green_reg = 0x19a44, .blue_reg = 0x19a44},
                    {.red_reg = 0x19b50, .green_reg = 0x19b50, .blue_reg = 0x19b50},
                    {.red_reg = 0x19c50, .green_reg = 0x19c50, .blue_reg = 0x19c50},
                    {.red_reg = 0x19d46, .green_reg = 0x19d46, .blue_reg = 0x19d46},
                    {.red_reg = 0x19e33, .green_reg = 0x19e33, .blue_reg = 0x19e33},
                    {.red_reg = 0x19ff2, .green_reg = 0x19ff2, .blue_reg = 0x19ff2},
                    {.red_reg = 0x1a0cb, .green_reg = 0x1a0cb, .blue_reg = 0x1a0cb},
                    {.red_reg = 0x1a190, .green_reg = 0x1a190, .blue_reg = 0x1a190},
                    {.red_reg = 0x1a24b, .green_reg = 0x1a24b, .blue_reg = 0x1a24b},
                    {.red_reg = 0x1a2fc, .green_reg = 0x1a2fc, .blue_reg = 0x1a2fc},
                    {.red_reg = 0x1a3a6, .green_reg = 0x1a3a6, .blue_reg = 0x1a3a6},
                    {.red_reg = 0x1a448, .green_reg = 0x1a448, .blue_reg = 0x1a448},
                    {.red_reg = 0x1a4e4, .green_reg = 0x1a4e4, .blue_reg = 0x1a4e4},
                    {.red_reg = 0x1a60a, .green_reg = 0x1a60a, .blue_reg = 0x1a60a},
                    {.red_reg = 0x1a71c, .green_reg = 0x1a71c, .blue_reg = 0x1a71c},
                    {.red_reg = 0x1a81e, .green_reg = 0x1a81e, .blue_reg = 0x1a81e},
                    {.red_reg = 0x1a911, .green_reg = 0x1a911, .blue_reg = 0x1a911},
                    {.red_reg = 0x1a9f8, .green_reg = 0x1a9f8, .blue_reg = 0x1a9f8},
                    {.red_reg = 0x1aad3, .green_reg = 0x1aad3, .blue_reg = 0x1aad3},
                    {.red_reg = 0x1aba5, .green_reg = 0x1aba5, .blue_reg = 0x1aba5},
                    {.red_reg = 0x1ac6e, .green_reg = 0x1ac6e, .blue_reg = 0x1ac6e},
                    {.red_reg = 0x1ade8, .green_reg = 0x1ade8, .blue_reg = 0x1ade8},
                    {.red_reg = 0x1af48, .green_reg = 0x1af48, .blue_reg = 0x1af48},
                    {.red_reg = 0x1b048, .green_reg = 0x1b048, .blue_reg = 0x1b048},
                    {.red_reg = 0x1b0e3, .green_reg = 0x1b0e3, .blue_reg = 0x1b0e3},
                    {.red_reg = 0x1b176, .green_reg = 0x1b176, .blue_reg = 0x1b176},
                    {.red_reg = 0x1b201, .green_reg = 0x1b201, .blue_reg = 0x1b201},
                    {.red_reg = 0x1b285, .green_reg = 0x1b285, .blue_reg = 0x1b285},
                    {.red_reg = 0x1b304, .green_reg = 0x1b304, .blue_reg = 0x1b304},
                    {.red_reg = 0x1b3f2, .green_reg = 0x1b3f2, .blue_reg = 0x1b3f2},
                    {.red_reg = 0x1b4cf, .green_reg = 0x1b4cf, .blue_reg = 0x1b4cf},
                    {.red_reg = 0x1b59c, .green_reg = 0x1b59c, .blue_reg = 0x1b59c},
                    {.red_reg = 0x1b65e, .green_reg = 0x1b65e, .blue_reg = 0x1b65e},
                    {.red_reg = 0x1b714, .green_reg = 0x1b714, .blue_reg = 0x1b714},
                    {.red_reg = 0x1b7c0, .green_reg = 0x1b7c0, .blue_reg = 0x1b7c0},
                    {.red_reg = 0x1b864, .green_reg = 0x1b864, .blue_reg = 0x1b864},
                    {.red_reg = 0x1b901, .green_reg = 0x1b901, .blue_reg = 0x1b901},
                    {.red_reg = 0x1ba26, .green_reg = 0x1ba26, .blue_reg = 0x1ba26},
                    {.red_reg = 0x1bb35, .green_reg = 0x1bb35, .blue_reg = 0x1bb35},
                    {.red_reg = 0x1bc31, .green_reg = 0x1bc31, .blue_reg = 0x1bc31},
                    {.red_reg = 0x1bd1d, .green_reg = 0x1bd1d, .blue_reg = 0x1bd1d},
                    {.red_reg = 0x1bdfa, .green_reg = 0x1bdfa, .blue_reg = 0x1bdfa},
                    {.red_reg = 0x1becc, .green_reg = 0x1becc, .blue_reg = 0x1becc},
                    {.red_reg = 0x1bf93, .green_reg = 0x1bf93, .blue_reg = 0x1bf93},
                    {.red_reg = 0x1c028, .green_reg = 0x1c028, .blue_reg = 0x1c028},
                    {.red_reg = 0x1c0d9, .green_reg = 0x1c0d9, .blue_reg = 0x1c0d9},
                    {.red_reg = 0x1c17b, .green_reg = 0x1c17b, .blue_reg = 0x1c17b},
                    {.red_reg = 0x1c212, .green_reg = 0x1c212, .blue_reg = 0x1c212},
                    {.red_reg = 0x1c29f, .green_reg = 0x1c29f, .blue_reg = 0x1c29f},
                    {.red_reg = 0x1c323, .green_reg = 0x1c323, .blue_reg = 0x1c323},
                    {.red_reg = 0x1c3a0, .green_reg = 0x1c3a0, .blue_reg = 0x1c3a0},
                    {.red_reg = 0x1c416, .green_reg = 0x1c416, .blue_reg = 0x1c416},
                    {.red_reg = 0x1c486, .green_reg = 0x1c486, .blue_reg = 0x1c486},
                    {.red_reg = 0x1c557, .green_reg = 0x1c557, .blue_reg = 0x1c557},
                    {.red_reg = 0x1c616, .green_reg = 0x1c616, .blue_reg = 0x1c616},
                    {.red_reg = 0x1c6c7, .green_reg = 0x1c6c7, .blue_reg = 0x1c6c7},
                    {.red_reg = 0x1c76c, .green_reg = 0x1c76c, .blue_reg = 0x1c76c},
                    {.red_reg = 0x1c807, .green_reg = 0x1c807, .blue_reg = 0x1c807},
                    {.red_reg = 0x1c898, .green_reg = 0x1c898, .blue_reg = 0x1c898},
                    {.red_reg = 0x1c921, .green_reg = 0x1c921, .blue_reg = 0x1c921},
                    {.red_reg = 0x1c9a3, .green_reg = 0x1c9a3, .blue_reg = 0x1c9a3},
                    {.red_reg = 0x1ca95, .green_reg = 0x1ca95, .blue_reg = 0x1ca95},
                    {.red_reg = 0x1cb72, .green_reg = 0x1cb72, .blue_reg = 0x1cb72},
                    {.red_reg = 0x1cc3e, .green_reg = 0x1cc3e, .blue_reg = 0x1cc3e},
                    {.red_reg = 0x1ccfb, .green_reg = 0x1ccfb, .blue_reg = 0x1ccfb},
                    {.red_reg = 0x1cdac, .green_reg = 0x1cdac, .blue_reg = 0x1cdac},
                    {.red_reg = 0x1ce52, .green_reg = 0x1ce52, .blue_reg = 0x1ce52},
                    {.red_reg = 0x1ceee, .green_reg = 0x1ceee, .blue_reg = 0x1ceee},
                    {.red_reg = 0x1cf82, .green_reg = 0x1cf82, .blue_reg = 0x1cf82},
                    {.red_reg = 0x1d04a, .green_reg = 0x1d04a, .blue_reg = 0x1d04a},
                    {.red_reg = 0x1d0c7, .green_reg = 0x1d0c7, .blue_reg = 0x1d0c7},
                    {.red_reg = 0x1d13a, .green_reg = 0x1d13a, .blue_reg = 0x1d13a},
                    {.red_reg = 0x1d1a5, .green_reg = 0x1d1a5, .blue_reg = 0x1d1a5},
                    {.red_reg = 0x1d208, .green_reg = 0x1d208, .blue_reg = 0x1d208},
                    {.red_reg = 0x1d265, .green_reg = 0x1d265, .blue_reg = 0x1d265},
                    {.red_reg = 0x1d2bc, .green_reg = 0x1d2bc, .blue_reg = 0x1d2bc},
                    {.red_reg = 0x1d30f, .green_reg = 0x1d30f, .blue_reg = 0x1d30f},
                    {.red_reg = 0x1d3a8, .green_reg = 0x1d3a8, .blue_reg = 0x1d3a8},
                    {.red_reg = 0x1d433, .green_reg = 0x1d433, .blue_reg = 0x1d433},
                    {.red_reg = 0x1d4b3, .green_reg = 0x1d4b3, .blue_reg = 0x1d4b3},
                    {.red_reg = 0x1d528, .green_reg = 0x1d528, .blue_reg = 0x1d528},
                    {.red_reg = 0x1d596, .green_reg = 0x1d596, .blue_reg = 0x1d596},
                    {.red_reg = 0x1d5fc, .green_reg = 0x1d5fc, .blue_reg = 0x1d5fc},
                    {.red_reg = 0x1d65d, .green_reg = 0x1d65d, .blue_reg = 0x1d65d},
                    {.red_reg = 0x1d6b7, .green_reg = 0x1d6b7, .blue_reg = 0x1d6b7},
                    {.red_reg = 0x1d75f, .green_reg = 0x1d75f, .blue_reg = 0x1d75f},
                    {.red_reg = 0x1d7f6, .green_reg = 0x1d7f6, .blue_reg = 0x1d7f6},
                    {.red_reg = 0x1d881, .green_reg = 0x1d881, .blue_reg = 0x1d881},
                    {.red_reg = 0x1d901, .green_reg = 0x1d901, .blue_reg = 0x1d901},
                    {.red_reg = 0x1d978, .green_reg = 0x1d978, .blue_reg = 0x1d978},
                    {.red_reg = 0x1d9e7, .green_reg = 0x1d9e7, .blue_reg = 0x1d9e7},
                    {.red_reg = 0x1da4f, .green_reg = 0x1da4f, .blue_reg = 0x1da4f},
                    {.red_reg = 0x1dab1, .green_reg = 0x1dab1, .blue_reg = 0x1dab1},
                    {.red_reg = 0x1db65, .green_reg = 0x1db65, .blue_reg = 0x1db65},
                    {.red_reg = 0x1dc08, .green_reg = 0x1dc08, .blue_reg = 0x1dc08},
                    {.red_reg = 0x1dc9d, .green_reg = 0x1dc9d, .blue_reg = 0x1dc9d},
                    {.red_reg = 0x1dd26, .green_reg = 0x1dd26, .blue_reg = 0x1dd26},
                    {.red_reg = 0x1dda5, .green_reg = 0x1dda5, .blue_reg = 0x1dda5},
                    {.red_reg = 0x1de1b, .green_reg = 0x1de1b, .blue_reg = 0x1de1b},
                    {.red_reg = 0x1de89, .green_reg = 0x1de89, .blue_reg = 0x1de89},
                    {.red_reg = 0x1def1, .green_reg = 0x1def1, .blue_reg = 0x1def1},
                    {.red_reg = 0x1dfb1, .green_reg = 0x1dfb1, .blue_reg = 0x1dfb1},
                    {.red_reg = 0x1e02e, .green_reg = 0x1e02e, .blue_reg = 0x1e02e},
                    {.red_reg = 0x1e07d, .green_reg = 0x1e07d, .blue_reg = 0x1e07d},
                    {.red_reg = 0x1e0c5, .green_reg = 0x1e0c5, .blue_reg = 0x1e0c5},
                    {.red_reg = 0x1e107, .green_reg = 0x1e107, .blue_reg = 0x1e107},
                    {.red_reg = 0x1e145, .green_reg = 0x1e145, .blue_reg = 0x1e145},
                    {.red_reg = 0x1e17f, .green_reg = 0x1e17f, .blue_reg = 0x1e17f},
                    {.red_reg = 0x1e1b6, .green_reg = 0x1e1b6, .blue_reg = 0x1e1b6},
                    {.red_reg = 0x1e21a, .green_reg = 0x1e21a, .blue_reg = 0x1e21a},
                    {.red_reg = 0x1e273, .green_reg = 0x1e273, .blue_reg = 0x1e273},
                    {.red_reg = 0x1e2c5, .green_reg = 0x1e2c5, .blue_reg = 0x1e2c5},
                    {.red_reg = 0x1e310, .green_reg = 0x1e310, .blue_reg = 0x1e310},
                    {.red_reg = 0x1e355, .green_reg = 0x1e355, .blue_reg = 0x1e355},
                    {.red_reg = 0x1e395, .green_reg = 0x1e395, .blue_reg = 0x1e395},
                    {.red_reg = 0x1e3d1, .green_reg = 0x1e3d1, .blue_reg = 0x1e3d1},
                    {.red_reg = 0x1e409, .green_reg = 0x1e409, .blue_reg = 0x1e409},
                    {.red_reg = 0x1e470, .green_reg = 0x1e470, .blue_reg = 0x1e470},
                    {.red_reg = 0x1e4cd, .green_reg = 0x1e4cd, .blue_reg = 0x1e4cd},
                    {.red_reg = 0x1e520, .green_reg = 0x1e520, .blue_reg = 0x1e520},
                    {.red_reg = 0x1e56d, .green_reg = 0x1e56d, .blue_reg = 0x1e56d},
                    {.red_reg = 0x1e5b4, .green_reg = 0x1e5b4, .blue_reg = 0x1e5b4},
                    {.red_reg = 0x1e5f5, .green_reg = 0x1e5f5, .blue_reg = 0x1e5f5},
                    {.red_reg = 0x1e633, .green_reg = 0x1e633, .blue_reg = 0x1e633},
                    {.red_reg = 0x1e66c, .green_reg = 0x1e66c, .blue_reg = 0x1e66c},
                    {.red_reg = 0x1e6d4, .green_reg = 0x1e6d4, .blue_reg = 0x1e6d4},
                    {.red_reg = 0x1e732, .green_reg = 0x1e732, .blue_reg = 0x1e732},
                    {.red_reg = 0x1e787, .green_reg = 0x1e787, .blue_reg = 0x1e787},
                    {.red_reg = 0x1e7d5, .green_reg = 0x1e7d5, .blue_reg = 0x1e7d5},
                    {.red_reg = 0x1e81c, .green_reg = 0x1e81c, .blue_reg = 0x1e81c},
                    {.red_reg = 0x1e85f, .green_reg = 0x1e85f, .blue_reg = 0x1e85f},
                    {.red_reg = 0x1e89c, .green_reg = 0x1e89c, .blue_reg = 0x1e89c},
                    {.red_reg = 0x1e8d6, .green_reg = 0x1e8d6, .blue_reg = 0x1e8d6},
                    {.red_reg = 0x1e93f, .green_reg = 0x1e93f, .blue_reg = 0x1e93f},
                    {.red_reg = 0x1e99d, .green_reg = 0x1e99d, .blue_reg = 0x1e99d},
                    {.red_reg = 0x1e9f2, .green_reg = 0x1e9f2, .blue_reg = 0x1e9f2},
                    {.red_reg = 0x1ea40, .green_reg = 0x1ea40, .blue_reg = 0x1ea40},
                    {.red_reg = 0x1ea88, .green_reg = 0x1ea88, .blue_reg = 0x1ea88},
                    {.red_reg = 0x1eaca, .green_reg = 0x1eaca, .blue_reg = 0x1eaca},
                    {.red_reg = 0x1eb07, .green_reg = 0x1eb07, .blue_reg = 0x1eb07},
                    {.red_reg = 0x1eb41, .green_reg = 0x1eb41, .blue_reg = 0x1eb41},
                    {.red_reg = 0x1eba9, .green_reg = 0x1eba9, .blue_reg = 0x1eba9},
                    {.red_reg = 0x1ec07, .green_reg = 0x1ec07, .blue_reg = 0x1ec07},
                    {.red_reg = 0x1ec5b, .green_reg = 0x1ec5b, .blue_reg = 0x1ec5b},
                    {.red_reg = 0x1eca8, .green_reg = 0x1eca8, .blue_reg = 0x1eca8},
                    {.red_reg = 0x1ecef, .green_reg = 0x1ecef, .blue_reg = 0x1ecef},
                    {.red_reg = 0x1ed30, .green_reg = 0x1ed30, .blue_reg = 0x1ed30},
                    {.red_reg = 0x1ed6d, .green_reg = 0x1ed6d, .blue_reg = 0x1ed6d},
                    {.red_reg = 0x1eda6, .green_reg = 0x1eda6, .blue_reg = 0x1eda6},
                    {.red_reg = 0x1ee0d, .green_reg = 0x1ee0d, .blue_reg = 0x1ee0d},
                    {.red_reg = 0x1ee69, .green_reg = 0x1ee69, .blue_reg = 0x1ee69},
                    {.red_reg = 0x1eebc, .green_reg = 0x1eebc, .blue_reg = 0x1eebc},
                    {.red_reg = 0x1ef07, .green_reg = 0x1ef07, .blue_reg = 0x1ef07},
                    {.red_reg = 0x1ef4d, .green_reg = 0x1ef4d, .blue_reg = 0x1ef4d},
                    {.red_reg = 0x1ef8d, .green_reg = 0x1ef8d, .blue_reg = 0x1ef8d},
                    {.red_reg = 0x1efc8, .green_reg = 0x1efc8, .blue_reg = 0x1efc8},
                    {.red_reg = 0x1f000, .green_reg = 0x1f000, .blue_reg = 0x1f000},
                    {.red_reg = 0x1f000, .green_reg = 0x1f000, .blue_reg = 0x1f000},
                    {.red_reg = 0x0, .green_reg = 0x0, .blue_reg = 0x0},
                    {.red_reg = 0x0, .green_reg = 0x0, .blue_reg = 0x0},
                    {.red_reg = 0x0, .green_reg = 0x0, .blue_reg = 0x0},
                    {.red_reg = 0x0, .green_reg = 0x0, .blue_reg = 0x0},
                    {.red_reg = 0x0, .green_reg = 0x0, .blue_reg = 0x0},
                    {.red_reg = 0x0, .green_reg = 0x0, .blue_reg = 0x0},
                    {.red_reg = 0x0, .green_reg = 0x0, .blue_reg = 0x0},
                    {.red_reg = 0x0, .green_reg = 0x0, .blue_reg = 0x0},
                    {.red_reg = 0x0, .green_reg = 0x0, .blue_reg = 0x0},
                    {.red_reg = 0x0, .green_reg = 0x0, .blue_reg = 0x0},
                    {.red_reg = 0x0, .green_reg = 0x0, .blue_reg = 0x0},
                    {.red_reg = 0x0, .green_reg = 0x0, .blue_reg = 0x0},
                    {.red_reg = 0x0, .green_reg = 0x0, .blue_reg = 0x0},
                    {.red_reg = 0x0, .green_reg = 0x0, .blue_reg = 0x0},
                    {.red_reg = 0x0, .green_reg = 0x0, .blue_reg = 0x0},
                    {.red_reg = 0x0, .green_reg = 0x0, .blue_reg = 0x0},
                    {.red_reg = 0x0, .green_reg = 0x0, .blue_reg = 0x0},
                    {.red_reg = 0x0, .green_reg = 0x0, .blue_reg = 0x0},
                    {.red_reg = 0x0, .green_reg = 0x0, .blue_reg = 0x0},
                    {.red_reg = 0x0, .green_reg = 0x0, .blue_reg = 0x0},
                    {.red_reg = 0x0, .green_reg = 0x0, .blue_reg = 0x0},
                    {.red_reg = 0x0, .green_reg = 0x0, .blue_reg = 0x0},
                    {.red_reg = 0x0, .green_reg = 0x0, .blue_reg = 0x0},
                    {.red_reg = 0x0, .green_reg = 0x0, .blue_reg = 0x0},
                    {.red_reg = 0x0, .green_reg = 0x0, .blue_reg = 0x0},
                    {.red_reg = 0x0, .green_reg = 0x0, .blue_reg = 0x0},
                    {.red_reg = 0x0, .green_reg = 0x0, .blue_reg = 0x0},
                    {.red_reg = 0x0, .green_reg = 0x0, .blue_reg = 0x0},
                    {.red_reg = 0x0, .green_reg = 0x0, .blue_reg = 0x0},
                    {.red_reg = 0x0, .green_reg = 0x0, .blue_reg = 0x0},
                    {.red_reg = 0x0, .green_reg = 0x0, .blue_reg = 0x0},
                    {.red_reg = 0x0, .green_reg = 0x0, .blue_reg = 0x0},
                    {.red_reg = 0x0, .green_reg = 0x0, .blue_reg = 0x0},
                    {.red_reg = 0x0, .green_reg = 0x0, .blue_reg = 0x0},
                    {.red_reg = 0x0, .green_reg = 0x0, .blue_reg = 0x0},
                    {.red_reg = 0x0, .green_reg = 0x0, .blue_reg = 0x0},
                    {.red_reg = 0x0, .green_reg = 0x0, .blue_reg = 0x0},
                    {.red_reg = 0x0, .green_reg = 0x0, .blue_reg = 0x0},
                    {.red_reg = 0x0, .green_reg = 0x0, .blue_reg = 0x0},
                    {.red_reg = 0x0, .green_reg = 0x0, .blue_reg = 0x0},
                    {.red_reg = 0x0, .green_reg = 0x0, .blue_reg = 0x0},
                    {.red_reg = 0x0, .green_reg = 0x0, .blue_reg = 0x0},
                    {.red_reg = 0x0, .green_reg = 0x0, .blue_reg = 0x0},
                    {.red_reg = 0x0, .green_reg = 0x0, .blue_reg = 0x0},
                    {.red_reg = 0x0, .green_reg = 0x0, .blue_reg = 0x0},
                    {.red_reg = 0x0, .green_reg = 0x0, .blue_reg = 0x0},
                    {.red_reg = 0x0, .green_reg = 0x0, .blue_reg = 0x0},
                    {.red_reg = 0x0, .green_reg = 0x0, .blue_reg = 0x0},
                    {.red_reg = 0x0, .green_reg = 0x0, .blue_reg = 0x0},
                    {.red_reg = 0x0, .green_reg = 0x0, .blue_reg = 0x0},
                    {.red_reg = 0x0, .green_reg = 0x0, .blue_reg = 0x0},
                    {.red_reg = 0x0, .green_reg = 0x0, .blue_reg = 0x0},
                    {.red_reg = 0x0, .green_reg = 0x0, .blue_reg = 0x0},
                    {.red_reg = 0x0, .green_reg = 0x0, .blue_reg = 0x0},
                    {.red_reg = 0x0, .green_reg = 0x0, .blue_reg = 0x0},
                    {.red_reg = 0x0, .green_reg = 0x0, .blue_reg = 0x0},
                    {.red_reg = 0x0, .green_reg = 0x0, .blue_reg = 0x0}}},
        {.hw_points_num       = NUM_OF_LUT_DATA_REGAM_LINEAR,
            .arr_curve_points = {{0x0, 0x3}, {0x8, 0x3}, {0x10, 0x3}, {0x18, 0x3}, {0x20, 0x3},
                {0x28, 0x3}, {0x30, 0x3}, {0x38, 0x3}, {0x40, 0x3}, {0x48, 0x3}, {0x50, 0x3},
                {0x58, 0x3}, {0x60, 0x3}, {0x68, 0x3}, {0x70, 0x3}, {0x78, 0x3}, {0x80, 0x3},
                {0x88, 0x3}, {0x90, 0x3}, {0x98, 0x3}, {0xa0, 0x3}, {0xa8, 0x3}, {0xb0, 0x3},
                {0xb8, 0x3}, {0xc0, 0x3}, {0xc8, 0x3}, {0xd0, 0x3}, {0xd8, 0x3}, {0xe0, 0x0},
                {0x0, 0x0}, {0x0, 0x0}, {0x0, 0x0}, {0x0, 0x0}, {0x0, 0x0}},
            .corner_points    = {{.red.custom_float_x          = 0x6000,
                                     .red.custom_float_y       = 0x0,
                                     .red.custom_float_slope   = 0x25f40,
                                     .green.custom_float_x     = 0x6000,
                                     .green.custom_float_y     = 0x0,
                                     .green.custom_float_slope = 0x25f40,
                                     .blue.custom_float_x      = 0x6000,
                                     .blue.custom_float_y      = 0x0,
                                     .blue.custom_float_slope  = 0x25f40},
                   {.red.custom_float_x          = 0x8800,
                       .red.custom_float_y       = 0x28f40,
                       .red.custom_float_slope   = 0x0,
                       .green.custom_float_x     = 0x8800,
                       .green.custom_float_y     = 0x28f40,
                       .green.custom_float_slope = 0x0,
                       .blue.custom_float_x      = 0x8800,
                       .blue.custom_float_y      = 0x28f40,
                       .blue.custom_float_slope  = 0x0}},
            .rgb_resulted     = {{.red_reg = 0xcf40, .green_reg = 0xcf40, .blue_reg = 0xcf40},
                    {.red_reg = 0xd194, .green_reg = 0xd194, .blue_reg = 0xd194},
                    {.red_reg = 0xd388, .green_reg = 0xd388, .blue_reg = 0xd388},
                    {.red_reg = 0xd57c, .green_reg = 0xd57c, .blue_reg = 0xd57c},
                    {.red_reg = 0xd770, .green_reg = 0xd770, .blue_reg = 0xd770},
                    {.red_reg = 0xd964, .green_reg = 0xd964, .blue_reg = 0xd964},
                    {.red_reg = 0xdb58, .green_reg = 0xdb58, .blue_reg = 0xdb58},
                    {.red_reg = 0xdd4c, .green_reg = 0xdd4c, .blue_reg = 0xdd4c},
                    {.red_reg = 0xdf40, .green_reg = 0xdf40, .blue_reg = 0xdf40},
                    {.red_reg = 0xe194, .green_reg = 0xe194, .blue_reg = 0xe194},
                    {.red_reg = 0xe388, .green_reg = 0xe388, .blue_reg = 0xe388},
                    {.red_reg = 0xe57c, .green_reg = 0xe57c, .blue_reg = 0xe57c},
                    {.red_reg = 0xe770, .green_reg = 0xe770, .blue_reg = 0xe770},
                    {.red_reg = 0xe964, .green_reg = 0xe964, .blue_reg = 0xe964},
                    {.red_reg = 0xeb58, .green_reg = 0xeb58, .blue_reg = 0xeb58},
                    {.red_reg = 0xed4c, .green_reg = 0xed4c, .blue_reg = 0xed4c},
                    {.red_reg = 0xef40, .green_reg = 0xef40, .blue_reg = 0xef40},
                    {.red_reg = 0xf194, .green_reg = 0xf194, .blue_reg = 0xf194},
                    {.red_reg = 0xf388, .green_reg = 0xf388, .blue_reg = 0xf388},
                    {.red_reg = 0xf57c, .green_reg = 0xf57c, .blue_reg = 0xf57c},
                    {.red_reg = 0xf770, .green_reg = 0xf770, .blue_reg = 0xf770},
                    {.red_reg = 0xf964, .green_reg = 0xf964, .blue_reg = 0xf964},
                    {.red_reg = 0xfb58, .green_reg = 0xfb58, .blue_reg = 0xfb58},
                    {.red_reg = 0xfd4c, .green_reg = 0xfd4c, .blue_reg = 0xfd4c},
                    {.red_reg = 0xff40, .green_reg = 0xff40, .blue_reg = 0xff40},
                    {.red_reg = 0x10194, .green_reg = 0x10194, .blue_reg = 0x10194},
                    {.red_reg = 0x10388, .green_reg = 0x10388, .blue_reg = 0x10388},
                    {.red_reg = 0x1057c, .green_reg = 0x1057c, .blue_reg = 0x1057c},
                    {.red_reg = 0x10770, .green_reg = 0x10770, .blue_reg = 0x10770},
                    {.red_reg = 0x10964, .green_reg = 0x10964, .blue_reg = 0x10964},
                    {.red_reg = 0x10b58, .green_reg = 0x10b58, .blue_reg = 0x10b58},
                    {.red_reg = 0x10d4c, .green_reg = 0x10d4c, .blue_reg = 0x10d4c},
                    {.red_reg = 0x10f40, .green_reg = 0x10f40, .blue_reg = 0x10f40},
                    {.red_reg = 0x11194, .green_reg = 0x11194, .blue_reg = 0x11194},
                    {.red_reg = 0x11388, .green_reg = 0x11388, .blue_reg = 0x11388},
                    {.red_reg = 0x1157c, .green_reg = 0x1157c, .blue_reg = 0x1157c},
                    {.red_reg = 0x11770, .green_reg = 0x11770, .blue_reg = 0x11770},
                    {.red_reg = 0x11964, .green_reg = 0x11964, .blue_reg = 0x11964},
                    {.red_reg = 0x11b58, .green_reg = 0x11b58, .blue_reg = 0x11b58},
                    {.red_reg = 0x11d4c, .green_reg = 0x11d4c, .blue_reg = 0x11d4c},
                    {.red_reg = 0x11f40, .green_reg = 0x11f40, .blue_reg = 0x11f40},
                    {.red_reg = 0x12194, .green_reg = 0x12194, .blue_reg = 0x12194},
                    {.red_reg = 0x12388, .green_reg = 0x12388, .blue_reg = 0x12388},
                    {.red_reg = 0x1257c, .green_reg = 0x1257c, .blue_reg = 0x1257c},
                    {.red_reg = 0x12770, .green_reg = 0x12770, .blue_reg = 0x12770},
                    {.red_reg = 0x12964, .green_reg = 0x12964, .blue_reg = 0x12964},
                    {.red_reg = 0x12b58, .green_reg = 0x12b58, .blue_reg = 0x12b58},
                    {.red_reg = 0x12d4c, .green_reg = 0x12d4c, .blue_reg = 0x12d4c},
                    {.red_reg = 0x12f40, .green_reg = 0x12f40, .blue_reg = 0x12f40},
                    {.red_reg = 0x13194, .green_reg = 0x13194, .blue_reg = 0x13194},
                    {.red_reg = 0x13388, .green_reg = 0x13388, .blue_reg = 0x13388},
                    {.red_reg = 0x1357c, .green_reg = 0x1357c, .blue_reg = 0x1357c},
                    {.red_reg = 0x13770, .green_reg = 0x13770, .blue_reg = 0x13770},
                    {.red_reg = 0x13964, .green_reg = 0x13964, .blue_reg = 0x13964},
                    {.red_reg = 0x13b58, .green_reg = 0x13b58, .blue_reg = 0x13b58},
                    {.red_reg = 0x13d4c, .green_reg = 0x13d4c, .blue_reg = 0x13d4c},
                    {.red_reg = 0x13f40, .green_reg = 0x13f40, .blue_reg = 0x13f40},
                    {.red_reg = 0x14194, .green_reg = 0x14194, .blue_reg = 0x14194},
                    {.red_reg = 0x14388, .green_reg = 0x14388, .blue_reg = 0x14388},
                    {.red_reg = 0x1457c, .green_reg = 0x1457c, .blue_reg = 0x1457c},
                    {.red_reg = 0x14770, .green_reg = 0x14770, .blue_reg = 0x14770},
                    {.red_reg = 0x14964, .green_reg = 0x14964, .blue_reg = 0x14964},
                    {.red_reg = 0x14b58, .green_reg = 0x14b58, .blue_reg = 0x14b58},
                    {.red_reg = 0x14d4c, .green_reg = 0x14d4c, .blue_reg = 0x14d4c},
                    {.red_reg = 0x14f40, .green_reg = 0x14f40, .blue_reg = 0x14f40},
                    {.red_reg = 0x15194, .green_reg = 0x15194, .blue_reg = 0x15194},
                    {.red_reg = 0x15388, .green_reg = 0x15388, .blue_reg = 0x15388},
                    {.red_reg = 0x1557c, .green_reg = 0x1557c, .blue_reg = 0x1557c},
                    {.red_reg = 0x15770, .green_reg = 0x15770, .blue_reg = 0x15770},
                    {.red_reg = 0x15964, .green_reg = 0x15964, .blue_reg = 0x15964},
                    {.red_reg = 0x15b58, .green_reg = 0x15b58, .blue_reg = 0x15b58},
                    {.red_reg = 0x15d4c, .green_reg = 0x15d4c, .blue_reg = 0x15d4c},
                    {.red_reg = 0x15f40, .green_reg = 0x15f40, .blue_reg = 0x15f40},
                    {.red_reg = 0x16194, .green_reg = 0x16194, .blue_reg = 0x16194},
                    {.red_reg = 0x16388, .green_reg = 0x16388, .blue_reg = 0x16388},
                    {.red_reg = 0x1657c, .green_reg = 0x1657c, .blue_reg = 0x1657c},
                    {.red_reg = 0x16770, .green_reg = 0x16770, .blue_reg = 0x16770},
                    {.red_reg = 0x16964, .green_reg = 0x16964, .blue_reg = 0x16964},
                    {.red_reg = 0x16b58, .green_reg = 0x16b58, .blue_reg = 0x16b58},
                    {.red_reg = 0x16d4c, .green_reg = 0x16d4c, .blue_reg = 0x16d4c},
                    {.red_reg = 0x16f40, .green_reg = 0x16f40, .blue_reg = 0x16f40},
                    {.red_reg = 0x17194, .green_reg = 0x17194, .blue_reg = 0x17194},
                    {.red_reg = 0x17388, .green_reg = 0x17388, .blue_reg = 0x17388},
                    {.red_reg = 0x1757c, .green_reg = 0x1757c, .blue_reg = 0x1757c},
                    {.red_reg = 0x17770, .green_reg = 0x17770, .blue_reg = 0x17770},
                    {.red_reg = 0x17964, .green_reg = 0x17964, .blue_reg = 0x17964},
                    {.red_reg = 0x17b58, .green_reg = 0x17b58, .blue_reg = 0x17b58},
                    {.red_reg = 0x17d4c, .green_reg = 0x17d4c, .blue_reg = 0x17d4c},
                    {.red_reg = 0x17f40, .green_reg = 0x17f40, .blue_reg = 0x17f40},
                    {.red_reg = 0x18194, .green_reg = 0x18194, .blue_reg = 0x18194},
                    {.red_reg = 0x18388, .green_reg = 0x18388, .blue_reg = 0x18388},
                    {.red_reg = 0x1857c, .green_reg = 0x1857c, .blue_reg = 0x1857c},
                    {.red_reg = 0x18770, .green_reg = 0x18770, .blue_reg = 0x18770},
                    {.red_reg = 0x18964, .green_reg = 0x18964, .blue_reg = 0x18964},
                    {.red_reg = 0x18b58, .green_reg = 0x18b58, .blue_reg = 0x18b58},
                    {.red_reg = 0x18d4c, .green_reg = 0x18d4c, .blue_reg = 0x18d4c},
                    {.red_reg = 0x18f40, .green_reg = 0x18f40, .blue_reg = 0x18f40},
                    {.red_reg = 0x19194, .green_reg = 0x19194, .blue_reg = 0x19194},
                    {.red_reg = 0x19388, .green_reg = 0x19388, .blue_reg = 0x19388},
                    {.red_reg = 0x1957c, .green_reg = 0x1957c, .blue_reg = 0x1957c},
                    {.red_reg = 0x19770, .green_reg = 0x19770, .blue_reg = 0x19770},
                    {.red_reg = 0x19964, .green_reg = 0x19964, .blue_reg = 0x19964},
                    {.red_reg = 0x19b58, .green_reg = 0x19b58, .blue_reg = 0x19b58},
                    {.red_reg = 0x19d4c, .green_reg = 0x19d4c, .blue_reg = 0x19d4c},
                    {.red_reg = 0x19f40, .green_reg = 0x19f40, .blue_reg = 0x19f40},
                    {.red_reg = 0x1a194, .green_reg = 0x1a194, .blue_reg = 0x1a194},
                    {.red_reg = 0x1a388, .green_reg = 0x1a388, .blue_reg = 0x1a388},
                    {.red_reg = 0x1a57c, .green_reg = 0x1a57c, .blue_reg = 0x1a57c},
                    {.red_reg = 0x1a770, .green_reg = 0x1a770, .blue_reg = 0x1a770},
                    {.red_reg = 0x1a964, .green_reg = 0x1a964, .blue_reg = 0x1a964},
                    {.red_reg = 0x1ab58, .green_reg = 0x1ab58, .blue_reg = 0x1ab58},
                    {.red_reg = 0x1ad4c, .green_reg = 0x1ad4c, .blue_reg = 0x1ad4c},
                    {.red_reg = 0x1af40, .green_reg = 0x1af40, .blue_reg = 0x1af40},
                    {.red_reg = 0x1b194, .green_reg = 0x1b194, .blue_reg = 0x1b194},
                    {.red_reg = 0x1b388, .green_reg = 0x1b388, .blue_reg = 0x1b388},
                    {.red_reg = 0x1b57c, .green_reg = 0x1b57c, .blue_reg = 0x1b57c},
                    {.red_reg = 0x1b770, .green_reg = 0x1b770, .blue_reg = 0x1b770},
                    {.red_reg = 0x1b964, .green_reg = 0x1b964, .blue_reg = 0x1b964},
                    {.red_reg = 0x1bb58, .green_reg = 0x1bb58, .blue_reg = 0x1bb58},
                    {.red_reg = 0x1bd4c, .green_reg = 0x1bd4c, .blue_reg = 0x1bd4c},
                    {.red_reg = 0x1bf40, .green_reg = 0x1bf40, .blue_reg = 0x1bf40},
                    {.red_reg = 0x1c194, .green_reg = 0x1c194, .blue_reg = 0x1c194},
                    {.red_reg = 0x1c388, .green_reg = 0x1c388, .blue_reg = 0x1c388},
                    {.red_reg = 0x1c57c, .green_reg = 0x1c57c, .blue_reg = 0x1c57c},
                    {.red_reg = 0x1c770, .green_reg = 0x1c770, .blue_reg = 0x1c770},
                    {.red_reg = 0x1c964, .green_reg = 0x1c964, .blue_reg = 0x1c964},
                    {.red_reg = 0x1cb58, .green_reg = 0x1cb58, .blue_reg = 0x1cb58},
                    {.red_reg = 0x1cd4c, .green_reg = 0x1cd4c, .blue_reg = 0x1cd4c},
                    {.red_reg = 0x1cf40, .green_reg = 0x1cf40, .blue_reg = 0x1cf40},
                    {.red_reg = 0x1d194, .green_reg = 0x1d194, .blue_reg = 0x1d194},
                    {.red_reg = 0x1d388, .green_reg = 0x1d388, .blue_reg = 0x1d388},
                    {.red_reg = 0x1d57c, .green_reg = 0x1d57c, .blue_reg = 0x1d57c},
                    {.red_reg = 0x1d770, .green_reg = 0x1d770, .blue_reg = 0x1d770},
                    {.red_reg = 0x1d964, .green_reg = 0x1d964, .blue_reg = 0x1d964},
                    {.red_reg = 0x1db58, .green_reg = 0x1db58, .blue_reg = 0x1db58},
                    {.red_reg = 0x1dd4c, .green_reg = 0x1dd4c, .blue_reg = 0x1dd4c},
                    {.red_reg = 0x1df40, .green_reg = 0x1df40, .blue_reg = 0x1df40},
                    {.red_reg = 0x1e194, .green_reg = 0x1e194, .blue_reg = 0x1e194},
                    {.red_reg = 0x1e388, .green_reg = 0x1e388, .blue_reg = 0x1e388},
                    {.red_reg = 0x1e57c, .green_reg = 0x1e57c, .blue_reg = 0x1e57c},
                    {.red_reg = 0x1e770, .green_reg = 0x1e770, .blue_reg = 0x1e770},
                    {.red_reg = 0x1e964, .green_reg = 0x1e964, .blue_reg = 0x1e964},
                    {.red_reg = 0x1eb58, .green_reg = 0x1eb58, .blue_reg = 0x1eb58},
                    {.red_reg = 0x1ed4c, .green_reg = 0x1ed4c, .blue_reg = 0x1ed4c},
                    {.red_reg = 0x1ef40, .green_reg = 0x1ef40, .blue_reg = 0x1ef40},
                    {.red_reg = 0x1f194, .green_reg = 0x1f194, .blue_reg = 0x1f194},
                    {.red_reg = 0x1f388, .green_reg = 0x1f388, .blue_reg = 0x1f388},
                    {.red_reg = 0x1f57c, .green_reg = 0x1f57c, .blue_reg = 0x1f57c},
                    {.red_reg = 0x1f770, .green_reg = 0x1f770, .blue_reg = 0x1f770},
                    {.red_reg = 0x1f964, .green_reg = 0x1f964, .blue_reg = 0x1f964},
                    {.red_reg = 0x1fb58, .green_reg = 0x1fb58, .blue_reg = 0x1fb58},
                    {.red_reg = 0x1fd4c, .green_reg = 0x1fd4c, .blue_reg = 0x1fd4c},
                    {.red_reg = 0x1ff40, .green_reg = 0x1ff40, .blue_reg = 0x1ff40},
                    {.red_reg = 0x20194, .green_reg = 0x20194, .blue_reg = 0x20194},
                    {.red_reg = 0x20388, .green_reg = 0x20388, .blue_reg = 0x20388},
                    {.red_reg = 0x2057c, .green_reg = 0x2057c, .blue_reg = 0x2057c},
                    {.red_reg = 0x20770, .green_reg = 0x20770, .blue_reg = 0x20770},
                    {.red_reg = 0x20964, .green_reg = 0x20964, .blue_reg = 0x20964},
                    {.red_reg = 0x20b58, .green_reg = 0x20b58, .blue_reg = 0x20b58},
                    {.red_reg = 0x20d4c, .green_reg = 0x20d4c, .blue_reg = 0x20d4c},
                    {.red_reg = 0x20f40, .green_reg = 0x20f40, .blue_reg = 0x20f40},
                    {.red_reg = 0x21194, .green_reg = 0x21194, .blue_reg = 0x21194},
                    {.red_reg = 0x21388, .green_reg = 0x21388, .blue_reg = 0x21388},
                    {.red_reg = 0x2157c, .green_reg = 0x2157c, .blue_reg = 0x2157c},
                    {.red_reg = 0x21770, .green_reg = 0x21770, .blue_reg = 0x21770},
                    {.red_reg = 0x21964, .green_reg = 0x21964, .blue_reg = 0x21964},
                    {.red_reg = 0x21b58, .green_reg = 0x21b58, .blue_reg = 0x21b58},
                    {.red_reg = 0x21d4c, .green_reg = 0x21d4c, .blue_reg = 0x21d4c},
                    {.red_reg = 0x21f40, .green_reg = 0x21f40, .blue_reg = 0x21f40},
                    {.red_reg = 0x22194, .green_reg = 0x22194, .blue_reg = 0x22194},
                    {.red_reg = 0x22388, .green_reg = 0x22388, .blue_reg = 0x22388},
                    {.red_reg = 0x2257c, .green_reg = 0x2257c, .blue_reg = 0x2257c},
                    {.red_reg = 0x22770, .green_reg = 0x22770, .blue_reg = 0x22770},
                    {.red_reg = 0x22964, .green_reg = 0x22964, .blue_reg = 0x22964},
                    {.red_reg = 0x22b58, .green_reg = 0x22b58, .blue_reg = 0x22b58},
                    {.red_reg = 0x22d4c, .green_reg = 0x22d4c, .blue_reg = 0x22d4c},
                    {.red_reg = 0x22f40, .green_reg = 0x22f40, .blue_reg = 0x22f40},
                    {.red_reg = 0x23194, .green_reg = 0x23194, .blue_reg = 0x23194},
                    {.red_reg = 0x23388, .green_reg = 0x23388, .blue_reg = 0x23388},
                    {.red_reg = 0x2357c, .green_reg = 0x2357c, .blue_reg = 0x2357c},
                    {.red_reg = 0x23770, .green_reg = 0x23770, .blue_reg = 0x23770},
                    {.red_reg = 0x23964, .green_reg = 0x23964, .blue_reg = 0x23964},
                    {.red_reg = 0x23b58, .green_reg = 0x23b58, .blue_reg = 0x23b58},
                    {.red_reg = 0x23d4c, .green_reg = 0x23d4c, .blue_reg = 0x23d4c},
                    {.red_reg = 0x23f40, .green_reg = 0x23f40, .blue_reg = 0x23f40},
                    {.red_reg = 0x24194, .green_reg = 0x24194, .blue_reg = 0x24194},
                    {.red_reg = 0x24388, .green_reg = 0x24388, .blue_reg = 0x24388},
                    {.red_reg = 0x2457c, .green_reg = 0x2457c, .blue_reg = 0x2457c},
                    {.red_reg = 0x24770, .green_reg = 0x24770, .blue_reg = 0x24770},
                    {.red_reg = 0x24964, .green_reg = 0x24964, .blue_reg = 0x24964},
                    {.red_reg = 0x24b58, .green_reg = 0x24b58, .blue_reg = 0x24b58},
                    {.red_reg = 0x24d4c, .green_reg = 0x24d4c, .blue_reg = 0x24d4c},
                    {.red_reg = 0x24f40, .green_reg = 0x24f40, .blue_reg = 0x24f40},
                    {.red_reg = 0x25194, .green_reg = 0x25194, .blue_reg = 0x25194},
                    {.red_reg = 0x25388, .green_reg = 0x25388, .blue_reg = 0x25388},
                    {.red_reg = 0x2557c, .green_reg = 0x2557c, .blue_reg = 0x2557c},
                    {.red_reg = 0x25770, .green_reg = 0x25770, .blue_reg = 0x25770},
                    {.red_reg = 0x25964, .green_reg = 0x25964, .blue_reg = 0x25964},
                    {.red_reg = 0x25b58, .green_reg = 0x25b58, .blue_reg = 0x25b58},
                    {.red_reg = 0x25d4c, .green_reg = 0x25d4c, .blue_reg = 0x25d4c},
                    {.red_reg = 0x25f40, .green_reg = 0x25f40, .blue_reg = 0x25f40},
                    {.red_reg = 0x26194, .green_reg = 0x26194, .blue_reg = 0x26194},
                    {.red_reg = 0x26388, .green_reg = 0x26388, .blue_reg = 0x26388},
                    {.red_reg = 0x2657c, .green_reg = 0x2657c, .blue_reg = 0x2657c},
                    {.red_reg = 0x26770, .green_reg = 0x26770, .blue_reg = 0x26770},
                    {.red_reg = 0x26964, .green_reg = 0x26964, .blue_reg = 0x26964},
                    {.red_reg = 0x26b58, .green_reg = 0x26b58, .blue_reg = 0x26b58},
                    {.red_reg = 0x26d4c, .green_reg = 0x26d4c, .blue_reg = 0x26d4c},
                    {.red_reg = 0x26f40, .green_reg = 0x26f40, .blue_reg = 0x26f40},
                    {.red_reg = 0x27194, .green_reg = 0x27194, .blue_reg = 0x27194},
                    {.red_reg = 0x27388, .green_reg = 0x27388, .blue_reg = 0x27388},
                    {.red_reg = 0x2757c, .green_reg = 0x2757c, .blue_reg = 0x2757c},
                    {.red_reg = 0x27770, .green_reg = 0x27770, .blue_reg = 0x27770},
                    {.red_reg = 0x27964, .green_reg = 0x27964, .blue_reg = 0x27964},
                    {.red_reg = 0x27b58, .green_reg = 0x27b58, .blue_reg = 0x27b58},
                    {.red_reg = 0x27d4c, .green_reg = 0x27d4c, .blue_reg = 0x27d4c},
                    {.red_reg = 0x27f40, .green_reg = 0x27f40, .blue_reg = 0x27f40},
                    {.red_reg = 0x28194, .green_reg = 0x28194, .blue_reg = 0x28194},
                    {.red_reg = 0x28388, .green_reg = 0x28388, .blue_reg = 0x28388},
                    {.red_reg = 0x2857c, .green_reg = 0x2857c, .blue_reg = 0x2857c},
                    {.red_reg = 0x28770, .green_reg = 0x28770, .blue_reg = 0x28770},
                    {.red_reg = 0x28964, .green_reg = 0x28964, .blue_reg = 0x28964},
                    {.red_reg = 0x28b58, .green_reg = 0x28b58, .blue_reg = 0x28b58},
                    {.red_reg = 0x28f40, .green_reg = 0x28f40, .blue_reg = 0x28f40},
                    {.red_reg = 0x0, .green_reg = 0x0, .blue_reg = 0x0},
                    {.red_reg = 0x0, .green_reg = 0x0, .blue_reg = 0x0},
                    {.red_reg = 0x0, .green_reg = 0x0, .blue_reg = 0x0},
                    {.red_reg = 0x0, .green_reg = 0x0, .blue_reg = 0x0},
                    {.red_reg = 0x0, .green_reg = 0x0, .blue_reg = 0x0},
                    {.red_reg = 0x0, .green_reg = 0x0, .blue_reg = 0x0},
                    {.red_reg = 0x0, .green_reg = 0x0, .blue_reg = 0x0},
                    {.red_reg = 0x0, .green_reg = 0x0, .blue_reg = 0x0},
                    {.red_reg = 0x0, .green_reg = 0x0, .blue_reg = 0x0},
                    {.red_reg = 0x0, .green_reg = 0x0, .blue_reg = 0x0},
                    {.red_reg = 0x0, .green_reg = 0x0, .blue_reg = 0x0},
                    {.red_reg = 0x0, .green_reg = 0x0, .blue_reg = 0x0},
                    {.red_reg = 0x0, .green_reg = 0x0, .blue_reg = 0x0},
                    {.red_reg = 0x0, .green_reg = 0x0, .blue_reg = 0x0},
                    {.red_reg = 0x0, .green_reg = 0x0, .blue_reg = 0x0},
                    {.red_reg = 0x0, .green_reg = 0x0, .blue_reg = 0x0},
                    {.red_reg = 0x0, .green_reg = 0x0, .blue_reg = 0x0},
                    {.red_reg = 0x0, .green_reg = 0x0, .blue_reg = 0x0},
                    {.red_reg = 0x0, .green_reg = 0x0, .blue_reg = 0x0},
                    {.red_reg = 0x0, .green_reg = 0x0, .blue_reg = 0x0},
                    {.red_reg = 0x0, .green_reg = 0x0, .blue_reg = 0x0},
                    {.red_reg = 0x0, .green_reg = 0x0, .blue_reg = 0x0},
                    {.red_reg = 0x0, .green_reg = 0x0, .blue_reg = 0x0},
                    {.red_reg = 0x0, .green_reg = 0x0, .blue_reg = 0x0},
                    {.red_reg = 0x0, .green_reg = 0x0, .blue_reg = 0x0},
                    {.red_reg = 0x0, .green_reg = 0x0, .blue_reg = 0x0},
                    {.red_reg = 0x0, .green_reg = 0x0, .blue_reg = 0x0},
                    {.red_reg = 0x0, .green_reg = 0x0, .blue_reg = 0x0},
                    {.red_reg = 0x0, .green_reg = 0x0, .blue_reg = 0x0},
                    {.red_reg = 0x0, .green_reg = 0x0, .blue_reg = 0x0},
                    {.red_reg = 0x0, .green_reg = 0x0, .blue_reg = 0x0},
                    {.red_reg = 0x0, .green_reg = 0x0, .blue_reg = 0x0},
                    {.red_reg = 0x0, .green_reg = 0x0, .blue_reg = 0x0},
                    {.red_reg = 0x0, .green_reg = 0x0, .blue_reg = 0x0},
                    {.red_reg = 0x0, .green_reg = 0x0, .blue_reg = 0x0}}},
    }};

#ifdef __cplusplus
}
#endif
